/*
    SPDX-License-Identifier: GPL-2.0-or-later

    SPDX-FileCopyrightText: 2006 Gael de Chalendar (aka Kleag) kleag@free.fr
    SPDX-FileCopyrightText: 2006-2020 Umbrello UML Modeller Authors <umbrello-devel@kde.org>
*/

#ifndef XHTMLGENERATOR_H
#define XHTMLGENERATOR_H

#include "basictypes.h"

#include <QObject>
#include <QUrl>

class UMLDoc;

class Docbook2XhtmlGeneratorJob;

/**
 * class XhtmlGenerator is a documentation generator for UML documents.
 * It uses first @ref DocbookGenerator to convert the XMI generated by
 * UMLDoc::saveToXMI1 to docbook and next libxslt through
 * the XSLT file stored in resources to convert the docbook file to XHTML.
 * The latter uses the XSLT available on the Web at
 * http://docbook.sourceforge.net/release/xsl/snapshot/html/docbook.xsl
 *
 * @todo allow to specify the destination and ensure that it works with distant
 * ones
 */
class XhtmlGenerator : public QObject
{
    Q_OBJECT
public:

    XhtmlGenerator();
    virtual ~XhtmlGenerator();

    bool generateXhtmlForProject();
    bool generateXhtmlForProjectInto(const QUrl& destDir);
    static QString customXslFile();

Q_SIGNALS:
    void finished(bool status);

protected Q_SLOTS:

    void slotDocbookToXhtml(bool status);
    void slotHtmlGenerated(const QString& tmpFileName);

    void threadFinished();

private:

    Docbook2XhtmlGeneratorJob* m_d2xg;

    bool m_pStatus;
    bool m_pThreadFinished;

    QUrl m_destDir;  ///< Destination directory where the final documentation will be written.
    UMLDoc* m_umlDoc;
};

#endif // XHTMLGENERATOR_H
