#ifndef CONN_H
#define CONN_H

#include <stdbool.h>

struct json_object;
struct sockaddr_un;

struct vali_buffer {
	char *data;
	size_t size, cap;
};

struct vali_conn {
	int fd;

	struct vali_buffer in, out;
};

void conn_init(struct vali_conn *conn, int fd);

void conn_finish(struct vali_conn *conn);

bool conn_enqueue(struct vali_conn *conn, struct json_object *obj);

bool conn_flush(struct vali_conn *conn);

bool conn_receive(struct vali_conn *conn, bool *eof);

bool conn_dequeue(struct vali_conn *conn, struct json_object **out);

bool set_sockaddr_un(struct sockaddr_un *addr, const char *path);

bool set_cloexec(int fd);

bool set_nonblock(int fd);

#endif
