/*
 * SPDX-FileCopyrightText: Copyright (c) NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef G_NV_NAME_RELEASED_H
#define G_NV_NAME_RELEASED_H

typedef struct _CHIPS_RELEASED {
    unsigned short devID;
    unsigned short subSystemID;
    unsigned short subSystemVendorID;
    const char *name;
} CHIPS_RELEASED;

static const CHIPS_RELEASED sChipsReleased[] = {
    { 0x1340, 0x0000, 0x0000, "NVIDIA GeForce 830M" },
    { 0x1340, 0x2b2b, 0x103c, "NVIDIA GeForce 830A" },
    { 0x1341, 0x0000, 0x0000, "NVIDIA GeForce 840M" },
    { 0x1341, 0x3697, 0x17aa, "NVIDIA GeForce 840A" },
    { 0x1341, 0x3699, 0x17aa, "NVIDIA GeForce 840A" },
    { 0x1341, 0x369c, 0x17aa, "NVIDIA GeForce 840A" },
    { 0x1341, 0x36af, 0x17aa, "NVIDIA GeForce 840A" },
    { 0x1344, 0x0000, 0x0000, "NVIDIA GeForce 845M" },
    { 0x1346, 0x0000, 0x0000, "NVIDIA GeForce 930M" },
    { 0x1346, 0x30ba, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1346, 0x362c, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1346, 0x362f, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1346, 0x3636, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1347, 0x0000, 0x0000, "NVIDIA GeForce 940M" },
    { 0x1347, 0x36b9, 0x17aa, "NVIDIA GeForce 940A" },
    { 0x1347, 0x36ba, 0x17aa, "NVIDIA GeForce 940A" },
    { 0x1348, 0x0000, 0x0000, "NVIDIA GeForce 945M" },
    { 0x1348, 0x2b5c, 0x103c, "NVIDIA GeForce 945A" },
    { 0x1349, 0x0000, 0x0000, "NVIDIA GeForce 930M" },
    { 0x1349, 0x3124, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1349, 0x364b, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1349, 0x36c3, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1349, 0x36d1, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x1349, 0x36d8, 0x17aa, "NVIDIA GeForce 930A" },
    { 0x134B, 0x0000, 0x0000, "NVIDIA GeForce 940MX" },
    { 0x134D, 0x0000, 0x0000, "NVIDIA GeForce 940MX" },
    { 0x134E, 0x0000, 0x0000, "NVIDIA GeForce 930MX" },
    { 0x134F, 0x0000, 0x0000, "NVIDIA GeForce 920MX" },
    { 0x137A, 0x0000, 0x0000, "NVIDIA N15M-Q3" },
    { 0x137A, 0x2225, 0x17aa, "Quadro K620M" },
    { 0x137A, 0x2232, 0x17aa, "Quadro M500M" },
    { 0x137A, 0x505a, 0x17aa, "Quadro M500M" },
    { 0x137B, 0x0000, 0x0000, "Quadro M520" },
    { 0x1380, 0x0000, 0x0000, "NVIDIA GeForce GTX 750 Ti" },
    { 0x1381, 0x0000, 0x0000, "NVIDIA GeForce GTX 750" },
    { 0x1382, 0x0000, 0x0000, "NVIDIA GeForce GTX 745" },
    { 0x1390, 0x0000, 0x0000, "NVIDIA GeForce 845M" },
    { 0x1391, 0x0000, 0x0000, "NVIDIA GeForce GTX 850M" },
    { 0x1391, 0x3697, 0x17aa, "NVIDIA GeForce GTX 850A" },
    { 0x1392, 0x0000, 0x0000, "NVIDIA GeForce GTX 860M" },
    { 0x1392, 0x066a, 0x1028, "NVIDIA GeForce GPU" },
    { 0x1392, 0x861e, 0x1043, "NVIDIA GeForce GTX 750 Ti" },
    { 0x1392, 0x86d9, 0x1043, "NVIDIA GeForce GTX 750 Ti" },
    { 0x1393, 0x0000, 0x0000, "NVIDIA GeForce 840M" },
    { 0x1398, 0x0000, 0x0000, "NVIDIA GeForce 845M" },
    { 0x1399, 0x0000, 0x0000, "NVIDIA GeForce 945M" },
    { 0x139A, 0x0000, 0x0000, "NVIDIA GeForce GTX 950M" },
    { 0x139A, 0x362c, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x362f, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x363f, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x3640, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x3647, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139A, 0x36b9, 0x17aa, "NVIDIA GeForce GTX 950A" },
    { 0x139B, 0x0000, 0x0000, "NVIDIA GeForce GTX 960M" },
    { 0x139B, 0x107a, 0x1025, "NVIDIA GeForce GTX 750 Ti" },
    { 0x139B, 0x06a3, 0x1028, "NVIDIA GeForce GTX 860M" },
    { 0x139B, 0x2b4c, 0x103c, "NVIDIA GeForce GTX 960A" },
    { 0x139B, 0x3649, 0x17aa, "NVIDIA GeForce GTX 750Ti" },
    { 0x139B, 0x36bf, 0x17aa, "NVIDIA GeForce GTX 960A" },
    { 0x139B, 0xc248, 0x19da, "NVIDIA GeForce GTX 750 Ti" },
    { 0x139B, 0x8a75, 0x1afa, "NVIDIA GeForce GTX 750Ti" },
    { 0x139C, 0x0000, 0x0000, "NVIDIA GeForce 940M" },
    { 0x139D, 0x0000, 0x0000, "NVIDIA GeForce GTX 750 Ti" },
    { 0x13B0, 0x0000, 0x0000, "Quadro M2000M" },
    { 0x13B1, 0x0000, 0x0000, "Quadro M1000M" },
    { 0x13B2, 0x0000, 0x0000, "Quadro M600M" },
    { 0x13B3, 0x0000, 0x0000, "Quadro K2200M" },
    { 0x13B4, 0x0000, 0x0000, "Quadro M620" },
    { 0x13B6, 0x0000, 0x0000, "Quadro M1200" },
    { 0x13B9, 0x0000, 0x0000, "NVS 810" },
    { 0x13BA, 0x0000, 0x0000, "Quadro K2200" },
    { 0x13BB, 0x0000, 0x0000, "Quadro K620" },
    { 0x13BC, 0x0000, 0x0000, "Quadro K1200" },
    { 0x13BC, 0x1140, 0x15c3, "EIZO Quadro MED-XN50LP" },
    { 0x13C0, 0x0000, 0x0000, "NVIDIA GeForce GTX 980" },
    { 0x13C2, 0x0000, 0x0000, "NVIDIA GeForce GTX 970" },
    { 0x13D7, 0x0000, 0x0000, "NVIDIA GeForce GTX 980M" },
    { 0x13D8, 0x0000, 0x0000, "NVIDIA GeForce GTX 970M" },
    { 0x13D8, 0x1198, 0x1462, "NVIDIA GeForce GTX 960" },
    { 0x13D8, 0x1199, 0x1462, "NVIDIA GeForce GTX 960" },
    { 0x13D8, 0xb282, 0x19da, "NVIDIA GeForce GTX 960" },
    { 0x13D8, 0xb284, 0x19da, "NVIDIA GeForce GTX 960" },
    { 0x13D8, 0xb286, 0x19da, "NVIDIA GeForce GTX 960" },
    { 0x13D9, 0x0000, 0x0000, "NVIDIA GeForce GTX 965M" },
    { 0x13DA, 0x0000, 0x0000, "NVIDIA GeForce GTX 980" },
    { 0x13F0, 0x0000, 0x0000, "Quadro M5000" },
    { 0x13F1, 0x0000, 0x0000, "Quadro M4000" },
    { 0x13F1, 0x1153, 0x15c3, "EIZO Quadro MED-XN90" },
    { 0x13F2, 0x0000, 0x0000, "Tesla M60" },
    { 0x13F3, 0x0000, 0x0000, "Tesla M6" },
    { 0x13F8, 0x0000, 0x0000, "Quadro M5000M" },
    { 0x13F8, 0x11dd, 0x10de, "Quadro M5000 SE" },
    { 0x13F9, 0x0000, 0x0000, "Quadro M4000M" },
    { 0x13FA, 0x0000, 0x0000, "Quadro M3000M" },
    { 0x13FA, 0x11c9, 0x10de, "Quadro M3000 SE" },
    { 0x13FB, 0x0000, 0x0000, "Quadro M5500" },
    { 0x1401, 0x0000, 0x0000, "NVIDIA GeForce GTX 960" },
    { 0x1402, 0x0000, 0x0000, "NVIDIA GeForce GTX 950" },
    { 0x1406, 0x0000, 0x0000, "NVIDIA GeForce GTX 960" },
    { 0x1407, 0x0000, 0x0000, "NVIDIA GeForce GTX 750" },
    { 0x1427, 0x0000, 0x0000, "NVIDIA GeForce GTX 965M" },
    { 0x1427, 0xd003, 0x1458, "NVIDIA GeForce GTX 950" },
    { 0x1430, 0x0000, 0x0000, "Quadro M2000" },
    { 0x1430, 0x1190, 0x15c3, "EIZO Quadro MED-XN70" },
    { 0x1431, 0x0000, 0x0000, "Tesla M4" },
    { 0x1436, 0x0000, 0x0000, "Quadro M2200" },
    { 0x15F0, 0x0000, 0x0000, "Quadro GP100" },
    { 0x15F7, 0x0000, 0x0000, "Tesla P100-PCIE-12GB" },
    { 0x15F8, 0x0000, 0x0000, "Tesla P100-PCIE-16GB" },
    { 0x15F9, 0x0000, 0x0000, "Tesla P100-SXM2-16GB" },
    { 0x1617, 0x0000, 0x0000, "NVIDIA GeForce GTX 980M" },
    { 0x1618, 0x0000, 0x0000, "NVIDIA GeForce GTX 970M" },
    { 0x1619, 0x0000, 0x0000, "NVIDIA GeForce GTX 965M" },
    { 0x161A, 0x0000, 0x0000, "NVIDIA GeForce GTX 980" },
    { 0x1667, 0x0000, 0x0000, "NVIDIA GeForce GTX 965M" },
    { 0x174D, 0x0000, 0x0000, "NVIDIA GeForce MX130" },
    { 0x174E, 0x0000, 0x0000, "NVIDIA GeForce MX110" },
    { 0x179C, 0x0000, 0x0000, "NVIDIA GeForce 940MX" },
    { 0x17C2, 0x0000, 0x0000, "NVIDIA GeForce GTX TITAN X" },
    { 0x17C8, 0x0000, 0x0000, "NVIDIA GeForce GTX 980 Ti" },
    { 0x17F0, 0x0000, 0x0000, "Quadro M6000" },
    { 0x17F1, 0x0000, 0x0000, "Quadro M6000 24GB" },
    { 0x17FD, 0x0000, 0x0000, "Tesla M40" },
    { 0x17FD, 0x1173, 0x10de, "Tesla M40 24GB" },
    { 0x1B00, 0x0000, 0x0000, "NVIDIA TITAN X (Pascal)" },
    { 0x1B02, 0x0000, 0x0000, "NVIDIA TITAN Xp" },
    { 0x1B02, 0x123e, 0x10de, "NVIDIA TITAN Xp COLLECTORS EDITION" },
    { 0x1B02, 0x123f, 0x10de, "NVIDIA TITAN Xp COLLECTORS EDITION" },
    { 0x1B06, 0x0000, 0x0000, "NVIDIA GeForce GTX 1080 Ti" },
    { 0x1B30, 0x0000, 0x0000, "Quadro P6000" },
    { 0x1B38, 0x0000, 0x0000, "Tesla P40" },
    { 0x1B80, 0x0000, 0x0000, "NVIDIA GeForce GTX 1080" },
    { 0x1B81, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070" },
    { 0x1B82, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070 Ti" },
    { 0x1B83, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 6GB" },
    { 0x1B84, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 3GB" },
    { 0x1B87, 0x0000, 0x0000, "NVIDIA P104-100" },
    { 0x1BA0, 0x0000, 0x0000, "NVIDIA GeForce GTX 1080" },
    { 0x1BA0, 0x0887, 0x1028, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BA1, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070" },
    { 0x1BA1, 0x08a1, 0x1028, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x08a2, 0x1028, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1cce, 0x1043, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1651, 0x1458, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1653, 0x1458, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x11e8, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x11e9, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1225, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1226, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1227, 0x1462, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x9501, 0x1558, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x95e1, 0x1558, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x2000, 0x1a58, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA1, 0x1032, 0x1d05, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BA2, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070" },
    { 0x1BB0, 0x0000, 0x0000, "Quadro P5000" },
    { 0x1BB1, 0x0000, 0x0000, "Quadro P4000" },
    { 0x1BB1, 0x11a3, 0x15c3, "EIZO Quadro MED-XN91" },
    { 0x1BB3, 0x11d8, 0x10de, "Tesla P4" },
    { 0x1BB3, 0x11e0, 0x10de, "Tesla P4" },
    { 0x1BB4, 0x0000, 0x0000, "Tesla P6" },
    { 0x1BB5, 0x0000, 0x0000, "Quadro P5200" },
    { 0x1BB5, 0x2268, 0x17aa, "Quadro P5200 with Max-Q Design" },
    { 0x1BB5, 0x2269, 0x17aa, "Quadro P5200 with Max-Q Design" },
    { 0x1BB6, 0x0000, 0x0000, "Quadro P5000" },
    { 0x1BB7, 0x0000, 0x0000, "Quadro P4000" },
    { 0x1BB7, 0x11e9, 0x1462, "Quadro P4000 with Max-Q Design" },
    { 0x1BB7, 0x9501, 0x1558, "Quadro P4000 with Max-Q Design" },
    { 0x1BB8, 0x0000, 0x0000, "Quadro P3000" },
    { 0x1BB9, 0x0000, 0x0000, "Quadro P4200" },
    { 0x1BB9, 0x95e1, 0x1558, "Quadro P4200 with Max-Q Design" },
    { 0x1BB9, 0x2268, 0x17aa, "Quadro P4200 with Max-Q Design" },
    { 0x1BB9, 0x2269, 0x17aa, "Quadro P4200 with Max-Q Design" },
    { 0x1BBB, 0x0000, 0x0000, "Quadro P3200" },
    { 0x1BBB, 0x225f, 0x17aa, "Quadro P3200 with Max-Q Design" },
    { 0x1BBB, 0x2262, 0x17aa, "Quadro P3200 with Max-Q Design" },
    { 0x1BC7, 0x0000, 0x0000, "NVIDIA P104-101" },
    { 0x1BE0, 0x0000, 0x0000, "NVIDIA GeForce GTX 1080" },
    { 0x1BE0, 0x1221, 0x1025, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x123e, 0x1025, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x07c0, 0x1028, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x0876, 0x1028, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x088b, 0x1028, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x1031, 0x1043, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x1bf0, 0x1043, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE0, 0x355b, 0x1458, "NVIDIA GeForce GTX 1080 with Max-Q Design" },
    { 0x1BE1, 0x0000, 0x0000, "NVIDIA GeForce GTX 1070" },
    { 0x1BE1, 0x84db, 0x103c, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BE1, 0x16f0, 0x1043, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1BE1, 0x2009, 0x3842, "NVIDIA GeForce GTX 1070 with Max-Q Design" },
    { 0x1C02, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 3GB" },
    { 0x1C03, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 6GB" },
    { 0x1C04, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 5GB" },
    { 0x1C06, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060 6GB" },
    { 0x1C07, 0x0000, 0x0000, "NVIDIA P106-100" },
    { 0x1C09, 0x0000, 0x0000, "NVIDIA P106-090" },
    { 0x1C20, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060" },
    { 0x1C20, 0x0802, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0803, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0825, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0827, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0885, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x0886, 0x1028, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x8467, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x8478, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x8581, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x1244, 0x1462, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x95e5, 0x1558, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x39b9, 0x17aa, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x2000, 0x1a58, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x2001, 0x1a58, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C20, 0x1059, 0x1d05, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C21, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C22, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C23, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060" },
    { 0x1C30, 0x0000, 0x0000, "Quadro P2000" },
    { 0x1C30, 0x11b3, 0x15c3, "EIZO Quadro MED-XN71" },
    { 0x1C31, 0x0000, 0x0000, "Quadro P2200" },
    { 0x1C31, 0x131b, 0x15c3, "EIZO Quadro MED-XN72" },
    { 0x1C60, 0x0000, 0x0000, "NVIDIA GeForce GTX 1060" },
    { 0x1C60, 0x8390, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C60, 0x8467, 0x103c, "NVIDIA GeForce GTX 1060 with Max-Q Design" },
    { 0x1C61, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C62, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C81, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C82, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C83, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C8C, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C8C, 0x087c, 0x1028, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x8519, 0x103c, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x856a, 0x103c, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x123c, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x126c, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x2266, 0x17aa, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x2267, 0x17aa, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8C, 0x39ff, 0x17aa, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8D, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C8D, 0x84e9, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x84eb, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x856a, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x114f, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1341, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1351, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1481, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x14a1, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x18c1, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1b5e, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x126c, 0x1462, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1217, 0x152d, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8D, 0x1707, 0x1d72, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C8F, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050 Ti" },
    { 0x1C8F, 0x123c, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8F, 0x126c, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8F, 0x126d, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8F, 0x1284, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C8F, 0x1297, 0x1462, "NVIDIA GeForce GTX 1050 Ti with Max-Q Design" },
    { 0x1C90, 0x0000, 0x0000, "NVIDIA GeForce MX150" },
    { 0x1C90, 0x09c1, 0x1028, "NVIDIA GeForce MX250" },
    { 0x1C91, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C91, 0x856a, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C91, 0x86e3, 0x103c, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C91, 0x1232, 0x152d, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C92, 0x0000, 0x0000, "NVIDIA GeForce GTX 1050" },
    { 0x1C92, 0x149f, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C92, 0x1b31, 0x1043, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C92, 0x1245, 0x1462, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C92, 0x126c, 0x1462, "NVIDIA GeForce GTX 1050 with Max-Q Design" },
    { 0x1C94, 0x0000, 0x0000, "NVIDIA GeForce MX350" },
    { 0x1C96, 0x0000, 0x0000, "NVIDIA GeForce MX350" },
    { 0x1CB1, 0x0000, 0x0000, "Quadro P1000" },
    { 0x1CB1, 0x11bc, 0x15c3, "EIZO Quadro MED-XN51LP" },
    { 0x1CB2, 0x0000, 0x0000, "Quadro P600" },
    { 0x1CB3, 0x0000, 0x0000, "Quadro P400" },
    { 0x1CB3, 0x11be, 0x15c3, "EIZO Quadro MED-XN31LP" },
    { 0x1CB6, 0x0000, 0x0000, "Quadro P620" },
    { 0x1CBA, 0x0000, 0x0000, "Quadro P2000" },
    { 0x1CBA, 0x2266, 0x17aa, "Quadro P2000 with Max-Q Design" },
    { 0x1CBA, 0x2267, 0x17aa, "Quadro P2000 with Max-Q Design" },
    { 0x1CBB, 0x0000, 0x0000, "Quadro P1000" },
    { 0x1CBC, 0x0000, 0x0000, "Quadro P600" },
    { 0x1CBD, 0x0000, 0x0000, "Quadro P620" },
    { 0x1CFA, 0x0000, 0x0000, "Quadro P2000" },
    { 0x1CFB, 0x0000, 0x0000, "Quadro P1000" },
    { 0x1CFB, 0x2600, 0x102b, "Matrox D-Series D1480" },
    { 0x1CFB, 0x2700, 0x102b, "Matrox D-Series D1450" },
    { 0x1D01, 0x0000, 0x0000, "NVIDIA GeForce GT 1030" },
    { 0x1D02, 0x0000, 0x0000, "NVIDIA GeForce GT 1010" },
    { 0x1D10, 0x0000, 0x0000, "NVIDIA GeForce MX150" },
    { 0x1D11, 0x0000, 0x0000, "NVIDIA GeForce MX230" },
    { 0x1D12, 0x0000, 0x0000, "NVIDIA GeForce MX150" },
    { 0x1D13, 0x0000, 0x0000, "NVIDIA GeForce MX250" },
    { 0x1D16, 0x0000, 0x0000, "NVIDIA GeForce MX330" },
    { 0x1D33, 0x0000, 0x0000, "Quadro P500" },
    { 0x1D34, 0x0000, 0x0000, "Quadro P520" },
    { 0x1D52, 0x0000, 0x0000, "NVIDIA GeForce MX250" },
    { 0x1D81, 0x0000, 0x0000, "NVIDIA TITAN V" },
    { 0x1DB1, 0x0000, 0x0000, "Tesla V100-SXM2-16GB" },
    { 0x1DB1, 0x1307, 0x10de, "Tesla V100-SXM2-16GB-LS" },
    { 0x1DB3, 0x0000, 0x0000, "Tesla V100-FHHL-16GB" },
    { 0x1DB4, 0x0000, 0x0000, "Tesla V100-PCIE-16GB" },
    { 0x1DB4, 0x1306, 0x10de, "Tesla V100-PCIE-16GB-LS" },
    { 0x1DB5, 0x0000, 0x0000, "Tesla V100-SXM2-32GB" },
    { 0x1DB5, 0x1308, 0x10de, "Tesla V100-SXM2-32GB-LS" },
    { 0x1DB6, 0x0000, 0x0000, "Tesla V100-PCIE-32GB" },
    { 0x1DB7, 0x0000, 0x0000, "Tesla V100-DGXS-32GB" },
    { 0x1DB8, 0x0000, 0x0000, "Tesla V100-SXM3-32GB" },
    { 0x1DB8, 0x131d, 0x10de, "Tesla V100-SXM3-32GB-H" },
    { 0x1DBA, 0x0000, 0x0000, "Quadro GV100" },
    { 0x1DBA, 0x12eb, 0x10de, "NVIDIA TITAN V JHH Special Edition" },
    { 0x1DF0, 0x0000, 0x0000, "Tesla PG500-216" },
    { 0x1DF2, 0x0000, 0x0000, "Tesla PG503-216" },
    { 0x1DF6, 0x0000, 0x0000, "Tesla V100S-PCIE-32GB" },
    { 0x1E02, 0x0000, 0x0000, "NVIDIA TITAN RTX" },
    { 0x1E04, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 Ti" },
    { 0x1E07, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 Ti" },
    { 0x1E09, 0x0000, 0x0000, "NVIDIA CMP 50HX" },
    { 0x1E30, 0x0000, 0x0000, "Quadro RTX 6000" },
    { 0x1E30, 0x129e, 0x1028, "Quadro RTX 8000" },
    { 0x1E30, 0x129e, 0x103c, "Quadro RTX 8000" },
    { 0x1E30, 0x129e, 0x10de, "Quadro RTX 8000" },
    { 0x1E36, 0x0000, 0x0000, "Quadro RTX 6000" },
    { 0x1E78, 0x13d8, 0x10de, "Quadro RTX 8000" },
    { 0x1E78, 0x13d9, 0x10de, "Quadro RTX 6000" },
    { 0x1E81, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 SUPER" },
    { 0x1E82, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080" },
    { 0x1E84, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 SUPER" },
    { 0x1E87, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080" },
    { 0x1E89, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1E90, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080" },
    { 0x1E90, 0x1375, 0x1025, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08a1, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08a2, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ea, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08eb, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ec, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ed, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ee, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x08ef, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x093b, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x093c, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x8572, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x8573, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x8602, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x8606, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x86c6, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x86c7, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x87a6, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x87a7, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x131f, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x137f, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x141f, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1751, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1660, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1661, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1662, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x75a6, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x75a7, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x86a6, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x86a7, 0x1458, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1274, 0x1462, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1277, 0x1462, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1220, 0x152d, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x95e1, 0x1558, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x97e1, 0x1558, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x2002, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x2005, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x2007, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x3000, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x3001, 0x1a58, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E90, 0x1069, 0x1d05, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1E91, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 Super" },
    { 0x1E91, 0x8607, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x8736, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x8738, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x8772, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x878a, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x878b, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x1e61, 0x1043, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x1511, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x75b3, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x75b4, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x76b2, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x76b3, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x78a2, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x78a3, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x86b2, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x86b3, 0x1458, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x12ae, 0x1462, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x12b0, 0x1462, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x12c6, 0x1462, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x22c3, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x22c5, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x2009, 0x1a58, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x200a, 0x1a58, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x3002, 0x1a58, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E91, 0x3012, 0x8086, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1E93, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 Super" },
    { 0x1E93, 0x1401, 0x1025, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x149c, 0x1025, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x09d2, 0x1028, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x8607, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x86c7, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x8736, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x8738, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x8772, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x87a6, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x87a7, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x75b1, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x75b2, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x76b0, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x76b1, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x78a0, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x78a1, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x86b0, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x86b1, 0x1458, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x12ae, 0x1462, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x12b0, 0x1462, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x12b4, 0x1462, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x12c6, 0x1462, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x50d3, 0x1558, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x70d1, 0x1558, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x22c3, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x22c5, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x2009, 0x1a58, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x200a, 0x1a58, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x3002, 0x1a58, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1E93, 0x1089, 0x1d05, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1EB0, 0x0000, 0x0000, "Quadro RTX 5000" },
    { 0x1EB1, 0x0000, 0x0000, "Quadro RTX 4000" },
    { 0x1EB1, 0x12a0, 0x15c3, "EIZO Quadro MED-XN92" },
    { 0x1EB5, 0x0000, 0x0000, "Quadro RTX 5000" },
    { 0x1EB5, 0x1375, 0x1025, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x1401, 0x1025, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x149c, 0x1025, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x09c3, 0x1028, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8736, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8738, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8772, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8780, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8782, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8783, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x8785, 0x103c, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x1dd1, 0x1043, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x1274, 0x1462, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x12b0, 0x1462, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x12c6, 0x1462, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x22b8, 0x17aa, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x22ba, 0x17aa, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x2005, 0x1a58, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x2007, 0x1a58, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x2008, 0x1a58, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB5, 0x200a, 0x1a58, "Quadro RTX 5000 with Max-Q Design" },
    { 0x1EB6, 0x0000, 0x0000, "Quadro RTX 4000" },
    { 0x1EB6, 0x09c3, 0x1028, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8736, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8738, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8772, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8780, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8782, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8783, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x8785, 0x103c, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x1274, 0x1462, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x1277, 0x1462, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x12b0, 0x1462, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x12c6, 0x1462, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x22b8, 0x17aa, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB6, 0x22ba, 0x17aa, "Quadro RTX 4000 with Max-Q Design" },
    { 0x1EB8, 0x12a2, 0x10de, "Tesla T4" },
    { 0x1EC2, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 SUPER" },
    { 0x1EC7, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 SUPER" },
    { 0x1ED0, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080" },
    { 0x1ED0, 0x132d, 0x1025, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x08ed, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x08ee, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x08ef, 0x1028, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x8572, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x8573, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x8600, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x8605, 0x103c, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x138f, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x15c1, 0x1043, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x3fee, 0x17aa, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED0, 0x3ffe, 0x17aa, "NVIDIA GeForce RTX 2080 with Max-Q Design" },
    { 0x1ED1, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070 Super" },
    { 0x1ED1, 0x1432, 0x1025, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x8746, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x878a, 0x103c, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x165f, 0x1043, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0xc192, 0x144d, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x3fce, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x3fcf, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED1, 0x3fd0, 0x17aa, "NVIDIA GeForce RTX 2070 Super with Max-Q Design" },
    { 0x1ED3, 0x0000, 0x0000, "NVIDIA GeForce RTX 2080 Super" },
    { 0x1ED3, 0x1432, 0x1025, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x09d1, 0x1028, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x8746, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x878a, 0x103c, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x1d61, 0x1043, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x1e51, 0x1043, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x1f01, 0x1043, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x3fce, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x3fcf, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1ED3, 0x3fd0, 0x17aa, "NVIDIA GeForce RTX 2080 Super with Max-Q Design" },
    { 0x1EF5, 0x0000, 0x0000, "Quadro RTX 5000" },
    { 0x1F02, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F03, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F06, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060 SUPER" },
    { 0x1F07, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F08, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F0A, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F0B, 0x0000, 0x0000, "NVIDIA CMP 40HX" },
    { 0x1F10, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F10, 0x132d, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1342, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08a1, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08a2, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ea, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08eb, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ec, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ed, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ee, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x08ef, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x093b, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x093c, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x8572, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x8573, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x8602, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x8606, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x132f, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x136f, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1881, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1e6e, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1658, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1663, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1664, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x75a4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x75a5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x86a4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x86a5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1274, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1277, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x95e1, 0x1558, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x97e1, 0x1558, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2002, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2005, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2007, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x3000, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x3001, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x105e, 0x1d05, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x1070, 0x1d05, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2087, 0x1d05, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F10, 0x2087, 0x8086, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F11, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F12, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F12, 0x098f, 0x1028, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x8741, 0x103c, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x8744, 0x103c, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x878e, 0x103c, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x880e, 0x103c, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x1e11, 0x1043, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x1f11, 0x1043, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x12d9, 0x1462, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x3801, 0x17aa, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x3802, 0x17aa, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F12, 0x3803, 0x17aa, "NVIDIA GeForce RTX 2060 with Max-Q Design" },
    { 0x1F14, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F14, 0x1401, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x1432, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x1442, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x1446, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x147d, 0x1025, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x09e2, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x09f3, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8607, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x86c6, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x86c7, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8736, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8738, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8746, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x8772, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x878a, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x878b, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x87a6, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x87a7, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x174f, 0x1043, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x1512, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x75b5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x75b6, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x76b4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x76b5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x78a4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x78a5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x86b4, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x86b5, 0x1458, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x12ae, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x12b0, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x12c6, 0x1462, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x50d3, 0x1558, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x70d1, 0x1558, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x200c, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x2011, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F14, 0x3002, 0x1a58, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F15, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F36, 0x0000, 0x0000, "Quadro RTX 3000" },
    { 0x1F36, 0x0990, 0x1028, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x8736, 0x103c, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x8738, 0x103c, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x8772, 0x103c, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x13cf, 0x1043, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F36, 0x0032, 0x1414, "Quadro RTX 3000 with Max-Q Design" },
    { 0x1F42, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060 SUPER" },
    { 0x1F47, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060 SUPER" },
    { 0x1F50, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F50, 0x08ed, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x08ee, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x08ef, 0x1028, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8572, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8573, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8574, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8600, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x8605, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x3fee, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F50, 0x3ffe, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F51, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F54, 0x0000, 0x0000, "NVIDIA GeForce RTX 2070" },
    { 0x1F54, 0x878a, 0x103c, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F54, 0x3fce, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F54, 0x3fcf, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F54, 0x3fd0, 0x17aa, "NVIDIA GeForce RTX 2070 with Max-Q Design" },
    { 0x1F55, 0x0000, 0x0000, "NVIDIA GeForce RTX 2060" },
    { 0x1F76, 0x0000, 0x0000, "Quadro RTX 3000" },
    { 0x1F76, 0x2800, 0x102b, "Matrox D-Series D2450" },
    { 0x1F76, 0x2900, 0x102b, "Matrox D-Series D2480" },
    { 0x1F82, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F83, 0x0000, 0x0000, "NVIDIA GeForce GTX 1630" },
    { 0x1F91, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F91, 0x863e, 0x103c, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x86e7, 0x103c, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x86e8, 0x103c, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x12cf, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x156f, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x0032, 0x1414, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0xc822, 0x144d, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x127e, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x1281, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x1284, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x1285, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x129c, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x229f, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x3802, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x3806, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x3f1a, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F91, 0x1001, 0x1a58, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F95, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650 Ti" },
    { 0x1F95, 0x1479, 0x1025, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x147a, 0x1025, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x147b, 0x1025, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x147c, 0x1025, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x86e7, 0x103c, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x86e8, 0x103c, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x8815, 0x103c, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1dff, 0x1043, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1e1f, 0x1043, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0xc838, 0x144d, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x12bd, 0x1462, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x12c5, 0x1462, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x12d2, 0x1462, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x22c0, 0x17aa, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x22c1, 0x17aa, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x3837, 0x17aa, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x3f95, 0x17aa, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1003, 0x1a58, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1006, 0x1a58, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x1007, 0x1a58, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F95, 0x3e30, 0x1e83, "NVIDIA GeForce GTX 1650 Ti with Max-Q Design" },
    { 0x1F96, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F96, 0x1297, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F97, 0x0000, 0x0000, "NVIDIA GeForce MX450" },
    { 0x1F98, 0x0000, 0x0000, "NVIDIA GeForce MX450" },
    { 0x1F99, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F99, 0x1479, 0x1025, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x147a, 0x1025, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x147b, 0x1025, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x147c, 0x1025, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x8815, 0x103c, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x13b2, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x1402, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x1902, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x12bd, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x12c5, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x12d2, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x22da, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x3f93, 0x17aa, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F99, 0x3e30, 0x1e83, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9C, 0x0000, 0x0000, "NVIDIA GeForce MX450" },
    { 0x1F9D, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1F9D, 0x128d, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x130d, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x149c, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x185c, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x189c, 0x1043, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x12f4, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x1302, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x131b, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x1326, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x132a, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9D, 0x132e, 0x1462, "NVIDIA GeForce GTX 1650 with Max-Q Design" },
    { 0x1F9F, 0x0000, 0x0000, "NVIDIA GeForce MX550" },
    { 0x1FA0, 0x0000, 0x0000, "NVIDIA GeForce MX550" },
    { 0x1FB0, 0x12db, 0x1028, "NVIDIA T1000" },
    { 0x1FB0, 0x12db, 0x103c, "NVIDIA T1000" },
    { 0x1FB0, 0x8a80, 0x103c, "NVIDIA T1000" },
    { 0x1FB0, 0x12db, 0x10de, "NVIDIA T1000" },
    { 0x1FB0, 0x1485, 0x10de, "NVIDIA DGX Display" },
    { 0x1FB0, 0x12db, 0x17aa, "NVIDIA T1000" },
    { 0x1FB1, 0x1488, 0x1028, "NVIDIA T600" },
    { 0x1FB1, 0x1488, 0x103c, "NVIDIA T600" },
    { 0x1FB1, 0x8a80, 0x103c, "NVIDIA T600" },
    { 0x1FB1, 0x1488, 0x10de, "NVIDIA T600" },
    { 0x1FB1, 0x1488, 0x17aa, "NVIDIA T600" },
    { 0x1FB2, 0x1489, 0x1028, "NVIDIA T400" },
    { 0x1FB2, 0x1489, 0x103c, "NVIDIA T400" },
    { 0x1FB2, 0x8a80, 0x103c, "NVIDIA T400" },
    { 0x1FB2, 0x1489, 0x10de, "NVIDIA T400" },
    { 0x1FB2, 0x1489, 0x17aa, "NVIDIA T400" },
    { 0x1FB6, 0x0000, 0x0000, "NVIDIA T600 Laptop GPU" },
    { 0x1FB7, 0x0000, 0x0000, "NVIDIA T550 Laptop GPU" },
    { 0x1FB8, 0x0000, 0x0000, "Quadro T2000" },
    { 0x1FB8, 0x097e, 0x1028, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8736, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8738, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8772, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8780, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8782, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8783, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x8785, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x87f0, 0x103c, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x1281, 0x1462, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x12bd, 0x1462, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x22c0, 0x17aa, "Quadro T2000 with Max-Q Design" },
    { 0x1FB8, 0x22c1, 0x17aa, "Quadro T2000 with Max-Q Design" },
    { 0x1FB9, 0x0000, 0x0000, "Quadro T1000" },
    { 0x1FB9, 0x1479, 0x1025, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x147a, 0x1025, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x147b, 0x1025, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x147c, 0x1025, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8736, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8738, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8772, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8780, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8782, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8783, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x8785, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x87f0, 0x103c, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x12bd, 0x1462, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x22c0, 0x17aa, "Quadro T1000 with Max-Q Design" },
    { 0x1FB9, 0x22c1, 0x17aa, "Quadro T1000 with Max-Q Design" },
    { 0x1FBA, 0x0000, 0x0000, "NVIDIA T600 Laptop GPU" },
    { 0x1FBB, 0x0000, 0x0000, "NVIDIA T500" },
    { 0x1FBC, 0x0000, 0x0000, "NVIDIA T1200 Laptop GPU" },
    { 0x1FDD, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x1FF0, 0x1612, 0x1028, "NVIDIA T1000 8GB" },
    { 0x1FF0, 0x1612, 0x103c, "NVIDIA T1000 8GB" },
    { 0x1FF0, 0x8a80, 0x103c, "NVIDIA T1000 8GB" },
    { 0x1FF0, 0x1612, 0x10de, "NVIDIA T1000 8GB" },
    { 0x1FF0, 0x1612, 0x17aa, "NVIDIA T1000 8GB" },
    { 0x1FF2, 0x1613, 0x1028, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x1613, 0x103c, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x18ff, 0x103c, "NVIDIA T400E" },
    { 0x1FF2, 0x8a80, 0x103c, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x1613, 0x10de, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x18ff, 0x10de, "NVIDIA T400E" },
    { 0x1FF2, 0x1613, 0x17aa, "NVIDIA T400 4GB" },
    { 0x1FF2, 0x18ff, 0x17aa, "NVIDIA T400E" },
    { 0x1FF9, 0x0000, 0x0000, "Quadro T1000" },
    { 0x20B0, 0x0000, 0x0000, "NVIDIA A100-SXM4-40GB" },
    { 0x20B0, 0x1450, 0x10de, "NVIDIA A100-PG509-200" },
    { 0x20B2, 0x1463, 0x10de, "NVIDIA A100-SXM4-80GB" },
    { 0x20B2, 0x147f, 0x10de, "NVIDIA A100-SXM4-80GB" },
    { 0x20B2, 0x1622, 0x10de, "NVIDIA A100-SXM4-80GB" },
    { 0x20B2, 0x1623, 0x10de, "NVIDIA A100-SXM4-80GB" },
    { 0x20B2, 0x1625, 0x10de, "NVIDIA PG509-210" },
    { 0x20B3, 0x14a7, 0x10de, "NVIDIA A100-SXM-64GB" },
    { 0x20B3, 0x14a8, 0x10de, "NVIDIA A100-SXM-64GB" },
    { 0x20B5, 0x1533, 0x10de, "NVIDIA A100 80GB PCIe" },
    { 0x20B5, 0x1642, 0x10de, "NVIDIA A100 80GB PCIe" },
    { 0x20B6, 0x1492, 0x10de, "NVIDIA PG506-232" },
    { 0x20B7, 0x1532, 0x10de, "NVIDIA A30" },
    { 0x20B7, 0x1804, 0x10de, "NVIDIA A30" },
    { 0x20B7, 0x1852, 0x10de, "NVIDIA A30" },
    { 0x20BD, 0x17f4, 0x10de, "NVIDIA A800-SXM4-40GB" },
    { 0x20F1, 0x145f, 0x10de, "NVIDIA A100-PCIE-40GB" },
    { 0x20F3, 0x179b, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x179c, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x179d, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x179e, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x179f, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x17a0, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x17a1, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F3, 0x17a2, 0x10de, "NVIDIA A800-SXM4-80GB" },
    { 0x20F5, 0x1799, 0x10de, "NVIDIA A800 80GB PCIe" },
    { 0x20F5, 0x179a, 0x10de, "NVIDIA A800 80GB PCIe LC" },
    { 0x20F6, 0x180a, 0x1028, "NVIDIA A800 40GB Active" },
    { 0x20F6, 0x180a, 0x103c, "NVIDIA A800 40GB Active" },
    { 0x20F6, 0x180a, 0x10de, "NVIDIA A800 40GB Active" },
    { 0x20F6, 0x180a, 0x17aa, "NVIDIA A800 40GB Active" },
    { 0x20FD, 0x17f8, 0x10de, "NVIDIA AX800" },
    { 0x2182, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660 Ti" },
    { 0x2184, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660" },
    { 0x2187, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650 SUPER" },
    { 0x2188, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650" },
    { 0x2189, 0x0000, 0x0000, "NVIDIA CMP 30HX" },
    { 0x2191, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660 Ti" },
    { 0x2191, 0x0949, 0x1028, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x85fb, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x85fe, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x86d6, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x8741, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x8744, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x878d, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x87af, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x87b3, 0x103c, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x171f, 0x1043, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x17ef, 0x1043, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x18d1, 0x1043, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x0032, 0x1414, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x128a, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x128b, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x12c6, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x12cb, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x12cc, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x12d9, 0x1462, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x380c, 0x17aa, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x381d, 0x17aa, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2191, 0x381e, 0x17aa, "NVIDIA GeForce GTX 1660 Ti with Max-Q Design" },
    { 0x2192, 0x0000, 0x0000, "NVIDIA GeForce GTX 1650 Ti" },
    { 0x21C4, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660 SUPER" },
    { 0x21D1, 0x0000, 0x0000, "NVIDIA GeForce GTX 1660 Ti" },
    { 0x2203, 0x0000, 0x0000, "NVIDIA GeForce RTX 3090 Ti" },
    { 0x2204, 0x0000, 0x0000, "NVIDIA GeForce RTX 3090" },
    { 0x2206, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080" },
    { 0x2207, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Ti" },
    { 0x2208, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Ti" },
    { 0x220A, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080" },
    { 0x220D, 0x0000, 0x0000, "NVIDIA CMP 90HX" },
    { 0x2216, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080" },
    { 0x2230, 0x1459, 0x1028, "NVIDIA RTX A6000" },
    { 0x2230, 0x1459, 0x103c, "NVIDIA RTX A6000" },
    { 0x2230, 0x1459, 0x10de, "NVIDIA RTX A6000" },
    { 0x2230, 0x1459, 0x17aa, "NVIDIA RTX A6000" },
    { 0x2231, 0x147e, 0x1028, "NVIDIA RTX A5000" },
    { 0x2231, 0x147e, 0x103c, "NVIDIA RTX A5000" },
    { 0x2231, 0x147e, 0x10de, "NVIDIA RTX A5000" },
    { 0x2231, 0x147e, 0x17aa, "NVIDIA RTX A5000" },
    { 0x2232, 0x163c, 0x1028, "NVIDIA RTX A4500" },
    { 0x2232, 0x163c, 0x103c, "NVIDIA RTX A4500" },
    { 0x2232, 0x163c, 0x10de, "NVIDIA RTX A4500" },
    { 0x2232, 0x163c, 0x17aa, "NVIDIA RTX A4500" },
    { 0x2233, 0x165a, 0x1028, "NVIDIA RTX A5500" },
    { 0x2233, 0x165a, 0x103c, "NVIDIA RTX A5500" },
    { 0x2233, 0x165a, 0x10de, "NVIDIA RTX A5500" },
    { 0x2233, 0x165a, 0x17aa, "NVIDIA RTX A5500" },
    { 0x2235, 0x145a, 0x10de, "NVIDIA A40" },
    { 0x2236, 0x1482, 0x10de, "NVIDIA A10" },
    { 0x2237, 0x152f, 0x10de, "NVIDIA A10G" },
    { 0x2238, 0x1677, 0x10de, "NVIDIA A10M" },
    { 0x2321, 0x1839, 0x10de, "NVIDIA H100 NVL" },
    { 0x2322, 0x17a4, 0x10de, "NVIDIA H800 PCIe" },
    { 0x2324, 0x17a6, 0x10de, "NVIDIA H800" },
    { 0x2324, 0x17a8, 0x10de, "NVIDIA H800" },
    { 0x2329, 0x198b, 0x10de, "NVIDIA H20" },
    { 0x2329, 0x198c, 0x10de, "NVIDIA H20" },
    { 0x232C, 0x2063, 0x10de, "NVIDIA H20-3e" },
    { 0x2330, 0x16c0, 0x10de, "NVIDIA H100 80GB HBM3" },
    { 0x2330, 0x16c1, 0x10de, "NVIDIA H100 80GB HBM3" },
    { 0x2331, 0x1626, 0x10de, "NVIDIA H100 PCIe" },
    { 0x2335, 0x18be, 0x10de, "NVIDIA H200" },
    { 0x2335, 0x18bf, 0x10de, "NVIDIA H200" },
    { 0x2339, 0x17fc, 0x10de, "NVIDIA H100" },
    { 0x233A, 0x183a, 0x10de, "NVIDIA H800 NVL" },
    { 0x233B, 0x1996, 0x10de, "NVIDIA H200 NVL" },
    { 0x2342, 0x16eb, 0x10de, "NVIDIA GH200 120GB" },
    { 0x2342, 0x1805, 0x10de, "NVIDIA GH200 120GB" },
    { 0x2342, 0x1809, 0x10de, "NVIDIA GH200 480GB" },
    { 0x2348, 0x18d2, 0x10de, "NVIDIA GH200 144G HBM3e" },
    { 0x2414, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Ti" },
    { 0x2420, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Ti Laptop GPU" },
    { 0x2438, 0x0000, 0x0000, "NVIDIA RTX A5500 Laptop GPU" },
    { 0x2460, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Ti Laptop GPU" },
    { 0x2482, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Ti" },
    { 0x2484, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070" },
    { 0x2486, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Ti" },
    { 0x2487, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x2488, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070" },
    { 0x2489, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Ti" },
    { 0x248A, 0x0000, 0x0000, "NVIDIA CMP 70HX" },
    { 0x249C, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Laptop GPU" },
    { 0x249C, 0x1194, 0x1d05, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x249D, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Laptop GPU" },
    { 0x24A0, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Ti Laptop GPU" },
    { 0x24A0, 0x1192, 0x1d05, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x24B0, 0x14ad, 0x1028, "NVIDIA RTX A4000" },
    { 0x24B0, 0x14ad, 0x103c, "NVIDIA RTX A4000" },
    { 0x24B0, 0x14ad, 0x10de, "NVIDIA RTX A4000" },
    { 0x24B0, 0x14ad, 0x17aa, "NVIDIA RTX A4000" },
    { 0x24B1, 0x1658, 0x10de, "NVIDIA RTX A4000H" },
    { 0x24B6, 0x0000, 0x0000, "NVIDIA RTX A5000 Laptop GPU" },
    { 0x24B7, 0x0000, 0x0000, "NVIDIA RTX A4000 Laptop GPU" },
    { 0x24B8, 0x0000, 0x0000, "NVIDIA RTX A3000 Laptop GPU" },
    { 0x24B9, 0x0000, 0x0000, "NVIDIA RTX A3000 12GB Laptop GPU" },
    { 0x24BA, 0x0000, 0x0000, "NVIDIA RTX A4500 Laptop GPU" },
    { 0x24BB, 0x0000, 0x0000, "NVIDIA RTX A3000 12GB Laptop GPU" },
    { 0x24C7, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x24C9, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Ti" },
    { 0x24DC, 0x0000, 0x0000, "NVIDIA GeForce RTX 3080 Laptop GPU" },
    { 0x24DD, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Laptop GPU" },
    { 0x24E0, 0x0000, 0x0000, "NVIDIA GeForce RTX 3070 Ti Laptop GPU" },
    { 0x24FA, 0x0000, 0x0000, "NVIDIA RTX A4500 Embedded GPU" },
    { 0x2503, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x2504, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x2507, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050" },
    { 0x2508, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 OEM" },
    { 0x2520, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x2521, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x2523, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x2531, 0x151d, 0x1028, "NVIDIA RTX A2000" },
    { 0x2531, 0x151d, 0x103c, "NVIDIA RTX A2000" },
    { 0x2531, 0x151d, 0x10de, "NVIDIA RTX A2000" },
    { 0x2531, 0x151d, 0x17aa, "NVIDIA RTX A2000" },
    { 0x2544, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060" },
    { 0x2560, 0x0000, 0x0000, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x2563, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x2571, 0x1611, 0x1028, "NVIDIA RTX A2000 12GB" },
    { 0x2571, 0x1611, 0x103c, "NVIDIA RTX A2000 12GB" },
    { 0x2571, 0x1611, 0x10de, "NVIDIA RTX A2000 12GB" },
    { 0x2571, 0x1611, 0x17aa, "NVIDIA RTX A2000 12GB" },
    { 0x2582, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050" },
    { 0x2584, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050" },
    { 0x25A0, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x25A0, 0x8928, 0x103c, "NVIDIA GeForce RTX 3050Ti Laptop GPU" },
    { 0x25A0, 0x89f9, 0x103c, "NVIDIA GeForce RTX 3050Ti Laptop GPU" },
    { 0x25A0, 0x1196, 0x1d05, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x25A2, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Laptop GPU" },
    { 0x25A2, 0x0baf, 0x1028, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x25A2, 0x1195, 0x1d05, "NVIDIA GeForce RTX 3060 Laptop GPU" },
    { 0x25A5, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Laptop GPU" },
    { 0x25A6, 0x0000, 0x0000, "NVIDIA GeForce MX570" },
    { 0x25A7, 0x0000, 0x0000, "NVIDIA GeForce RTX 2050" },
    { 0x25A9, 0x0000, 0x0000, "NVIDIA GeForce RTX 2050" },
    { 0x25AA, 0x0000, 0x0000, "NVIDIA GeForce MX570 A" },
    { 0x25AB, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 4GB Laptop GPU" },
    { 0x25AC, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 6GB Laptop GPU" },
    { 0x25AD, 0x0000, 0x0000, "NVIDIA GeForce RTX 2050" },
    { 0x25B0, 0x1878, 0x1028, "NVIDIA RTX A1000" },
    { 0x25B0, 0x1878, 0x103c, "NVIDIA RTX A1000" },
    { 0x25B0, 0x8d96, 0x103c, "NVIDIA RTX A1000" },
    { 0x25B0, 0x1878, 0x10de, "NVIDIA RTX A1000" },
    { 0x25B0, 0x1878, 0x17aa, "NVIDIA RTX A1000" },
    { 0x25B2, 0x1879, 0x1028, "NVIDIA RTX A400" },
    { 0x25B2, 0x1879, 0x103c, "NVIDIA RTX A400" },
    { 0x25B2, 0x8d95, 0x103c, "NVIDIA RTX A400" },
    { 0x25B2, 0x1879, 0x10de, "NVIDIA RTX A400" },
    { 0x25B2, 0x1879, 0x17aa, "NVIDIA RTX A400" },
    { 0x25B6, 0x14a9, 0x10de, "NVIDIA A16" },
    { 0x25B6, 0x157e, 0x10de, "NVIDIA A2" },
    { 0x25B8, 0x0000, 0x0000, "NVIDIA RTX A2000 Laptop GPU" },
    { 0x25B9, 0x0000, 0x0000, "NVIDIA RTX A1000 Laptop GPU" },
    { 0x25BA, 0x0000, 0x0000, "NVIDIA RTX A2000 8GB Laptop GPU" },
    { 0x25BB, 0x0000, 0x0000, "NVIDIA RTX A500 Laptop GPU" },
    { 0x25BC, 0x0000, 0x0000, "NVIDIA RTX A1000 6GB Laptop GPU" },
    { 0x25BD, 0x0000, 0x0000, "NVIDIA RTX A500 Laptop GPU" },
    { 0x25E0, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Ti Laptop GPU" },
    { 0x25E2, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Laptop GPU" },
    { 0x25E5, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 Laptop GPU" },
    { 0x25EC, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 6GB Laptop GPU" },
    { 0x25ED, 0x0000, 0x0000, "NVIDIA GeForce RTX 2050" },
    { 0x25F9, 0x0000, 0x0000, "NVIDIA RTX A1000 Embedded GPU" },
    { 0x25FA, 0x0000, 0x0000, "NVIDIA RTX A2000 Embedded GPU" },
    { 0x25FB, 0x0000, 0x0000, "NVIDIA RTX A500 Embedded GPU" },
    { 0x2684, 0x0000, 0x0000, "NVIDIA GeForce RTX 4090" },
    { 0x2685, 0x0000, 0x0000, "NVIDIA GeForce RTX 4090 D" },
    { 0x2689, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Ti SUPER" },
    { 0x26B1, 0x16a1, 0x1028, "NVIDIA RTX 6000 Ada Generation" },
    { 0x26B1, 0x16a1, 0x103c, "NVIDIA RTX 6000 Ada Generation" },
    { 0x26B1, 0x16a1, 0x10de, "NVIDIA RTX 6000 Ada Generation" },
    { 0x26B1, 0x16a1, 0x17aa, "NVIDIA RTX 6000 Ada Generation" },
    { 0x26B2, 0x17fa, 0x1028, "NVIDIA RTX 5000 Ada Generation" },
    { 0x26B2, 0x17fa, 0x103c, "NVIDIA RTX 5000 Ada Generation" },
    { 0x26B2, 0x17fa, 0x10de, "NVIDIA RTX 5000 Ada Generation" },
    { 0x26B2, 0x17fa, 0x17aa, "NVIDIA RTX 5000 Ada Generation" },
    { 0x26B3, 0x1934, 0x1028, "NVIDIA RTX 5880 Ada Generation" },
    { 0x26B3, 0x1934, 0x103c, "NVIDIA RTX 5880 Ada Generation" },
    { 0x26B3, 0x1934, 0x10de, "NVIDIA RTX 5880 Ada Generation" },
    { 0x26B3, 0x1934, 0x17aa, "NVIDIA RTX 5880 Ada Generation" },
    { 0x26B5, 0x169d, 0x10de, "NVIDIA L40" },
    { 0x26B5, 0x17da, 0x10de, "NVIDIA L40" },
    { 0x26B9, 0x1851, 0x10de, "NVIDIA L40S" },
    { 0x26B9, 0x18cf, 0x10de, "NVIDIA L40S" },
    { 0x26BA, 0x1957, 0x10de, "NVIDIA L20" },
    { 0x26BA, 0x1990, 0x10de, "NVIDIA L20" },
    { 0x2702, 0x0000, 0x0000, "NVIDIA GeForce RTX 4080 SUPER" },
    { 0x2704, 0x0000, 0x0000, "NVIDIA GeForce RTX 4080" },
    { 0x2705, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Ti SUPER" },
    { 0x2709, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070" },
    { 0x2717, 0x0000, 0x0000, "NVIDIA GeForce RTX 4090 Laptop GPU" },
    { 0x2730, 0x0000, 0x0000, "NVIDIA RTX 5000 Ada Generation Laptop GPU" },
    { 0x2757, 0x0000, 0x0000, "NVIDIA GeForce RTX 4090 Laptop GPU" },
    { 0x2770, 0x0000, 0x0000, "NVIDIA RTX 5000 Ada Generation Embedded GPU" },
    { 0x2782, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Ti" },
    { 0x2783, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 SUPER" },
    { 0x2786, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070" },
    { 0x2788, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Ti" },
    { 0x27A0, 0x0000, 0x0000, "NVIDIA GeForce RTX 4080 Laptop GPU" },
    { 0x27B0, 0x16fa, 0x1028, "NVIDIA RTX 4000 SFF Ada Generation" },
    { 0x27B0, 0x16fa, 0x103c, "NVIDIA RTX 4000 SFF Ada Generation" },
    { 0x27B0, 0x16fa, 0x10de, "NVIDIA RTX 4000 SFF Ada Generation" },
    { 0x27B0, 0x16fa, 0x17aa, "NVIDIA RTX 4000 SFF Ada Generation" },
    { 0x27B1, 0x180c, 0x1028, "NVIDIA RTX 4500 Ada Generation" },
    { 0x27B1, 0x180c, 0x103c, "NVIDIA RTX 4500 Ada Generation" },
    { 0x27B1, 0x180c, 0x10de, "NVIDIA RTX 4500 Ada Generation" },
    { 0x27B1, 0x180c, 0x17aa, "NVIDIA RTX 4500 Ada Generation" },
    { 0x27B2, 0x181b, 0x1028, "NVIDIA RTX 4000 Ada Generation" },
    { 0x27B2, 0x181b, 0x103c, "NVIDIA RTX 4000 Ada Generation" },
    { 0x27B2, 0x181b, 0x10de, "NVIDIA RTX 4000 Ada Generation" },
    { 0x27B2, 0x181b, 0x17aa, "NVIDIA RTX 4000 Ada Generation" },
    { 0x27B6, 0x1933, 0x10de, "NVIDIA L2" },
    { 0x27B8, 0x16ca, 0x10de, "NVIDIA L4" },
    { 0x27B8, 0x16ee, 0x10de, "NVIDIA L4" },
    { 0x27BA, 0x0000, 0x0000, "NVIDIA RTX 4000 Ada Generation Laptop GPU" },
    { 0x27BB, 0x0000, 0x0000, "NVIDIA RTX 3500 Ada Generation Laptop GPU" },
    { 0x27E0, 0x0000, 0x0000, "NVIDIA GeForce RTX 4080 Laptop GPU" },
    { 0x27FB, 0x0000, 0x0000, "NVIDIA RTX 3500 Ada Generation Embedded GPU" },
    { 0x2803, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Ti" },
    { 0x2805, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Ti" },
    { 0x2808, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060" },
    { 0x2820, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Laptop GPU" },
    { 0x2822, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 A Laptop GPU" },
    { 0x2838, 0x0000, 0x0000, "NVIDIA RTX 3000 Ada Generation Laptop GPU" },
    { 0x2860, 0x0000, 0x0000, "NVIDIA GeForce RTX 4070 Laptop GPU" },
    { 0x2882, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060" },
    { 0x28A0, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Laptop GPU" },
    { 0x28A1, 0x0000, 0x0000, "NVIDIA GeForce RTX 4050 Laptop GPU" },
    { 0x28A3, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 A Laptop GPU" },
    { 0x28B0, 0x1870, 0x1028, "NVIDIA RTX 2000 Ada Generation" },
    { 0x28B0, 0x1870, 0x103c, "NVIDIA RTX 2000 Ada Generation" },
    { 0x28B0, 0x1871, 0x103c, "NVIDIA RTX 2000E Ada Generation" },
    { 0x28B0, 0x1870, 0x10de, "NVIDIA RTX 2000 Ada Generation" },
    { 0x28B0, 0x1871, 0x10de, "NVIDIA RTX 2000E Ada Generation" },
    { 0x28B0, 0x1870, 0x17aa, "NVIDIA RTX 2000 Ada Generation" },
    { 0x28B0, 0x1871, 0x17aa, "NVIDIA RTX 2000E Ada Generation" },
    { 0x28B8, 0x0000, 0x0000, "NVIDIA RTX 2000 Ada Generation Laptop GPU" },
    { 0x28B9, 0x0000, 0x0000, "NVIDIA RTX 1000 Ada Generation Laptop GPU" },
    { 0x28BA, 0x0000, 0x0000, "NVIDIA RTX 500 Ada Generation Laptop GPU" },
    { 0x28BB, 0x0000, 0x0000, "NVIDIA RTX 500 Ada Generation Laptop GPU" },
    { 0x28E0, 0x0000, 0x0000, "NVIDIA GeForce RTX 4060 Laptop GPU" },
    { 0x28E1, 0x0000, 0x0000, "NVIDIA GeForce RTX 4050 Laptop GPU" },
    { 0x28E3, 0x0000, 0x0000, "NVIDIA GeForce RTX 3050 A Laptop GPU" },
    { 0x28F8, 0x0000, 0x0000, "NVIDIA RTX 2000 Ada Generation Embedded GPU" },
    { 0x2901, 0x1999, 0x10de, "NVIDIA B200" },
    { 0x2901, 0x199b, 0x10de, "NVIDIA B200" },
    { 0x2901, 0x20da, 0x10de, "NVIDIA B200" },
    { 0x2941, 0x2046, 0x10de, "NVIDIA GB200" },
    { 0x2941, 0x20ca, 0x10de, "NVIDIA GB200" },
    { 0x2941, 0x20d5, 0x10de, "NVIDIA GB200" },
    { 0x2941, 0x21c9, 0x10de, "NVIDIA GB200" },
    { 0x2941, 0x21ca, 0x10de, "NVIDIA GB200" },
    { 0x2B85, 0x0000, 0x0000, "NVIDIA GeForce RTX 5090" },
    { 0x2B87, 0x0000, 0x0000, "NVIDIA GeForce RTX 5090 D" },
    { 0x2BB1, 0x204b, 0x1028, "NVIDIA RTX PRO 6000 Blackwell Workstation Edition" },
    { 0x2BB1, 0x204b, 0x103c, "NVIDIA RTX PRO 6000 Blackwell Workstation Edition" },
    { 0x2BB1, 0x204b, 0x10de, "NVIDIA RTX PRO 6000 Blackwell Workstation Edition" },
    { 0x2BB1, 0x204b, 0x17aa, "NVIDIA RTX PRO 6000 Blackwell Workstation Edition" },
    { 0x2BB3, 0x204d, 0x1028, "NVIDIA RTX PRO 5000 Blackwell" },
    { 0x2BB3, 0x204d, 0x103c, "NVIDIA RTX PRO 5000 Blackwell" },
    { 0x2BB3, 0x204d, 0x10de, "NVIDIA RTX PRO 5000 Blackwell" },
    { 0x2BB3, 0x204d, 0x17aa, "NVIDIA RTX PRO 5000 Blackwell" },
    { 0x2BB4, 0x204c, 0x1028, "NVIDIA RTX PRO 6000 Blackwell Max-Q Workstation Edition" },
    { 0x2BB4, 0x204c, 0x103c, "NVIDIA RTX PRO 6000 Blackwell Max-Q Workstation Edition" },
    { 0x2BB4, 0x204c, 0x10de, "NVIDIA RTX PRO 6000 Blackwell Max-Q Workstation Edition" },
    { 0x2BB4, 0x204c, 0x17aa, "NVIDIA RTX PRO 6000 Blackwell Max-Q Workstation Edition" },
    { 0x2BB5, 0x204e, 0x10de, "NVIDIA RTX PRO 6000 Blackwell Server Edition" },
    { 0x2C02, 0x0000, 0x0000, "NVIDIA GeForce RTX 5080" },
    { 0x2C05, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Ti" },
    { 0x2C18, 0x0000, 0x0000, "NVIDIA GeForce RTX 5090 Laptop GPU" },
    { 0x2C19, 0x0000, 0x0000, "NVIDIA GeForce RTX 5080 Laptop GPU" },
    { 0x2C31, 0x2051, 0x1028, "NVIDIA RTX PRO 4500 Blackwell" },
    { 0x2C31, 0x2051, 0x103c, "NVIDIA RTX PRO 4500 Blackwell" },
    { 0x2C31, 0x2051, 0x10de, "NVIDIA RTX PRO 4500 Blackwell" },
    { 0x2C31, 0x2051, 0x17aa, "NVIDIA RTX PRO 4500 Blackwell" },
    { 0x2C34, 0x2052, 0x1028, "NVIDIA RTX PRO 4000 Blackwell" },
    { 0x2C34, 0x2052, 0x103c, "NVIDIA RTX PRO 4000 Blackwell" },
    { 0x2C34, 0x2052, 0x10de, "NVIDIA RTX PRO 4000 Blackwell" },
    { 0x2C34, 0x2052, 0x17aa, "NVIDIA RTX PRO 4000 Blackwell" },
    { 0x2C38, 0x0000, 0x0000, "NVIDIA RTX PRO 5000 Blackwell Generation Laptop GPU" },
    { 0x2C39, 0x0000, 0x0000, "NVIDIA RTX PRO 4000 Blackwell Generation Laptop GPU" },
    { 0x2C58, 0x0000, 0x0000, "NVIDIA GeForce RTX 5090 Laptop GPU" },
    { 0x2C59, 0x0000, 0x0000, "NVIDIA GeForce RTX 5080 Laptop GPU" },
    { 0x2D04, 0x0000, 0x0000, "NVIDIA GeForce RTX 5060 Ti" },
    { 0x2D05, 0x0000, 0x0000, "NVIDIA GeForce RTX 5060" },
    { 0x2D18, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Laptop GPU" },
    { 0x2D19, 0x0000, 0x0000, "NVIDIA GeForce RTX 5060 Laptop GPU" },
    { 0x2D39, 0x0000, 0x0000, "NVIDIA RTX PRO 2000 Blackwell Generation Laptop GPU" },
    { 0x2D58, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Laptop GPU" },
    { 0x2D59, 0x0000, 0x0000, "NVIDIA GeForce RTX 5060 Laptop GPU" },
    { 0x2D83, 0x0000, 0x0000, "NVIDIA GeForce RTX 5050" },
    { 0x2D98, 0x0000, 0x0000, "NVIDIA GeForce RTX 5050 Laptop GPU" },
    { 0x2DB8, 0x0000, 0x0000, "NVIDIA RTX PRO 1000 Blackwell Generation Laptop GPU" },
    { 0x2DB9, 0x0000, 0x0000, "NVIDIA RTX PRO 500 Blackwell Generation Laptop GPU" },
    { 0x2DD8, 0x0000, 0x0000, "NVIDIA GeForce RTX 5050 Laptop GPU" },
    { 0x2F04, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070" },
    { 0x2F18, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Ti Laptop GPU" },
    { 0x2F38, 0x0000, 0x0000, "NVIDIA RTX PRO 3000 Blackwell Generation Laptop GPU" },
    { 0x2F58, 0x0000, 0x0000, "NVIDIA GeForce RTX 5070 Ti Laptop GPU" },
    { 0x13BD, 0x11cc, 0x10DE, "GRID M10-0B" },
    { 0x13BD, 0x11cd, 0x10DE, "GRID M10-1B" },
    { 0x13BD, 0x11ce, 0x10DE, "GRID M10-0Q" },
    { 0x13BD, 0x11cf, 0x10DE, "GRID M10-1Q" },
    { 0x13BD, 0x11d0, 0x10DE, "GRID M10-2Q" },
    { 0x13BD, 0x11d1, 0x10DE, "GRID M10-4Q" },
    { 0x13BD, 0x11d2, 0x10DE, "GRID M10-8Q" },
    { 0x13BD, 0x11d3, 0x10DE, "GRID M10-1A" },
    { 0x13BD, 0x11d4, 0x10DE, "GRID M10-2A" },
    { 0x13BD, 0x11d5, 0x10DE, "GRID M10-4A" },
    { 0x13BD, 0x11d6, 0x10DE, "GRID M10-8A" },
    { 0x13BD, 0x1286, 0x10DE, "GRID M10-2B" },
    { 0x13BD, 0x12ee, 0x10DE, "GRID M10-2B4" },
    { 0x13BD, 0x1339, 0x10DE, "GRID M10-1B4" },
    { 0x1DB1, 0x1259, 0x10DE, "GRID V100X-1B" },
    { 0x1DB1, 0x125a, 0x10DE, "GRID V100X-1Q" },
    { 0x1DB1, 0x125b, 0x10DE, "GRID V100X-2Q" },
    { 0x1DB1, 0x125c, 0x10DE, "GRID V100X-4Q" },
    { 0x1DB1, 0x125d, 0x10DE, "GRID V100X-8Q" },
    { 0x1DB1, 0x125e, 0x10DE, "GRID V100X-16Q" },
    { 0x1DB1, 0x125f, 0x10DE, "GRID V100X-1A" },
    { 0x1DB1, 0x1260, 0x10DE, "GRID V100X-2A" },
    { 0x1DB1, 0x1261, 0x10DE, "GRID V100X-4A" },
    { 0x1DB1, 0x1262, 0x10DE, "GRID V100X-8A" },
    { 0x1DB1, 0x1263, 0x10DE, "GRID V100X-16A" },
    { 0x1DB1, 0x128e, 0x10DE, "GRID V100X-2B" },
    { 0x1DB1, 0x12f6, 0x10DE, "GRID V100X-2B4" },
    { 0x1DB1, 0x1341, 0x10DE, "GRID V100X-1B4" },
    { 0x1DB1, 0x1378, 0x10DE, "GRID V100X-16C" },
    { 0x1DB1, 0x138e, 0x10DE, "GRID V100X-4C" },
    { 0x1DB1, 0x138f, 0x10DE, "GRID V100X-8C" },
    { 0x1DB3, 0x1290, 0x10DE, "GRID V100L-1B" },
    { 0x1DB3, 0x1291, 0x10DE, "GRID V100L-2B" },
    { 0x1DB3, 0x1292, 0x10DE, "GRID V100L-1Q" },
    { 0x1DB3, 0x1293, 0x10DE, "GRID V100L-2Q" },
    { 0x1DB3, 0x1294, 0x10DE, "GRID V100L-4Q" },
    { 0x1DB3, 0x1295, 0x10DE, "GRID V100L-8Q" },
    { 0x1DB3, 0x1296, 0x10DE, "GRID V100L-16Q" },
    { 0x1DB3, 0x1297, 0x10DE, "GRID V100L-1A" },
    { 0x1DB3, 0x1298, 0x10DE, "GRID V100L-2A" },
    { 0x1DB3, 0x1299, 0x10DE, "GRID V100L-4A" },
    { 0x1DB3, 0x129a, 0x10DE, "GRID V100L-8A" },
    { 0x1DB3, 0x129b, 0x10DE, "GRID V100L-16A" },
    { 0x1DB3, 0x12f9, 0x10DE, "GRID V100L-2B4" },
    { 0x1DB3, 0x1344, 0x10DE, "GRID V100L-1B4" },
    { 0x1DB3, 0x137a, 0x10DE, "GRID V100L-16C" },
    { 0x1DB3, 0x1398, 0x10DE, "GRID V100L-4C" },
    { 0x1DB3, 0x1399, 0x10DE, "GRID V100L-8C" },
    { 0x1DB4, 0x124e, 0x10DE, "GRID V100-1B" },
    { 0x1DB4, 0x124f, 0x10DE, "GRID V100-1Q" },
    { 0x1DB4, 0x1250, 0x10DE, "GRID V100-2Q" },
    { 0x1DB4, 0x1251, 0x10DE, "GRID V100-4Q" },
    { 0x1DB4, 0x1252, 0x10DE, "GRID V100-8Q" },
    { 0x1DB4, 0x1253, 0x10DE, "GRID V100-16Q" },
    { 0x1DB4, 0x1254, 0x10DE, "GRID V100-1A" },
    { 0x1DB4, 0x1255, 0x10DE, "GRID V100-2A" },
    { 0x1DB4, 0x1256, 0x10DE, "GRID V100-4A" },
    { 0x1DB4, 0x1257, 0x10DE, "GRID V100-8A" },
    { 0x1DB4, 0x1258, 0x10DE, "GRID V100-16A" },
    { 0x1DB4, 0x128f, 0x10DE, "GRID V100-2B" },
    { 0x1DB4, 0x12f5, 0x10DE, "GRID V100-2B4" },
    { 0x1DB4, 0x1340, 0x10DE, "GRID V100-1B4" },
    { 0x1DB4, 0x1379, 0x10DE, "GRID V100-16C" },
    { 0x1DB4, 0x1393, 0x10DE, "GRID V100-4C" },
    { 0x1DB4, 0x1394, 0x10DE, "GRID V100-8C" },
    { 0x1DB5, 0x12cb, 0x10DE, "GRID V100DX-1B" },
    { 0x1DB5, 0x12cc, 0x10DE, "GRID V100DX-2B" },
    { 0x1DB5, 0x12cd, 0x10DE, "GRID V100DX-1Q" },
    { 0x1DB5, 0x12ce, 0x10DE, "GRID V100DX-2Q" },
    { 0x1DB5, 0x12cf, 0x10DE, "GRID V100DX-4Q" },
    { 0x1DB5, 0x12d0, 0x10DE, "GRID V100DX-8Q" },
    { 0x1DB5, 0x12d1, 0x10DE, "GRID V100DX-16Q" },
    { 0x1DB5, 0x12d2, 0x10DE, "GRID V100DX-32Q" },
    { 0x1DB5, 0x12d3, 0x10DE, "GRID V100DX-1A" },
    { 0x1DB5, 0x12d4, 0x10DE, "GRID V100DX-2A" },
    { 0x1DB5, 0x12d5, 0x10DE, "GRID V100DX-4A" },
    { 0x1DB5, 0x12d6, 0x10DE, "GRID V100DX-8A" },
    { 0x1DB5, 0x12d7, 0x10DE, "GRID V100DX-16A" },
    { 0x1DB5, 0x12d8, 0x10DE, "GRID V100DX-32A" },
    { 0x1DB5, 0x12f8, 0x10DE, "GRID V100DX-2B4" },
    { 0x1DB5, 0x1343, 0x10DE, "GRID V100DX-1B4" },
    { 0x1DB5, 0x1376, 0x10DE, "GRID V100DX-32C" },
    { 0x1DB5, 0x1390, 0x10DE, "GRID V100DX-4C" },
    { 0x1DB5, 0x1391, 0x10DE, "GRID V100DX-8C" },
    { 0x1DB5, 0x1392, 0x10DE, "GRID V100DX-16C" },
    { 0x1DB6, 0x12bd, 0x10DE, "GRID V100D-1B" },
    { 0x1DB6, 0x12be, 0x10DE, "GRID V100D-2B" },
    { 0x1DB6, 0x12bf, 0x10DE, "GRID V100D-1Q" },
    { 0x1DB6, 0x12c0, 0x10DE, "GRID V100D-2Q" },
    { 0x1DB6, 0x12c1, 0x10DE, "GRID V100D-4Q" },
    { 0x1DB6, 0x12c2, 0x10DE, "GRID V100D-8Q" },
    { 0x1DB6, 0x12c3, 0x10DE, "GRID V100D-16Q" },
    { 0x1DB6, 0x12c4, 0x10DE, "GRID V100D-32Q" },
    { 0x1DB6, 0x12c5, 0x10DE, "GRID V100D-1A" },
    { 0x1DB6, 0x12c6, 0x10DE, "GRID V100D-2A" },
    { 0x1DB6, 0x12c7, 0x10DE, "GRID V100D-4A" },
    { 0x1DB6, 0x12c8, 0x10DE, "GRID V100D-8A" },
    { 0x1DB6, 0x12c9, 0x10DE, "GRID V100D-16A" },
    { 0x1DB6, 0x12ca, 0x10DE, "GRID V100D-32A" },
    { 0x1DB6, 0x12f7, 0x10DE, "GRID V100D-2B4" },
    { 0x1DB6, 0x1342, 0x10DE, "GRID V100D-1B4" },
    { 0x1DB6, 0x1377, 0x10DE, "GRID V100D-32C" },
    { 0x1DB6, 0x1395, 0x10DE, "GRID V100D-4C" },
    { 0x1DB6, 0x1396, 0x10DE, "GRID V100D-8C" },
    { 0x1DB6, 0x1397, 0x10DE, "GRID V100D-16C" },
    { 0x1DB6, 0x13cd, 0x10DE, "GRID GTX V100D-8" },
    { 0x1DB6, 0x13ce, 0x10DE, "GRID GTX V100D-16" },
    { 0x1DB6, 0x13cf, 0x10DE, "GRID GTX V100D-32" },
    { 0x1DF6, 0x13e1, 0x10DE, "GRID V100S-1B" },
    { 0x1DF6, 0x13e3, 0x10DE, "GRID V100S-2B" },
    { 0x1DF6, 0x13e5, 0x10DE, "GRID V100S-1Q" },
    { 0x1DF6, 0x13e6, 0x10DE, "GRID V100S-2Q" },
    { 0x1DF6, 0x13e7, 0x10DE, "GRID V100S-4Q" },
    { 0x1DF6, 0x13e8, 0x10DE, "GRID V100S-8Q" },
    { 0x1DF6, 0x13e9, 0x10DE, "GRID V100S-16Q" },
    { 0x1DF6, 0x13ea, 0x10DE, "GRID V100S-32Q" },
    { 0x1DF6, 0x13eb, 0x10DE, "GRID V100S-1A" },
    { 0x1DF6, 0x13ec, 0x10DE, "GRID V100S-2A" },
    { 0x1DF6, 0x13ed, 0x10DE, "GRID V100S-4A" },
    { 0x1DF6, 0x13ee, 0x10DE, "GRID V100S-8A" },
    { 0x1DF6, 0x13ef, 0x10DE, "GRID V100S-16A" },
    { 0x1DF6, 0x13f0, 0x10DE, "GRID V100S-32A" },
    { 0x1DF6, 0x13f1, 0x10DE, "GRID V100S-4C" },
    { 0x1DF6, 0x13f2, 0x10DE, "GRID V100S-8C" },
    { 0x1DF6, 0x13f3, 0x10DE, "GRID V100S-16C" },
    { 0x1DF6, 0x13f4, 0x10DE, "GRID V100S-32C" },
    { 0x1E30, 0x1325, 0x10DE, "GRID RTX6000-1Q" },
    { 0x1E30, 0x1326, 0x10DE, "GRID RTX6000-2Q" },
    { 0x1E30, 0x1327, 0x10DE, "GRID RTX6000-3Q" },
    { 0x1E30, 0x1328, 0x10DE, "GRID RTX6000-4Q" },
    { 0x1E30, 0x1329, 0x10DE, "GRID RTX6000-6Q" },
    { 0x1E30, 0x132a, 0x10DE, "GRID RTX6000-8Q" },
    { 0x1E30, 0x132b, 0x10DE, "GRID RTX6000-12Q" },
    { 0x1E30, 0x132c, 0x10DE, "GRID RTX6000-24Q" },
    { 0x1E30, 0x132d, 0x10DE, "GRID RTX8000-1Q" },
    { 0x1E30, 0x132e, 0x10DE, "GRID RTX8000-2Q" },
    { 0x1E30, 0x132f, 0x10DE, "GRID RTX8000-3Q" },
    { 0x1E30, 0x1330, 0x10DE, "GRID RTX8000-4Q" },
    { 0x1E30, 0x1331, 0x10DE, "GRID RTX8000-6Q" },
    { 0x1E30, 0x1332, 0x10DE, "GRID RTX8000-8Q" },
    { 0x1E30, 0x1333, 0x10DE, "GRID RTX8000-12Q" },
    { 0x1E30, 0x1334, 0x10DE, "GRID RTX8000-16Q" },
    { 0x1E30, 0x1335, 0x10DE, "GRID RTX8000-24Q" },
    { 0x1E30, 0x1336, 0x10DE, "GRID RTX8000-48Q" },
    { 0x1E30, 0x13b9, 0x10DE, "GRID RTX6000-6" },
    { 0x1E30, 0x13ba, 0x10DE, "GRID RTX6000-12" },
    { 0x1E30, 0x13bb, 0x10DE, "GRID RTX6000-24" },
    { 0x1E30, 0x13bc, 0x10DE, "GRID RTX8000-12" },
    { 0x1E30, 0x13bd, 0x10DE, "GRID RTX8000-24" },
    { 0x1E30, 0x13be, 0x10DE, "GRID RTX8000-48" },
    { 0x1E30, 0x13bf, 0x10DE, "GRID RTX6000-4C" },
    { 0x1E30, 0x13c0, 0x10DE, "GRID RTX6000-6C" },
    { 0x1E30, 0x13c1, 0x10DE, "GRID RTX6000-8C" },
    { 0x1E30, 0x13c2, 0x10DE, "GRID RTX6000-12C" },
    { 0x1E30, 0x13c3, 0x10DE, "GRID RTX6000-24C" },
    { 0x1E30, 0x13c4, 0x10DE, "GRID RTX8000-4C" },
    { 0x1E30, 0x13c5, 0x10DE, "GRID RTX8000-6C" },
    { 0x1E30, 0x13c6, 0x10DE, "GRID RTX8000-8C" },
    { 0x1E30, 0x13c7, 0x10DE, "GRID RTX8000-12C" },
    { 0x1E30, 0x13c8, 0x10DE, "GRID RTX8000-16C" },
    { 0x1E30, 0x13c9, 0x10DE, "GRID RTX8000-24C" },
    { 0x1E30, 0x13ca, 0x10DE, "GRID RTX8000-48C" },
    { 0x1E30, 0x13cb, 0x10DE, "GRID RTX6000-8" },
    { 0x1E30, 0x13cc, 0x10DE, "GRID RTX8000-16" },
    { 0x1E30, 0x1437, 0x10DE, "GRID RTX6000-1B" },
    { 0x1E30, 0x1438, 0x10DE, "GRID RTX6000-2B" },
    { 0x1E30, 0x1439, 0x10DE, "GRID RTX6000-1A" },
    { 0x1E30, 0x143a, 0x10DE, "GRID RTX6000-2A" },
    { 0x1E30, 0x143b, 0x10DE, "GRID RTX6000-3A" },
    { 0x1E30, 0x143c, 0x10DE, "GRID RTX6000-4A" },
    { 0x1E30, 0x143d, 0x10DE, "GRID RTX6000-6A" },
    { 0x1E30, 0x143e, 0x10DE, "GRID RTX6000-8A" },
    { 0x1E30, 0x143f, 0x10DE, "GRID RTX6000-12A" },
    { 0x1E30, 0x1440, 0x10DE, "GRID RTX6000-24A" },
    { 0x1E30, 0x1441, 0x10DE, "GRID RTX8000-1B" },
    { 0x1E30, 0x1442, 0x10DE, "GRID RTX8000-2B" },
    { 0x1E30, 0x1443, 0x10DE, "GRID RTX8000-1A" },
    { 0x1E30, 0x1444, 0x10DE, "GRID RTX8000-2A" },
    { 0x1E30, 0x1445, 0x10DE, "GRID RTX8000-3A" },
    { 0x1E30, 0x1446, 0x10DE, "GRID RTX8000-4A" },
    { 0x1E30, 0x1447, 0x10DE, "GRID RTX8000-6A" },
    { 0x1E30, 0x1448, 0x10DE, "GRID RTX8000-8A" },
    { 0x1E30, 0x1449, 0x10DE, "GRID RTX8000-12A" },
    { 0x1E30, 0x144a, 0x10DE, "GRID RTX8000-16A" },
    { 0x1E30, 0x144b, 0x10DE, "GRID RTX8000-24A" },
    { 0x1E30, 0x144c, 0x10DE, "GRID RTX8000-48A" },
    { 0x1E37, 0x1347, 0x10DE, "GeForce RTX T10x-8" },
    { 0x1E37, 0x1348, 0x10DE, "GeForce RTX T10x-4" },
    { 0x1E37, 0x1349, 0x10DE, "GeForce RTX T10x-2" },
    { 0x1E37, 0x136a, 0x10DE, "GRID RTX T10-4" },
    { 0x1E37, 0x136b, 0x10DE, "GRID RTX T10-8" },
    { 0x1E37, 0x136c, 0x10DE, "GRID RTX T10-16" },
    { 0x1E37, 0x13a4, 0x10DE, "GeForce RTX T10-4" },
    { 0x1E37, 0x13a5, 0x10DE, "GeForce RTX T10-8" },
    { 0x1E37, 0x13a6, 0x10DE, "GeForce RTX T10-16" },
    { 0x1E37, 0x13a7, 0x10DE, "GRID RTX T10x-2" },
    { 0x1E37, 0x13a8, 0x10DE, "GRID RTX T10x-4" },
    { 0x1E37, 0x13a9, 0x10DE, "GRID RTX T10x-8" },
    { 0x1E37, 0x180d, 0x10DE, "NVIDIA GeForce GTX 1060" },
    { 0x1E37, 0x1820, 0x10DE, "NVIDIA GeForce RTX 2080" },
    { 0x1E78, 0x13f7, 0x10DE, "GRID RTX6000P-1B" },
    { 0x1E78, 0x13f8, 0x10DE, "GRID RTX6000P-2B" },
    { 0x1E78, 0x13f9, 0x10DE, "GRID RTX6000P-1Q" },
    { 0x1E78, 0x13fa, 0x10DE, "GRID RTX6000P-2Q" },
    { 0x1E78, 0x13fb, 0x10DE, "GRID RTX6000P-3Q" },
    { 0x1E78, 0x13fc, 0x10DE, "GRID RTX6000P-4Q" },
    { 0x1E78, 0x13fd, 0x10DE, "GRID RTX6000P-6Q" },
    { 0x1E78, 0x13fe, 0x10DE, "GRID RTX6000P-8Q" },
    { 0x1E78, 0x13ff, 0x10DE, "GRID RTX6000P-12Q" },
    { 0x1E78, 0x1400, 0x10DE, "GRID RTX6000P-24Q" },
    { 0x1E78, 0x1401, 0x10DE, "GRID RTX6000P-1A" },
    { 0x1E78, 0x1402, 0x10DE, "GRID RTX6000P-2A" },
    { 0x1E78, 0x1403, 0x10DE, "GRID RTX6000P-3A" },
    { 0x1E78, 0x1404, 0x10DE, "GRID RTX6000P-4A" },
    { 0x1E78, 0x1405, 0x10DE, "GRID RTX6000P-6A" },
    { 0x1E78, 0x1406, 0x10DE, "GRID RTX6000P-8A" },
    { 0x1E78, 0x1407, 0x10DE, "GRID RTX6000P-12A" },
    { 0x1E78, 0x1408, 0x10DE, "GRID RTX6000P-24A" },
    { 0x1E78, 0x1409, 0x10DE, "GRID RTX6000P-6" },
    { 0x1E78, 0x140a, 0x10DE, "GRID RTX6000P-8" },
    { 0x1E78, 0x140b, 0x10DE, "GRID RTX6000P-12" },
    { 0x1E78, 0x140c, 0x10DE, "GRID RTX6000P-24" },
    { 0x1E78, 0x140d, 0x10DE, "GRID RTX6000P-4C" },
    { 0x1E78, 0x140e, 0x10DE, "GRID RTX6000P-6C" },
    { 0x1E78, 0x140f, 0x10DE, "GRID RTX6000P-8C" },
    { 0x1E78, 0x1410, 0x10DE, "GRID RTX6000P-12C" },
    { 0x1E78, 0x1411, 0x10DE, "GRID RTX6000P-24C" },
    { 0x1E78, 0x1412, 0x10DE, "GRID RTX8000P-1B" },
    { 0x1E78, 0x1413, 0x10DE, "GRID RTX8000P-2B" },
    { 0x1E78, 0x1414, 0x10DE, "GRID RTX8000P-1Q" },
    { 0x1E78, 0x1415, 0x10DE, "GRID RTX8000P-2Q" },
    { 0x1E78, 0x1416, 0x10DE, "GRID RTX8000P-3Q" },
    { 0x1E78, 0x1417, 0x10DE, "GRID RTX8000P-4Q" },
    { 0x1E78, 0x1418, 0x10DE, "GRID RTX8000P-6Q" },
    { 0x1E78, 0x1419, 0x10DE, "GRID RTX8000P-8Q" },
    { 0x1E78, 0x141a, 0x10DE, "GRID RTX8000P-12Q" },
    { 0x1E78, 0x141b, 0x10DE, "GRID RTX8000P-16Q" },
    { 0x1E78, 0x141c, 0x10DE, "GRID RTX8000P-24Q" },
    { 0x1E78, 0x141d, 0x10DE, "GRID RTX8000P-48Q" },
    { 0x1E78, 0x141e, 0x10DE, "GRID RTX8000P-1A" },
    { 0x1E78, 0x141f, 0x10DE, "GRID RTX8000P-2A" },
    { 0x1E78, 0x1420, 0x10DE, "GRID RTX8000P-3A" },
    { 0x1E78, 0x1421, 0x10DE, "GRID RTX8000P-4A" },
    { 0x1E78, 0x1422, 0x10DE, "GRID RTX8000P-6A" },
    { 0x1E78, 0x1423, 0x10DE, "GRID RTX8000P-8A" },
    { 0x1E78, 0x1424, 0x10DE, "GRID RTX8000P-12A" },
    { 0x1E78, 0x1425, 0x10DE, "GRID RTX8000P-24A" },
    { 0x1E78, 0x1426, 0x10DE, "GRID RTX8000P-48A" },
    { 0x1E78, 0x1427, 0x10DE, "GRID RTX8000P-12" },
    { 0x1E78, 0x1428, 0x10DE, "GRID RTX8000P-16" },
    { 0x1E78, 0x1429, 0x10DE, "GRID RTX8000P-24" },
    { 0x1E78, 0x142a, 0x10DE, "GRID RTX8000P-48" },
    { 0x1E78, 0x142b, 0x10DE, "GRID RTX8000P-4C" },
    { 0x1E78, 0x142c, 0x10DE, "GRID RTX8000P-6C" },
    { 0x1E78, 0x142d, 0x10DE, "GRID RTX8000P-8C" },
    { 0x1E78, 0x142e, 0x10DE, "GRID RTX8000P-12C" },
    { 0x1E78, 0x142f, 0x10DE, "GRID RTX8000P-16C" },
    { 0x1E78, 0x1430, 0x10DE, "GRID RTX8000P-24C" },
    { 0x1E78, 0x1431, 0x10DE, "GRID RTX8000P-48C" },
    { 0x1E78, 0x1436, 0x10DE, "GRID RTX8000P-16A" },
    { 0x1EB8, 0x1309, 0x10DE, "GRID T4-1B" },
    { 0x1EB8, 0x130a, 0x10DE, "GRID T4-2B" },
    { 0x1EB8, 0x130b, 0x10DE, "GRID T4-2B4" },
    { 0x1EB8, 0x130c, 0x10DE, "GRID T4-1Q" },
    { 0x1EB8, 0x130d, 0x10DE, "GRID T4-2Q" },
    { 0x1EB8, 0x130e, 0x10DE, "GRID T4-4Q" },
    { 0x1EB8, 0x130f, 0x10DE, "GRID T4-8Q" },
    { 0x1EB8, 0x1310, 0x10DE, "GRID T4-16Q" },
    { 0x1EB8, 0x1311, 0x10DE, "GRID T4-1A" },
    { 0x1EB8, 0x1312, 0x10DE, "GRID T4-2A" },
    { 0x1EB8, 0x1313, 0x10DE, "GRID T4-4A" },
    { 0x1EB8, 0x1314, 0x10DE, "GRID T4-8A" },
    { 0x1EB8, 0x1315, 0x10DE, "GRID T4-16A" },
    { 0x1EB8, 0x1345, 0x10DE, "GRID T4-1B4" },
    { 0x1EB8, 0x1367, 0x10DE, "GRID RTX T4-4" },
    { 0x1EB8, 0x1368, 0x10DE, "GRID RTX T4-8" },
    { 0x1EB8, 0x1369, 0x10DE, "GRID RTX T4-16" },
    { 0x1EB8, 0x1375, 0x10DE, "GRID T4-16C" },
    { 0x1EB8, 0x139a, 0x10DE, "GRID T4-4C" },
    { 0x1EB8, 0x139b, 0x10DE, "GRID T4-8C" },
    { 0x20B0, 0x146f, 0x10DE, "GRID A100X-1-5C" },
    { 0x20B0, 0x1470, 0x10DE, "GRID A100X-2-10C" },
    { 0x20B0, 0x1471, 0x10DE, "GRID A100X-3-20C" },
    { 0x20B0, 0x1472, 0x10DE, "GRID A100X-4-20C" },
    { 0x20B0, 0x1473, 0x10DE, "GRID A100X-7-40C" },
    { 0x20B0, 0x1474, 0x10DE, "GRID A100X-4C" },
    { 0x20B0, 0x1475, 0x10DE, "GRID A100X-5C" },
    { 0x20B0, 0x1476, 0x10DE, "GRID A100X-8C" },
    { 0x20B0, 0x1477, 0x10DE, "GRID A100X-10C" },
    { 0x20B0, 0x1478, 0x10DE, "GRID A100X-20C" },
    { 0x20B0, 0x1479, 0x10DE, "GRID A100X-40C" },
    { 0x20B0, 0x160c, 0x10DE, "GRID A100X-1-5CME" },
    { 0x20B0, 0x1840, 0x10DE, "GRID A100X-1-10C" },
    { 0x20B2, 0x1523, 0x10DE, "GRID A100DX-1-10C" },
    { 0x20B2, 0x1524, 0x10DE, "GRID A100DX-2-20C" },
    { 0x20B2, 0x1525, 0x10DE, "GRID A100DX-3-40C" },
    { 0x20B2, 0x1526, 0x10DE, "GRID A100DX-4-40C" },
    { 0x20B2, 0x1527, 0x10DE, "GRID A100DX-7-80C" },
    { 0x20B2, 0x1528, 0x10DE, "GRID A100DX-4C" },
    { 0x20B2, 0x1529, 0x10DE, "GRID A100DX-8C" },
    { 0x20B2, 0x152a, 0x10DE, "GRID A100DX-10C" },
    { 0x20B2, 0x152b, 0x10DE, "GRID A100DX-16C" },
    { 0x20B2, 0x152c, 0x10DE, "GRID A100DX-20C" },
    { 0x20B2, 0x152d, 0x10DE, "GRID A100DX-40C" },
    { 0x20B2, 0x152e, 0x10DE, "GRID A100DX-80C" },
    { 0x20B2, 0x160d, 0x10DE, "GRID A100DX-1-10CME" },
    { 0x20B2, 0x1841, 0x10DE, "GRID A100DX-1-20C" },
    { 0x20B5, 0x1591, 0x10DE, "GRID A100D-1-10C" },
    { 0x20B5, 0x1592, 0x10DE, "GRID A100D-2-20C" },
    { 0x20B5, 0x1593, 0x10DE, "GRID A100D-3-40C" },
    { 0x20B5, 0x1594, 0x10DE, "GRID A100D-4-40C" },
    { 0x20B5, 0x1595, 0x10DE, "GRID A100D-7-80C" },
    { 0x20B5, 0x1596, 0x10DE, "GRID A100D-4C" },
    { 0x20B5, 0x1597, 0x10DE, "GRID A100D-8C" },
    { 0x20B5, 0x1598, 0x10DE, "GRID A100D-10C" },
    { 0x20B5, 0x1599, 0x10DE, "GRID A100D-16C" },
    { 0x20B5, 0x159a, 0x10DE, "GRID A100D-20C" },
    { 0x20B5, 0x159b, 0x10DE, "GRID A100D-40C" },
    { 0x20B5, 0x159c, 0x10DE, "GRID A100D-80C" },
    { 0x20B5, 0x160f, 0x10DE, "GRID A100D-1-10CME" },
    { 0x20B5, 0x183e, 0x10DE, "GRID A100D-1-20C" },
    { 0x20B7, 0x1589, 0x10DE, "NVIDIA A30-1-6C" },
    { 0x20B7, 0x158a, 0x10DE, "NVIDIA A30-2-12C" },
    { 0x20B7, 0x158b, 0x10DE, "NVIDIA A30-4-24C" },
    { 0x20B7, 0x158c, 0x10DE, "NVIDIA A30-4C" },
    { 0x20B7, 0x158d, 0x10DE, "NVIDIA A30-6C" },
    { 0x20B7, 0x158e, 0x10DE, "NVIDIA A30-8C" },
    { 0x20B7, 0x158f, 0x10DE, "NVIDIA A30-12C" },
    { 0x20B7, 0x1590, 0x10DE, "NVIDIA A30-24C" },
    { 0x20B7, 0x1610, 0x10DE, "NVIDIA A30-1-6CME" },
    { 0x20B7, 0x183c, 0x10DE, "NVIDIA A30-2-12CME" },
    { 0x20F1, 0x1493, 0x10DE, "GRID A100-1-5C" },
    { 0x20F1, 0x1494, 0x10DE, "GRID A100-2-10C" },
    { 0x20F1, 0x1495, 0x10DE, "GRID A100-3-20C" },
    { 0x20F1, 0x1496, 0x10DE, "GRID A100-4-20C" },
    { 0x20F1, 0x1497, 0x10DE, "GRID A100-7-40C" },
    { 0x20F1, 0x1498, 0x10DE, "GRID A100-4C" },
    { 0x20F1, 0x1499, 0x10DE, "GRID A100-5C" },
    { 0x20F1, 0x149a, 0x10DE, "GRID A100-8C" },
    { 0x20F1, 0x149b, 0x10DE, "GRID A100-10C" },
    { 0x20F1, 0x149c, 0x10DE, "GRID A100-20C" },
    { 0x20F1, 0x149d, 0x10DE, "GRID A100-40C" },
    { 0x20F1, 0x160e, 0x10DE, "GRID A100-1-5CME" },
    { 0x20F1, 0x183d, 0x10DE, "GRID A100-1-10C" },
    { 0x20F3, 0x17b2, 0x10DE, "GRID A800DX-1-10CME" },
    { 0x20F3, 0x17b3, 0x10DE, "GRID A800DX-1-10C" },
    { 0x20F3, 0x17b4, 0x10DE, "GRID A800DX-2-20C" },
    { 0x20F3, 0x17b5, 0x10DE, "GRID A800DX-3-40C" },
    { 0x20F3, 0x17b6, 0x10DE, "GRID A800DX-4-40C" },
    { 0x20F3, 0x17b7, 0x10DE, "GRID A800DX-7-80C" },
    { 0x20F3, 0x17b8, 0x10DE, "GRID A800DX-4C" },
    { 0x20F3, 0x17b9, 0x10DE, "GRID A800DX-8C" },
    { 0x20F3, 0x17ba, 0x10DE, "GRID A800DX-10C" },
    { 0x20F3, 0x17bb, 0x10DE, "GRID A800DX-16C" },
    { 0x20F3, 0x17bc, 0x10DE, "GRID A800DX-20C" },
    { 0x20F3, 0x17bd, 0x10DE, "GRID A800DX-40C" },
    { 0x20F3, 0x17be, 0x10DE, "GRID A800DX-80C" },
    { 0x20F3, 0x1842, 0x10DE, "GRID A800DX-1-20C" },
    { 0x20F5, 0x17bf, 0x10DE, "GRID A800D-1-10CME" },
    { 0x20F5, 0x17c0, 0x10DE, "GRID A800D-1-10C" },
    { 0x20F5, 0x17c1, 0x10DE, "GRID A800D-2-20C" },
    { 0x20F5, 0x17c2, 0x10DE, "GRID A800D-3-40C" },
    { 0x20F5, 0x17c3, 0x10DE, "GRID A800D-4-40C" },
    { 0x20F5, 0x17c4, 0x10DE, "GRID A800D-7-80C" },
    { 0x20F5, 0x17c5, 0x10DE, "GRID A800D-4C" },
    { 0x20F5, 0x17c6, 0x10DE, "GRID A800D-8C" },
    { 0x20F5, 0x17c7, 0x10DE, "GRID A800D-10C" },
    { 0x20F5, 0x17c8, 0x10DE, "GRID A800D-16C" },
    { 0x20F5, 0x17c9, 0x10DE, "GRID A800D-20C" },
    { 0x20F5, 0x17ca, 0x10DE, "GRID A800D-40C" },
    { 0x20F5, 0x17cb, 0x10DE, "GRID A800D-80C" },
    { 0x20F5, 0x183f, 0x10DE, "GRID A800D-1-20C" },
    { 0x20F6, 0x17cc, 0x10DE, "GRID A800-1-5CME" },
    { 0x20F6, 0x17cd, 0x10DE, "GRID A800-1-5C" },
    { 0x20F6, 0x17ce, 0x10DE, "GRID A800-2-10C" },
    { 0x20F6, 0x17cf, 0x10DE, "GRID A800-3-20C" },
    { 0x20F6, 0x17d0, 0x10DE, "GRID A800-4-20C" },
    { 0x20F6, 0x17d1, 0x10DE, "GRID A800-7-40C" },
    { 0x20F6, 0x17d2, 0x10DE, "GRID A800-4C" },
    { 0x20F6, 0x17d3, 0x10DE, "GRID A800-5C" },
    { 0x20F6, 0x17d4, 0x10DE, "GRID A800-8C" },
    { 0x20F6, 0x17d5, 0x10DE, "GRID A800-10C" },
    { 0x20F6, 0x17d6, 0x10DE, "GRID A800-20C" },
    { 0x20F6, 0x17d7, 0x10DE, "GRID A800-40C" },
    { 0x20F6, 0x1843, 0x10DE, "GRID A800-1-10C" },
    { 0x2230, 0x14fa, 0x10DE, "NVIDIA RTXA6000-1B" },
    { 0x2230, 0x14fb, 0x10DE, "NVIDIA RTXA6000-2B" },
    { 0x2230, 0x14fc, 0x10DE, "NVIDIA RTXA6000-1Q" },
    { 0x2230, 0x14fd, 0x10DE, "NVIDIA RTXA6000-2Q" },
    { 0x2230, 0x14fe, 0x10DE, "NVIDIA RTXA6000-3Q" },
    { 0x2230, 0x14ff, 0x10DE, "NVIDIA RTXA6000-4Q" },
    { 0x2230, 0x1500, 0x10DE, "NVIDIA RTXA6000-6Q" },
    { 0x2230, 0x1501, 0x10DE, "NVIDIA RTXA6000-8Q" },
    { 0x2230, 0x1502, 0x10DE, "NVIDIA RTXA6000-12Q" },
    { 0x2230, 0x1503, 0x10DE, "NVIDIA RTXA6000-16Q" },
    { 0x2230, 0x1504, 0x10DE, "NVIDIA RTXA6000-24Q" },
    { 0x2230, 0x1505, 0x10DE, "NVIDIA RTXA6000-48Q" },
    { 0x2230, 0x1506, 0x10DE, "NVIDIA RTXA6000-1A" },
    { 0x2230, 0x1507, 0x10DE, "NVIDIA RTXA6000-2A" },
    { 0x2230, 0x1508, 0x10DE, "NVIDIA RTXA6000-3A" },
    { 0x2230, 0x1509, 0x10DE, "NVIDIA RTXA6000-4A" },
    { 0x2230, 0x150a, 0x10DE, "NVIDIA RTXA6000-6A" },
    { 0x2230, 0x150b, 0x10DE, "NVIDIA RTXA6000-8A" },
    { 0x2230, 0x150c, 0x10DE, "NVIDIA RTXA6000-12A" },
    { 0x2230, 0x150d, 0x10DE, "NVIDIA RTXA6000-16A" },
    { 0x2230, 0x150e, 0x10DE, "NVIDIA RTXA6000-24A" },
    { 0x2230, 0x150f, 0x10DE, "NVIDIA RTXA6000-48A" },
    { 0x2230, 0x1510, 0x10DE, "NVIDIA RTXA6000-12" },
    { 0x2230, 0x1511, 0x10DE, "NVIDIA RTXA6000-16" },
    { 0x2230, 0x1512, 0x10DE, "NVIDIA RTXA6000-24" },
    { 0x2230, 0x1513, 0x10DE, "NVIDIA RTXA6000-48" },
    { 0x2230, 0x1514, 0x10DE, "NVIDIA RTXA6000-4C" },
    { 0x2230, 0x1515, 0x10DE, "NVIDIA RTXA6000-6C" },
    { 0x2230, 0x1516, 0x10DE, "NVIDIA RTXA6000-8C" },
    { 0x2230, 0x1517, 0x10DE, "NVIDIA RTXA6000-12C" },
    { 0x2230, 0x1518, 0x10DE, "NVIDIA RTXA6000-16C" },
    { 0x2230, 0x1519, 0x10DE, "NVIDIA RTXA6000-24C" },
    { 0x2230, 0x151a, 0x10DE, "NVIDIA RTXA6000-48C" },
    { 0x2231, 0x1562, 0x10DE, "NVIDIA RTXA5000-1B" },
    { 0x2231, 0x1563, 0x10DE, "NVIDIA RTXA5000-2B" },
    { 0x2231, 0x1564, 0x10DE, "NVIDIA RTXA5000-1Q" },
    { 0x2231, 0x1565, 0x10DE, "NVIDIA RTXA5000-2Q" },
    { 0x2231, 0x1566, 0x10DE, "NVIDIA RTXA5000-3Q" },
    { 0x2231, 0x1567, 0x10DE, "NVIDIA RTXA5000-4Q" },
    { 0x2231, 0x1568, 0x10DE, "NVIDIA RTXA5000-6Q" },
    { 0x2231, 0x1569, 0x10DE, "NVIDIA RTXA5000-8Q" },
    { 0x2231, 0x156a, 0x10DE, "NVIDIA RTXA5000-12Q" },
    { 0x2231, 0x156b, 0x10DE, "NVIDIA RTXA5000-24Q" },
    { 0x2231, 0x156c, 0x10DE, "NVIDIA RTXA5000-1A" },
    { 0x2231, 0x156d, 0x10DE, "NVIDIA RTXA5000-2A" },
    { 0x2231, 0x156e, 0x10DE, "NVIDIA RTXA5000-3A" },
    { 0x2231, 0x156f, 0x10DE, "NVIDIA RTXA5000-4A" },
    { 0x2231, 0x1570, 0x10DE, "NVIDIA RTXA5000-6A" },
    { 0x2231, 0x1571, 0x10DE, "NVIDIA RTXA5000-8A" },
    { 0x2231, 0x1572, 0x10DE, "NVIDIA RTXA5000-12A" },
    { 0x2231, 0x1573, 0x10DE, "NVIDIA RTXA5000-24A" },
    { 0x2231, 0x1574, 0x10DE, "NVIDIA RTXA5000-6" },
    { 0x2231, 0x1575, 0x10DE, "NVIDIA RTXA5000-8" },
    { 0x2231, 0x1576, 0x10DE, "NVIDIA RTXA5000-12" },
    { 0x2231, 0x1577, 0x10DE, "NVIDIA RTXA5000-24" },
    { 0x2231, 0x1578, 0x10DE, "NVIDIA RTXA5000-4C" },
    { 0x2231, 0x1579, 0x10DE, "NVIDIA RTXA5000-6C" },
    { 0x2231, 0x157a, 0x10DE, "NVIDIA RTXA5000-8C" },
    { 0x2231, 0x157b, 0x10DE, "NVIDIA RTXA5000-12C" },
    { 0x2231, 0x157c, 0x10DE, "NVIDIA RTXA5000-24C" },
    { 0x2233, 0x165c, 0x10DE, "NVIDIA RTXA5500-1B" },
    { 0x2233, 0x165d, 0x10DE, "NVIDIA RTXA5500-2B" },
    { 0x2233, 0x165e, 0x10DE, "NVIDIA RTXA5500-1Q" },
    { 0x2233, 0x165f, 0x10DE, "NVIDIA RTXA5500-2Q" },
    { 0x2233, 0x1660, 0x10DE, "NVIDIA RTXA5500-3Q" },
    { 0x2233, 0x1661, 0x10DE, "NVIDIA RTXA5500-4Q" },
    { 0x2233, 0x1662, 0x10DE, "NVIDIA RTXA5500-6Q" },
    { 0x2233, 0x1663, 0x10DE, "NVIDIA RTXA5500-8Q" },
    { 0x2233, 0x1664, 0x10DE, "NVIDIA RTXA5500-12Q" },
    { 0x2233, 0x1665, 0x10DE, "NVIDIA RTXA5500-24Q" },
    { 0x2233, 0x1666, 0x10DE, "NVIDIA RTXA5500-1A" },
    { 0x2233, 0x1667, 0x10DE, "NVIDIA RTXA5500-2A" },
    { 0x2233, 0x1668, 0x10DE, "NVIDIA RTXA5500-3A" },
    { 0x2233, 0x1669, 0x10DE, "NVIDIA RTXA5500-4A" },
    { 0x2233, 0x166a, 0x10DE, "NVIDIA RTXA5500-6A" },
    { 0x2233, 0x166b, 0x10DE, "NVIDIA RTXA5500-8A" },
    { 0x2233, 0x166c, 0x10DE, "NVIDIA RTXA5500-12A" },
    { 0x2233, 0x166d, 0x10DE, "NVIDIA RTXA5500-24A" },
    { 0x2233, 0x166e, 0x10DE, "NVIDIA RTXA5500-6" },
    { 0x2233, 0x166f, 0x10DE, "NVIDIA RTXA5500-8" },
    { 0x2233, 0x1670, 0x10DE, "NVIDIA RTXA5500-12" },
    { 0x2233, 0x1671, 0x10DE, "NVIDIA RTXA5500-24" },
    { 0x2233, 0x1672, 0x10DE, "NVIDIA RTXA5500-4C" },
    { 0x2233, 0x1673, 0x10DE, "NVIDIA RTXA5500-6C" },
    { 0x2233, 0x1674, 0x10DE, "NVIDIA RTXA5500-8C" },
    { 0x2233, 0x1675, 0x10DE, "NVIDIA RTXA5500-12C" },
    { 0x2233, 0x1676, 0x10DE, "NVIDIA RTXA5500-24C" },
    { 0x2235, 0x14d5, 0x10DE, "NVIDIA A40-1B" },
    { 0x2235, 0x14d6, 0x10DE, "NVIDIA A40-2B" },
    { 0x2235, 0x14d7, 0x10DE, "NVIDIA A40-1Q" },
    { 0x2235, 0x14d8, 0x10DE, "NVIDIA A40-2Q" },
    { 0x2235, 0x14d9, 0x10DE, "NVIDIA A40-3Q" },
    { 0x2235, 0x14da, 0x10DE, "NVIDIA A40-4Q" },
    { 0x2235, 0x14db, 0x10DE, "NVIDIA A40-6Q" },
    { 0x2235, 0x14dc, 0x10DE, "NVIDIA A40-8Q" },
    { 0x2235, 0x14dd, 0x10DE, "NVIDIA A40-12Q" },
    { 0x2235, 0x14de, 0x10DE, "NVIDIA A40-16Q" },
    { 0x2235, 0x14df, 0x10DE, "NVIDIA A40-24Q" },
    { 0x2235, 0x14e0, 0x10DE, "NVIDIA A40-48Q" },
    { 0x2235, 0x14e1, 0x10DE, "NVIDIA A40-1A" },
    { 0x2235, 0x14e2, 0x10DE, "NVIDIA A40-2A" },
    { 0x2235, 0x14e3, 0x10DE, "NVIDIA A40-3A" },
    { 0x2235, 0x14e4, 0x10DE, "NVIDIA A40-4A" },
    { 0x2235, 0x14e5, 0x10DE, "NVIDIA A40-6A" },
    { 0x2235, 0x14e6, 0x10DE, "NVIDIA A40-8A" },
    { 0x2235, 0x14e7, 0x10DE, "NVIDIA A40-12A" },
    { 0x2235, 0x14e8, 0x10DE, "NVIDIA A40-16A" },
    { 0x2235, 0x14e9, 0x10DE, "NVIDIA A40-24A" },
    { 0x2235, 0x14ea, 0x10DE, "NVIDIA A40-48A" },
    { 0x2235, 0x14eb, 0x10DE, "NVIDIA A40-12" },
    { 0x2235, 0x14ec, 0x10DE, "NVIDIA A40-16" },
    { 0x2235, 0x14ed, 0x10DE, "NVIDIA A40-24" },
    { 0x2235, 0x14ee, 0x10DE, "NVIDIA A40-48" },
    { 0x2235, 0x14f3, 0x10DE, "NVIDIA A40-4C" },
    { 0x2235, 0x14f4, 0x10DE, "NVIDIA A40-6C" },
    { 0x2235, 0x14f5, 0x10DE, "NVIDIA A40-8C" },
    { 0x2235, 0x14f6, 0x10DE, "NVIDIA A40-12C" },
    { 0x2235, 0x14f7, 0x10DE, "NVIDIA A40-16C" },
    { 0x2235, 0x14f8, 0x10DE, "NVIDIA A40-24C" },
    { 0x2235, 0x14f9, 0x10DE, "NVIDIA A40-48C" },
    { 0x2235, 0x1684, 0x10DE, "NVIDIA A40-2" },
    { 0x2235, 0x1685, 0x10DE, "NVIDIA A40-3" },
    { 0x2235, 0x1686, 0x10DE, "NVIDIA A40-4" },
    { 0x2235, 0x1687, 0x10DE, "NVIDIA A40-6" },
    { 0x2235, 0x1688, 0x10DE, "NVIDIA A40-8" },
    { 0x2235, 0x16e7, 0x10DE, "NVIDIA A40-1" },
    { 0x2236, 0x14b6, 0x10DE, "NVIDIA A10-1B" },
    { 0x2236, 0x14b7, 0x10DE, "NVIDIA A10-2B" },
    { 0x2236, 0x14b8, 0x10DE, "NVIDIA A10-1Q" },
    { 0x2236, 0x14b9, 0x10DE, "NVIDIA A10-2Q" },
    { 0x2236, 0x14ba, 0x10DE, "NVIDIA A10-3Q" },
    { 0x2236, 0x14bb, 0x10DE, "NVIDIA A10-4Q" },
    { 0x2236, 0x14bc, 0x10DE, "NVIDIA A10-6Q" },
    { 0x2236, 0x14bd, 0x10DE, "NVIDIA A10-8Q" },
    { 0x2236, 0x14be, 0x10DE, "NVIDIA A10-12Q" },
    { 0x2236, 0x14bf, 0x10DE, "NVIDIA A10-24Q" },
    { 0x2236, 0x14c0, 0x10DE, "NVIDIA A10-1A" },
    { 0x2236, 0x14c1, 0x10DE, "NVIDIA A10-2A" },
    { 0x2236, 0x14c2, 0x10DE, "NVIDIA A10-3A" },
    { 0x2236, 0x14c3, 0x10DE, "NVIDIA A10-4A" },
    { 0x2236, 0x14c4, 0x10DE, "NVIDIA A10-6A" },
    { 0x2236, 0x14c5, 0x10DE, "NVIDIA A10-8A" },
    { 0x2236, 0x14c6, 0x10DE, "NVIDIA A10-12A" },
    { 0x2236, 0x14c7, 0x10DE, "NVIDIA A10-24A" },
    { 0x2236, 0x14c8, 0x10DE, "NVIDIA A10-6" },
    { 0x2236, 0x14c9, 0x10DE, "NVIDIA A10-8" },
    { 0x2236, 0x14ca, 0x10DE, "NVIDIA A10-12" },
    { 0x2236, 0x14cb, 0x10DE, "NVIDIA A10-24" },
    { 0x2236, 0x14d0, 0x10DE, "NVIDIA A10-4C" },
    { 0x2236, 0x14d1, 0x10DE, "NVIDIA A10-6C" },
    { 0x2236, 0x14d2, 0x10DE, "NVIDIA A10-8C" },
    { 0x2236, 0x14d3, 0x10DE, "NVIDIA A10-12C" },
    { 0x2236, 0x14d4, 0x10DE, "NVIDIA A10-24C" },
    { 0x2236, 0x167e, 0x10DE, "NVIDIA A10-2" },
    { 0x2236, 0x167f, 0x10DE, "NVIDIA A10-3" },
    { 0x2236, 0x1680, 0x10DE, "NVIDIA A10-4" },
    { 0x2236, 0x16e8, 0x10DE, "NVIDIA A10-1" },
    { 0x2237, 0x155a, 0x10DE, "NVIDIA A10G-1" },
    { 0x2237, 0x155b, 0x10DE, "NVIDIA A10G-2" },
    { 0x2237, 0x155c, 0x10DE, "NVIDIA A10G-3" },
    { 0x2237, 0x155d, 0x10DE, "NVIDIA A10G-4" },
    { 0x2237, 0x155e, 0x10DE, "NVIDIA A10G-6" },
    { 0x2237, 0x155f, 0x10DE, "NVIDIA A10G-8" },
    { 0x2237, 0x1560, 0x10DE, "NVIDIA A10G-12" },
    { 0x2237, 0x1561, 0x10DE, "NVIDIA A10G-24" },
    { 0x2237, 0x162a, 0x10DE, "NVIDIA A10G-1B" },
    { 0x2237, 0x162b, 0x10DE, "NVIDIA A10G-2B" },
    { 0x2237, 0x162c, 0x10DE, "NVIDIA A10G-1Q" },
    { 0x2237, 0x162d, 0x10DE, "NVIDIA A10G-2Q" },
    { 0x2237, 0x162e, 0x10DE, "NVIDIA A10G-3Q" },
    { 0x2237, 0x162f, 0x10DE, "NVIDIA A10G-4Q" },
    { 0x2237, 0x1630, 0x10DE, "NVIDIA A10G-6Q" },
    { 0x2237, 0x1631, 0x10DE, "NVIDIA A10G-8Q" },
    { 0x2237, 0x1632, 0x10DE, "NVIDIA A10G-12Q" },
    { 0x2237, 0x1633, 0x10DE, "NVIDIA A10G-24Q" },
    { 0x2237, 0x1634, 0x10DE, "NVIDIA A10G-1A" },
    { 0x2237, 0x1635, 0x10DE, "NVIDIA A10G-2A" },
    { 0x2237, 0x1636, 0x10DE, "NVIDIA A10G-3A" },
    { 0x2237, 0x1637, 0x10DE, "NVIDIA A10G-4A" },
    { 0x2237, 0x1638, 0x10DE, "NVIDIA A10G-6A" },
    { 0x2237, 0x1639, 0x10DE, "NVIDIA A10G-8A" },
    { 0x2237, 0x163a, 0x10DE, "NVIDIA A10G-12A" },
    { 0x2237, 0x163b, 0x10DE, "NVIDIA A10G-24A" },
    { 0x2237, 0x1810, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x2237, 0x1811, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x2238, 0x16a3, 0x10DE, "NVIDIA A10M-1B" },
    { 0x2238, 0x16a4, 0x10DE, "NVIDIA A10M-2B" },
    { 0x2238, 0x16a5, 0x10DE, "NVIDIA A10M-1Q" },
    { 0x2238, 0x16a6, 0x10DE, "NVIDIA A10M-2Q" },
    { 0x2238, 0x16a7, 0x10DE, "NVIDIA A10M-4Q" },
    { 0x2238, 0x16a8, 0x10DE, "NVIDIA A10M-5Q" },
    { 0x2238, 0x16a9, 0x10DE, "NVIDIA A10M-10Q" },
    { 0x2238, 0x16aa, 0x10DE, "NVIDIA A10M-20Q" },
    { 0x2238, 0x16ab, 0x10DE, "NVIDIA A10M-1A" },
    { 0x2238, 0x16ac, 0x10DE, "NVIDIA A10M-2A" },
    { 0x2238, 0x16ad, 0x10DE, "NVIDIA A10M-4A" },
    { 0x2238, 0x16ae, 0x10DE, "NVIDIA A10M-5A" },
    { 0x2238, 0x16af, 0x10DE, "NVIDIA A10M-10A" },
    { 0x2238, 0x16b0, 0x10DE, "NVIDIA A10M-20A" },
    { 0x2238, 0x16b1, 0x10DE, "NVIDIA A10M-2" },
    { 0x2238, 0x16b2, 0x10DE, "NVIDIA A10M-4" },
    { 0x2238, 0x16b3, 0x10DE, "NVIDIA A10M-5" },
    { 0x2238, 0x16b4, 0x10DE, "NVIDIA A10M-10" },
    { 0x2238, 0x16b5, 0x10DE, "NVIDIA A10M-20" },
    { 0x2238, 0x16b6, 0x10DE, "NVIDIA A10M-4C" },
    { 0x2238, 0x16b7, 0x10DE, "NVIDIA A10M-5C" },
    { 0x2238, 0x16b8, 0x10DE, "NVIDIA A10M-10C" },
    { 0x2238, 0x16b9, 0x10DE, "NVIDIA A10M-20C" },
    { 0x2238, 0x16e6, 0x10DE, "NVIDIA A10M-1" },
    { 0x2321, 0x1853, 0x10DE, "NVIDIA H100L-1-12CME" },
    { 0x2321, 0x1854, 0x10DE, "NVIDIA H100L-1-12C" },
    { 0x2321, 0x1855, 0x10DE, "NVIDIA H100L-1-24C" },
    { 0x2321, 0x1856, 0x10DE, "NVIDIA H100L-2-24C" },
    { 0x2321, 0x1857, 0x10DE, "NVIDIA H100L-3-47C" },
    { 0x2321, 0x1858, 0x10DE, "NVIDIA H100L-4-47C" },
    { 0x2321, 0x1859, 0x10DE, "NVIDIA H100L-7-94C" },
    { 0x2321, 0x185a, 0x10DE, "NVIDIA H100L-4C" },
    { 0x2321, 0x185b, 0x10DE, "NVIDIA H100L-6C" },
    { 0x2321, 0x185c, 0x10DE, "NVIDIA H100L-11C" },
    { 0x2321, 0x185d, 0x10DE, "NVIDIA H100L-15C" },
    { 0x2321, 0x185e, 0x10DE, "NVIDIA H100L-23C" },
    { 0x2321, 0x185f, 0x10DE, "NVIDIA H100L-47C" },
    { 0x2321, 0x1860, 0x10DE, "NVIDIA H100L-94C" },
    { 0x2322, 0x17e2, 0x10DE, "NVIDIA H800-1-10CME" },
    { 0x2322, 0x17e3, 0x10DE, "NVIDIA H800-1-10C" },
    { 0x2322, 0x17e4, 0x10DE, "NVIDIA H800-2-20C" },
    { 0x2322, 0x17e5, 0x10DE, "NVIDIA H800-3-40C" },
    { 0x2322, 0x17e6, 0x10DE, "NVIDIA H800-4-40C" },
    { 0x2322, 0x17e7, 0x10DE, "NVIDIA H800-7-80C" },
    { 0x2322, 0x17e8, 0x10DE, "NVIDIA H800-4C" },
    { 0x2322, 0x17e9, 0x10DE, "NVIDIA H800-5C" },
    { 0x2322, 0x17ea, 0x10DE, "NVIDIA H800-8C" },
    { 0x2322, 0x17eb, 0x10DE, "NVIDIA H800-10C" },
    { 0x2322, 0x17ec, 0x10DE, "NVIDIA H800-16C" },
    { 0x2322, 0x17ed, 0x10DE, "NVIDIA H800-20C" },
    { 0x2322, 0x17ee, 0x10DE, "NVIDIA H800-40C" },
    { 0x2322, 0x17ef, 0x10DE, "NVIDIA H800-80C" },
    { 0x2322, 0x1845, 0x10DE, "NVIDIA H800-1-20C" },
    { 0x2324, 0x18d5, 0x10DE, "NVIDIA H800XM-1-10CME" },
    { 0x2324, 0x18d6, 0x10DE, "NVIDIA H800XM-1-10C" },
    { 0x2324, 0x18d7, 0x10DE, "NVIDIA H800XM-1-20C" },
    { 0x2324, 0x18d8, 0x10DE, "NVIDIA H800XM-2-20C" },
    { 0x2324, 0x18d9, 0x10DE, "NVIDIA H800XM-3-40C" },
    { 0x2324, 0x18da, 0x10DE, "NVIDIA H800XM-4-40C" },
    { 0x2324, 0x18db, 0x10DE, "NVIDIA H800XM-7-80C" },
    { 0x2324, 0x18dc, 0x10DE, "NVIDIA H800XM-4C" },
    { 0x2324, 0x18dd, 0x10DE, "NVIDIA H800XM-5C" },
    { 0x2324, 0x18de, 0x10DE, "NVIDIA H800XM-8C" },
    { 0x2324, 0x18df, 0x10DE, "NVIDIA H800XM-10C" },
    { 0x2324, 0x18e0, 0x10DE, "NVIDIA H800XM-16C" },
    { 0x2324, 0x18e1, 0x10DE, "NVIDIA H800XM-20C" },
    { 0x2324, 0x18e2, 0x10DE, "NVIDIA H800XM-40C" },
    { 0x2324, 0x18e3, 0x10DE, "NVIDIA H800XM-80C" },
    { 0x2329, 0x2028, 0x10DE, "NVIDIA H20-1-12CME" },
    { 0x2329, 0x2029, 0x10DE, "NVIDIA H20-1-12C" },
    { 0x2329, 0x202a, 0x10DE, "NVIDIA H20-1-24C" },
    { 0x2329, 0x202b, 0x10DE, "NVIDIA H20-2-24C" },
    { 0x2329, 0x202c, 0x10DE, "NVIDIA H20-3-48C" },
    { 0x2329, 0x202d, 0x10DE, "NVIDIA H20-4-48C" },
    { 0x2329, 0x202e, 0x10DE, "NVIDIA H20-7-96C" },
    { 0x2329, 0x202f, 0x10DE, "NVIDIA H20-4C" },
    { 0x2329, 0x2030, 0x10DE, "NVIDIA H20-6C" },
    { 0x2329, 0x2031, 0x10DE, "NVIDIA H20-12C" },
    { 0x2329, 0x2032, 0x10DE, "NVIDIA H20-16C" },
    { 0x2329, 0x2033, 0x10DE, "NVIDIA H20-24C" },
    { 0x2329, 0x2034, 0x10DE, "NVIDIA H20-48C" },
    { 0x2329, 0x2035, 0x10DE, "NVIDIA H20-96C" },
    { 0x2329, 0x2047, 0x10DE, "NVIDIA H20-8C" },
    { 0x2329, 0x2048, 0x10DE, "NVIDIA H20-32C" },
    { 0x232C, 0x2108, 0x10DE, "NVIDIA H20X-1-18CME" },
    { 0x232C, 0x2109, 0x10DE, "NVIDIA H20X-1-18C" },
    { 0x232C, 0x210a, 0x10DE, "NVIDIA H20X-1-35C" },
    { 0x232C, 0x210b, 0x10DE, "NVIDIA H20X-2-35C" },
    { 0x232C, 0x210c, 0x10DE, "NVIDIA H20X-3-71C" },
    { 0x232C, 0x210d, 0x10DE, "NVIDIA H20X-4-71C" },
    { 0x232C, 0x210e, 0x10DE, "NVIDIA H20X-7-141C" },
    { 0x232C, 0x210f, 0x10DE, "NVIDIA H20X-4C" },
    { 0x232C, 0x2110, 0x10DE, "NVIDIA H20X-7C" },
    { 0x232C, 0x2111, 0x10DE, "NVIDIA H20X-8C" },
    { 0x232C, 0x2112, 0x10DE, "NVIDIA H20X-14C" },
    { 0x232C, 0x2113, 0x10DE, "NVIDIA H20X-17C" },
    { 0x232C, 0x2114, 0x10DE, "NVIDIA H20X-28C" },
    { 0x232C, 0x2115, 0x10DE, "NVIDIA H20X-35C" },
    { 0x232C, 0x2116, 0x10DE, "NVIDIA H20X-70C" },
    { 0x232C, 0x2117, 0x10DE, "NVIDIA H20X-141C" },
    { 0x2330, 0x187a, 0x10DE, "NVIDIA H100XM-1-10CME" },
    { 0x2330, 0x187b, 0x10DE, "NVIDIA H100XM-1-10C" },
    { 0x2330, 0x187c, 0x10DE, "NVIDIA H100XM-1-20C" },
    { 0x2330, 0x187d, 0x10DE, "NVIDIA H100XM-2-20C" },
    { 0x2330, 0x187e, 0x10DE, "NVIDIA H100XM-3-40C" },
    { 0x2330, 0x187f, 0x10DE, "NVIDIA H100XM-4-40C" },
    { 0x2330, 0x1880, 0x10DE, "NVIDIA H100XM-7-80C" },
    { 0x2330, 0x1881, 0x10DE, "NVIDIA H100XM-4C" },
    { 0x2330, 0x1882, 0x10DE, "NVIDIA H100XM-5C" },
    { 0x2330, 0x1883, 0x10DE, "NVIDIA H100XM-8C" },
    { 0x2330, 0x1884, 0x10DE, "NVIDIA H100XM-10C" },
    { 0x2330, 0x1885, 0x10DE, "NVIDIA H100XM-16C" },
    { 0x2330, 0x1886, 0x10DE, "NVIDIA H100XM-20C" },
    { 0x2330, 0x1887, 0x10DE, "NVIDIA H100XM-40C" },
    { 0x2330, 0x1888, 0x10DE, "NVIDIA H100XM-80C" },
    { 0x2331, 0x16d3, 0x10DE, "NVIDIA H100-1-10C" },
    { 0x2331, 0x16d4, 0x10DE, "NVIDIA H100-2-20C" },
    { 0x2331, 0x16d5, 0x10DE, "NVIDIA H100-3-40C" },
    { 0x2331, 0x16d6, 0x10DE, "NVIDIA H100-4-40C" },
    { 0x2331, 0x16d7, 0x10DE, "NVIDIA H100-7-80C" },
    { 0x2331, 0x16d8, 0x10DE, "NVIDIA H100-4C" },
    { 0x2331, 0x16d9, 0x10DE, "NVIDIA H100-8C" },
    { 0x2331, 0x16da, 0x10DE, "NVIDIA H100-10C" },
    { 0x2331, 0x16db, 0x10DE, "NVIDIA H100-16C" },
    { 0x2331, 0x16dc, 0x10DE, "NVIDIA H100-20C" },
    { 0x2331, 0x16dd, 0x10DE, "NVIDIA H100-40C" },
    { 0x2331, 0x16de, 0x10DE, "NVIDIA H100-80C" },
    { 0x2331, 0x1798, 0x10DE, "NVIDIA H100-5C" },
    { 0x2331, 0x17f0, 0x10DE, "NVIDIA H100-1-10CME" },
    { 0x2331, 0x1844, 0x10DE, "NVIDIA H100-1-20C" },
    { 0x2335, 0x206e, 0x10DE, "NVIDIA H200X-1-18CME" },
    { 0x2335, 0x206f, 0x10DE, "NVIDIA H200X-1-18C" },
    { 0x2335, 0x2070, 0x10DE, "NVIDIA H200X-1-35C" },
    { 0x2335, 0x2071, 0x10DE, "NVIDIA H200X-2-35C" },
    { 0x2335, 0x2072, 0x10DE, "NVIDIA H200X-3-71C" },
    { 0x2335, 0x2073, 0x10DE, "NVIDIA H200X-4-71C" },
    { 0x2335, 0x2074, 0x10DE, "NVIDIA H200X-7-141C" },
    { 0x2335, 0x2075, 0x10DE, "NVIDIA H200X-4C" },
    { 0x2335, 0x2076, 0x10DE, "NVIDIA H200X-7C" },
    { 0x2335, 0x2077, 0x10DE, "NVIDIA H200X-8C" },
    { 0x2335, 0x2078, 0x10DE, "NVIDIA H200X-14C" },
    { 0x2335, 0x2079, 0x10DE, "NVIDIA H200X-17C" },
    { 0x2335, 0x207a, 0x10DE, "NVIDIA H200X-28C" },
    { 0x2335, 0x207b, 0x10DE, "NVIDIA H200X-35C" },
    { 0x2335, 0x207e, 0x10DE, "NVIDIA H200X-70C" },
    { 0x2335, 0x207f, 0x10DE, "NVIDIA H200X-141C" },
    { 0x2337, 0x18f2, 0x10DE, "NVIDIA H100XS-1-8CME" },
    { 0x2337, 0x18f3, 0x10DE, "NVIDIA H100XS-1-8C" },
    { 0x2337, 0x18f4, 0x10DE, "NVIDIA H100XS-1-16C" },
    { 0x2337, 0x18f5, 0x10DE, "NVIDIA H100XS-2-16C" },
    { 0x2337, 0x18f6, 0x10DE, "NVIDIA H100XS-3-32C" },
    { 0x2337, 0x18f7, 0x10DE, "NVIDIA H100XS-4-32C" },
    { 0x2337, 0x18f8, 0x10DE, "NVIDIA H100XS-7-64C" },
    { 0x2337, 0x18f9, 0x10DE, "NVIDIA H100XS-4C" },
    { 0x2337, 0x18fa, 0x10DE, "NVIDIA H100XS-8C" },
    { 0x2337, 0x18fb, 0x10DE, "NVIDIA H100XS-16C" },
    { 0x2337, 0x18fc, 0x10DE, "NVIDIA H100XS-32C" },
    { 0x2337, 0x18fd, 0x10DE, "NVIDIA H100XS-64C" },
    { 0x2339, 0x18e4, 0x10DE, "NVIDIA H100XL-1-12CME" },
    { 0x2339, 0x18e5, 0x10DE, "NVIDIA H100XL-1-12C" },
    { 0x2339, 0x18e6, 0x10DE, "NVIDIA H100XL-1-24C" },
    { 0x2339, 0x18e7, 0x10DE, "NVIDIA H100XL-2-24C" },
    { 0x2339, 0x18e8, 0x10DE, "NVIDIA H100XL-3-47C" },
    { 0x2339, 0x18e9, 0x10DE, "NVIDIA H100XL-4-47C" },
    { 0x2339, 0x18ea, 0x10DE, "NVIDIA H100XL-7-94C" },
    { 0x2339, 0x18eb, 0x10DE, "NVIDIA H100XL-4C" },
    { 0x2339, 0x18ec, 0x10DE, "NVIDIA H100XL-6C" },
    { 0x2339, 0x18ed, 0x10DE, "NVIDIA H100XL-11C" },
    { 0x2339, 0x18ee, 0x10DE, "NVIDIA H100XL-15C" },
    { 0x2339, 0x18ef, 0x10DE, "NVIDIA H100XL-23C" },
    { 0x2339, 0x18f0, 0x10DE, "NVIDIA H100XL-47C" },
    { 0x2339, 0x18f1, 0x10DE, "NVIDIA H100XL-94C" },
    { 0x233A, 0x1861, 0x10DE, "NVIDIA H800L-1-12CME" },
    { 0x233A, 0x1862, 0x10DE, "NVIDIA H800L-1-12C" },
    { 0x233A, 0x1863, 0x10DE, "NVIDIA H800L-1-24C" },
    { 0x233A, 0x1864, 0x10DE, "NVIDIA H800L-2-24C" },
    { 0x233A, 0x1865, 0x10DE, "NVIDIA H800L-3-47C" },
    { 0x233A, 0x1866, 0x10DE, "NVIDIA H800L-4-47C" },
    { 0x233A, 0x1867, 0x10DE, "NVIDIA H800L-7-94C" },
    { 0x233A, 0x1868, 0x10DE, "NVIDIA H800L-4C" },
    { 0x233A, 0x1869, 0x10DE, "NVIDIA H800L-6C" },
    { 0x233A, 0x186a, 0x10DE, "NVIDIA H800L-11C" },
    { 0x233A, 0x186b, 0x10DE, "NVIDIA H800L-15C" },
    { 0x233A, 0x186c, 0x10DE, "NVIDIA H800L-23C" },
    { 0x233A, 0x186d, 0x10DE, "NVIDIA H800L-47C" },
    { 0x233A, 0x186e, 0x10DE, "NVIDIA H800L-94C" },
    { 0x233B, 0x2081, 0x10DE, "NVIDIA H200-1-18CME" },
    { 0x233B, 0x2082, 0x10DE, "NVIDIA H200-1-18C" },
    { 0x233B, 0x2083, 0x10DE, "NVIDIA H200-1-35C" },
    { 0x233B, 0x2084, 0x10DE, "NVIDIA H200-2-35C" },
    { 0x233B, 0x2085, 0x10DE, "NVIDIA H200-3-71C" },
    { 0x233B, 0x2086, 0x10DE, "NVIDIA H200-4-71C" },
    { 0x233B, 0x2087, 0x10DE, "NVIDIA H200-7-141C" },
    { 0x233B, 0x2088, 0x10DE, "NVIDIA H200-4C" },
    { 0x233B, 0x2089, 0x10DE, "NVIDIA H200-7C" },
    { 0x233B, 0x208a, 0x10DE, "NVIDIA H200-8C" },
    { 0x233B, 0x208b, 0x10DE, "NVIDIA H200-14C" },
    { 0x233B, 0x208c, 0x10DE, "NVIDIA H200-17C" },
    { 0x233B, 0x208d, 0x10DE, "NVIDIA H200-28C" },
    { 0x233B, 0x208e, 0x10DE, "NVIDIA H200-35C" },
    { 0x233B, 0x208f, 0x10DE, "NVIDIA H200-70C" },
    { 0x233B, 0x2090, 0x10DE, "NVIDIA H200-141C" },
    { 0x2342, 0x18c2, 0x10DE, "NVIDIA GH200-1-12CME" },
    { 0x2342, 0x18c3, 0x10DE, "NVIDIA GH200-1-12C" },
    { 0x2342, 0x18c4, 0x10DE, "NVIDIA GH200-1-24C" },
    { 0x2342, 0x18c5, 0x10DE, "NVIDIA GH200-2-24C" },
    { 0x2342, 0x18c6, 0x10DE, "NVIDIA GH200-3-48C" },
    { 0x2342, 0x18c7, 0x10DE, "NVIDIA GH200-4-48C" },
    { 0x2342, 0x18c8, 0x10DE, "NVIDIA GH200-7-96C" },
    { 0x2342, 0x18c9, 0x10DE, "NVIDIA GH200-96C" },
    { 0x2348, 0x20c2, 0x10DE, "NVIDIA GH200L-1-18CME" },
    { 0x2348, 0x20c3, 0x10DE, "NVIDIA GH200L-1-18C" },
    { 0x2348, 0x20c4, 0x10DE, "NVIDIA GH200L-1-36C" },
    { 0x2348, 0x20c5, 0x10DE, "NVIDIA GH200L-2-36C" },
    { 0x2348, 0x20c6, 0x10DE, "NVIDIA GH200L-3-72C" },
    { 0x2348, 0x20c7, 0x10DE, "NVIDIA GH200L-4-72C" },
    { 0x2348, 0x20c8, 0x10DE, "NVIDIA GH200L-7-144C" },
    { 0x2348, 0x20c9, 0x10DE, "NVIDIA GH200L-144C" },
    { 0x25B6, 0x159d, 0x10DE, "NVIDIA A16-1B" },
    { 0x25B6, 0x159e, 0x10DE, "NVIDIA A16-2B" },
    { 0x25B6, 0x159f, 0x10DE, "NVIDIA A16-1Q" },
    { 0x25B6, 0x1600, 0x10DE, "NVIDIA A16-2Q" },
    { 0x25B6, 0x1601, 0x10DE, "NVIDIA A16-4Q" },
    { 0x25B6, 0x1602, 0x10DE, "NVIDIA A16-8Q" },
    { 0x25B6, 0x1603, 0x10DE, "NVIDIA A16-16Q" },
    { 0x25B6, 0x1604, 0x10DE, "NVIDIA A16-1A" },
    { 0x25B6, 0x1605, 0x10DE, "NVIDIA A16-2A" },
    { 0x25B6, 0x1606, 0x10DE, "NVIDIA A16-4A" },
    { 0x25B6, 0x1607, 0x10DE, "NVIDIA A16-8A" },
    { 0x25B6, 0x1608, 0x10DE, "NVIDIA A16-16A" },
    { 0x25B6, 0x1609, 0x10DE, "NVIDIA A16-4C" },
    { 0x25B6, 0x160a, 0x10DE, "NVIDIA A16-8C" },
    { 0x25B6, 0x160b, 0x10DE, "NVIDIA A16-16C" },
    { 0x25B6, 0x1646, 0x10DE, "NVIDIA A2-1B" },
    { 0x25B6, 0x1647, 0x10DE, "NVIDIA A2-2B" },
    { 0x25B6, 0x1648, 0x10DE, "NVIDIA A2-1Q" },
    { 0x25B6, 0x1649, 0x10DE, "NVIDIA A2-2Q" },
    { 0x25B6, 0x164a, 0x10DE, "NVIDIA A2-4Q" },
    { 0x25B6, 0x164b, 0x10DE, "NVIDIA A2-8Q" },
    { 0x25B6, 0x164c, 0x10DE, "NVIDIA A2-16Q" },
    { 0x25B6, 0x164d, 0x10DE, "NVIDIA A2-1A" },
    { 0x25B6, 0x164e, 0x10DE, "NVIDIA A2-2A" },
    { 0x25B6, 0x164f, 0x10DE, "NVIDIA A2-4A" },
    { 0x25B6, 0x1650, 0x10DE, "NVIDIA A2-8A" },
    { 0x25B6, 0x1651, 0x10DE, "NVIDIA A2-16A" },
    { 0x25B6, 0x1652, 0x10DE, "NVIDIA A2-4" },
    { 0x25B6, 0x1653, 0x10DE, "NVIDIA A2-8" },
    { 0x25B6, 0x1654, 0x10DE, "NVIDIA A2-16" },
    { 0x25B6, 0x1655, 0x10DE, "NVIDIA A2-4C" },
    { 0x25B6, 0x1656, 0x10DE, "NVIDIA A2-8C" },
    { 0x25B6, 0x1657, 0x10DE, "NVIDIA A2-16C" },
    { 0x26B1, 0x1708, 0x10DE, "NVIDIA RTX6000-Ada-1B" },
    { 0x26B1, 0x1709, 0x10DE, "NVIDIA RTX6000-Ada-2B" },
    { 0x26B1, 0x170a, 0x10DE, "NVIDIA RTX6000-Ada-1Q" },
    { 0x26B1, 0x170b, 0x10DE, "NVIDIA RTX6000-Ada-2Q" },
    { 0x26B1, 0x170c, 0x10DE, "NVIDIA RTX6000-Ada-3Q" },
    { 0x26B1, 0x170d, 0x10DE, "NVIDIA RTX6000-Ada-4Q" },
    { 0x26B1, 0x170e, 0x10DE, "NVIDIA RTX6000-Ada-6Q" },
    { 0x26B1, 0x170f, 0x10DE, "NVIDIA RTX6000-Ada-8Q" },
    { 0x26B1, 0x1710, 0x10DE, "NVIDIA RTX6000-Ada-12Q" },
    { 0x26B1, 0x1711, 0x10DE, "NVIDIA RTX6000-Ada-16Q" },
    { 0x26B1, 0x1712, 0x10DE, "NVIDIA RTX6000-Ada-24Q" },
    { 0x26B1, 0x1713, 0x10DE, "NVIDIA RTX6000-Ada-48Q" },
    { 0x26B1, 0x1714, 0x10DE, "NVIDIA RTX6000-Ada-1A" },
    { 0x26B1, 0x1715, 0x10DE, "NVIDIA RTX6000-Ada-2A" },
    { 0x26B1, 0x1716, 0x10DE, "NVIDIA RTX6000-Ada-3A" },
    { 0x26B1, 0x1717, 0x10DE, "NVIDIA RTX6000-Ada-4A" },
    { 0x26B1, 0x1718, 0x10DE, "NVIDIA RTX6000-Ada-6A" },
    { 0x26B1, 0x1719, 0x10DE, "NVIDIA RTX6000-Ada-8A" },
    { 0x26B1, 0x171a, 0x10DE, "NVIDIA RTX6000-Ada-12A" },
    { 0x26B1, 0x171b, 0x10DE, "NVIDIA RTX6000-Ada-16A" },
    { 0x26B1, 0x171c, 0x10DE, "NVIDIA RTX6000-Ada-24A" },
    { 0x26B1, 0x171d, 0x10DE, "NVIDIA RTX6000-Ada-48A" },
    { 0x26B1, 0x171e, 0x10DE, "NVIDIA RTX6000-Ada-1" },
    { 0x26B1, 0x171f, 0x10DE, "NVIDIA RTX6000-Ada-2" },
    { 0x26B1, 0x1720, 0x10DE, "NVIDIA RTX6000-Ada-3" },
    { 0x26B1, 0x1721, 0x10DE, "NVIDIA RTX6000-Ada-4" },
    { 0x26B1, 0x1722, 0x10DE, "NVIDIA RTX6000-Ada-6" },
    { 0x26B1, 0x1723, 0x10DE, "NVIDIA RTX6000-Ada-8" },
    { 0x26B1, 0x1724, 0x10DE, "NVIDIA RTX6000-Ada-12" },
    { 0x26B1, 0x1725, 0x10DE, "NVIDIA RTX6000-Ada-16" },
    { 0x26B1, 0x1726, 0x10DE, "NVIDIA RTX6000-Ada-24" },
    { 0x26B1, 0x1727, 0x10DE, "NVIDIA RTX6000-Ada-48" },
    { 0x26B1, 0x1728, 0x10DE, "NVIDIA RTX6000-Ada-4C" },
    { 0x26B1, 0x1729, 0x10DE, "NVIDIA RTX6000-Ada-6C" },
    { 0x26B1, 0x172a, 0x10DE, "NVIDIA RTX6000-Ada-8C" },
    { 0x26B1, 0x172b, 0x10DE, "NVIDIA RTX6000-Ada-12C" },
    { 0x26B1, 0x172c, 0x10DE, "NVIDIA RTX6000-Ada-16C" },
    { 0x26B1, 0x172d, 0x10DE, "NVIDIA RTX6000-Ada-24C" },
    { 0x26B1, 0x172e, 0x10DE, "NVIDIA RTX6000-Ada-48C" },
    { 0x26B2, 0x1821, 0x10DE, "NVIDIA RTX5000-Ada-1B" },
    { 0x26B2, 0x1822, 0x10DE, "NVIDIA RTX5000-Ada-2B" },
    { 0x26B2, 0x1823, 0x10DE, "NVIDIA RTX5000-Ada-1Q" },
    { 0x26B2, 0x1824, 0x10DE, "NVIDIA RTX5000-Ada-2Q" },
    { 0x26B2, 0x1825, 0x10DE, "NVIDIA RTX5000-Ada-4Q" },
    { 0x26B2, 0x1826, 0x10DE, "NVIDIA RTX5000-Ada-8Q" },
    { 0x26B2, 0x1827, 0x10DE, "NVIDIA RTX5000-Ada-16Q" },
    { 0x26B2, 0x1828, 0x10DE, "NVIDIA RTX5000-Ada-32Q" },
    { 0x26B2, 0x1829, 0x10DE, "NVIDIA RTX5000-Ada-1A" },
    { 0x26B2, 0x182a, 0x10DE, "NVIDIA RTX5000-Ada-2A" },
    { 0x26B2, 0x182b, 0x10DE, "NVIDIA RTX5000-Ada-4A" },
    { 0x26B2, 0x182c, 0x10DE, "NVIDIA RTX5000-Ada-8A" },
    { 0x26B2, 0x182d, 0x10DE, "NVIDIA RTX5000-Ada-16A" },
    { 0x26B2, 0x182e, 0x10DE, "NVIDIA RTX5000-Ada-32A" },
    { 0x26B2, 0x182f, 0x10DE, "NVIDIA RTX5000-Ada-1" },
    { 0x26B2, 0x1830, 0x10DE, "NVIDIA RTX5000-Ada-2" },
    { 0x26B2, 0x1831, 0x10DE, "NVIDIA RTX5000-Ada-4" },
    { 0x26B2, 0x1832, 0x10DE, "NVIDIA RTX5000-Ada-8" },
    { 0x26B2, 0x1833, 0x10DE, "NVIDIA RTX5000-Ada-16" },
    { 0x26B2, 0x1834, 0x10DE, "NVIDIA RTX5000-Ada-32" },
    { 0x26B2, 0x1835, 0x10DE, "NVIDIA RTX5000-Ada-4C" },
    { 0x26B2, 0x1836, 0x10DE, "NVIDIA RTX5000-Ada-8C" },
    { 0x26B2, 0x1837, 0x10DE, "NVIDIA RTX5000-Ada-16C" },
    { 0x26B2, 0x1838, 0x10DE, "NVIDIA RTX5000-Ada-32C" },
    { 0x26B3, 0x1958, 0x10DE, "NVIDIA RTX5880-Ada-1B" },
    { 0x26B3, 0x1959, 0x10DE, "NVIDIA RTX5880-Ada-2B" },
    { 0x26B3, 0x195a, 0x10DE, "NVIDIA RTX5880-Ada-1Q" },
    { 0x26B3, 0x195b, 0x10DE, "NVIDIA RTX5880-Ada-2Q" },
    { 0x26B3, 0x195c, 0x10DE, "NVIDIA RTX5880-Ada-3Q" },
    { 0x26B3, 0x195d, 0x10DE, "NVIDIA RTX5880-Ada-4Q" },
    { 0x26B3, 0x195e, 0x10DE, "NVIDIA RTX5880-Ada-6Q" },
    { 0x26B3, 0x195f, 0x10DE, "NVIDIA RTX5880-Ada-8Q" },
    { 0x26B3, 0x1960, 0x10DE, "NVIDIA RTX5880-Ada-12Q" },
    { 0x26B3, 0x1961, 0x10DE, "NVIDIA RTX5880-Ada-16Q" },
    { 0x26B3, 0x1962, 0x10DE, "NVIDIA RTX5880-Ada-24Q" },
    { 0x26B3, 0x1963, 0x10DE, "NVIDIA RTX5880-Ada-48Q" },
    { 0x26B3, 0x1964, 0x10DE, "NVIDIA RTX5880-Ada-1A" },
    { 0x26B3, 0x1965, 0x10DE, "NVIDIA RTX5880-Ada-2A" },
    { 0x26B3, 0x1966, 0x10DE, "NVIDIA RTX5880-Ada-3A" },
    { 0x26B3, 0x1967, 0x10DE, "NVIDIA RTX5880-Ada-4A" },
    { 0x26B3, 0x1968, 0x10DE, "NVIDIA RTX5880-Ada-6A" },
    { 0x26B3, 0x1969, 0x10DE, "NVIDIA RTX5880-Ada-8A" },
    { 0x26B3, 0x196a, 0x10DE, "NVIDIA RTX5880-Ada-12A" },
    { 0x26B3, 0x196b, 0x10DE, "NVIDIA RTX5880-Ada-16A" },
    { 0x26B3, 0x196c, 0x10DE, "NVIDIA RTX5880-Ada-24A" },
    { 0x26B3, 0x196d, 0x10DE, "NVIDIA RTX5880-Ada-48A" },
    { 0x26B3, 0x196e, 0x10DE, "NVIDIA RTX5880-Ada-1" },
    { 0x26B3, 0x196f, 0x10DE, "NVIDIA RTX5880-Ada-2" },
    { 0x26B3, 0x1970, 0x10DE, "NVIDIA RTX5880-Ada-3" },
    { 0x26B3, 0x1971, 0x10DE, "NVIDIA RTX5880-Ada-4" },
    { 0x26B3, 0x1972, 0x10DE, "NVIDIA RTX5880-Ada-6" },
    { 0x26B3, 0x1973, 0x10DE, "NVIDIA RTX5880-Ada-8" },
    { 0x26B3, 0x1974, 0x10DE, "NVIDIA RTX5880-Ada-12" },
    { 0x26B3, 0x1975, 0x10DE, "NVIDIA RTX5880-Ada-16" },
    { 0x26B3, 0x1976, 0x10DE, "NVIDIA RTX5880-Ada-24" },
    { 0x26B3, 0x1977, 0x10DE, "NVIDIA RTX5880-Ada-48" },
    { 0x26B3, 0x1978, 0x10DE, "NVIDIA RTX5880-Ada-4C" },
    { 0x26B3, 0x1979, 0x10DE, "NVIDIA RTX5880-Ada-6C" },
    { 0x26B3, 0x197a, 0x10DE, "NVIDIA RTX5880-Ada-8C" },
    { 0x26B3, 0x197b, 0x10DE, "NVIDIA RTX5880-Ada-12C" },
    { 0x26B3, 0x197c, 0x10DE, "NVIDIA RTX5880-Ada-16C" },
    { 0x26B3, 0x197d, 0x10DE, "NVIDIA RTX5880-Ada-24C" },
    { 0x26B3, 0x197e, 0x10DE, "NVIDIA RTX5880-Ada-48C" },
    { 0x26B5, 0x176d, 0x10DE, "NVIDIA L40-1B" },
    { 0x26B5, 0x176e, 0x10DE, "NVIDIA L40-2B" },
    { 0x26B5, 0x176f, 0x10DE, "NVIDIA L40-1Q" },
    { 0x26B5, 0x1770, 0x10DE, "NVIDIA L40-2Q" },
    { 0x26B5, 0x1771, 0x10DE, "NVIDIA L40-3Q" },
    { 0x26B5, 0x1772, 0x10DE, "NVIDIA L40-4Q" },
    { 0x26B5, 0x1773, 0x10DE, "NVIDIA L40-6Q" },
    { 0x26B5, 0x1774, 0x10DE, "NVIDIA L40-8Q" },
    { 0x26B5, 0x1775, 0x10DE, "NVIDIA L40-12Q" },
    { 0x26B5, 0x1776, 0x10DE, "NVIDIA L40-16Q" },
    { 0x26B5, 0x1777, 0x10DE, "NVIDIA L40-24Q" },
    { 0x26B5, 0x1778, 0x10DE, "NVIDIA L40-48Q" },
    { 0x26B5, 0x1779, 0x10DE, "NVIDIA L40-1A" },
    { 0x26B5, 0x177a, 0x10DE, "NVIDIA L40-2A" },
    { 0x26B5, 0x177b, 0x10DE, "NVIDIA L40-3A" },
    { 0x26B5, 0x177c, 0x10DE, "NVIDIA L40-4A" },
    { 0x26B5, 0x177d, 0x10DE, "NVIDIA L40-6A" },
    { 0x26B5, 0x177e, 0x10DE, "NVIDIA L40-8A" },
    { 0x26B5, 0x177f, 0x10DE, "NVIDIA L40-12A" },
    { 0x26B5, 0x1780, 0x10DE, "NVIDIA L40-16A" },
    { 0x26B5, 0x1781, 0x10DE, "NVIDIA L40-24A" },
    { 0x26B5, 0x1782, 0x10DE, "NVIDIA L40-48A" },
    { 0x26B5, 0x1783, 0x10DE, "NVIDIA L40-1" },
    { 0x26B5, 0x1784, 0x10DE, "NVIDIA L40-2" },
    { 0x26B5, 0x1785, 0x10DE, "NVIDIA L40-3" },
    { 0x26B5, 0x1786, 0x10DE, "NVIDIA L40-4" },
    { 0x26B5, 0x1787, 0x10DE, "NVIDIA L40-6" },
    { 0x26B5, 0x1788, 0x10DE, "NVIDIA L40-8" },
    { 0x26B5, 0x1789, 0x10DE, "NVIDIA L40-12" },
    { 0x26B5, 0x178a, 0x10DE, "NVIDIA L40-16" },
    { 0x26B5, 0x178b, 0x10DE, "NVIDIA L40-24" },
    { 0x26B5, 0x178c, 0x10DE, "NVIDIA L40-48" },
    { 0x26B5, 0x178d, 0x10DE, "NVIDIA L40-4C" },
    { 0x26B5, 0x178e, 0x10DE, "NVIDIA L40-6C" },
    { 0x26B5, 0x178f, 0x10DE, "NVIDIA L40-8C" },
    { 0x26B5, 0x1790, 0x10DE, "NVIDIA L40-12C" },
    { 0x26B5, 0x1791, 0x10DE, "NVIDIA L40-16C" },
    { 0x26B5, 0x1792, 0x10DE, "NVIDIA L40-24C" },
    { 0x26B5, 0x1793, 0x10DE, "NVIDIA L40-48C" },
    { 0x26B5, 0x1818, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x26B5, 0x181a, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x26B8, 0x174e, 0x10DE, "NVIDIA L40G-1B" },
    { 0x26B8, 0x174f, 0x10DE, "NVIDIA L40G-2B" },
    { 0x26B8, 0x1750, 0x10DE, "NVIDIA L40G-1Q" },
    { 0x26B8, 0x1751, 0x10DE, "NVIDIA L40G-2Q" },
    { 0x26B8, 0x1752, 0x10DE, "NVIDIA L40G-3Q" },
    { 0x26B8, 0x1753, 0x10DE, "NVIDIA L40G-4Q" },
    { 0x26B8, 0x1754, 0x10DE, "NVIDIA L40G-6Q" },
    { 0x26B8, 0x1755, 0x10DE, "NVIDIA L40G-8Q" },
    { 0x26B8, 0x1756, 0x10DE, "NVIDIA L40G-12Q" },
    { 0x26B8, 0x1757, 0x10DE, "NVIDIA L40G-24Q" },
    { 0x26B8, 0x1758, 0x10DE, "NVIDIA L40G-1A" },
    { 0x26B8, 0x1759, 0x10DE, "NVIDIA L40G-2A" },
    { 0x26B8, 0x175a, 0x10DE, "NVIDIA L40G-3A" },
    { 0x26B8, 0x175b, 0x10DE, "NVIDIA L40G-4A" },
    { 0x26B8, 0x175c, 0x10DE, "NVIDIA L40G-6A" },
    { 0x26B8, 0x175d, 0x10DE, "NVIDIA L40G-8A" },
    { 0x26B8, 0x175e, 0x10DE, "NVIDIA L40G-12A" },
    { 0x26B8, 0x175f, 0x10DE, "NVIDIA L40G-24A" },
    { 0x26B8, 0x1760, 0x10DE, "NVIDIA L40G-1" },
    { 0x26B8, 0x1761, 0x10DE, "NVIDIA L40G-2" },
    { 0x26B8, 0x1762, 0x10DE, "NVIDIA L40G-3" },
    { 0x26B8, 0x1763, 0x10DE, "NVIDIA L40G-4" },
    { 0x26B8, 0x1764, 0x10DE, "NVIDIA L40G-6" },
    { 0x26B8, 0x1765, 0x10DE, "NVIDIA L40G-8" },
    { 0x26B8, 0x1766, 0x10DE, "NVIDIA L40G-12" },
    { 0x26B8, 0x1767, 0x10DE, "NVIDIA L40G-24" },
    { 0x26B8, 0x1768, 0x10DE, "NVIDIA L40G-4C" },
    { 0x26B8, 0x1769, 0x10DE, "NVIDIA L40G-6C" },
    { 0x26B8, 0x176a, 0x10DE, "NVIDIA L40G-8C" },
    { 0x26B8, 0x176b, 0x10DE, "NVIDIA L40G-12C" },
    { 0x26B8, 0x176c, 0x10DE, "NVIDIA L40G-24C" },
    { 0x26B8, 0x181c, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x26B8, 0x181e, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x26B9, 0x1889, 0x10DE, "NVIDIA L40S-1B" },
    { 0x26B9, 0x188a, 0x10DE, "NVIDIA L40S-2B" },
    { 0x26B9, 0x188b, 0x10DE, "NVIDIA L40S-1Q" },
    { 0x26B9, 0x188c, 0x10DE, "NVIDIA L40S-2Q" },
    { 0x26B9, 0x188d, 0x10DE, "NVIDIA L40S-3Q" },
    { 0x26B9, 0x188e, 0x10DE, "NVIDIA L40S-4Q" },
    { 0x26B9, 0x188f, 0x10DE, "NVIDIA L40S-6Q" },
    { 0x26B9, 0x1890, 0x10DE, "NVIDIA L40S-8Q" },
    { 0x26B9, 0x1891, 0x10DE, "NVIDIA L40S-12Q" },
    { 0x26B9, 0x1892, 0x10DE, "NVIDIA L40S-16Q" },
    { 0x26B9, 0x1893, 0x10DE, "NVIDIA L40S-24Q" },
    { 0x26B9, 0x1894, 0x10DE, "NVIDIA L40S-48Q" },
    { 0x26B9, 0x1895, 0x10DE, "NVIDIA L40S-1A" },
    { 0x26B9, 0x1896, 0x10DE, "NVIDIA L40S-2A" },
    { 0x26B9, 0x1897, 0x10DE, "NVIDIA L40S-3A" },
    { 0x26B9, 0x1898, 0x10DE, "NVIDIA L40S-4A" },
    { 0x26B9, 0x1899, 0x10DE, "NVIDIA L40S-6A" },
    { 0x26B9, 0x189a, 0x10DE, "NVIDIA L40S-8A" },
    { 0x26B9, 0x189b, 0x10DE, "NVIDIA L40S-12A" },
    { 0x26B9, 0x189c, 0x10DE, "NVIDIA L40S-16A" },
    { 0x26B9, 0x189d, 0x10DE, "NVIDIA L40S-24A" },
    { 0x26B9, 0x189e, 0x10DE, "NVIDIA L40S-48A" },
    { 0x26B9, 0x189f, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x26B9, 0x18a0, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x26B9, 0x18a1, 0x10DE, "NVIDIA L40S-1" },
    { 0x26B9, 0x18a2, 0x10DE, "NVIDIA L40S-2" },
    { 0x26B9, 0x18a3, 0x10DE, "NVIDIA L40S-3" },
    { 0x26B9, 0x18a4, 0x10DE, "NVIDIA L40S-4" },
    { 0x26B9, 0x18a5, 0x10DE, "NVIDIA L40S-6" },
    { 0x26B9, 0x18a6, 0x10DE, "NVIDIA L40S-8" },
    { 0x26B9, 0x18a7, 0x10DE, "NVIDIA L40S-12" },
    { 0x26B9, 0x18a8, 0x10DE, "NVIDIA L40S-16" },
    { 0x26B9, 0x18a9, 0x10DE, "NVIDIA L40S-24" },
    { 0x26B9, 0x18aa, 0x10DE, "NVIDIA L40S-48" },
    { 0x26B9, 0x18ab, 0x10DE, "NVIDIA L40S-4C" },
    { 0x26B9, 0x18ac, 0x10DE, "NVIDIA L40S-6C" },
    { 0x26B9, 0x18ad, 0x10DE, "NVIDIA L40S-8C" },
    { 0x26B9, 0x18ae, 0x10DE, "NVIDIA L40S-12C" },
    { 0x26B9, 0x18af, 0x10DE, "NVIDIA L40S-16C" },
    { 0x26B9, 0x18b0, 0x10DE, "NVIDIA L40S-24C" },
    { 0x26B9, 0x18b1, 0x10DE, "NVIDIA L40S-48C" },
    { 0x26BA, 0x1909, 0x10DE, "NVIDIA L20-1B" },
    { 0x26BA, 0x190a, 0x10DE, "NVIDIA L20-2B" },
    { 0x26BA, 0x190b, 0x10DE, "NVIDIA L20-1Q" },
    { 0x26BA, 0x190c, 0x10DE, "NVIDIA L20-2Q" },
    { 0x26BA, 0x190d, 0x10DE, "NVIDIA L20-3Q" },
    { 0x26BA, 0x190e, 0x10DE, "NVIDIA L20-4Q" },
    { 0x26BA, 0x190f, 0x10DE, "NVIDIA L20-6Q" },
    { 0x26BA, 0x1910, 0x10DE, "NVIDIA L20-8Q" },
    { 0x26BA, 0x1911, 0x10DE, "NVIDIA L20-12Q" },
    { 0x26BA, 0x1912, 0x10DE, "NVIDIA L20-16Q" },
    { 0x26BA, 0x1913, 0x10DE, "NVIDIA L20-24Q" },
    { 0x26BA, 0x1914, 0x10DE, "NVIDIA L20-48Q" },
    { 0x26BA, 0x1915, 0x10DE, "NVIDIA L20-1A" },
    { 0x26BA, 0x1916, 0x10DE, "NVIDIA L20-2A" },
    { 0x26BA, 0x1917, 0x10DE, "NVIDIA L20-3A" },
    { 0x26BA, 0x1918, 0x10DE, "NVIDIA L20-4A" },
    { 0x26BA, 0x1919, 0x10DE, "NVIDIA L20-6A" },
    { 0x26BA, 0x191a, 0x10DE, "NVIDIA L20-8A" },
    { 0x26BA, 0x191b, 0x10DE, "NVIDIA L20-12A" },
    { 0x26BA, 0x191c, 0x10DE, "NVIDIA L20-16A" },
    { 0x26BA, 0x191d, 0x10DE, "NVIDIA L20-24A" },
    { 0x26BA, 0x191e, 0x10DE, "NVIDIA L20-48A" },
    { 0x26BA, 0x191f, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x26BA, 0x1920, 0x10DE, "NVIDIA GeForce RTX 3060" },
    { 0x26BA, 0x1921, 0x10DE, "NVIDIA L20-1" },
    { 0x26BA, 0x1922, 0x10DE, "NVIDIA L20-2" },
    { 0x26BA, 0x1923, 0x10DE, "NVIDIA L20-3" },
    { 0x26BA, 0x1924, 0x10DE, "NVIDIA L20-4" },
    { 0x26BA, 0x1925, 0x10DE, "NVIDIA L20-6" },
    { 0x26BA, 0x1926, 0x10DE, "NVIDIA L20-8" },
    { 0x26BA, 0x1927, 0x10DE, "NVIDIA L20-12" },
    { 0x26BA, 0x1928, 0x10DE, "NVIDIA L20-16" },
    { 0x26BA, 0x1929, 0x10DE, "NVIDIA L20-24" },
    { 0x26BA, 0x192a, 0x10DE, "NVIDIA L20-48" },
    { 0x26BA, 0x192b, 0x10DE, "NVIDIA L20-4C" },
    { 0x26BA, 0x192c, 0x10DE, "NVIDIA L20-6C" },
    { 0x26BA, 0x192d, 0x10DE, "NVIDIA L20-8C" },
    { 0x26BA, 0x192e, 0x10DE, "NVIDIA L20-12C" },
    { 0x26BA, 0x192f, 0x10DE, "NVIDIA L20-16C" },
    { 0x26BA, 0x1930, 0x10DE, "NVIDIA L20-24C" },
    { 0x26BA, 0x1931, 0x10DE, "NVIDIA L20-48C" },
    { 0x27B6, 0x1938, 0x10DE, "NVIDIA L2-1B" },
    { 0x27B6, 0x1939, 0x10DE, "NVIDIA L2-2B" },
    { 0x27B6, 0x193a, 0x10DE, "NVIDIA L2-1Q" },
    { 0x27B6, 0x193b, 0x10DE, "NVIDIA L2-2Q" },
    { 0x27B6, 0x193c, 0x10DE, "NVIDIA L2-3Q" },
    { 0x27B6, 0x193d, 0x10DE, "NVIDIA L2-4Q" },
    { 0x27B6, 0x193e, 0x10DE, "NVIDIA L2-6Q" },
    { 0x27B6, 0x193f, 0x10DE, "NVIDIA L2-8Q" },
    { 0x27B6, 0x1940, 0x10DE, "NVIDIA L2-12Q" },
    { 0x27B6, 0x1941, 0x10DE, "NVIDIA L2-24Q" },
    { 0x27B6, 0x1942, 0x10DE, "NVIDIA L2-1A" },
    { 0x27B6, 0x1943, 0x10DE, "NVIDIA L2-2A" },
    { 0x27B6, 0x1944, 0x10DE, "NVIDIA L2-3A" },
    { 0x27B6, 0x1945, 0x10DE, "NVIDIA L2-4A" },
    { 0x27B6, 0x1946, 0x10DE, "NVIDIA L2-6A" },
    { 0x27B6, 0x1947, 0x10DE, "NVIDIA L2-8A" },
    { 0x27B6, 0x1948, 0x10DE, "NVIDIA L2-12A" },
    { 0x27B6, 0x1949, 0x10DE, "NVIDIA L2-24A" },
    { 0x27B6, 0x194a, 0x10DE, "NVIDIA L2-1" },
    { 0x27B6, 0x194b, 0x10DE, "NVIDIA L2-2" },
    { 0x27B6, 0x194c, 0x10DE, "NVIDIA L2-3" },
    { 0x27B6, 0x194d, 0x10DE, "NVIDIA L2-4" },
    { 0x27B6, 0x194e, 0x10DE, "NVIDIA L2-6" },
    { 0x27B6, 0x194f, 0x10DE, "NVIDIA L2-8" },
    { 0x27B6, 0x1950, 0x10DE, "NVIDIA L2-12" },
    { 0x27B6, 0x1951, 0x10DE, "NVIDIA L2-24" },
    { 0x27B6, 0x1952, 0x10DE, "NVIDIA L2-4C" },
    { 0x27B6, 0x1953, 0x10DE, "NVIDIA L2-6C" },
    { 0x27B6, 0x1954, 0x10DE, "NVIDIA L2-8C" },
    { 0x27B6, 0x1955, 0x10DE, "NVIDIA L2-12C" },
    { 0x27B6, 0x1956, 0x10DE, "NVIDIA L2-24C" },
    { 0x27B8, 0x172f, 0x10DE, "NVIDIA L4-1B" },
    { 0x27B8, 0x1730, 0x10DE, "NVIDIA L4-2B" },
    { 0x27B8, 0x1731, 0x10DE, "NVIDIA L4-1Q" },
    { 0x27B8, 0x1732, 0x10DE, "NVIDIA L4-2Q" },
    { 0x27B8, 0x1733, 0x10DE, "NVIDIA L4-3Q" },
    { 0x27B8, 0x1734, 0x10DE, "NVIDIA L4-4Q" },
    { 0x27B8, 0x1735, 0x10DE, "NVIDIA L4-6Q" },
    { 0x27B8, 0x1736, 0x10DE, "NVIDIA L4-8Q" },
    { 0x27B8, 0x1737, 0x10DE, "NVIDIA L4-12Q" },
    { 0x27B8, 0x1738, 0x10DE, "NVIDIA L4-24Q" },
    { 0x27B8, 0x1739, 0x10DE, "NVIDIA L4-1A" },
    { 0x27B8, 0x173a, 0x10DE, "NVIDIA L4-2A" },
    { 0x27B8, 0x173b, 0x10DE, "NVIDIA L4-3A" },
    { 0x27B8, 0x173c, 0x10DE, "NVIDIA L4-4A" },
    { 0x27B8, 0x173d, 0x10DE, "NVIDIA L4-6A" },
    { 0x27B8, 0x173e, 0x10DE, "NVIDIA L4-8A" },
    { 0x27B8, 0x173f, 0x10DE, "NVIDIA L4-12A" },
    { 0x27B8, 0x1740, 0x10DE, "NVIDIA L4-24A" },
    { 0x27B8, 0x1741, 0x10DE, "NVIDIA L4-1" },
    { 0x27B8, 0x1742, 0x10DE, "NVIDIA L4-2" },
    { 0x27B8, 0x1743, 0x10DE, "NVIDIA L4-3" },
    { 0x27B8, 0x1744, 0x10DE, "NVIDIA L4-4" },
    { 0x27B8, 0x1745, 0x10DE, "NVIDIA L4-6" },
    { 0x27B8, 0x1746, 0x10DE, "NVIDIA L4-8" },
    { 0x27B8, 0x1747, 0x10DE, "NVIDIA L4-12" },
    { 0x27B8, 0x1748, 0x10DE, "NVIDIA L4-24" },
    { 0x27B8, 0x1749, 0x10DE, "NVIDIA L4-4C" },
    { 0x27B8, 0x174a, 0x10DE, "NVIDIA L4-6C" },
    { 0x27B8, 0x174b, 0x10DE, "NVIDIA L4-8C" },
    { 0x27B8, 0x174c, 0x10DE, "NVIDIA L4-12C" },
    { 0x27B8, 0x174d, 0x10DE, "NVIDIA L4-24C" },
    { 0x2941, 0x20cb, 0x10DE, "NVIDIA GB200-1-24CME" },
    { 0x2941, 0x20cc, 0x10DE, "NVIDIA GB200-1-24C" },
    { 0x2941, 0x20cd, 0x10DE, "NVIDIA GB200-1-47C" },
    { 0x2941, 0x20ce, 0x10DE, "NVIDIA GB200-2-47C" },
    { 0x2941, 0x20cf, 0x10DE, "NVIDIA GB200-3-95C" },
    { 0x2941, 0x20d0, 0x10DE, "NVIDIA GB200-4-95C" },
    { 0x2941, 0x20d1, 0x10DE, "NVIDIA GB200-7-189C" },
    { 0x2941, 0x20d2, 0x10DE, "NVIDIA GB200-189C" },
    { 0x2BB5, 0x21a6, 0x10DE, "NVIDIA GeForce RTX 3050" },
    { 0x2BB5, 0x21a7, 0x10DE, "NVIDIA GeForce RTX 3060" },
};

#endif // G_NV_NAME_RELEASED_H
