/*
 * Copyright (C) 2025 Apple Inc. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY APPLE INC. AND ITS CONTRIBUTORS ``AS IS''
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL APPLE INC. OR ITS CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */

#pragma once

#include <WebCore/WebTransportDatagramStats.h>

namespace WebCore {

struct WebTransportConnectionStats {

    uint64_t bytesSent { 0 };
    uint64_t packetsSent { 0 };
    uint64_t bytesLost { 0 };
    uint64_t packetsLost { 0 };
    uint64_t bytesReceived { 0 };
    uint64_t packetsReceived { 0 };
    double smoothedRtt { 0 };
    double rttVariation { 0 };
    double minRtt { 0 };
    WebTransportDatagramStats datagrams;
    std::optional<uint64_t> estimatedSendRate;
    bool atSendCapacity { false };

    WebTransportConnectionStats isolatedCopy() const
    {
        return {
            bytesSent,
            packetsSent,
            bytesLost,
            packetsLost,
            bytesReceived,
            packetsReceived,
            smoothedRtt,
            rttVariation,
            minRtt,
            datagrams.isolatedCopy(),
            estimatedSendRate,
            atSendCapacity
        };
    }
};

}
