/*
 * Copyright (c) 2002, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
/*
  @test
  @bug 4423838
  @summary KEY_TYPED and KEY_PRESSED generated by the same key are notified to
           different TextFields
  @key headful
  @run main QuickTypeTest
*/

import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Panel;
import java.awt.Point;
import java.awt.Robot;
import java.awt.TextArea;
import java.awt.EventQueue;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

import java.util.Properties;

import javax.swing.JFrame;
import javax.swing.JTextField;

public class QuickTypeTest {
    static final int TEST_TIMEOUT=10000;
    static JFrame frame1;
    static JFrame frame2;
    static JTextField tf1;
    static JTextField tf2;
    static SmartKeyAdapter ska;
    static Object keyMonitor;

    public static void main(String[] args) throws Exception {
        try {
            EventQueue.invokeAndWait(() -> {
                frame1 = new JFrame("First Frame");
                frame2 = new JFrame("Second Frame");
                tf1 = new JTextField("", 10);
                tf2 = new JTextField("", 10);
                frame1.getContentPane().add(tf1);
                frame2.getContentPane().add(tf2);
                frame1.setLocation(200,220);
                frame2.setLocation(220,300);
                frame1.pack();
                frame2.pack();
                keyMonitor = new Object();
                ska = new SmartKeyAdapter(frame2, keyMonitor);
                tf1.addKeyListener(ska);
                frame1.setVisible(true);
            });

            Robot robot = new Robot();
            robot.setAutoWaitForIdle(true);
            robot.setAutoDelay(100);
            robot.waitForIdle();
            robot.delay(1000);
            Object tf1Monitor = new Object();
            MonitoredFocusListener monitorer = new MonitoredFocusListener(tf1Monitor);
            tf1.addFocusListener(monitorer);
            Point origin = tf1.getLocationOnScreen();
            Dimension dim = tf1.getSize();
            robot.mouseMove((int)origin.getX() + (int)dim.getWidth()/2,
                            (int)origin.getY() + (int)dim.getHeight()/2);
            robot.mousePress(InputEvent.BUTTON1_DOWN_MASK);
            robot.mouseRelease(InputEvent.BUTTON1_DOWN_MASK);

            if (!tf1.isFocusOwner()) {
                synchronized (tf1Monitor) {
                    tf1Monitor.wait(TEST_TIMEOUT);
                }
            }
            if (!tf1.isFocusOwner()) {
                throw new RuntimeException("TEST FAILED. tf1 doesn't receive focus.");
            }

            robot.keyPress(KeyEvent.VK_A);
            robot.keyRelease(KeyEvent.VK_A);
            robot.keyPress(KeyEvent.VK_B);
            robot.keyRelease(KeyEvent.VK_B);
            if (!ska.isFrameShown) {
                synchronized (keyMonitor) {
                    keyMonitor.wait(TEST_TIMEOUT);
                }
            }
            if (!ska.isFrameShown) {
                throw new RuntimeException("TEST FAILED. Second frame is not shown.");
            }

            Object waitMonitor = new Object();
            ReleaseWaiter waiter = new ReleaseWaiter(waitMonitor, KeyEvent.VK_C);
            tf1.addKeyListener(waiter);
            tf2.addKeyListener(waiter);
            robot.keyPress(KeyEvent.VK_C);
            robot.keyRelease(KeyEvent.VK_C);

            synchronized (waitMonitor) {
                waitMonitor.wait(2000);
            }

            if ((tf1.getText().length() > 2) || (tf2.getText().length() < 1)) {
                System.out.println("tf1's text = \"" + tf1.getText() + "\"");
                System.out.println("tf2's text = \"" + tf2.getText() + "\"");
                System.out.println("l1 = " + tf1.getText().length());
                System.out.println("l2 = " + tf2.getText().length());
                throw new RuntimeException("TEST FAILED.");
            }
        } finally {
            EventQueue.invokeAndWait(() -> {
                if (frame1 != null) {
                    frame1.dispose();
                }
                if (frame2 != null) {
                    frame2.dispose();
                }
            });
        }
    }

 }// class QuickTypeTest

class ReleaseWaiter extends KeyAdapter {
    Object monitor;
    int keycode;
    public ReleaseWaiter(Object monitor, int keycode) {
        this.monitor = monitor;
        this.keycode = keycode;
    }

    public void keyReleased(KeyEvent ke) {
        System.out.println("keyReleased " + ke.getKeyCode());
        if (ke.getKeyCode() == keycode) {
            synchronized (monitor) {
                monitor.notify();
            }
        }
    }
}

class SmartKeyAdapter implements KeyListener {
    JFrame frame;
    int charCounter = 0;
    boolean isFrameShown = false;
    Object monitor;

    public SmartKeyAdapter(JFrame frame, Object monitor) {
        this.frame = frame;
        this.monitor = monitor;
    }

    public void keyReleased(KeyEvent ke) {
        System.out.println(ke.toString());
    }
    public void keyPressed(KeyEvent ke) {
        System.out.println(ke.toString());
        charCounter++;
        if (charCounter == 2) {
            frame.setVisible(true);
            isFrameShown = true;
            synchronized (monitor) {
                monitor.notify();
            }
        }
    }
    public void keyTyped(KeyEvent ke) {
        System.out.println(ke.toString());
    }
}

class MonitoredFocusListener extends FocusAdapter {
    Object monitor;

    public MonitoredFocusListener(Object monitor) {
        this.monitor = monitor;
    }

    public void focusLost(FocusEvent fe) {
        System.out.println(fe.toString());
    }
    public void focusGained(FocusEvent fe) {
        System.out.println(fe.toString());
        synchronized (monitor) {
            monitor.notify();
        }
    }
}
