# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.dnsresolver import DnsResolverManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDnsResolverManagementDnsForwardingRulesetsOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DnsResolverManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dns_forwarding_rulesets_get(self, resource_group):
        response = self.client.dns_forwarding_rulesets.get(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dns_forwarding_rulesets_begin_create_or_update(self, resource_group):
        response = self.client.dns_forwarding_rulesets.begin_create_or_update(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            parameters={
                "location": "str",
                "properties": {
                    "dnsResolverOutboundEndpoints": [{"id": "str"}],
                    "provisioningState": "str",
                    "resourceGuid": "str",
                },
                "etag": "str",
                "id": "str",
                "name": "str",
                "systemData": {
                    "createdAt": "2020-02-20 00:00:00",
                    "createdBy": "str",
                    "createdByType": "str",
                    "lastModifiedAt": "2020-02-20 00:00:00",
                    "lastModifiedBy": "str",
                    "lastModifiedByType": "str",
                },
                "tags": {"str": "str"},
                "type": "str",
            },
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dns_forwarding_rulesets_begin_update(self, resource_group):
        response = self.client.dns_forwarding_rulesets.begin_update(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
            parameters={"dnsResolverOutboundEndpoints": [{"id": "str"}], "tags": {"str": "str"}},
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dns_forwarding_rulesets_begin_delete(self, resource_group):
        response = self.client.dns_forwarding_rulesets.begin_delete(
            resource_group_name=resource_group.name,
            dns_forwarding_ruleset_name="str",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dns_forwarding_rulesets_list_by_resource_group(self, resource_group):
        response = self.client.dns_forwarding_rulesets.list_by_resource_group(
            resource_group_name=resource_group.name,
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dns_forwarding_rulesets_list(self, resource_group):
        response = self.client.dns_forwarding_rulesets.list()
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_dns_forwarding_rulesets_list_by_virtual_network(self, resource_group):
        response = self.client.dns_forwarding_rulesets.list_by_virtual_network(
            resource_group_name=resource_group.name,
            virtual_network_name="str",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
