# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.dashboard import DashboardManagementClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-dashboard
# USAGE
    python managed_private_endpoints_create.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = DashboardManagementClient(
        credential=DefaultAzureCredential(),
        subscription_id="SUBSCRIPTION_ID",
    )

    response = client.managed_private_endpoints.begin_create(
        resource_group_name="myResourceGroup",
        workspace_name="myWorkspace",
        managed_private_endpoint_name="myMPEName",
        request_body_parameters={
            "location": "West US",
            "properties": {
                "groupIds": ["grafana"],
                "privateLinkResourceId": "/subscriptions/xxxxxxxx-xxxx-xxxx-xxxx-000000000000/resourceGroups/xx-rg/providers/Microsoft.Kusto/Clusters/sampleKustoResource",
                "privateLinkResourceRegion": "West US",
                "privateLinkServiceUrl": "my-self-hosted-influxdb.westus.mydomain.com",
                "requestMessage": "Example Request Message",
            },
        },
    ).result()
    print(response)


# x-ms-original-file: 2025-08-01/ManagedPrivateEndpoints_Create.json
if __name__ == "__main__":
    main()
