/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#if !defined(FIT_RECORD_MESG_HPP)
#define FIT_RECORD_MESG_HPP

#include "fit_mesg.hpp"

namespace fit
{

class RecordMesg : public Mesg
{
public:
    class FieldDefNum final
    {
    public:
       static const FIT_UINT8 Timestamp = 253;
       static const FIT_UINT8 PositionLat = 0;
       static const FIT_UINT8 PositionLong = 1;
       static const FIT_UINT8 Altitude = 2;
       static const FIT_UINT8 HeartRate = 3;
       static const FIT_UINT8 Cadence = 4;
       static const FIT_UINT8 Distance = 5;
       static const FIT_UINT8 Speed = 6;
       static const FIT_UINT8 Power = 7;
       static const FIT_UINT8 CompressedSpeedDistance = 8;
       static const FIT_UINT8 Grade = 9;
       static const FIT_UINT8 Resistance = 10;
       static const FIT_UINT8 TimeFromCourse = 11;
       static const FIT_UINT8 CycleLength = 12;
       static const FIT_UINT8 Temperature = 13;
       static const FIT_UINT8 Speed1s = 17;
       static const FIT_UINT8 Cycles = 18;
       static const FIT_UINT8 TotalCycles = 19;
       static const FIT_UINT8 CompressedAccumulatedPower = 28;
       static const FIT_UINT8 AccumulatedPower = 29;
       static const FIT_UINT8 LeftRightBalance = 30;
       static const FIT_UINT8 GpsAccuracy = 31;
       static const FIT_UINT8 VerticalSpeed = 32;
       static const FIT_UINT8 Calories = 33;
       static const FIT_UINT8 VerticalOscillation = 39;
       static const FIT_UINT8 StanceTimePercent = 40;
       static const FIT_UINT8 StanceTime = 41;
       static const FIT_UINT8 ActivityType = 42;
       static const FIT_UINT8 LeftTorqueEffectiveness = 43;
       static const FIT_UINT8 RightTorqueEffectiveness = 44;
       static const FIT_UINT8 LeftPedalSmoothness = 45;
       static const FIT_UINT8 RightPedalSmoothness = 46;
       static const FIT_UINT8 CombinedPedalSmoothness = 47;
       static const FIT_UINT8 Time128 = 48;
       static const FIT_UINT8 StrokeType = 49;
       static const FIT_UINT8 Zone = 50;
       static const FIT_UINT8 BallSpeed = 51;
       static const FIT_UINT8 Cadence256 = 52;
       static const FIT_UINT8 FractionalCadence = 53;
       static const FIT_UINT8 TotalHemoglobinConc = 54;
       static const FIT_UINT8 TotalHemoglobinConcMin = 55;
       static const FIT_UINT8 TotalHemoglobinConcMax = 56;
       static const FIT_UINT8 SaturatedHemoglobinPercent = 57;
       static const FIT_UINT8 SaturatedHemoglobinPercentMin = 58;
       static const FIT_UINT8 SaturatedHemoglobinPercentMax = 59;
       static const FIT_UINT8 DeviceIndex = 62;
       static const FIT_UINT8 LeftPco = 67;
       static const FIT_UINT8 RightPco = 68;
       static const FIT_UINT8 LeftPowerPhase = 69;
       static const FIT_UINT8 LeftPowerPhasePeak = 70;
       static const FIT_UINT8 RightPowerPhase = 71;
       static const FIT_UINT8 RightPowerPhasePeak = 72;
       static const FIT_UINT8 EnhancedSpeed = 73;
       static const FIT_UINT8 EnhancedAltitude = 78;
       static const FIT_UINT8 BatterySoc = 81;
       static const FIT_UINT8 MotorPower = 82;
       static const FIT_UINT8 VerticalRatio = 83;
       static const FIT_UINT8 StanceTimeBalance = 84;
       static const FIT_UINT8 StepLength = 85;
       static const FIT_UINT8 CycleLength16 = 87;
       static const FIT_UINT8 AbsolutePressure = 91;
       static const FIT_UINT8 Depth = 92;
       static const FIT_UINT8 NextStopDepth = 93;
       static const FIT_UINT8 NextStopTime = 94;
       static const FIT_UINT8 TimeToSurface = 95;
       static const FIT_UINT8 NdlTime = 96;
       static const FIT_UINT8 CnsLoad = 97;
       static const FIT_UINT8 N2Load = 98;
       static const FIT_UINT8 RespirationRate = 99;
       static const FIT_UINT8 EnhancedRespirationRate = 108;
       static const FIT_UINT8 Grit = 114;
       static const FIT_UINT8 Flow = 115;
       static const FIT_UINT8 CurrentStress = 116;
       static const FIT_UINT8 EbikeTravelRange = 117;
       static const FIT_UINT8 EbikeBatteryLevel = 118;
       static const FIT_UINT8 EbikeAssistMode = 119;
       static const FIT_UINT8 EbikeAssistLevelPercent = 120;
       static const FIT_UINT8 AirTimeRemaining = 123;
       static const FIT_UINT8 PressureSac = 124;
       static const FIT_UINT8 VolumeSac = 125;
       static const FIT_UINT8 Rmv = 126;
       static const FIT_UINT8 AscentRate = 127;
       static const FIT_UINT8 Po2 = 129;
       static const FIT_UINT8 CoreTemperature = 139;
       static const FIT_UINT8 Invalid = FIT_FIELD_NUM_INVALID;
    };

    RecordMesg(void) : Mesg(Profile::MESG_RECORD)
    {
    }

    RecordMesg(const Mesg &mesg) : Mesg(mesg)
    {
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of timestamp field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimestampValid() const
    {
        const Field* field = GetField(253);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns timestamp field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_DATE_TIME GetTimestamp(void) const
    {
        return GetFieldUINT32Value(253, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set timestamp field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimestamp(FIT_DATE_TIME timestamp)
    {
        SetFieldUINT32Value(253, timestamp, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of position_lat field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPositionLatValid() const
    {
        const Field* field = GetField(0);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetPositionLat(void) const
    {
        return GetFieldSINT32Value(0, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set position_lat field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetPositionLat(FIT_SINT32 positionLat)
    {
        SetFieldSINT32Value(0, positionLat, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of position_long field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPositionLongValid() const
    {
        const Field* field = GetField(1);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT32 GetPositionLong(void) const
    {
        return GetFieldSINT32Value(1, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set position_long field
    // Units: semicircles
    ///////////////////////////////////////////////////////////////////////
    void SetPositionLong(FIT_SINT32 positionLong)
    {
        SetFieldSINT32Value(1, positionLong, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAltitudeValid() const
    {
        const Field* field = GetField(2);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAltitude(void) const
    {
        return GetFieldFLOAT32Value(2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetAltitude(FIT_FLOAT32 altitude)
    {
        SetFieldFLOAT32Value(2, altitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of heart_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsHeartRateValid() const
    {
        const Field* field = GetField(3);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetHeartRate(void) const
    {
        return GetFieldUINT8Value(3, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set heart_rate field
    // Units: bpm
    ///////////////////////////////////////////////////////////////////////
    void SetHeartRate(FIT_UINT8 heartRate)
    {
        SetFieldUINT8Value(3, heartRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCadenceValid() const
    {
        const Field* field = GetField(4);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetCadence(void) const
    {
        return GetFieldUINT8Value(4, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetCadence(FIT_UINT8 cadence)
    {
        SetFieldUINT8Value(4, cadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDistanceValid() const
    {
        const Field* field = GetField(5);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetDistance(void) const
    {
        return GetFieldFLOAT32Value(5, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set distance field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetDistance(FIT_FLOAT32 distance)
    {
        SetFieldFLOAT32Value(5, distance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSpeedValid() const
    {
        const Field* field = GetField(6);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSpeed(void) const
    {
        return GetFieldFLOAT32Value(6, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetSpeed(FIT_FLOAT32 speed)
    {
        SetFieldFLOAT32Value(6, speed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPowerValid() const
    {
        const Field* field = GetField(7);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetPower(void) const
    {
        return GetFieldUINT16Value(7, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetPower(FIT_UINT16 power)
    {
        SetFieldUINT16Value(7, power, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of compressed_speed_distance
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumCompressedSpeedDistance(void) const
    {
        return GetFieldNumValues(8, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of compressed_speed_distance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCompressedSpeedDistanceValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(8);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns compressed_speed_distance field
    ///////////////////////////////////////////////////////////////////////
    FIT_BYTE GetCompressedSpeedDistance(FIT_UINT8 index) const
    {
        return GetFieldBYTEValue(8, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set compressed_speed_distance field
    ///////////////////////////////////////////////////////////////////////
    void SetCompressedSpeedDistance(FIT_UINT8 index, FIT_BYTE compressedSpeedDistance)
    {
        SetFieldBYTEValue(8, compressedSpeedDistance, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of grade field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGradeValid() const
    {
        const Field* field = GetField(9);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetGrade(void) const
    {
        return GetFieldFLOAT32Value(9, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set grade field
    // Units: %
    ///////////////////////////////////////////////////////////////////////
    void SetGrade(FIT_FLOAT32 grade)
    {
        SetFieldFLOAT32Value(9, grade, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of resistance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsResistanceValid() const
    {
        const Field* field = GetField(10);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns resistance field
    // Comment: Relative. 0 is none 254 is Max.
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetResistance(void) const
    {
        return GetFieldUINT8Value(10, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set resistance field
    // Comment: Relative. 0 is none 254 is Max.
    ///////////////////////////////////////////////////////////////////////
    void SetResistance(FIT_UINT8 resistance)
    {
        SetFieldUINT8Value(10, resistance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_from_course field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeFromCourseValid() const
    {
        const Field* field = GetField(11);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_from_course field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTimeFromCourse(void) const
    {
        return GetFieldFLOAT32Value(11, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_from_course field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeFromCourse(FIT_FLOAT32 timeFromCourse)
    {
        SetFieldFLOAT32Value(11, timeFromCourse, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of cycle_length field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCycleLengthValid() const
    {
        const Field* field = GetField(12);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns cycle_length field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCycleLength(void) const
    {
        return GetFieldFLOAT32Value(12, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set cycle_length field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetCycleLength(FIT_FLOAT32 cycleLength)
    {
        SetFieldFLOAT32Value(12, cycleLength, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTemperatureValid() const
    {
        const Field* field = GetField(13);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetTemperature(void) const
    {
        return GetFieldSINT8Value(13, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetTemperature(FIT_SINT8 temperature)
    {
        SetFieldSINT8Value(13, temperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of speed_1s
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumSpeed1s(void) const
    {
        return GetFieldNumValues(17, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of speed_1s field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSpeed1sValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(17);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns speed_1s field
    // Units: m/s
    // Comment: Speed at 1s intervals. Timestamp field indicates time of last array element.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSpeed1s(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(17, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set speed_1s field
    // Units: m/s
    // Comment: Speed at 1s intervals. Timestamp field indicates time of last array element.
    ///////////////////////////////////////////////////////////////////////
    void SetSpeed1s(FIT_UINT8 index, FIT_FLOAT32 speed1s)
    {
        SetFieldFLOAT32Value(17, speed1s, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of cycles field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCyclesValid() const
    {
        const Field* field = GetField(18);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetCycles(void) const
    {
        return GetFieldUINT8Value(18, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    void SetCycles(FIT_UINT8 cycles)
    {
        SetFieldUINT8Value(18, cycles, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_cycles field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalCyclesValid() const
    {
        const Field* field = GetField(19);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTotalCycles(void) const
    {
        return GetFieldUINT32Value(19, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_cycles field
    // Units: cycles
    ///////////////////////////////////////////////////////////////////////
    void SetTotalCycles(FIT_UINT32 totalCycles)
    {
        SetFieldUINT32Value(19, totalCycles, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of compressed_accumulated_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCompressedAccumulatedPowerValid() const
    {
        const Field* field = GetField(28);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns compressed_accumulated_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetCompressedAccumulatedPower(void) const
    {
        return GetFieldUINT16Value(28, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set compressed_accumulated_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetCompressedAccumulatedPower(FIT_UINT16 compressedAccumulatedPower)
    {
        SetFieldUINT16Value(28, compressedAccumulatedPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of accumulated_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAccumulatedPowerValid() const
    {
        const Field* field = GetField(29);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns accumulated_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetAccumulatedPower(void) const
    {
        return GetFieldUINT32Value(29, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set accumulated_power field
    // Units: watts
    ///////////////////////////////////////////////////////////////////////
    void SetAccumulatedPower(FIT_UINT32 accumulatedPower)
    {
        SetFieldUINT32Value(29, accumulatedPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of left_right_balance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLeftRightBalanceValid() const
    {
        const Field* field = GetField(30);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns left_right_balance field
    ///////////////////////////////////////////////////////////////////////
    FIT_LEFT_RIGHT_BALANCE GetLeftRightBalance(void) const
    {
        return GetFieldUINT8Value(30, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set left_right_balance field
    ///////////////////////////////////////////////////////////////////////
    void SetLeftRightBalance(FIT_LEFT_RIGHT_BALANCE leftRightBalance)
    {
        SetFieldUINT8Value(30, leftRightBalance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of gps_accuracy field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGpsAccuracyValid() const
    {
        const Field* field = GetField(31);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns gps_accuracy field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetGpsAccuracy(void) const
    {
        return GetFieldUINT8Value(31, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set gps_accuracy field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetGpsAccuracy(FIT_UINT8 gpsAccuracy)
    {
        SetFieldUINT8Value(31, gpsAccuracy, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of vertical_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsVerticalSpeedValid() const
    {
        const Field* field = GetField(32);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetVerticalSpeed(void) const
    {
        return GetFieldFLOAT32Value(32, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set vertical_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetVerticalSpeed(FIT_FLOAT32 verticalSpeed)
    {
        SetFieldFLOAT32Value(32, verticalSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of calories field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCaloriesValid() const
    {
        const Field* field = GetField(33);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetCalories(void) const
    {
        return GetFieldUINT16Value(33, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set calories field
    // Units: kcal
    ///////////////////////////////////////////////////////////////////////
    void SetCalories(FIT_UINT16 calories)
    {
        SetFieldUINT16Value(33, calories, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of vertical_oscillation field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsVerticalOscillationValid() const
    {
        const Field* field = GetField(39);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns vertical_oscillation field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetVerticalOscillation(void) const
    {
        return GetFieldFLOAT32Value(39, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set vertical_oscillation field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    void SetVerticalOscillation(FIT_FLOAT32 verticalOscillation)
    {
        SetFieldFLOAT32Value(39, verticalOscillation, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of stance_time_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStanceTimePercentValid() const
    {
        const Field* field = GetField(40);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns stance_time_percent field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetStanceTimePercent(void) const
    {
        return GetFieldFLOAT32Value(40, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set stance_time_percent field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetStanceTimePercent(FIT_FLOAT32 stanceTimePercent)
    {
        SetFieldFLOAT32Value(40, stanceTimePercent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of stance_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStanceTimeValid() const
    {
        const Field* field = GetField(41);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns stance_time field
    // Units: ms
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetStanceTime(void) const
    {
        return GetFieldFLOAT32Value(41, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set stance_time field
    // Units: ms
    ///////////////////////////////////////////////////////////////////////
    void SetStanceTime(FIT_FLOAT32 stanceTime)
    {
        SetFieldFLOAT32Value(41, stanceTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of activity_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsActivityTypeValid() const
    {
        const Field* field = GetField(42);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns activity_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_ACTIVITY_TYPE GetActivityType(void) const
    {
        return GetFieldENUMValue(42, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set activity_type field
    ///////////////////////////////////////////////////////////////////////
    void SetActivityType(FIT_ACTIVITY_TYPE activityType)
    {
        SetFieldENUMValue(42, activityType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of left_torque_effectiveness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLeftTorqueEffectivenessValid() const
    {
        const Field* field = GetField(43);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns left_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetLeftTorqueEffectiveness(void) const
    {
        return GetFieldFLOAT32Value(43, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set left_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetLeftTorqueEffectiveness(FIT_FLOAT32 leftTorqueEffectiveness)
    {
        SetFieldFLOAT32Value(43, leftTorqueEffectiveness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of right_torque_effectiveness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRightTorqueEffectivenessValid() const
    {
        const Field* field = GetField(44);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns right_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetRightTorqueEffectiveness(void) const
    {
        return GetFieldFLOAT32Value(44, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set right_torque_effectiveness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetRightTorqueEffectiveness(FIT_FLOAT32 rightTorqueEffectiveness)
    {
        SetFieldFLOAT32Value(44, rightTorqueEffectiveness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of left_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLeftPedalSmoothnessValid() const
    {
        const Field* field = GetField(45);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns left_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetLeftPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(45, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set left_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetLeftPedalSmoothness(FIT_FLOAT32 leftPedalSmoothness)
    {
        SetFieldFLOAT32Value(45, leftPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of right_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRightPedalSmoothnessValid() const
    {
        const Field* field = GetField(46);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns right_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetRightPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(46, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set right_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetRightPedalSmoothness(FIT_FLOAT32 rightPedalSmoothness)
    {
        SetFieldFLOAT32Value(46, rightPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of combined_pedal_smoothness field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCombinedPedalSmoothnessValid() const
    {
        const Field* field = GetField(47);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns combined_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCombinedPedalSmoothness(void) const
    {
        return GetFieldFLOAT32Value(47, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set combined_pedal_smoothness field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetCombinedPedalSmoothness(FIT_FLOAT32 combinedPedalSmoothness)
    {
        SetFieldFLOAT32Value(47, combinedPedalSmoothness, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time128 field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTime128Valid() const
    {
        const Field* field = GetField(48);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time128 field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTime128(void) const
    {
        return GetFieldFLOAT32Value(48, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time128 field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTime128(FIT_FLOAT32 time128)
    {
        SetFieldFLOAT32Value(48, time128, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of stroke_type field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStrokeTypeValid() const
    {
        const Field* field = GetField(49);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns stroke_type field
    ///////////////////////////////////////////////////////////////////////
    FIT_STROKE_TYPE GetStrokeType(void) const
    {
        return GetFieldENUMValue(49, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set stroke_type field
    ///////////////////////////////////////////////////////////////////////
    void SetStrokeType(FIT_STROKE_TYPE strokeType)
    {
        SetFieldENUMValue(49, strokeType, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of zone field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsZoneValid() const
    {
        const Field* field = GetField(50);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns zone field
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetZone(void) const
    {
        return GetFieldUINT8Value(50, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set zone field
    ///////////////////////////////////////////////////////////////////////
    void SetZone(FIT_UINT8 zone)
    {
        SetFieldUINT8Value(50, zone, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ball_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBallSpeedValid() const
    {
        const Field* field = GetField(51);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ball_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetBallSpeed(void) const
    {
        return GetFieldFLOAT32Value(51, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ball_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetBallSpeed(FIT_FLOAT32 ballSpeed)
    {
        SetFieldFLOAT32Value(51, ballSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of cadence256 field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCadence256Valid() const
    {
        const Field* field = GetField(52);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns cadence256 field
    // Units: rpm
    // Comment: Log cadence and fractional cadence for backwards compatability
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCadence256(void) const
    {
        return GetFieldFLOAT32Value(52, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set cadence256 field
    // Units: rpm
    // Comment: Log cadence and fractional cadence for backwards compatability
    ///////////////////////////////////////////////////////////////////////
    void SetCadence256(FIT_FLOAT32 cadence256)
    {
        SetFieldFLOAT32Value(52, cadence256, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of fractional_cadence field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsFractionalCadenceValid() const
    {
        const Field* field = GetField(53);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns fractional_cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetFractionalCadence(void) const
    {
        return GetFieldFLOAT32Value(53, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set fractional_cadence field
    // Units: rpm
    ///////////////////////////////////////////////////////////////////////
    void SetFractionalCadence(FIT_FLOAT32 fractionalCadence)
    {
        SetFieldFLOAT32Value(53, fractionalCadence, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_hemoglobin_conc field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalHemoglobinConcValid() const
    {
        const Field* field = GetField(54);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Total saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalHemoglobinConc(void) const
    {
        return GetFieldFLOAT32Value(54, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_hemoglobin_conc field
    // Units: g/dL
    // Comment: Total saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    void SetTotalHemoglobinConc(FIT_FLOAT32 totalHemoglobinConc)
    {
        SetFieldFLOAT32Value(54, totalHemoglobinConc, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_hemoglobin_conc_min field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalHemoglobinConcMinValid() const
    {
        const Field* field = GetField(55);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_hemoglobin_conc_min field
    // Units: g/dL
    // Comment: Min saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalHemoglobinConcMin(void) const
    {
        return GetFieldFLOAT32Value(55, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_hemoglobin_conc_min field
    // Units: g/dL
    // Comment: Min saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    void SetTotalHemoglobinConcMin(FIT_FLOAT32 totalHemoglobinConcMin)
    {
        SetFieldFLOAT32Value(55, totalHemoglobinConcMin, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of total_hemoglobin_conc_max field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTotalHemoglobinConcMaxValid() const
    {
        const Field* field = GetField(56);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns total_hemoglobin_conc_max field
    // Units: g/dL
    // Comment: Max saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetTotalHemoglobinConcMax(void) const
    {
        return GetFieldFLOAT32Value(56, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set total_hemoglobin_conc_max field
    // Units: g/dL
    // Comment: Max saturated and unsaturated hemoglobin
    ///////////////////////////////////////////////////////////////////////
    void SetTotalHemoglobinConcMax(FIT_FLOAT32 totalHemoglobinConcMax)
    {
        SetFieldFLOAT32Value(56, totalHemoglobinConcMax, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of saturated_hemoglobin_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSaturatedHemoglobinPercentValid() const
    {
        const Field* field = GetField(57);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns saturated_hemoglobin_percent field
    // Units: %
    // Comment: Percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSaturatedHemoglobinPercent(void) const
    {
        return GetFieldFLOAT32Value(57, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set saturated_hemoglobin_percent field
    // Units: %
    // Comment: Percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetSaturatedHemoglobinPercent(FIT_FLOAT32 saturatedHemoglobinPercent)
    {
        SetFieldFLOAT32Value(57, saturatedHemoglobinPercent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of saturated_hemoglobin_percent_min field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSaturatedHemoglobinPercentMinValid() const
    {
        const Field* field = GetField(58);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns saturated_hemoglobin_percent_min field
    // Units: %
    // Comment: Min percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSaturatedHemoglobinPercentMin(void) const
    {
        return GetFieldFLOAT32Value(58, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set saturated_hemoglobin_percent_min field
    // Units: %
    // Comment: Min percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetSaturatedHemoglobinPercentMin(FIT_FLOAT32 saturatedHemoglobinPercentMin)
    {
        SetFieldFLOAT32Value(58, saturatedHemoglobinPercentMin, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of saturated_hemoglobin_percent_max field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsSaturatedHemoglobinPercentMaxValid() const
    {
        const Field* field = GetField(59);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns saturated_hemoglobin_percent_max field
    // Units: %
    // Comment: Max percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetSaturatedHemoglobinPercentMax(void) const
    {
        return GetFieldFLOAT32Value(59, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set saturated_hemoglobin_percent_max field
    // Units: %
    // Comment: Max percentage of hemoglobin saturated with oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetSaturatedHemoglobinPercentMax(FIT_FLOAT32 saturatedHemoglobinPercentMax)
    {
        SetFieldFLOAT32Value(59, saturatedHemoglobinPercentMax, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of device_index field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDeviceIndexValid() const
    {
        const Field* field = GetField(62);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns device_index field
    ///////////////////////////////////////////////////////////////////////
    FIT_DEVICE_INDEX GetDeviceIndex(void) const
    {
        return GetFieldUINT8Value(62, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set device_index field
    ///////////////////////////////////////////////////////////////////////
    void SetDeviceIndex(FIT_DEVICE_INDEX deviceIndex)
    {
        SetFieldUINT8Value(62, deviceIndex, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of left_pco field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLeftPcoValid() const
    {
        const Field* field = GetField(67);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns left_pco field
    // Units: mm
    // Comment: Left platform center offset
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetLeftPco(void) const
    {
        return GetFieldSINT8Value(67, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set left_pco field
    // Units: mm
    // Comment: Left platform center offset
    ///////////////////////////////////////////////////////////////////////
    void SetLeftPco(FIT_SINT8 leftPco)
    {
        SetFieldSINT8Value(67, leftPco, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of right_pco field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRightPcoValid() const
    {
        const Field* field = GetField(68);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns right_pco field
    // Units: mm
    // Comment: Right platform center offset
    ///////////////////////////////////////////////////////////////////////
    FIT_SINT8 GetRightPco(void) const
    {
        return GetFieldSINT8Value(68, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set right_pco field
    // Units: mm
    // Comment: Right platform center offset
    ///////////////////////////////////////////////////////////////////////
    void SetRightPco(FIT_SINT8 rightPco)
    {
        SetFieldSINT8Value(68, rightPco, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of left_power_phase
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumLeftPowerPhase(void) const
    {
        return GetFieldNumValues(69, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of left_power_phase field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLeftPowerPhaseValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(69);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns left_power_phase field
    // Units: degrees
    // Comment: Left power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetLeftPowerPhase(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(69, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set left_power_phase field
    // Units: degrees
    // Comment: Left power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetLeftPowerPhase(FIT_UINT8 index, FIT_FLOAT32 leftPowerPhase)
    {
        SetFieldFLOAT32Value(69, leftPowerPhase, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of left_power_phase_peak
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumLeftPowerPhasePeak(void) const
    {
        return GetFieldNumValues(70, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of left_power_phase_peak field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsLeftPowerPhasePeakValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(70);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns left_power_phase_peak field
    // Units: degrees
    // Comment: Left power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetLeftPowerPhasePeak(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(70, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set left_power_phase_peak field
    // Units: degrees
    // Comment: Left power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetLeftPowerPhasePeak(FIT_UINT8 index, FIT_FLOAT32 leftPowerPhasePeak)
    {
        SetFieldFLOAT32Value(70, leftPowerPhasePeak, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of right_power_phase
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumRightPowerPhase(void) const
    {
        return GetFieldNumValues(71, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of right_power_phase field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRightPowerPhaseValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(71);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns right_power_phase field
    // Units: degrees
    // Comment: Right power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetRightPowerPhase(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(71, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set right_power_phase field
    // Units: degrees
    // Comment: Right power phase angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetRightPowerPhase(FIT_UINT8 index, FIT_FLOAT32 rightPowerPhase)
    {
        SetFieldFLOAT32Value(71, rightPowerPhase, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns number of right_power_phase_peak
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetNumRightPowerPhasePeak(void) const
    {
        return GetFieldNumValues(72, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of right_power_phase_peak field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRightPowerPhasePeakValid(FIT_UINT8 index) const
    {
        const Field* field = GetField(72);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid(index);
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns right_power_phase_peak field
    // Units: degrees
    // Comment: Right power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetRightPowerPhasePeak(FIT_UINT8 index) const
    {
        return GetFieldFLOAT32Value(72, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set right_power_phase_peak field
    // Units: degrees
    // Comment: Right power phase peak angles. Data value indexes defined by power_phase_type.
    ///////////////////////////////////////////////////////////////////////
    void SetRightPowerPhasePeak(FIT_UINT8 index, FIT_FLOAT32 rightPowerPhasePeak)
    {
        SetFieldFLOAT32Value(72, rightPowerPhasePeak, index, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_speed field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedSpeedValid() const
    {
        const Field* field = GetField(73);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedSpeed(void) const
    {
        return GetFieldFLOAT32Value(73, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_speed field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedSpeed(FIT_FLOAT32 enhancedSpeed)
    {
        SetFieldFLOAT32Value(73, enhancedSpeed, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_altitude field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedAltitudeValid() const
    {
        const Field* field = GetField(78);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedAltitude(void) const
    {
        return GetFieldFLOAT32Value(78, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_altitude field
    // Units: m
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedAltitude(FIT_FLOAT32 enhancedAltitude)
    {
        SetFieldFLOAT32Value(78, enhancedAltitude, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of battery_soc field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsBatterySocValid() const
    {
        const Field* field = GetField(81);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns battery_soc field
    // Units: percent
    // Comment: lev battery state of charge
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetBatterySoc(void) const
    {
        return GetFieldFLOAT32Value(81, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set battery_soc field
    // Units: percent
    // Comment: lev battery state of charge
    ///////////////////////////////////////////////////////////////////////
    void SetBatterySoc(FIT_FLOAT32 batterySoc)
    {
        SetFieldFLOAT32Value(81, batterySoc, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of motor_power field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsMotorPowerValid() const
    {
        const Field* field = GetField(82);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns motor_power field
    // Units: watts
    // Comment: lev motor power
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetMotorPower(void) const
    {
        return GetFieldUINT16Value(82, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set motor_power field
    // Units: watts
    // Comment: lev motor power
    ///////////////////////////////////////////////////////////////////////
    void SetMotorPower(FIT_UINT16 motorPower)
    {
        SetFieldUINT16Value(82, motorPower, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of vertical_ratio field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsVerticalRatioValid() const
    {
        const Field* field = GetField(83);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns vertical_ratio field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetVerticalRatio(void) const
    {
        return GetFieldFLOAT32Value(83, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set vertical_ratio field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetVerticalRatio(FIT_FLOAT32 verticalRatio)
    {
        SetFieldFLOAT32Value(83, verticalRatio, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of stance_time_balance field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStanceTimeBalanceValid() const
    {
        const Field* field = GetField(84);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns stance_time_balance field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetStanceTimeBalance(void) const
    {
        return GetFieldFLOAT32Value(84, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set stance_time_balance field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetStanceTimeBalance(FIT_FLOAT32 stanceTimeBalance)
    {
        SetFieldFLOAT32Value(84, stanceTimeBalance, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of step_length field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsStepLengthValid() const
    {
        const Field* field = GetField(85);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns step_length field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetStepLength(void) const
    {
        return GetFieldFLOAT32Value(85, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set step_length field
    // Units: mm
    ///////////////////////////////////////////////////////////////////////
    void SetStepLength(FIT_FLOAT32 stepLength)
    {
        SetFieldFLOAT32Value(85, stepLength, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of cycle_length16 field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCycleLength16Valid() const
    {
        const Field* field = GetField(87);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns cycle_length16 field
    // Units: m
    // Comment: Supports larger cycle sizes needed for paddlesports. Max cycle size: 655.35
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCycleLength16(void) const
    {
        return GetFieldFLOAT32Value(87, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set cycle_length16 field
    // Units: m
    // Comment: Supports larger cycle sizes needed for paddlesports. Max cycle size: 655.35
    ///////////////////////////////////////////////////////////////////////
    void SetCycleLength16(FIT_FLOAT32 cycleLength16)
    {
        SetFieldFLOAT32Value(87, cycleLength16, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of absolute_pressure field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAbsolutePressureValid() const
    {
        const Field* field = GetField(91);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns absolute_pressure field
    // Units: Pa
    // Comment: Includes atmospheric pressure
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetAbsolutePressure(void) const
    {
        return GetFieldUINT32Value(91, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set absolute_pressure field
    // Units: Pa
    // Comment: Includes atmospheric pressure
    ///////////////////////////////////////////////////////////////////////
    void SetAbsolutePressure(FIT_UINT32 absolutePressure)
    {
        SetFieldUINT32Value(91, absolutePressure, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of depth field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsDepthValid() const
    {
        const Field* field = GetField(92);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns depth field
    // Units: m
    // Comment: 0 if above water
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetDepth(void) const
    {
        return GetFieldFLOAT32Value(92, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set depth field
    // Units: m
    // Comment: 0 if above water
    ///////////////////////////////////////////////////////////////////////
    void SetDepth(FIT_FLOAT32 depth)
    {
        SetFieldFLOAT32Value(92, depth, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of next_stop_depth field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNextStopDepthValid() const
    {
        const Field* field = GetField(93);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns next_stop_depth field
    // Units: m
    // Comment: 0 if above water
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetNextStopDepth(void) const
    {
        return GetFieldFLOAT32Value(93, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set next_stop_depth field
    // Units: m
    // Comment: 0 if above water
    ///////////////////////////////////////////////////////////////////////
    void SetNextStopDepth(FIT_FLOAT32 nextStopDepth)
    {
        SetFieldFLOAT32Value(93, nextStopDepth, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of next_stop_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNextStopTimeValid() const
    {
        const Field* field = GetField(94);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns next_stop_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetNextStopTime(void) const
    {
        return GetFieldUINT32Value(94, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set next_stop_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetNextStopTime(FIT_UINT32 nextStopTime)
    {
        SetFieldUINT32Value(94, nextStopTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of time_to_surface field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsTimeToSurfaceValid() const
    {
        const Field* field = GetField(95);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns time_to_surface field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetTimeToSurface(void) const
    {
        return GetFieldUINT32Value(95, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set time_to_surface field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetTimeToSurface(FIT_UINT32 timeToSurface)
    {
        SetFieldUINT32Value(95, timeToSurface, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ndl_time field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsNdlTimeValid() const
    {
        const Field* field = GetField(96);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ndl_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetNdlTime(void) const
    {
        return GetFieldUINT32Value(96, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ndl_time field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetNdlTime(FIT_UINT32 ndlTime)
    {
        SetFieldUINT32Value(96, ndlTime, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of cns_load field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCnsLoadValid() const
    {
        const Field* field = GetField(97);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns cns_load field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetCnsLoad(void) const
    {
        return GetFieldUINT8Value(97, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set cns_load field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetCnsLoad(FIT_UINT8 cnsLoad)
    {
        SetFieldUINT8Value(97, cnsLoad, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of n2_load field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsN2LoadValid() const
    {
        const Field* field = GetField(98);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns n2_load field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetN2Load(void) const
    {
        return GetFieldUINT16Value(98, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set n2_load field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetN2Load(FIT_UINT16 n2Load)
    {
        SetFieldUINT16Value(98, n2Load, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of respiration_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRespirationRateValid() const
    {
        const Field* field = GetField(99);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns respiration_rate field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetRespirationRate(void) const
    {
        return GetFieldUINT8Value(99, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set respiration_rate field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetRespirationRate(FIT_UINT8 respirationRate)
    {
        SetFieldUINT8Value(99, respirationRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of enhanced_respiration_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEnhancedRespirationRateValid() const
    {
        const Field* field = GetField(108);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns enhanced_respiration_rate field
    // Units: Breaths/min
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetEnhancedRespirationRate(void) const
    {
        return GetFieldFLOAT32Value(108, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set enhanced_respiration_rate field
    // Units: Breaths/min
    ///////////////////////////////////////////////////////////////////////
    void SetEnhancedRespirationRate(FIT_FLOAT32 enhancedRespirationRate)
    {
        SetFieldFLOAT32Value(108, enhancedRespirationRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of grit field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsGritValid() const
    {
        const Field* field = GetField(114);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns grit field
    // Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetGrit(void) const
    {
        return GetFieldFLOAT32Value(114, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set grit field
    // Comment: The grit score estimates how challenging a route could be for a cyclist in terms of time spent going over sharp turns or large grade slopes.
    ///////////////////////////////////////////////////////////////////////
    void SetGrit(FIT_FLOAT32 grit)
    {
        SetFieldFLOAT32Value(114, grit, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of flow field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsFlowValid() const
    {
        const Field* field = GetField(115);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns flow field
    // Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetFlow(void) const
    {
        return GetFieldFLOAT32Value(115, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set flow field
    // Comment: The flow score estimates how long distance wise a cyclist deaccelerates over intervals where deacceleration is unnecessary such as smooth turns or small grade angle intervals.
    ///////////////////////////////////////////////////////////////////////
    void SetFlow(FIT_FLOAT32 flow)
    {
        SetFieldFLOAT32Value(115, flow, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of current_stress field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCurrentStressValid() const
    {
        const Field* field = GetField(116);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns current_stress field
    // Comment: Current Stress value
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCurrentStress(void) const
    {
        return GetFieldFLOAT32Value(116, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set current_stress field
    // Comment: Current Stress value
    ///////////////////////////////////////////////////////////////////////
    void SetCurrentStress(FIT_FLOAT32 currentStress)
    {
        SetFieldFLOAT32Value(116, currentStress, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ebike_travel_range field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEbikeTravelRangeValid() const
    {
        const Field* field = GetField(117);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ebike_travel_range field
    // Units: km
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT16 GetEbikeTravelRange(void) const
    {
        return GetFieldUINT16Value(117, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ebike_travel_range field
    // Units: km
    ///////////////////////////////////////////////////////////////////////
    void SetEbikeTravelRange(FIT_UINT16 ebikeTravelRange)
    {
        SetFieldUINT16Value(117, ebikeTravelRange, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ebike_battery_level field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEbikeBatteryLevelValid() const
    {
        const Field* field = GetField(118);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ebike_battery_level field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetEbikeBatteryLevel(void) const
    {
        return GetFieldUINT8Value(118, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ebike_battery_level field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetEbikeBatteryLevel(FIT_UINT8 ebikeBatteryLevel)
    {
        SetFieldUINT8Value(118, ebikeBatteryLevel, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ebike_assist_mode field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEbikeAssistModeValid() const
    {
        const Field* field = GetField(119);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ebike_assist_mode field
    // Units: depends on sensor
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetEbikeAssistMode(void) const
    {
        return GetFieldUINT8Value(119, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ebike_assist_mode field
    // Units: depends on sensor
    ///////////////////////////////////////////////////////////////////////
    void SetEbikeAssistMode(FIT_UINT8 ebikeAssistMode)
    {
        SetFieldUINT8Value(119, ebikeAssistMode, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ebike_assist_level_percent field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsEbikeAssistLevelPercentValid() const
    {
        const Field* field = GetField(120);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ebike_assist_level_percent field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT8 GetEbikeAssistLevelPercent(void) const
    {
        return GetFieldUINT8Value(120, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ebike_assist_level_percent field
    // Units: percent
    ///////////////////////////////////////////////////////////////////////
    void SetEbikeAssistLevelPercent(FIT_UINT8 ebikeAssistLevelPercent)
    {
        SetFieldUINT8Value(120, ebikeAssistLevelPercent, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of air_time_remaining field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAirTimeRemainingValid() const
    {
        const Field* field = GetField(123);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns air_time_remaining field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    FIT_UINT32 GetAirTimeRemaining(void) const
    {
        return GetFieldUINT32Value(123, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set air_time_remaining field
    // Units: s
    ///////////////////////////////////////////////////////////////////////
    void SetAirTimeRemaining(FIT_UINT32 airTimeRemaining)
    {
        SetFieldUINT32Value(123, airTimeRemaining, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of pressure_sac field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPressureSacValid() const
    {
        const Field* field = GetField(124);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns pressure_sac field
    // Units: bar/min
    // Comment: Pressure-based surface air consumption
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetPressureSac(void) const
    {
        return GetFieldFLOAT32Value(124, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set pressure_sac field
    // Units: bar/min
    // Comment: Pressure-based surface air consumption
    ///////////////////////////////////////////////////////////////////////
    void SetPressureSac(FIT_FLOAT32 pressureSac)
    {
        SetFieldFLOAT32Value(124, pressureSac, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of volume_sac field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsVolumeSacValid() const
    {
        const Field* field = GetField(125);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns volume_sac field
    // Units: L/min
    // Comment: Volumetric surface air consumption
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetVolumeSac(void) const
    {
        return GetFieldFLOAT32Value(125, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set volume_sac field
    // Units: L/min
    // Comment: Volumetric surface air consumption
    ///////////////////////////////////////////////////////////////////////
    void SetVolumeSac(FIT_FLOAT32 volumeSac)
    {
        SetFieldFLOAT32Value(125, volumeSac, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of rmv field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsRmvValid() const
    {
        const Field* field = GetField(126);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns rmv field
    // Units: L/min
    // Comment: Respiratory minute volume
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetRmv(void) const
    {
        return GetFieldFLOAT32Value(126, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set rmv field
    // Units: L/min
    // Comment: Respiratory minute volume
    ///////////////////////////////////////////////////////////////////////
    void SetRmv(FIT_FLOAT32 rmv)
    {
        SetFieldFLOAT32Value(126, rmv, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of ascent_rate field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsAscentRateValid() const
    {
        const Field* field = GetField(127);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns ascent_rate field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetAscentRate(void) const
    {
        return GetFieldFLOAT32Value(127, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set ascent_rate field
    // Units: m/s
    ///////////////////////////////////////////////////////////////////////
    void SetAscentRate(FIT_FLOAT32 ascentRate)
    {
        SetFieldFLOAT32Value(127, ascentRate, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of po2 field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsPo2Valid() const
    {
        const Field* field = GetField(129);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns po2 field
    // Units: percent
    // Comment: Current partial pressure of oxygen
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetPo2(void) const
    {
        return GetFieldFLOAT32Value(129, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set po2 field
    // Units: percent
    // Comment: Current partial pressure of oxygen
    ///////////////////////////////////////////////////////////////////////
    void SetPo2(FIT_FLOAT32 po2)
    {
        SetFieldFLOAT32Value(129, po2, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Checks the validity of core_temperature field
    // Returns FIT_TRUE if field is valid
    ///////////////////////////////////////////////////////////////////////
    FIT_BOOL IsCoreTemperatureValid() const
    {
        const Field* field = GetField(139);
        if( FIT_NULL == field )
        {
            return FIT_FALSE;
        }

        return field->IsValueValid();
    }

    ///////////////////////////////////////////////////////////////////////
    // Returns core_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    FIT_FLOAT32 GetCoreTemperature(void) const
    {
        return GetFieldFLOAT32Value(139, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

    ///////////////////////////////////////////////////////////////////////
    // Set core_temperature field
    // Units: C
    ///////////////////////////////////////////////////////////////////////
    void SetCoreTemperature(FIT_FLOAT32 coreTemperature)
    {
        SetFieldFLOAT32Value(139, coreTemperature, 0, FIT_SUBFIELD_INDEX_MAIN_FIELD);
    }

};

} // namespace fit

#endif // !defined(FIT_RECORD_MESG_HPP)
