/* GUI_PlaylistGeneratorPreferences.h, (Created on 29.03.2025) */

/* Copyright (C) 2011-2025 Michael Lugmair
 *
 * This file is part of Sayonara Player
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
#ifndef SAYONARA_PLAYER_GUI_PLAYLISTGENERATORPREFERENCES_H
#define SAYONARA_PLAYER_GUI_PLAYLISTGENERATORPREFERENCES_H

#include "Gui/Preferences/PreferenceWidget.h"

UI_FWD(GUI_PlaylistGeneratorPreferences);

class SmartPlaylistManager;
namespace Library
{
	class Manager;
}

class GUI_PlaylistGeneratorPreferences :
	public Preferences::Base
{
	Q_OBJECT
	UI_CLASS_SHARED_PTR(GUI_PlaylistGeneratorPreferences)
	PIMPL(GUI_PlaylistGeneratorPreferences)

	public:
		GUI_PlaylistGeneratorPreferences(SmartPlaylistManager* smartPlaylistManager, Library::Manager* libraryManager,
		                                 const QString& identifier);
		~GUI_PlaylistGeneratorPreferences() override;

		[[nodiscard]] QString actionName() const override;

		bool commit() override;
		void revert() override;
		void initUi() override;
		void retranslate() override;

	private slots:
		void newClicked();
		void editClicked();
		void removeClicked();

	private: // NOLINT(*-redundant-access-specifiers)
		void populateList();

};

#endif //SAYONARA_PLAYER_GUI_PLAYLISTGENERATORPREFERENCES_H
