## TFSA-2020-027: Segfault in `tf.quantization.quantize_and_dequantize`

### CVE Number
CVE-2020-15265

### Impact
An attacker can pass an invalid `axis` value to
`tf.quantization.quantize_and_dequantize`:

```python
tf.quantization.quantize_and_dequantize(
    input=[2.5, 2.5], input_min=[0,0], input_max=[1,1], axis=10)
```

This results in accessing [a dimension outside the rank of the input
tensor](https://github.com/tensorflow/tensorflow/blob/0225022b725993bfc19b87a02a2faaad9a53bc17/tensorflow/core/kernels/quantize_and_dequantize_op.cc#L74)
in the C++ kernel implementation:
```cc
const int depth = (axis_ == -1) ? 1 : input.dim_size(axis_);
```

However, [`dim_size` only does a
`DCHECK`](https://github.com/tensorflow/tensorflow/blob/0225022b725993bfc19b87a02a2faaad9a53bc17/tensorflow/core/framework/tensor_shape.cc#L292-L307)
to validate the argument and then uses it to access the corresponding element of
an array:
```cc
int64 TensorShapeBase<Shape>::dim_size(int d) const {
  DCHECK_GE(d, 0);
  DCHECK_LT(d, dims());
  DoStuffWith(dims_[d]);
}
```

Since in normal builds, `DCHECK`-like macros are no-ops, this results in
segfault and access out of bounds of the array.

### Patches

We have patched the issue in
[eccb7ec454e6617738554a255d77f08e60ee0808](https://github.com/tensorflow/tensorflow/commit/eccb7ec454e6617738554a255d77f08e60ee0808)
and will release TensorFlow 2.4.0 containing the patch. TensorFlow nightly
packages after this commit will also have the issue resolved.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported in
[#42105](https://github.com/tensorflow/issues/42105).
