## TFSA-2022-142: `CHECK`-fail in `tensorflow::full_type::SubstituteFromAttrs`

### CVE Number
CVE-2022-36016

### Impact
When [`tensorflow::full_type::SubstituteFromAttrs`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/ops/math_ops.cc) receives a `FullTypeDef& t` that is not exactly three args, it triggers a `CHECK`-fail instead of returning a status.
```cpp
Status SubstituteForEach(AttrMap& attrs, FullTypeDef& t) {
  DCHECK_EQ(t.args_size(), 3);

  const auto& cont = t.args(0);
  const auto& tmpl = t.args(1);
  const auto& t_var = t.args(2);
```

### Patches
We have patched the issue in GitHub commit [6104f0d4091c260ce9352f9155f7e9b725eab012](https://github.com/tensorflow/tensorflow/commit/6104f0d4091c260ce9352f9155f7e9b725eab012).
The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
