/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef LOCKSLIDER_H
#define LOCKSLIDER_H

#include "kslider.h"
#include <QSlider>
#include <QSlider>

using namespace kdk;

class LockSlider:public KSlider
{
public:
    LockSlider(QStringList list, QWidget *parent = nullptr);
    ~LockSlider();
    void initNodePoint();
    bool isContains(QPoint p1, QPoint p2, int radius);
    void showTooltip(const int &num);

protected:
    void paintEvent(QPaintEvent *e);
    bool eventFilter(QObject *watched, QEvent *event);
    void mousePressEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);
    void mouseMoveEvent(QMouseEvent *e);

private:
    QStringList scaleList;
    QList<QPoint>nodePointList;
    bool mouseLeftBtnIsPressed;
};


#endif // LOCKSLIDER_H
