/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#include "myslider.h"
#include <QMouseEvent>
#include <QDebug>
#include <QWidget>


MySlider::MySlider(QWidget *parent):QSlider (parent){}
MySlider::~MySlider(){}

//重写鼠标点击事件
void MySlider::mousePressEvent(QMouseEvent *ev)
{
    isMouseCliked = true;
    QSlider::mousePressEvent(ev);
    int currentx = ev->pos().x();
    int value = (currentx /(double)this->width())*(this->maximum() - this->minimum()) + this->minimum();
    this->setValue(value);

}

void MySlider::wheelEvent(QWheelEvent *ev)
{
    if (isMouseCliked)
        return QSlider::wheelEvent(ev);
}

void MySlider::leaveEvent(QEvent *ev)
{
    isMouseCliked = false;
}

void MySlider::mouseReleaseEvent(QMouseEvent *ev)
{
    emit sliderClickedSignals();
    QSlider::mouseReleaseEvent(ev);
}
