/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef SHORTCUTINTERFACE_H
#define SHORTCUTINTERFACE_H

#include "universalinterface.h"
#include "getshortcutworker.h"
#include "type.h"
#include <QObject>
#include <QtDBus>
#include <QMap>

class ShortcutInterface : public QObject
{
    Q_OBJECT
    Q_CLASSINFO("D-Bus Interface", "org.ukui.ukcc.session.Shortcut")

public:
    ShortcutInterface();
    ~ShortcutInterface();

public Q_SLOTS:
    QList<QStringPair> getSystemShortcut();
    QList<QStringPair> getCustomShortcut();
    QList<KeyEntry>    getSystemShortcutEntry();
    QList<KeyEntry>    getCustomShortcutEntry();

    void               updateShortcut();
    void               setSystemShortcut(const QString &key, const QString &value);

private:
    QList<KeyEntry>    systemEntries;
    QList<KeyEntry>    customEntries;
    QList<QStringPair> systemShortcutList;
    QList<QStringPair> customShortcutList;

private:
    void getShortcutThread();
    QMap<QString, QString> MergerOfTheSamekind(QMap<QString, QString> desktopMap);
    void buildGeneralWidget(QString schema, QMap<QString, QString> subShortcutsMap);
    QString getShowShortcutString(QString src);

Q_SIGNALS:
    void changed(QString key);
};

#endif // SHORTCUTINTERFACE_H
