/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef UTILS_H
#define UTILS_H

#include <QRect>
#include <QCursor>
#include <QObject>
#include <QWidget>
#include <QSettings>
#include <QApplication>
#include <QCommandLineOption>
#include <QCommandLineParser>
#include <QDesktopWidget>
#include <QVariantMap>
#include <QtDBus/QDBusInterface>
#include <QtDBus/QDBusReply>
#include <QtDBus/QDBusConnection>

namespace Utils
{
    void centerToScreen(QWidget *widget);
    QRect sizeOnCursor();
    QVariantMap getModuleHideStatus();
    QString getCpuInfo();
    QString getCpuArchitecture();
    bool isExistEffect();
    bool isExitBattery();
    void setKwinMouseSize(int size);
    bool isWayland();
    bool isCommunity();
    bool isTablet();
    bool isZJY();
    QString getHostName();
    QString getUkccVersion();
}
#endif // UTILS_H
