/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.SentryEvent;
import io.sentry.Session;
import io.sentry.protocol.SentryTransaction;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public enum SentryItemType {
    Session("session"),
    Event("event"),
    UserFeedback("user_report"),
    Attachment("attachment"),
    Transaction("transaction"),
    Unknown("__unknown__");

    private final String itemType;

    public static SentryItemType resolve(Object item) {
        if (item instanceof SentryEvent) {
            return Event;
        }
        if (item instanceof SentryTransaction) {
            return Transaction;
        }
        if (item instanceof Session) {
            return Session;
        }
        return Attachment;
    }

    private SentryItemType(String itemType) {
        this.itemType = itemType;
    }

    public String getItemType() {
        return this.itemType;
    }
}

