/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class VkDebugMarkerObjectTagInfoEXT
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STYPE;
    public static final int PNEXT;
    public static final int OBJECTTYPE;
    public static final int OBJECT;
    public static final int TAGNAME;
    public static final int TAGSIZE;
    public static final int PTAG;

    public VkDebugMarkerObjectTagInfoEXT(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkDebugMarkerObjectTagInfoEXT.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="VkStructureType")
    public int sType() {
        return VkDebugMarkerObjectTagInfoEXT.nsType(this.address());
    }

    @NativeType(value="void const *")
    public long pNext() {
        return VkDebugMarkerObjectTagInfoEXT.npNext(this.address());
    }

    @NativeType(value="VkDebugReportObjectTypeEXT")
    public int objectType() {
        return VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address());
    }

    @NativeType(value="uint64_t")
    public long object() {
        return VkDebugMarkerObjectTagInfoEXT.nobject(this.address());
    }

    @NativeType(value="uint64_t")
    public long tagName() {
        return VkDebugMarkerObjectTagInfoEXT.ntagName(this.address());
    }

    @NativeType(value="size_t")
    public long tagSize() {
        return VkDebugMarkerObjectTagInfoEXT.ntagSize(this.address());
    }

    @NativeType(value="void const *")
    public ByteBuffer pTag() {
        return VkDebugMarkerObjectTagInfoEXT.npTag(this.address());
    }

    public VkDebugMarkerObjectTagInfoEXT sType(@NativeType(value="VkStructureType") int value) {
        VkDebugMarkerObjectTagInfoEXT.nsType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT sType$Default() {
        return this.sType(1000022001);
    }

    public VkDebugMarkerObjectTagInfoEXT pNext(@NativeType(value="void const *") long value) {
        VkDebugMarkerObjectTagInfoEXT.npNext(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT objectType(@NativeType(value="VkDebugReportObjectTypeEXT") int value) {
        VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT object(@NativeType(value="uint64_t") long value) {
        VkDebugMarkerObjectTagInfoEXT.nobject(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT tagName(@NativeType(value="uint64_t") long value) {
        VkDebugMarkerObjectTagInfoEXT.ntagName(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT pTag(@NativeType(value="void const *") ByteBuffer value) {
        VkDebugMarkerObjectTagInfoEXT.npTag(this.address(), value);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT set(int sType, long pNext, int objectType, long object, long tagName, ByteBuffer pTag) {
        this.sType(sType);
        this.pNext(pNext);
        this.objectType(objectType);
        this.object(object);
        this.tagName(tagName);
        this.pTag(pTag);
        return this;
    }

    public VkDebugMarkerObjectTagInfoEXT set(VkDebugMarkerObjectTagInfoEXT src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkDebugMarkerObjectTagInfoEXT malloc() {
        return (VkDebugMarkerObjectTagInfoEXT)VkDebugMarkerObjectTagInfoEXT.wrap(VkDebugMarkerObjectTagInfoEXT.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkDebugMarkerObjectTagInfoEXT calloc() {
        return (VkDebugMarkerObjectTagInfoEXT)VkDebugMarkerObjectTagInfoEXT.wrap(VkDebugMarkerObjectTagInfoEXT.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkDebugMarkerObjectTagInfoEXT create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkDebugMarkerObjectTagInfoEXT)VkDebugMarkerObjectTagInfoEXT.wrap(VkDebugMarkerObjectTagInfoEXT.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkDebugMarkerObjectTagInfoEXT create(long address) {
        return (VkDebugMarkerObjectTagInfoEXT)VkDebugMarkerObjectTagInfoEXT.wrap(VkDebugMarkerObjectTagInfoEXT.class, (long)address);
    }

    @Nullable
    public static VkDebugMarkerObjectTagInfoEXT createSafe(long address) {
        return address == 0L ? null : (VkDebugMarkerObjectTagInfoEXT)VkDebugMarkerObjectTagInfoEXT.wrap(VkDebugMarkerObjectTagInfoEXT.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkDebugMarkerObjectTagInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkDebugMarkerObjectTagInfoEXT.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkDebugMarkerObjectTagInfoEXT.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkDebugMarkerObjectTagInfoEXT.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkDebugMarkerObjectTagInfoEXT.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkDebugMarkerObjectTagInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkDebugMarkerObjectTagInfoEXT.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkDebugMarkerObjectTagInfoEXT mallocStack() {
        return VkDebugMarkerObjectTagInfoEXT.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerObjectTagInfoEXT callocStack() {
        return VkDebugMarkerObjectTagInfoEXT.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkDebugMarkerObjectTagInfoEXT mallocStack(MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.malloc(stack);
    }

    @Deprecated
    public static VkDebugMarkerObjectTagInfoEXT callocStack(MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkDebugMarkerObjectTagInfoEXT.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkDebugMarkerObjectTagInfoEXT.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkDebugMarkerObjectTagInfoEXT.calloc(capacity, stack);
    }

    public static VkDebugMarkerObjectTagInfoEXT malloc(MemoryStack stack) {
        return (VkDebugMarkerObjectTagInfoEXT)VkDebugMarkerObjectTagInfoEXT.wrap(VkDebugMarkerObjectTagInfoEXT.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkDebugMarkerObjectTagInfoEXT calloc(MemoryStack stack) {
        return (VkDebugMarkerObjectTagInfoEXT)VkDebugMarkerObjectTagInfoEXT.wrap(VkDebugMarkerObjectTagInfoEXT.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugMarkerObjectTagInfoEXT.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkDebugMarkerObjectTagInfoEXT.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nsType(long struct) {
        return UNSAFE.getInt(null, struct + (long)STYPE);
    }

    public static long npNext(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PNEXT));
    }

    public static int nobjectType(long struct) {
        return UNSAFE.getInt(null, struct + (long)OBJECTTYPE);
    }

    public static long nobject(long struct) {
        return UNSAFE.getLong(null, struct + (long)OBJECT);
    }

    public static long ntagName(long struct) {
        return UNSAFE.getLong(null, struct + (long)TAGNAME);
    }

    public static long ntagSize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)TAGSIZE));
    }

    public static ByteBuffer npTag(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PTAG)), (int)((int)VkDebugMarkerObjectTagInfoEXT.ntagSize(struct)));
    }

    public static void nsType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)STYPE, value);
    }

    public static void npNext(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PNEXT), (long)value);
    }

    public static void nobjectType(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)OBJECTTYPE, value);
    }

    public static void nobject(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)OBJECT, value);
    }

    public static void ntagName(long struct, long value) {
        UNSAFE.putLong(null, struct + (long)TAGNAME, value);
    }

    public static void ntagSize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)TAGSIZE), (long)value);
    }

    public static void npTag(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PTAG), (long)MemoryUtil.memAddress((ByteBuffer)value));
        VkDebugMarkerObjectTagInfoEXT.ntagSize(struct, value.remaining());
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PTAG)));
    }

    static {
        Struct.Layout layout = VkDebugMarkerObjectTagInfoEXT.__struct((Struct.Member[])new Struct.Member[]{VkDebugMarkerObjectTagInfoEXT.__member((int)4), VkDebugMarkerObjectTagInfoEXT.__member((int)POINTER_SIZE), VkDebugMarkerObjectTagInfoEXT.__member((int)4), VkDebugMarkerObjectTagInfoEXT.__member((int)8), VkDebugMarkerObjectTagInfoEXT.__member((int)8), VkDebugMarkerObjectTagInfoEXT.__member((int)POINTER_SIZE), VkDebugMarkerObjectTagInfoEXT.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STYPE = layout.offsetof(0);
        PNEXT = layout.offsetof(1);
        OBJECTTYPE = layout.offsetof(2);
        OBJECT = layout.offsetof(3);
        TAGNAME = layout.offsetof(4);
        TAGSIZE = layout.offsetof(5);
        PTAG = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<VkDebugMarkerObjectTagInfoEXT, Buffer>
    implements NativeResource {
        private static final VkDebugMarkerObjectTagInfoEXT ELEMENT_FACTORY = VkDebugMarkerObjectTagInfoEXT.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkDebugMarkerObjectTagInfoEXT getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="VkStructureType")
        public int sType() {
            return VkDebugMarkerObjectTagInfoEXT.nsType(this.address());
        }

        @NativeType(value="void const *")
        public long pNext() {
            return VkDebugMarkerObjectTagInfoEXT.npNext(this.address());
        }

        @NativeType(value="VkDebugReportObjectTypeEXT")
        public int objectType() {
            return VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address());
        }

        @NativeType(value="uint64_t")
        public long object() {
            return VkDebugMarkerObjectTagInfoEXT.nobject(this.address());
        }

        @NativeType(value="uint64_t")
        public long tagName() {
            return VkDebugMarkerObjectTagInfoEXT.ntagName(this.address());
        }

        @NativeType(value="size_t")
        public long tagSize() {
            return VkDebugMarkerObjectTagInfoEXT.ntagSize(this.address());
        }

        @NativeType(value="void const *")
        public ByteBuffer pTag() {
            return VkDebugMarkerObjectTagInfoEXT.npTag(this.address());
        }

        public Buffer sType(@NativeType(value="VkStructureType") int value) {
            VkDebugMarkerObjectTagInfoEXT.nsType(this.address(), value);
            return this;
        }

        public Buffer sType$Default() {
            return this.sType(1000022001);
        }

        public Buffer pNext(@NativeType(value="void const *") long value) {
            VkDebugMarkerObjectTagInfoEXT.npNext(this.address(), value);
            return this;
        }

        public Buffer objectType(@NativeType(value="VkDebugReportObjectTypeEXT") int value) {
            VkDebugMarkerObjectTagInfoEXT.nobjectType(this.address(), value);
            return this;
        }

        public Buffer object(@NativeType(value="uint64_t") long value) {
            VkDebugMarkerObjectTagInfoEXT.nobject(this.address(), value);
            return this;
        }

        public Buffer tagName(@NativeType(value="uint64_t") long value) {
            VkDebugMarkerObjectTagInfoEXT.ntagName(this.address(), value);
            return this;
        }

        public Buffer pTag(@NativeType(value="void const *") ByteBuffer value) {
            VkDebugMarkerObjectTagInfoEXT.npTag(this.address(), value);
            return this;
        }
    }
}

