/*
 * Decompiled with CFR 0.152.
 */
package com.concurrent_ruby.ext;

import com.concurrent_ruby.ext.jsr166e.ConcurrentHashMap;
import com.concurrent_ruby.ext.jsr166e.nounsafe.ConcurrentHashMapV8;
import java.io.IOException;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.load.Library;

public class JRubyMapBackendLibrary
implements Library {
    private static final ObjectAllocator BACKEND_ALLOCATOR = new ObjectAllocator(){

        public IRubyObject allocate(Ruby ruby, RubyClass rubyClass) {
            return new JRubyMapBackend(ruby, rubyClass);
        }
    };

    public void load(Ruby ruby, boolean bl) throws IOException {
        RubyModule rubyModule = ruby.defineModule("Concurrent");
        RubyModule rubyModule2 = rubyModule.defineModuleUnder("Collection");
        RubyClass rubyClass = rubyModule2.defineClassUnder("JRubyMapBackend", ruby.getObject(), BACKEND_ALLOCATOR);
        rubyClass.setAllocator(BACKEND_ALLOCATOR);
        rubyClass.defineAnnotatedMethods(JRubyMapBackend.class);
    }

    @JRubyClass(name={"JRubyMapBackend"}, parent="Object")
    public static class JRubyMapBackend
    extends RubyObject {
        static final int DEFAULT_INITIAL_CAPACITY = 16;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        public static final boolean CAN_USE_UNSAFE_CHM = JRubyMapBackend.canUseUnsafeCHM();
        private ConcurrentHashMap<IRubyObject, IRubyObject> map;

        private static ConcurrentHashMap<IRubyObject, IRubyObject> newCHM(int n, float f) {
            if (CAN_USE_UNSAFE_CHM) {
                return new com.concurrent_ruby.ext.jsr166e.ConcurrentHashMapV8<IRubyObject, IRubyObject>(n, f);
            }
            return new ConcurrentHashMapV8<IRubyObject, IRubyObject>(n, f);
        }

        private static ConcurrentHashMap<IRubyObject, IRubyObject> newCHM() {
            return JRubyMapBackend.newCHM(16, 0.75f);
        }

        private static boolean canUseUnsafeCHM() {
            try {
                new com.concurrent_ruby.ext.jsr166e.ConcurrentHashMapV8();
                return true;
            }
            catch (Throwable throwable) {
                if (JRubyMapBackend.isCausedBySecurityException(throwable)) {
                    return false;
                }
                throw throwable instanceof RuntimeException ? (RuntimeException)throwable : new RuntimeException(throwable);
            }
        }

        private static boolean isCausedBySecurityException(Throwable throwable) {
            while (throwable != null) {
                if (throwable.getMessage() != null && throwable.getMessage().contains("Could not initialize intrinsics") || throwable instanceof SecurityException) {
                    return true;
                }
                throwable = throwable.getCause();
            }
            return false;
        }

        public JRubyMapBackend(Ruby ruby, RubyClass rubyClass) {
            super(ruby, rubyClass);
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext) {
            this.map = JRubyMapBackend.newCHM();
            return threadContext.getRuntime().getNil();
        }

        @JRubyMethod
        public IRubyObject initialize(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.map = this.toCHM(threadContext, iRubyObject);
            return threadContext.getRuntime().getNil();
        }

        private ConcurrentHashMap<IRubyObject, IRubyObject> toCHM(ThreadContext threadContext, IRubyObject iRubyObject) {
            Ruby ruby = threadContext.getRuntime();
            if (!iRubyObject.isNil() && iRubyObject.respondsTo("[]")) {
                IRubyObject iRubyObject2 = iRubyObject.callMethod(threadContext, "[]", (IRubyObject)ruby.newSymbol("initial_capacity"));
                IRubyObject iRubyObject3 = iRubyObject.callMethod(threadContext, "[]", (IRubyObject)ruby.newSymbol("load_factor"));
                int n = !iRubyObject2.isNil() ? RubyNumeric.num2int((IRubyObject)iRubyObject2.convertToInteger()) : 16;
                float f = !iRubyObject3.isNil() ? (float)RubyNumeric.num2dbl((IRubyObject)iRubyObject3.convertToFloat()) : 0.75f;
                return JRubyMapBackend.newCHM(n, f);
            }
            return JRubyMapBackend.newCHM();
        }

        @JRubyMethod(name={"[]"}, required=1)
        public IRubyObject op_aref(ThreadContext threadContext, IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = this.map.get(iRubyObject);
            return iRubyObject2 == null ? threadContext.getRuntime().getNil() : iRubyObject2;
        }

        @JRubyMethod(name={"[]="}, required=2)
        public IRubyObject op_aset(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            this.map.put(iRubyObject, iRubyObject2);
            return iRubyObject2;
        }

        @JRubyMethod
        public IRubyObject put_if_absent(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            IRubyObject iRubyObject3 = this.map.putIfAbsent(iRubyObject, iRubyObject2);
            return iRubyObject3 == null ? this.getRuntime().getNil() : iRubyObject3;
        }

        @JRubyMethod
        public IRubyObject compute_if_absent(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
            return this.map.computeIfAbsent(iRubyObject, new ConcurrentHashMap.Fun<IRubyObject, IRubyObject>(){

                @Override
                public IRubyObject apply(IRubyObject iRubyObject) {
                    return block.yieldSpecific(threadContext);
                }
            });
        }

        @JRubyMethod
        public IRubyObject compute_if_present(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
            IRubyObject iRubyObject2 = this.map.computeIfPresent(iRubyObject, new ConcurrentHashMap.BiFun<IRubyObject, IRubyObject, IRubyObject>(){

                @Override
                public IRubyObject apply(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                    IRubyObject iRubyObject3 = block.yieldSpecific(threadContext, iRubyObject2 == null ? threadContext.getRuntime().getNil() : iRubyObject2);
                    return iRubyObject3.isNil() ? null : iRubyObject3;
                }
            });
            return iRubyObject2 == null ? threadContext.getRuntime().getNil() : iRubyObject2;
        }

        @JRubyMethod
        public IRubyObject compute(final ThreadContext threadContext, IRubyObject iRubyObject, final Block block) {
            IRubyObject iRubyObject2 = this.map.compute(iRubyObject, new ConcurrentHashMap.BiFun<IRubyObject, IRubyObject, IRubyObject>(){

                @Override
                public IRubyObject apply(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                    IRubyObject iRubyObject3 = block.yieldSpecific(threadContext, iRubyObject2 == null ? threadContext.getRuntime().getNil() : iRubyObject2);
                    return iRubyObject3.isNil() ? null : iRubyObject3;
                }
            });
            return iRubyObject2 == null ? threadContext.getRuntime().getNil() : iRubyObject2;
        }

        @JRubyMethod
        public IRubyObject merge_pair(final ThreadContext threadContext, IRubyObject iRubyObject, IRubyObject iRubyObject2, final Block block) {
            IRubyObject iRubyObject3 = this.map.merge(iRubyObject, iRubyObject2, new ConcurrentHashMap.BiFun<IRubyObject, IRubyObject, IRubyObject>(){

                @Override
                public IRubyObject apply(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
                    IRubyObject iRubyObject3 = block.yieldSpecific(threadContext, iRubyObject == null ? threadContext.getRuntime().getNil() : iRubyObject);
                    return iRubyObject3.isNil() ? null : iRubyObject3;
                }
            });
            return iRubyObject3 == null ? threadContext.getRuntime().getNil() : iRubyObject3;
        }

        @JRubyMethod
        public RubyBoolean replace_pair(IRubyObject iRubyObject, IRubyObject iRubyObject2, IRubyObject iRubyObject3) {
            return this.getRuntime().newBoolean(this.map.replace(iRubyObject, iRubyObject2, iRubyObject3));
        }

        @JRubyMethod(name={"key?"}, required=1)
        public RubyBoolean has_key_p(IRubyObject iRubyObject) {
            return this.map.containsKey(iRubyObject) ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod
        public IRubyObject key(IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = this.map.findKey(iRubyObject);
            return iRubyObject2 == null ? this.getRuntime().getNil() : iRubyObject2;
        }

        @JRubyMethod
        public IRubyObject replace_if_exists(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            IRubyObject iRubyObject3 = this.map.replace(iRubyObject, iRubyObject2);
            return iRubyObject3 == null ? this.getRuntime().getNil() : iRubyObject3;
        }

        @JRubyMethod
        public IRubyObject get_and_set(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            IRubyObject iRubyObject3 = this.map.put(iRubyObject, iRubyObject2);
            return iRubyObject3 == null ? this.getRuntime().getNil() : iRubyObject3;
        }

        @JRubyMethod
        public IRubyObject delete(IRubyObject iRubyObject) {
            IRubyObject iRubyObject2 = this.map.remove(iRubyObject);
            return iRubyObject2 == null ? this.getRuntime().getNil() : iRubyObject2;
        }

        @JRubyMethod
        public RubyBoolean delete_pair(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return this.getRuntime().newBoolean(this.map.remove(iRubyObject, iRubyObject2));
        }

        @JRubyMethod
        public IRubyObject clear() {
            this.map.clear();
            return this;
        }

        @JRubyMethod
        public IRubyObject each_pair(ThreadContext threadContext, Block block) {
            for (Map.Entry<IRubyObject, IRubyObject> entry : this.map.entrySet()) {
                block.yieldSpecific(threadContext, entry.getKey(), entry.getValue());
            }
            return this;
        }

        @JRubyMethod
        public RubyFixnum size(ThreadContext threadContext) {
            return threadContext.getRuntime().newFixnum(this.map.size());
        }

        @JRubyMethod
        public IRubyObject get_or_default(IRubyObject iRubyObject, IRubyObject iRubyObject2) {
            return this.map.getValueOrDefault(iRubyObject, iRubyObject2);
        }

        @JRubyMethod(visibility=Visibility.PRIVATE)
        public JRubyMapBackend initialize_copy(ThreadContext threadContext, IRubyObject iRubyObject) {
            this.map = JRubyMapBackend.newCHM();
            return this;
        }
    }
}

