#!/usr/bin/perl
#  export.pl - functions to implement exporting data to other formats
#
#  Written by Curtis Olson.  Started October 19, 1994.
#
#  Copyright (C) 1994 - 1997  Curtis L. Olson  - curt@sledge.mn.org
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License as published by
#  the Free Software Foundation; either version 2 of the License, or
#  (at your option) any later version.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  You should have received a copy of the GNU General Public License
#  along with this program; if not, write to the Free Software
#  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# $Id: export.pl,v 2.7 1997/04/23 18:07:28 curt Exp $
# (Log is kept at end of this file)


package CBB;

use strict;   # don't take no guff


# save data in the CBB format
sub save_cbb {
    # in: file base name
    # out: result

    my($file) = @_;
    my($key);

    if ($CBB::calced == 0) {
	&calc_trans();
    }

    open(SAVE, ">$file.new");

    if ($CBB::sorted_keys == 0) {
	&sort_keys();
    }

    foreach $key (@CBB::KEYS) {
	print (SAVE "$CBB::TRANS{$key}\n");
    }

    close(SAVE);

    unlink("$file.bak");
    rename("$file", "$file.bak");
    rename("$file.new", "$file");

    return "ok";
}


# Contributed by Christopher Browne, Oct. 18/94
# export a quicken export file (.qif)
sub export_qif {
    # in: file
    # out: result
    
    my($file) = @_;
    my($key);
    my($date, $check, $desc, $debit, $credit, $cat, $split, $com, $cleared);
    my($amount, $i, @SPLIT, $scom, $scat, $junk);
    my($dy, $mo, $yr);

    $CBB::sorted_keys = 0;
    $CBB::calced = 0;
    
    open(QIF, ">$file");
    
    print QIF "Type:Bank\n";      # This will need to change,
    # eventually, to handle other
    # varieties of QUICKEN accounts.
    # Credit cards, investments, etc.
    # Later.

    ($date, $check, $desc, $debit, $credit, $cat, $split, $com,
     $cleared) = ("", "", "", "", "", "", "", "", "");

    foreach $key (keys (%CBB::TRANS)) {
        ($date, $check, $desc, $debit, $credit, $cat, $com, $cleared,
	 $junk) = split(/\t/, $CBB::TRANS{$key});
     
	# Handle date
	$yr = substr($date, 2, 2);
	$mo = substr($date, 4, 2);
	$dy = substr($date, 6, 2);
	printf QIF "D%d/%2d/%2d\n", $mo, $dy, $yr;
     
	# Handle amount
	$amount = $credit-$debit;
	printf QIF "T%.2lf\n", $amount;

	printf QIF "C$cleared\n" unless ($cleared eq "");
     
	# Handle Ref. #
	print QIF "N$check\n" unless ($check eq "");
	print QIF "P$desc\n" unless ($desc eq "");

	# Replace underscores by blanks in transfer categories. (BW)  
	while (($cat =~ s/\[([^\]_]*)_([^\]]*)\]/\[$1 $2\]/g) != 0) {
	}

	print QIF "L$cat\n" unless (substr($cat, 0, 1) eq "\|");  # split txn
	# Handle splitting of txn
	if (substr($cat, 0, 1) eq "\|")	{
	    # Take: |Salary|2434.70|Tax-Fed|-0.34|Tax-FICA|-33.25|Tax-State|-5.78|
	    @SPLIT = split(/\|/, $cat);
	    print QIF "L$SPLIT[1]\n";   
	    # Pretend that the initial category is "the one"
	    for ($i = 1 ; $i <= $#SPLIT ; $i += 3) {
		$scat = $SPLIT[$i];
		print QIF "S$scat\n";
		$scom = $SPLIT[$i+1];
		print QIF "E$scom\n";
		$amount = $SPLIT[$i+2];
		print QIF "\$$amount\n";
	    }
	} else {
	}
	print QIF "M$com\n" unless ($com eq "");
	print QIF  "^\n";
    }
    
    close(QIF);

    return "ok";
}


1;				# need to return a true value


# ----------------------------------------------------------------------------
# $Log: export.pl,v $
# Revision 2.7  1997/04/23 18:07:28  curt
# Patched these to make importing/exporting more seamless.
#
# Revision 2.6  1997/01/18 03:28:43  curt
# Added "use strict" pragma to enforce good scoping habits.
#
# Revision 2.5  1996/12/17 14:53:55  curt
# Updated copyright date.
#
# Revision 2.4  1996/12/16 04:18:16  curt
# Continuing the great overhaul of December 1996.
#
# Revision 2.3  1996/12/11 18:33:34  curt
# Ran a spell checker.
#
# Revision 2.2  1996/07/13 02:57:42  curt
# Version 0.65
# Packing Changes
# Documentation changes
# Changes to handle a value in both debit and credit fields.
#
# Revision 2.1  1996/02/27  05:35:41  curt
# Just stumbling around a bit with cvs ... :-(
#
# Revision 2.0  1996/02/27  04:42:54  curt
# Initial 2.0 revision.  (See "Log" files for old history.)
