/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.ma.json;

import java.util.Map;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.ma.json.JsonHandler;
import net.sf.saxon.om.Function;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.serialize.charcode.UTF16CharacterSet;
import net.sf.saxon.str.StringView;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.type.StringToDouble;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.DoubleValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class JsonParser {
    public static final int ESCAPE = 1;
    public static final int ALLOW_ANY_TOP_LEVEL = 2;
    public static final int LIBERAL = 4;
    public static final int VALIDATE = 8;
    public static final int DEBUG = 16;
    public static final int DUPLICATES_RETAINED = 32;
    public static final int DUPLICATES_LAST = 64;
    public static final int DUPLICATES_FIRST = 128;
    public static final int DUPLICATES_REJECTED = 256;
    public static final int DUPLICATES_SPECIFIED = 480;
    public static final int NESTING_LIMIT = 10000;
    private static final String ERR_GRAMMAR = "FOJS0001";
    private static final String ERR_DUPLICATE = "FOJS0003";
    private static final String ERR_SCHEMA = "FOJS0004";
    private static final String ERR_OPTIONS = "FOJS0005";
    private static final String ERR_LIMITS = "FOJS0001";
    private Function numberParser = null;
    private int nesting = 0;

    public void parse(String input, int flags, JsonHandler handler, XPathContext context) throws XPathException {
        if (input.isEmpty()) {
            JsonParser.invalidJSON("An empty string is not valid JSON", "FOJS0001", 1);
        }
        JsonTokenizer t = new JsonTokenizer(input);
        t.next();
        try {
            this.parseConstruct(handler, t, flags, context);
        }
        catch (IllegalStateException e) {
            JsonParser.invalidJSON(e.getMessage(), "FOJS0001", t.lineNumber);
        }
        if (t.next() != JsonToken.EOF) {
            JsonParser.invalidJSON("Unexpected token beyond end of JSON input", "FOJS0001", t.lineNumber);
        }
    }

    public static int getFlags(Map<String, Sequence> options, boolean allowValidate, boolean isSchemaAware) throws XPathException {
        BooleanValue liberal;
        BooleanValue escape;
        int flags = 0;
        BooleanValue debug = (BooleanValue)options.get("debug");
        if (debug != null && debug.getBooleanValue()) {
            flags |= 0x10;
        }
        if ((escape = (BooleanValue)options.get("escape")) != null && escape.getBooleanValue()) {
            flags |= 1;
            if (options.get("fallback") != null) {
                throw new XPathException("Cannot specify a fallback function when escape=true", ERR_OPTIONS);
            }
        }
        if ((liberal = (BooleanValue)options.get("liberal")) != null && liberal.getBooleanValue()) {
            flags |= 4;
            flags |= 2;
        }
        boolean validate = false;
        if (allowValidate && (validate = ((BooleanValue)options.get("validate")).getBooleanValue())) {
            if (!isSchemaAware) {
                JsonParser.error("Requiring validation on non-schema-aware processor", ERR_SCHEMA);
            }
            flags |= 8;
        }
        if (options.containsKey("duplicates")) {
            String duplicates;
            switch (duplicates = ((StringValue)options.get("duplicates")).getStringValue()) {
                case "reject": {
                    flags |= 0x100;
                    break;
                }
                case "use-last": {
                    flags |= 0x40;
                    break;
                }
                case "use-first": {
                    flags |= 0x80;
                    break;
                }
                case "retain": {
                    flags |= 0x20;
                    break;
                }
                default: {
                    JsonParser.error("Invalid value for 'duplicates' option", ERR_OPTIONS);
                }
            }
            if (validate && "retain".equals(duplicates)) {
                JsonParser.error("The options validate:true and duplicates:retain cannot be used together", ERR_OPTIONS);
            }
        }
        return flags;
    }

    private void parseConstruct(JsonHandler handler, JsonTokenizer tokenizer, int flags, XPathContext context) throws XPathException {
        boolean debug;
        boolean bl = debug = (flags & 0x10) != 0;
        if (debug) {
            System.err.println("token:" + (Object)((Object)tokenizer.currentToken) + " :" + tokenizer.currentTokenValue);
        }
        if (this.nesting > 10000) {
            JsonParser.invalidJSON("Objects are too deeply nested", "FOJS0001", tokenizer.lineNumber);
        }
        JsonToken tok = tokenizer.currentToken;
        switch (tok) {
            case LCURLY: {
                ++this.nesting;
                this.parseObject(handler, tokenizer, flags, context);
                --this.nesting;
                break;
            }
            case LSQB: {
                ++this.nesting;
                this.parseArray(handler, tokenizer, flags, context);
                --this.nesting;
                break;
            }
            case NUMERIC_LITERAL: {
                String lexical = tokenizer.currentTokenValue.toString();
                AtomicValue d = this.parseNumericLiteral(lexical, flags, tokenizer.lineNumber, context);
                handler.writeNumeric(lexical, d);
                break;
            }
            case TRUE: {
                handler.writeBoolean(true);
                break;
            }
            case FALSE: {
                handler.writeBoolean(false);
                break;
            }
            case NULL: {
                handler.writeNull();
                break;
            }
            case STRING_LITERAL: {
                String literal = tokenizer.currentTokenValue.toString();
                handler.writeString(JsonParser.unescape(literal, flags, "FOJS0001", tokenizer.lineNumber));
                break;
            }
            default: {
                JsonParser.invalidJSON("Unexpected symbol: " + tokenizer.currentTokenValue, "FOJS0001", tokenizer.lineNumber);
            }
        }
    }

    private void parseObject(JsonHandler handler, JsonTokenizer tokenizer, int flags, XPathContext context) throws XPathException {
        boolean liberal = (flags & 4) != 0;
        handler.startMap();
        JsonToken tok = tokenizer.next();
        while (tok != JsonToken.RCURLY) {
            if (!(tok == JsonToken.STRING_LITERAL || tok == JsonToken.UNQUOTED_STRING && liberal)) {
                JsonParser.invalidJSON("Property name must be a string literal (found " + JsonParser.showToken(tok, tokenizer.currentTokenValue.toString() + ")"), "FOJS0001", tokenizer.lineNumber);
            }
            String key = tokenizer.currentTokenValue.toString();
            key = JsonParser.unescape(key, flags, "FOJS0001", tokenizer.lineNumber);
            String reEscaped = handler.reEscape(key);
            tok = tokenizer.next();
            if (tok != JsonToken.COLON) {
                JsonParser.invalidJSON("Missing colon after \"" + Err.wrap(key) + "\"", "FOJS0001", tokenizer.lineNumber);
            }
            tokenizer.next();
            boolean duplicate = handler.setKey(key, reEscaped);
            if (duplicate && (flags & 0x100) != 0) {
                JsonParser.invalidJSON("Duplicate key value \"" + Err.wrap(key) + "\"", ERR_DUPLICATE, tokenizer.lineNumber);
            }
            try {
                if (!duplicate || (flags & 0x60) != 0) {
                    this.parseConstruct(handler, tokenizer, flags, context);
                } else {
                    JsonHandler h2 = new JsonHandler();
                    h2.setContext(context);
                    this.parseConstruct(h2, tokenizer, flags, context);
                }
            }
            catch (StackOverflowError e) {
                JsonParser.invalidJSON("Objects are too deeply nested", "FOJS0001", tokenizer.lineNumber);
            }
            tok = tokenizer.next();
            if (tok == JsonToken.COMMA) {
                tok = tokenizer.next();
                if (tok != JsonToken.RCURLY) continue;
                if (liberal) break;
                JsonParser.invalidJSON("Trailing comma after entry in object", "FOJS0001", tokenizer.lineNumber);
                continue;
            }
            if (tok == JsonToken.RCURLY) break;
            JsonParser.invalidJSON("Unexpected token after value of \"" + Err.wrap(key) + "\" property", "FOJS0001", tokenizer.lineNumber);
        }
        handler.endMap();
    }

    private void parseArray(JsonHandler handler, JsonTokenizer tokenizer, int flags, XPathContext context) throws XPathException {
        boolean liberal = (flags & 4) != 0;
        handler.startArray();
        JsonToken tok = tokenizer.next();
        if (tok == JsonToken.RSQB) {
            handler.endArray();
            return;
        }
        while (true) {
            try {
                this.parseConstruct(handler, tokenizer, flags, context);
            }
            catch (StackOverflowError e) {
                JsonParser.invalidJSON("Arrays are too deeply nested", "FOJS0001", tokenizer.lineNumber);
            }
            tok = tokenizer.next();
            if (tok == JsonToken.COMMA) {
                tok = tokenizer.next();
                if (tok != JsonToken.RSQB) continue;
                if (liberal) break;
                JsonParser.invalidJSON("Trailing comma after entry in array", "FOJS0001", tokenizer.lineNumber);
                continue;
            }
            if (tok == JsonToken.RSQB) break;
            JsonParser.invalidJSON("Unexpected token (" + JsonParser.showToken(tok, tokenizer.currentTokenValue.toString()) + ") after entry in array", "FOJS0001", tokenizer.lineNumber);
        }
        handler.endArray();
    }

    private AtomicValue parseNumericLiteral(String token, int flags, int lineNumber, XPathContext context) throws XPathException {
        try {
            if ((flags & 4) == 0) {
                if (token.startsWith("+")) {
                    JsonParser.invalidJSON("Leading + sign not allowed: " + token, "FOJS0001", lineNumber);
                } else {
                    String t = token;
                    if (t.startsWith("-")) {
                        t = t.substring(1);
                    }
                    if (!(!t.startsWith("0") || t.equals("0") || t.startsWith("0.") || t.startsWith("0e") || t.startsWith("0E"))) {
                        JsonParser.invalidJSON("Redundant leading zeroes not allowed: " + token, "FOJS0001", lineNumber);
                    }
                    if (t.endsWith(".") || t.contains(".e") || t.contains(".E")) {
                        JsonParser.invalidJSON("Empty fractional part not allowed", "FOJS0001", lineNumber);
                    }
                    if (t.startsWith(".")) {
                        JsonParser.invalidJSON("Empty integer part not allowed", "FOJS0001", lineNumber);
                    }
                }
            }
            if (this.numberParser != null) {
                Sequence[] args = new Sequence[]{new StringValue(token)};
                Item result = SystemFunction.dynamicCall(this.numberParser, context, args).head();
                return (AtomicValue)result.head();
            }
            return new DoubleValue(StringToDouble.getInstance().stringToNumber(StringView.tidy(token)));
        }
        catch (NumberFormatException e) {
            JsonParser.invalidJSON("Invalid numeric literal: " + e.getMessage(), "FOJS0001", lineNumber);
            return DoubleValue.NaN;
        }
    }

    public static String unescape(String literal, int flags, String errorCode, int lineNumber) throws XPathException {
        if (literal.indexOf(92) < 0) {
            return literal;
        }
        boolean liberal = (flags & 4) != 0;
        StringBuilder buffer = new StringBuilder(literal.length());
        block13: for (int i = 0; i < literal.length(); ++i) {
            char c = literal.charAt(i);
            if (c == '\\') {
                if (i++ == literal.length() - 1) {
                    throw new XPathException("Invalid JSON escape: String " + Err.wrap(literal) + " ends in backslash", errorCode);
                }
                switch (literal.charAt(i)) {
                    case '\"': {
                        buffer.append('\"');
                        continue block13;
                    }
                    case '\\': {
                        buffer.append('\\');
                        continue block13;
                    }
                    case '/': {
                        buffer.append('/');
                        continue block13;
                    }
                    case 'b': {
                        buffer.append('\b');
                        continue block13;
                    }
                    case 'f': {
                        buffer.append('\f');
                        continue block13;
                    }
                    case 'n': {
                        buffer.append('\n');
                        continue block13;
                    }
                    case 'r': {
                        buffer.append('\r');
                        continue block13;
                    }
                    case 't': {
                        buffer.append('\t');
                        continue block13;
                    }
                    case 'u': {
                        try {
                            String hex = literal.substring(i + 1, i + 5);
                            int code = Integer.parseInt(hex, 16);
                            buffer.append((char)code);
                            i += 4;
                            continue block13;
                        }
                        catch (Exception e) {
                            if (liberal) {
                                buffer.append("\\u");
                                continue block13;
                            }
                            throw new XPathException("Invalid JSON escape: \\u must be followed by four hex characters", errorCode);
                        }
                    }
                    default: {
                        if (liberal) {
                            buffer.append(literal.charAt(i));
                            continue block13;
                        }
                        char next = literal.charAt(i);
                        String xx = next < '\u0100' ? next + "" : "x" + Integer.toHexString(next);
                        throw new XPathException("Unknown escape sequence \\" + xx, errorCode);
                    }
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }

    private static void error(String message, String code) throws XPathException {
        throw new XPathException(message, code);
    }

    private static void invalidJSON(String message, String code, int lineNumber) throws XPathException {
        JsonParser.error("Invalid JSON input on line " + lineNumber + ": " + message, code);
    }

    public static String showToken(JsonToken token, String currentTokenValue) {
        switch (token) {
            case LSQB: {
                return "[";
            }
            case RSQB: {
                return "]";
            }
            case LCURLY: {
                return "{";
            }
            case RCURLY: {
                return "}";
            }
            case STRING_LITERAL: {
                return "string (\"" + currentTokenValue + "\")";
            }
            case NUMERIC_LITERAL: {
                return "number (" + currentTokenValue + ")";
            }
            case TRUE: {
                return "true";
            }
            case FALSE: {
                return "false";
            }
            case NULL: {
                return "null";
            }
            case COLON: {
                return ":";
            }
            case COMMA: {
                return ",";
            }
            case EOF: {
                return "<eof>";
            }
        }
        return "<" + (Object)((Object)token) + ">";
    }

    public void setNumberParser(Map<String, Sequence> options, XPathContext context) throws XPathException {
        Sequence val = options.get("number-parser");
        if (val != null) {
            Item fn = val.head();
            if (fn instanceof Function) {
                this.numberParser = (Function)fn;
                if (this.numberParser.getArity() != 1) {
                    throw new XPathException("Number-parser function must have arity=1", ERR_OPTIONS);
                }
                SpecificFunctionType required = new SpecificFunctionType(new SequenceType[]{SequenceType.SINGLE_STRING}, SequenceType.SINGLE_ATOMIC);
                if (!required.matches(this.numberParser, context.getConfiguration().getTypeHierarchy())) {
                    throw new XPathException("Number-parser function does not match the required type", ERR_OPTIONS);
                }
            } else {
                throw new XPathException("Value of option 'number-parser' is not a function", ERR_OPTIONS);
            }
        }
    }

    private static class JsonTokenizer {
        public final String input;
        public int position;
        public int lineNumber = 1;
        public JsonToken currentToken;
        public StringBuilder currentTokenValue = new StringBuilder(64);

        JsonTokenizer(String input) {
            this.input = input;
            this.position = 0;
            if (!input.isEmpty() && input.charAt(0) == '\ufeff') {
                ++this.position;
            }
        }

        public JsonToken next() throws XPathException {
            this.currentToken = this.readToken();
            return this.currentToken;
        }

        private JsonToken readToken() throws XPathException {
            char c;
            if (this.position >= this.input.length()) {
                return JsonToken.EOF;
            }
            boolean breakLoop = false;
            block26: do {
                char c2 = this.input.charAt(this.position);
                switch (c2) {
                    case '\n': 
                    case '\r': {
                        if (c2 != '\n' || this.position <= 0 || this.input.charAt(this.position) != '\n') {
                            ++this.lineNumber;
                        }
                        CSharp.emitCode("goto case ' ';");
                    }
                    case '\t': 
                    case ' ': {
                        if (++this.position < this.input.length()) continue block26;
                        return JsonToken.EOF;
                    }
                    default: {
                        breakLoop = true;
                    }
                }
            } while (!breakLoop);
            char ch = this.input.charAt(this.position++);
            switch (ch) {
                case '[': {
                    return JsonToken.LSQB;
                }
                case '{': {
                    return JsonToken.LCURLY;
                }
                case ']': {
                    return JsonToken.RSQB;
                }
                case '}': {
                    return JsonToken.RCURLY;
                }
                case '\"': {
                    this.currentTokenValue.setLength(0);
                    boolean afterBackslash = false;
                    while (true) {
                        char c3;
                        if (this.position >= this.input.length()) {
                            JsonParser.invalidJSON("Unclosed quotes in string literal", "FOJS0001", this.lineNumber);
                        }
                        if ((c3 = this.input.charAt(this.position++)) < ' ') {
                            JsonParser.invalidJSON("Unescaped control character (x" + Integer.toHexString(c3) + ")", "FOJS0001", this.lineNumber);
                        }
                        if (afterBackslash && c3 == 'u') {
                            try {
                                String hex = this.input.substring(this.position, this.position + 4);
                                Integer.parseInt(hex, 16);
                            }
                            catch (Exception e) {
                                JsonParser.invalidJSON("\\u must be followed by four hex characters", "FOJS0001", this.lineNumber);
                            }
                        }
                        if (c3 == '\"' && !afterBackslash) break;
                        this.currentTokenValue.append(c3);
                        afterBackslash = c3 == '\\' && !afterBackslash;
                    }
                    return JsonToken.STRING_LITERAL;
                }
                case ':': {
                    return JsonToken.COLON;
                }
                case ',': {
                    return JsonToken.COMMA;
                }
                case '+': 
                case '-': 
                case '.': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    this.currentTokenValue.setLength(0);
                    this.currentTokenValue.append(ch);
                    if (this.position < this.input.length()) {
                        char c4;
                        while ((c4 = this.input.charAt(this.position)) >= '0' && c4 <= '9' || c4 == '-' || c4 == '+' || c4 == '.' || c4 == 'e' || c4 == 'E') {
                            this.currentTokenValue.append(c4);
                            if (++this.position < this.input.length()) continue;
                            break;
                        }
                    }
                    return JsonToken.NUMERIC_LITERAL;
                }
            }
            if (NameChecker.isNCNameChar(ch)) {
                String val;
                char c5;
                this.currentTokenValue.setLength(0);
                this.currentTokenValue.append(ch);
                while (this.position < this.input.length() && NameChecker.isNCNameChar(c5 = this.input.charAt(this.position))) {
                    this.currentTokenValue.append(c5);
                    ++this.position;
                }
                switch (val = this.currentTokenValue.toString()) {
                    case "true": {
                        return JsonToken.TRUE;
                    }
                    case "false": {
                        return JsonToken.FALSE;
                    }
                    case "null": {
                        return JsonToken.NULL;
                    }
                }
                return JsonToken.UNQUOTED_STRING;
            }
            String s = UTF16CharacterSet.isSurrogate(c = this.input.charAt(--this.position)) ? "" : " '" + c + "'";
            JsonParser.invalidJSON("Unexpected character" + s + " (\\u" + Integer.toHexString(c) + ") at position " + this.position, "FOJS0001", this.lineNumber);
            return JsonToken.EOF;
        }
    }

    public static enum JsonToken {
        LSQB,
        RSQB,
        LCURLY,
        RCURLY,
        STRING_LITERAL,
        NUMERIC_LITERAL,
        TRUE,
        FALSE,
        NULL,
        COLON,
        COMMA,
        UNQUOTED_STRING,
        EOF;

    }
}

