/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;

public class SquiggleUnderlineHighlightPainter
extends DefaultHighlighter.DefaultHighlightPainter {
    private static final int AMT = 2;

    public SquiggleUnderlineHighlightPainter(Color color) {
        super(color);
    }

    public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
        Color color = this.getColor();
        if (color == null) {
            graphics.setColor(jTextComponent.getSelectionColor());
        } else {
            graphics.setColor(color);
        }
        if (n == view.getStartOffset() && n2 == view.getEndOffset()) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            this.paintSquiggle(graphics, rectangle);
            return rectangle;
        }
        try {
            Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
            Rectangle rectangle = shape2 instanceof Rectangle ? (Rectangle)shape2 : shape2.getBounds();
            this.paintSquiggle(graphics, rectangle);
            return rectangle;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected void paintSquiggle(Graphics graphics, Rectangle rectangle) {
        int n = rectangle.y + rectangle.height - 2;
        int n2 = -2;
        for (int i = rectangle.x; i < rectangle.x + rectangle.width; i += 2) {
            graphics.drawLine(i, n, i + 2, n + n2);
            n += n2;
            n2 = -n2;
        }
    }
}

