/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ASUtils;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.DBTree;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.dbtree.DBTreeModel;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.swingui.ProgressWatcher;
import ca.sqlpower.swingui.SPSwingWorker;
import ca.sqlpower.swingui.SwingWorkerRegistry;
import ca.sqlpower.swingui.event.TaskTerminationEvent;
import ca.sqlpower.swingui.event.TaskTerminationListener;
import ca.sqlpower.util.Monitorable;
import ca.sqlpower.util.SQLPowerUtils;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;

public class RefreshAction
extends AbstractArchitectAction {
    private DBTree dbTree;

    public RefreshAction(ArchitectSwingSession session) {
        super(session, "Refresh", "Refreshes the tree to match current structure in the selected database", (Icon)new ImageIcon(RefreshAction.class.getResource("/icons/database_refresh.png")));
    }

    public RefreshAction(ArchitectSwingSession session, DBTree tree) {
        super(session, "Refresh", "Refreshes the tree to match current structure in the selected database", (Icon)new ImageIcon(RefreshAction.class.getResource("/icons/database_refresh.png")));
        this.dbTree = tree;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.dbTree == null) {
            this.dbTree = this.getSession().getDBTree();
        }
        HashSet<SQLDatabase> databasesToRefresh = new HashSet<SQLDatabase>();
        for (TreePath tp : this.dbTree.getSelectionPaths()) {
            SQLObject so = (SQLObject)tp.getLastPathComponent();
            SQLDatabase db = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)so, SQLDatabase.class);
            if (db == null || db.isPlayPenDatabase()) continue;
            databasesToRefresh.add(db);
        }
        if (databasesToRefresh.isEmpty()) {
            JOptionPane.showMessageDialog(this.dbTree, "Please select a source database to refresh");
            return;
        }
        final RefreshMonitorableWorker worker = new RefreshMonitorableWorker(this.getSession(), (Window)SwingUtilities.getRoot(this.dbTree), databasesToRefresh);
        Thread thread = new Thread((Runnable)((Object)worker), "Refresh database worker");
        JProgressBar progressBar = new JProgressBar();
        progressBar.setIndeterminate(true);
        JLabel messageLabel = new JLabel("Refreshing selected databases.");
        ProgressWatcher.watchProgress((JProgressBar)progressBar, (Monitorable)worker, (JLabel)messageLabel);
        final JDialog dialog = new JDialog((Window)SwingUtilities.getRoot(this.dbTree), "Refresh");
        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref"));
        builder.setDefaultDialogBorder();
        builder.append((Component)messageLabel, 3);
        builder.nextLine();
        builder.append((Component)progressBar, 3);
        builder.nextLine();
        builder.append((Component)new JLabel(""), (Component)new JButton(new AbstractAction("Cancel"){

            @Override
            public void actionPerformed(ActionEvent e) {
                worker.kill();
            }
        }));
        dialog.add(builder.getPanel());
        worker.addTaskTerminationListener(new TaskTerminationListener(){

            public void taskFinished(TaskTerminationEvent e) {
                dialog.dispose();
            }
        });
        dialog.pack();
        dialog.setModal(true);
        dialog.setLocationRelativeTo(this.getSession().getArchitectFrame());
        thread.start();
        dialog.setVisible(true);
    }

    private class RefreshMonitorableWorker
    extends SPSwingWorker {
        private final Set<SQLDatabase> databasesToRefresh;
        private final Component parent;
        private SQLDatabase dbBeingRefreshed;

        public RefreshMonitorableWorker(SwingWorkerRegistry registry, Component parent, Set<SQLDatabase> dbs) {
            super(registry);
            this.databasesToRefresh = new HashSet<SQLDatabase>();
            this.parent = parent;
            this.databasesToRefresh.addAll(dbs);
            this.setJobSize(null);
        }

        protected String getMessageImpl() {
            if (this.dbBeingRefreshed == null) {
                return "Refreshing selected databases.";
            }
            return "Refreshing database " + this.dbBeingRefreshed.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doStuff() throws Exception {
            this.setProgress(0);
            try {
                Iterator<SQLDatabase> i$ = this.databasesToRefresh.iterator();
                while (i$.hasNext()) {
                    SQLDatabase db;
                    this.dbBeingRefreshed = db = i$.next();
                    db.refresh();
                    this.increaseProgress();
                }
            }
            catch (SQLObjectException ex) {
                this.setDoStuffException(ex);
            }
            finally {
                this.dbBeingRefreshed = null;
            }
        }

        public void cleanup() throws Exception {
            ((DBTreeModel)RefreshAction.this.getSession().getDBTree().getModel()).refreshTreeStructure();
            if (this.getDoStuffException() != null) {
                ASUtils.showExceptionDialogNoReport(this.parent, "Refresh failed", this.getDoStuffException());
            }
        }
    }
}

