/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.label;

import javax.swing.ImageIcon;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.label.FreeColLabel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.util.Utils;

public class AbstractGoodsLabel
extends FreeColLabel {
    private final ImageLibrary lib;
    private final AbstractGoods abstractGoods;
    private AmountType amountType = AmountType.DEFAULT;

    public AbstractGoodsLabel(FreeColClient freeColClient, AbstractGoods abstractGoods) {
        super(new ImageIcon(freeColClient.getGUI().getFixedImageLibrary().getScaledGoodsTypeImage(abstractGoods.getType())));
        this.lib = freeColClient.getGUI().getFixedImageLibrary();
        this.abstractGoods = abstractGoods;
        this.setToolTipText(Messages.getName(abstractGoods));
    }

    protected ImageLibrary getImageLibrary() {
        return this.lib;
    }

    public void setAmountType(AmountType amountType) {
        this.amountType = amountType == null ? AmountType.DEFAULT : amountType;
    }

    public boolean isSuperFullChosen() {
        return this.amountType == AmountType.SUPER_FULL;
    }

    public boolean isPartialChosen() {
        return this.amountType == AmountType.PARTIAL;
    }

    public boolean isFullChosen() {
        return this.amountType == AmountType.FULL;
    }

    public AbstractGoods getAbstractGoods() {
        return this.abstractGoods;
    }

    public GoodsType getType() {
        return this.abstractGoods.getType();
    }

    public int getAmount() {
        return this.abstractGoods.getAmount();
    }

    public void setAmount(int amount) {
        this.abstractGoods.setAmount(amount);
    }

    public void setDefaultAmount() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof AbstractGoodsLabel) {
            AbstractGoodsLabel other = (AbstractGoodsLabel)o;
            return Utils.equals(this.abstractGoods, other.abstractGoods) && this.amountType == other.amountType;
        }
        return false;
    }

    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + Utils.hashCode(this.abstractGoods);
        hash = 31 * hash + this.amountType.ordinal();
        return hash;
    }

    public static enum AmountType {
        DEFAULT,
        PARTIAL,
        FULL,
        SUPER_FULL;

    }
}

