/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.profile;

import dotty.tools.dotc.profile.FileUtils$;
import dotty.tools.dotc.profile.FileUtils$AsyncBufferedWriter$;
import dotty.tools.dotc.profile.FileUtils$AsyncBufferedWriter$background$;
import java.io.Writer;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.LazyVals;
import scala.util.Properties$;

public final class FileUtils {
    public static LineWriter newAsyncBufferedWriter(Path path, Charset charset, OpenOption[] openOptionArray, boolean bl) {
        return FileUtils$.MODULE$.newAsyncBufferedWriter(path, charset, openOptionArray, bl);
    }

    public static LineWriter newAsyncBufferedWriter(Writer writer, boolean bl) {
        return FileUtils$.MODULE$.newAsyncBufferedWriter(writer, bl);
    }

    public static Charset newAsyncBufferedWriter$default$2() {
        return FileUtils$.MODULE$.newAsyncBufferedWriter$default$2();
    }

    public static OpenOption[] newAsyncBufferedWriter$default$3() {
        return FileUtils$.MODULE$.newAsyncBufferedWriter$default$3();
    }

    public static boolean newAsyncBufferedWriter$default$4() {
        return FileUtils$.MODULE$.newAsyncBufferedWriter$default$4();
    }

    public static class AsyncBufferedWriter
    extends LineWriter {
        private static final VarHandle background$lzy1$lzyHandle = MethodHandles.lookup().findVarHandle(AsyncBufferedWriter.class, "background$lzy1", Object.class);
        private final Writer underlying;
        private final int bufferSize;
        private CharBuffer current;
        private volatile Object background$lzy1;

        public static int $lessinit$greater$default$2() {
            return FileUtils$AsyncBufferedWriter$.MODULE$.$lessinit$greater$default$2();
        }

        public AsyncBufferedWriter(Writer underlying, int bufferSize) {
            this.underlying = underlying;
            this.bufferSize = bufferSize;
            this.current = this.allocate();
        }

        public Writer underlying() {
            return this.underlying;
        }

        @Override
        public void write(int c) {
            super.write(c);
        }

        private void flushAsync() {
            this.background().ensureProcessed(this.current);
            this.current = this.allocate();
        }

        private CharBuffer allocate() {
            CharBuffer reused = this.background().reuseBuffer();
            if (reused == null) {
                return CharBuffer.allocate(this.bufferSize);
            }
            this.background().reuseBuffer_$eq(null);
            reused.clear();
            return reused;
        }

        @Override
        public void write(char[] cbuf, int initialOffset, int initialLength) {
            int offset = initialOffset;
            int length = initialLength;
            while (length > 0) {
                int capacity = this.current.remaining();
                if (length <= capacity) {
                    this.current.put(cbuf, offset, length);
                    length = 0;
                    continue;
                }
                this.current.put(cbuf, offset, capacity);
                this.flushAsync();
                length -= capacity;
                offset += capacity;
            }
        }

        @Override
        public void write(String s, int initialOffset, int initialLength) {
            int offset = initialOffset;
            int length = initialLength;
            while (length > 0) {
                int capacity = this.current.remaining();
                if (length <= capacity) {
                    this.current.put(s, offset, offset + length);
                    length = 0;
                    continue;
                }
                this.current.put(s, offset, offset + capacity);
                this.flushAsync();
                length -= capacity;
                offset += capacity;
            }
        }

        @Override
        public void newLine() {
            this.write(Properties$.MODULE$.lineSeparator());
        }

        @Override
        public void flush() {
            this.flushAsync();
        }

        @Override
        public void close() {
            this.background().ensureProcessed(this.current);
            this.background().ensureProcessed(FileUtils$AsyncBufferedWriter$.dotty$tools$dotc$profile$FileUtils$AsyncBufferedWriter$$$Close);
            this.current = null;
            Await$.MODULE$.result((Awaitable)this.background().asyncStatus().future(), (Duration)Duration$.MODULE$.Inf());
            this.underlying().close();
        }

        private final FileUtils$AsyncBufferedWriter$background$ background() {
            Object object = this.background$lzy1;
            if (object instanceof FileUtils$AsyncBufferedWriter$background$) {
                return (FileUtils$AsyncBufferedWriter$background$)object;
            }
            if (object == LazyVals.NullValue$.MODULE$) {
                return null;
            }
            return (FileUtils$AsyncBufferedWriter$background$)this.background$lzyINIT1();
        }

        private Object background$lzyINIT1() {
            Object object;
            block8: {
                while (true) {
                    if ((object = this.background$lzy1) == null) {
                        if (!background$lzy1$lzyHandle.compareAndSet(this, null, LazyVals.Evaluating$.MODULE$)) continue;
                        Object object2 = null;
                        FileUtils$AsyncBufferedWriter$background$ fileUtils$AsyncBufferedWriter$background$ = null;
                        try {
                            fileUtils$AsyncBufferedWriter$background$ = new FileUtils$AsyncBufferedWriter$background$(this);
                            object2 = fileUtils$AsyncBufferedWriter$background$ == null ? LazyVals.NullValue$.MODULE$ : fileUtils$AsyncBufferedWriter$background$;
                        }
                        finally {
                            if (!background$lzy1$lzyHandle.compareAndSet(this, LazyVals.Evaluating$.MODULE$, object2)) {
                                LazyVals.Waiting waiting = (LazyVals.Waiting)this.background$lzy1;
                                background$lzy1$lzyHandle.compareAndSet(this, waiting, object2);
                                waiting.countDown();
                            }
                        }
                        return fileUtils$AsyncBufferedWriter$background$;
                    }
                    if (!(object instanceof LazyVals.LazyValControlState)) break block8;
                    if (object == LazyVals.Evaluating$.MODULE$) {
                        background$lzy1$lzyHandle.compareAndSet(this, object, new LazyVals.Waiting());
                        continue;
                    }
                    if (!(object instanceof LazyVals.Waiting)) break;
                    ((LazyVals.Waiting)object).await();
                }
                return null;
            }
            return object;
        }
    }

    public static abstract class LineWriter
    extends Writer {
        public abstract void newLine();
    }

    public static class ThreadsafeWriter
    extends LineWriter {
        private final AsyncBufferedWriter underlying;

        public ThreadsafeWriter(AsyncBufferedWriter underlying) {
            this.underlying = underlying;
            this.lock = underlying;
        }

        public AsyncBufferedWriter underlying() {
            return this.underlying;
        }

        @Override
        public void write(int c) {
            Object object = this.lock;
            synchronized (object) {
                this.underlying().write(c);
            }
        }

        @Override
        public void write(char[] cbuf) {
            Object object = this.lock;
            synchronized (object) {
                this.underlying().write(cbuf);
            }
        }

        @Override
        public void write(char[] cbuf, int off, int len) {
            Object object = this.lock;
            synchronized (object) {
                this.underlying().write(cbuf, off, len);
            }
        }

        @Override
        public void write(String str) {
            Object object = this.lock;
            synchronized (object) {
                this.underlying().write(str);
            }
        }

        @Override
        public void write(String str, int off, int len) {
            Object object = this.lock;
            synchronized (object) {
                this.underlying().write(str, off, len);
            }
        }

        @Override
        public void flush() {
            Object object = this.lock;
            synchronized (object) {
                this.underlying().flush();
            }
        }

        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.underlying().close();
            }
        }

        @Override
        public void newLine() {
            Object object = this.lock;
            synchronized (object) {
                this.underlying().newLine();
            }
        }
    }
}

