/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.dotc.transform.init;

import dotty.tools.dotc.ast.Trees;
import dotty.tools.dotc.core.Contexts;
import dotty.tools.dotc.core.Decorators$;
import dotty.tools.dotc.core.Types;
import dotty.tools.dotc.printing.Formatting$ShownDef$Show$;
import dotty.tools.dotc.printing.Formatting$ShownDef$Shown$;
import dotty.tools.dotc.printing.SyntaxHighlighting$;
import dotty.tools.dotc.util.SourcePosition;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.StringContext$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.StringBuilder;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichChar$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class Trace$
implements Serializable {
    private static final Vector<Trees.Tree<Types.Type>> empty;
    private static final String EMPTY_PADDING;
    private static final String CONNECTING_INDENT;
    private static final String CHILD;
    private static final String LAST_CHILD;
    public static final Trace$ MODULE$;

    private Trace$() {
    }

    static {
        MODULE$ = new Trace$();
        empty = scala.package$.MODULE$.Vector().empty();
        EMPTY_PADDING = "    ";
        CONNECTING_INDENT = "\u2502   ";
        CHILD = "\u251c\u2500\u2500 ";
        LAST_CHILD = "\u2514\u2500\u2500 ";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Trace$.class);
    }

    public Vector<Trees.Tree<Types.Type>> empty() {
        return empty;
    }

    public String EMPTY_PADDING() {
        return EMPTY_PADDING;
    }

    public String CONNECTING_INDENT() {
        return CONNECTING_INDENT;
    }

    public String CHILD() {
        return CHILD;
    }

    public String LAST_CHILD() {
        return LAST_CHILD;
    }

    public Vector<Trees.Tree<Types.Type>> add(Vector<Trees.Tree<Types.Type>> trace2, Trees.Tree<Types.Type> node) {
        return (Vector)trace2.$colon$plus(node);
    }

    public Vector<Trees.Tree<Types.Type>> toVector(Vector<Trees.Tree<Types.Type>> trace2) {
        return trace2;
    }

    public Vector<Trees.Tree<Types.Type>> $plus$plus(Vector<Trees.Tree<Types.Type>> trace2, Vector<Trees.Tree<Types.Type>> trace22) {
        return (Vector)trace2.$plus$plus(trace22);
    }

    public String show(Vector<Trees.Tree<Types.Type>> trace2, Contexts.Context ctx) {
        return this.buildStacktrace(trace2, "Calling trace:" + System.lineSeparator(), ctx);
    }

    public Trees.Tree<Types.Type> position(Vector<Trees.Tree<Types.Type>> trace2) {
        return (Trees.Tree)trace2.last();
    }

    public Vector<Trees.Tree<Types.Type>> trace(Vector<Trees.Tree<Types.Type>> t) {
        return t;
    }

    public String buildStacktrace(Vector<Trees.Tree<Types.Type>> trace2, String preamble, Contexts.Context x$3) {
        if (trace2.isEmpty()) {
            return "";
        }
        IntRef lastLineNum = IntRef.create((int)-1);
        ObjectRef lines = ObjectRef.create((Object)new ArrayBuffer());
        trace2.foreach((Function1)(JProcedure1 & Serializable)tree -> {
            String positionMarkerLine;
            String line;
            boolean isLastTraceItem = tree == trace2.last();
            SourcePosition pos = tree.sourcePos(x$3);
            if (pos.source().exists()) {
                String loc = "[ " + pos.source().file().name() + ":" + (pos.line() + 1) + " ]";
                String code = SyntaxHighlighting$.MODULE$.highlight(pos.lineContent().trim(), x$3);
                v0 = Decorators$.MODULE$.i(StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", "\\t", ""})), (Seq<Object>)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)code), Formatting$ShownDef$Shown$.MODULE$.given_Conversion_A_Shown(Formatting$ShownDef$Show$.MODULE$.given_Show_String()).apply((Object)loc)}), x$3);
            } else {
                Trees.Tree tree2 = tree;
                if (tree2 instanceof Trees.DefTree) {
                    Trees.DefTree defTree;
                    Trees.DefTree defDef = defTree = (Trees.DefTree)((Object)tree2);
                    v0 = ((Trees.Tree)((Object)defDef)).symbol(x$3).showFullName(x$3);
                } else {
                    Object object = Predef$.MODULE$.refArrayOps((Object[])tree.show(x$3).split(System.lineSeparator(), 2));
                    v0 = line = (String)ArrayOps$.MODULE$.head$extension(object);
                }
            }
            Object object = pos.exists() && pos.source().exists() ? (isLastTraceItem ? MODULE$.EMPTY_PADDING() : MODULE$.CONNECTING_INDENT()) + MODULE$.positionMarker(pos) : (positionMarkerLine = "");
            if (lastLineNum$1.elem >= 0 && lastLineNum$1.elem == pos.line()) {
                ((ArrayBuffer)lines$1.elem).dropRightInPlace(1);
            }
            String prefix = isLastTraceItem ? MODULE$.LAST_CHILD() : MODULE$.CHILD();
            ((ArrayBuffer)lines$1.elem).$plus$eq((Object)(prefix + line + System.lineSeparator() + positionMarkerLine));
            lastLineNum$1.elem = pos.line();
        });
        StringBuilder sb = new StringBuilder();
        ((ArrayBuffer)lines.elem).foreach((Function1 & Serializable)line -> sb.append(line));
        return preamble + sb.toString();
    }

    private String positionMarker(SourcePosition pos) {
        int trimmed = StringOps$.MODULE$.takeWhile$extension(Predef$.MODULE$.augmentString(pos.source().lineContent(pos.start())), (Function1 & Serializable)c -> RichChar$.MODULE$.isWhitespace$extension(Predef$.MODULE$.charWrapper(BoxesRunTime.unboxToChar((Object)c)))).length();
        String padding = pos.startColumnPadding().substring(trimmed);
        String carets = pos.startLine() == pos.endLine() ? StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("^"), package$.MODULE$.max(1, pos.endColumn() - pos.startColumn())) : "^";
        return padding + carets + System.lineSeparator();
    }
}

