/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.record;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.minidns.edns.EdnsOption;
import org.minidns.record.Data;
import org.minidns.record.Record;

public class OPT
extends Data {
    public final List<EdnsOption> variablePart;

    public OPT() {
        this(Collections.emptyList());
    }

    public OPT(List<EdnsOption> variablePart) {
        this.variablePart = Collections.unmodifiableList(variablePart);
    }

    public static OPT parse(DataInputStream dis, int payloadLength) throws IOException {
        List<EdnsOption> variablePart;
        if (payloadLength == 0) {
            variablePart = Collections.emptyList();
        } else {
            int payloadLeft = payloadLength;
            variablePart = new ArrayList<EdnsOption>(4);
            while (payloadLeft > 0) {
                int optionCode = dis.readUnsignedShort();
                int optionLength = dis.readUnsignedShort();
                byte[] optionData = new byte[optionLength];
                dis.read(optionData);
                EdnsOption ednsOption = EdnsOption.parse(optionCode, optionData);
                variablePart.add(ednsOption);
                assert ((payloadLeft -= 4 + optionLength) >= 0);
            }
        }
        return new OPT(variablePart);
    }

    @Override
    public Record.TYPE getType() {
        return Record.TYPE.OPT;
    }

    @Override
    protected void serialize(DataOutputStream dos) throws IOException {
        for (EdnsOption endsOption : this.variablePart) {
            endsOption.writeToDos(dos);
        }
    }
}

