/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.fonts.encoding;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import org.pentaho.reporting.libraries.fonts.encoding.Encoding;
import org.pentaho.reporting.libraries.fonts.encoding.External8BitEncodingCore;
import org.pentaho.reporting.libraries.fonts.encoding.External8BitEncodingData;
import org.pentaho.reporting.libraries.resourceloader.Resource;
import org.pentaho.reporting.libraries.resourceloader.ResourceCreationException;
import org.pentaho.reporting.libraries.resourceloader.ResourceData;
import org.pentaho.reporting.libraries.resourceloader.ResourceFactory;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceLoadingException;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.pentaho.reporting.libraries.resourceloader.SimpleResource;

public class EncodingFactory
implements ResourceFactory {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource create(ResourceManager manager, ResourceData data, ResourceKey context) throws ResourceCreationException, ResourceLoadingException {
        SimpleResource simpleResource;
        InputStream in = data.getResourceAsStream(manager);
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            Object ob = oin.readObject();
            if (!(ob instanceof External8BitEncodingData)) {
                throw new ResourceCreationException("This is no 8Bit Encoding data");
            }
            External8BitEncodingData encData = (External8BitEncodingData)ob;
            External8BitEncodingCore encCore = new External8BitEncodingCore(encData);
            simpleResource = new SimpleResource(data.getKey(), (Object)encCore, this.getFactoryType(), data.getVersion(manager));
        }
        catch (Throwable throwable) {
            try {
                oin.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ResourceLoadingException("Failed to load resource", (Exception)e);
            }
            catch (ClassNotFoundException e) {
                throw new ResourceCreationException("Missing class definition: Failed to create encoding.");
            }
        }
        oin.close();
        return simpleResource;
    }

    public Class getFactoryType() {
        return Encoding.class;
    }

    public void initializeDefaults() {
    }
}

