/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * require_extensions: GL_ARB_gpu_shader_fp64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * determinant(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf)) => 4.25571426lf
 * determinant(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf)) => -5.941131430000001lf
 */
#version 150
#extension GL_ARB_gpu_shader_fp64 : require

void main()
{
  double[distance(determinant(dmat4(-1.0lf, 1.77lf, 0.09lf, -0.91lf, -0.55lf, 0.62lf, -0.71lf, -1.82lf, -1.08lf, 0.48lf, -1.39lf, -1.43lf, 1.79lf, -1.35lf, -1.21lf, 0.72lf)), 4.25571426lf) <= 4.255714260000001e-05lf ? 1 : -1] array0;
  double[distance(determinant(dmat4(0.06lf, 1.6lf, 1.25lf, -0.16lf, 1.31lf, -0.32lf, 0.45lf, 0.45lf, 1.52lf, 0.51lf, 1.9lf, -0.88lf, -1.96lf, -1.84lf, -0.72lf, 0.39lf)), -5.941131430000001lf) <= 5.941131430000002e-05lf ? 1 : -1] array1;
  gl_FragColor = vec4(array0.length() + array1.length());
}
