/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (+ ivec4(-64, 72, 88, -76)) => ivec4(-64, 72, 88, -76)
 * (+ ivec4(64, 72, 88, 76)) => ivec4(64, 72, 88, 76)
 * (+ ivec4(-24, 40, -23, 64)) => ivec4(-24, 40, -23, 64)
 * (+ ivec4(24, 40, 23, 64)) => ivec4(24, 40, 23, 64)
 */
#version 120

void main()
{
  float[all(equal((+ ivec4(-64, 72, 88, -76)), ivec4(-64, 72, 88, -76))) ? 1 : -1] array0;
  float[all(equal((+ ivec4(64, 72, 88, 76)), ivec4(64, 72, 88, 76))) ? 1 : -1] array1;
  float[all(equal((+ ivec4(-24, 40, -23, 64)), ivec4(-24, 40, -23, 64))) ? 1 : -1] array2;
  float[all(equal((+ ivec4(24, 40, 23, 64)), ivec4(24, 40, 23, 64))) ? 1 : -1] array3;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
