/*
 * Decompiled with CFR 0.152.
 */
package com.projectlibre1.pm.calendar;

import com.projectlibre1.configuration.Settings;
import com.projectlibre1.pm.calendar.WorkRange;
import com.projectlibre1.pm.calendar.WorkRangeException;
import com.projectlibre1.strings.Messages;
import com.projectlibre1.util.DateTime;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

public class WorkingHours
implements Cloneable,
Serializable {
    static final long serialVersionUID = 83888849333431L;
    private static long MS_PER_MINUTE = 60000L;
    long duration = 0L;
    WorkRange[] workRange = new WorkRange[Settings.CALENDAR_INTERVALS];
    private static GregorianCalendar helper = DateTime.calendarInstance();
    private static WorkingHours defaultWorkingHours = null;
    private static WorkingHours nonStopWorkingHours = null;

    public Object clone() {
        WorkingHours workingHours = new WorkingHours();
        for (int i = 0; i < this.workRange.length; ++i) {
            workingHours.workRange[i] = this.workRange[i] == null ? null : (WorkRange)this.workRange[i].clone();
        }
        workingHours.duration = this.duration;
        return workingHours;
    }

    WorkingHours intersectWith(WorkingHours workingHours) {
        int n = 0;
        int n2 = 0;
        ArrayList<WorkRange> arrayList = new ArrayList<WorkRange>();
        while (n != this.workRange.length && n2 != workingHours.workRange.length) {
            long l;
            WorkRange workRange = this.workRange[n];
            WorkRange workRange2 = workingHours.workRange[n2];
            if (workRange == null || workRange2 == null) break;
            long l2 = Math.max(workRange.getStart(), workRange2.getStart());
            if (workRange.getEnd() < workRange2.getEnd()) {
                l = workRange.getEnd();
                ++n;
            } else {
                l = workRange2.getEnd();
                ++n2;
            }
            if (l <= l2) continue;
            try {
                arrayList.add(new WorkRange(l2, l));
            }
            catch (WorkRangeException workRangeException) {
                workRangeException.printStackTrace();
            }
        }
        WorkingHours workingHours2 = new WorkingHours();
        workingHours2.workRange = new WorkRange[arrayList.size()];
        arrayList.toArray(workingHours2.workRange);
        workingHours2.initialize();
        return workingHours2;
    }

    private static synchronized long getHoursAndMinutes(Date date) {
        helper.setTime(date);
        long l = 60L * (long)(24 + helper.get(11)) + (long)helper.get(12) - (long)date.getTimezoneOffset();
        return 60000L * (l %= 1440L);
    }

    public static synchronized long hourTime(int n) {
        helper.setTimeInMillis(0L);
        helper.set(11, n);
        return helper.getTimeInMillis();
    }

    public boolean setInterval(int n, Date date, Date date2) {
        if (date == null || date2 == null) {
            return false;
        }
        try {
            this.setInterval(n, WorkingHours.getHoursAndMinutes(date), WorkingHours.getHoursAndMinutes(date2));
            return true;
        }
        catch (WorkRangeException workRangeException) {
            workRangeException.printStackTrace();
            return false;
        }
    }

    public void setInterval(int n, long l, long l2) throws WorkRangeException {
        if (l == -1L || l2 == -1L) {
            this.workRange[n] = null;
        } else {
            GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
            gregorianCalendar.setTimeInMillis(l2);
            if (gregorianCalendar.get(11) == 0 && gregorianCalendar.get(12) == 0) {
                gregorianCalendar.add(11, 24);
                l2 = gregorianCalendar.getTimeInMillis();
            }
            this.workRange[n] = new WorkRange(l, l2);
        }
        this.initialize();
    }

    public WorkRange getInterval(int n) {
        return this.workRange[n];
    }

    public List getIntervals() {
        return Arrays.asList(this.workRange);
    }

    public WorkingHours() {
        for (int i = 0; i < this.workRange.length; ++i) {
            this.workRange[i] = null;
        }
    }

    void validate() throws WorkRangeException {
        int n;
        boolean bl = false;
        for (n = 0; n < this.workRange.length - 1; ++n) {
            if (this.workRange[n] == null) {
                bl = true;
                continue;
            }
            if (!bl) continue;
            throw new WorkRangeException(Messages.getString("WorkRangeException.RangeIncomplete"));
        }
        for (n = 0; n < this.workRange.length - 1; ++n) {
            for (int i = n + 1; i < this.workRange.length; ++i) {
                if (this.workRange[n] == null || this.workRange[n].isBefore(this.workRange[i])) continue;
                throw new WorkRangeException(Messages.getString("WorkRangeException.RangesMustBeOrdered"));
            }
        }
        this.initialize();
    }

    public long getDuration() {
        return this.duration;
    }

    void initialize() {
        this.duration = 0L;
        for (int i = 0; i < this.workRange.length; ++i) {
            if (this.workRange[i] == null) continue;
            this.duration += this.workRange[i].calcWorkingHours();
        }
    }

    public void setNonWorking() {
        this.duration = 0L;
    }

    public long calcTimeAtRemainingWork(long l) {
        long l2 = 0L;
        for (int i = this.workRange.length - 1; i >= 0; --i) {
            if (this.workRange[i] == null || (l2 += this.workRange[i].calcWorkingHours()) < l) continue;
            return this.workRange[i].getStart() + (l2 - l);
        }
        return -1L;
    }

    public long calcTimeAtWork(long l) {
        long l2 = 0L;
        for (int i = 0; i < this.workRange.length; ++i) {
            if (this.workRange[i] == null || (l2 += this.workRange[i].calcWorkingHours()) < l) continue;
            return this.workRange[i].getEnd() - (l2 - l);
        }
        return -1L;
    }

    public long calcWorkTimeAfter(long l) {
        long l2 = 0L;
        for (int i = 0; i < this.workRange.length; ++i) {
            if (this.workRange[i] == null || this.workRange[i].getEnd() <= l) continue;
            l2 += this.workRange[i].getEnd() - Math.max(l, this.workRange[i].getStart());
        }
        return l2;
    }

    public long calcWorkTimeBefore(long l) {
        return this.duration - this.calcWorkTimeAfter(l);
    }

    public long calcWorkTime(long l, boolean bl) {
        return bl ? this.calcWorkTimeAfter(l) : this.calcWorkTimeBefore(l);
    }

    public String toString() {
        Object object = "WorkingHours\n";
        for (int i = 0; i < this.workRange.length; ++i) {
            if (this.workRange[i] == null) continue;
            if (((String)object).length() != 0) {
                object = (String)object + "\n";
            }
            object = (String)object + "Range " + i + " - " + String.valueOf(this.workRange[i]);
        }
        return object;
    }

    public static WorkingHours getDefault() {
        if (defaultWorkingHours == null) {
            defaultWorkingHours = new WorkingHours();
            try {
                GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
                gregorianCalendar.setTimeInMillis(0L);
                gregorianCalendar.set(11, 8);
                long l = gregorianCalendar.getTimeInMillis();
                gregorianCalendar.set(11, 12);
                long l2 = gregorianCalendar.getTimeInMillis();
                defaultWorkingHours.setInterval(0, l, l2);
                gregorianCalendar.set(11, 13);
                l = gregorianCalendar.getTimeInMillis();
                gregorianCalendar.set(11, 17);
                l2 = gregorianCalendar.getTimeInMillis();
                defaultWorkingHours.setInterval(1, l, l2);
            }
            catch (WorkRangeException workRangeException) {
                workRangeException.printStackTrace();
            }
        }
        return defaultWorkingHours;
    }

    public static WorkingHours getNonStop() {
        if (nonStopWorkingHours == null) {
            nonStopWorkingHours = new WorkingHours();
            try {
                GregorianCalendar gregorianCalendar = DateTime.calendarInstance();
                gregorianCalendar.setTimeInMillis(0L);
                gregorianCalendar.set(11, 0);
                long l = gregorianCalendar.getTimeInMillis();
                nonStopWorkingHours.setInterval(0, l, l);
            }
            catch (WorkRangeException workRangeException) {
                workRangeException.printStackTrace();
            }
        }
        return nonStopWorkingHours;
    }

    public boolean equals(Object object) {
        if (!(object instanceof WorkingHours)) {
            return false;
        }
        if (this == object) {
            return true;
        }
        WorkingHours workingHours = (WorkingHours)object;
        for (int i = 0; i < this.workRange.length; ++i) {
            if (!(this.workRange[i] != null ? !this.workRange[i].equals(workingHours.workRange[i]) : workingHours.workRange[i] != null)) continue;
            return false;
        }
        return true;
    }

    public boolean hasHours() {
        this.duration = 0L;
        for (int i = 0; i < this.workRange.length; ++i) {
            if (this.workRange[i] == null) continue;
            return true;
        }
        return false;
    }
}

