/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1StreamParser;
import org.bouncycastle.asn1.BERApplicationSpecificParser;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.BEROctetStringParser;
import org.bouncycastle.asn1.BERSequenceParser;
import org.bouncycastle.asn1.BERSetParser;
import org.bouncycastle.asn1.BERTaggedObjectParser;
import org.bouncycastle.asn1.DERApplicationSpecific;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERBoolean;
import org.bouncycastle.asn1.DEREnumerated;
import org.bouncycastle.asn1.DERExternal;
import org.bouncycastle.asn1.DERExternalParser;
import org.bouncycastle.asn1.DERFactory;
import org.bouncycastle.asn1.DERGeneralString;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERNumericString;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERT61String;
import org.bouncycastle.asn1.DERTags;
import org.bouncycastle.asn1.DERUTCTime;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.DERUnknownTag;
import org.bouncycastle.asn1.DERVisibleString;
import org.bouncycastle.asn1.DefiniteLengthInputStream;
import org.bouncycastle.asn1.IndefiniteLengthInputStream;
import org.bouncycastle.asn1.LazyDERSequence;
import org.bouncycastle.util.io.Streams;

public class ASN1InputStream
extends FilterInputStream
implements DERTags {
    private final int limit;
    private final boolean lazyEvaluate;

    public ASN1InputStream(InputStream inputStream) {
        this(inputStream, Integer.MAX_VALUE);
    }

    public ASN1InputStream(byte[] byArray) {
        this(new ByteArrayInputStream(byArray), byArray.length);
    }

    public ASN1InputStream(byte[] byArray, boolean bl) {
        this(new ByteArrayInputStream(byArray), byArray.length, bl);
    }

    public ASN1InputStream(InputStream inputStream, int n) {
        this(inputStream, n, false);
    }

    public ASN1InputStream(InputStream inputStream, int n, boolean bl) {
        super(inputStream);
        this.limit = n;
        this.lazyEvaluate = bl;
    }

    protected int readLength() throws IOException {
        return ASN1InputStream.readLength(this, this.limit);
    }

    protected void readFully(byte[] byArray) throws IOException {
        if (Streams.readFully(this, byArray) != byArray.length) {
            throw new EOFException("EOF encountered in middle of object");
        }
    }

    protected DERObject buildObject(int n, int n2, int n3) throws IOException {
        boolean bl = (n & 0x20) != 0;
        DefiniteLengthInputStream definiteLengthInputStream = new DefiniteLengthInputStream(this, n3);
        if ((n & 0x40) != 0) {
            return new DERApplicationSpecific(bl, n2, definiteLengthInputStream.toByteArray());
        }
        if ((n & 0x80) != 0) {
            return new BERTaggedObjectParser(n, n2, definiteLengthInputStream).getDERObject();
        }
        if (bl) {
            switch (n2) {
                case 4: {
                    return new BERConstructedOctetString(this.buildDEREncodableVector((DefiniteLengthInputStream)definiteLengthInputStream).v);
                }
                case 16: {
                    if (this.lazyEvaluate) {
                        return new LazyDERSequence(definiteLengthInputStream.toByteArray());
                    }
                    return DERFactory.createSequence(this.buildDEREncodableVector(definiteLengthInputStream));
                }
                case 17: {
                    return DERFactory.createSet(this.buildDEREncodableVector(definiteLengthInputStream), false);
                }
                case 8: {
                    return new DERExternal(this.buildDEREncodableVector(definiteLengthInputStream));
                }
            }
            return new DERUnknownTag(true, n2, definiteLengthInputStream.toByteArray());
        }
        return ASN1InputStream.createPrimitiveDERObject(n2, definiteLengthInputStream.toByteArray());
    }

    ASN1EncodableVector buildEncodableVector() throws IOException {
        DERObject dERObject;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        while ((dERObject = this.readObject()) != null) {
            aSN1EncodableVector.add(dERObject);
        }
        return aSN1EncodableVector;
    }

    ASN1EncodableVector buildDEREncodableVector(DefiniteLengthInputStream definiteLengthInputStream) throws IOException {
        return new ASN1InputStream(definiteLengthInputStream).buildEncodableVector();
    }

    public DERObject readObject() throws IOException {
        int n = this.read();
        if (n <= 0) {
            if (n == 0) {
                throw new IOException("unexpected end-of-contents marker");
            }
            return null;
        }
        int n2 = ASN1InputStream.readTagNumber(this, n);
        boolean bl = (n & 0x20) != 0;
        int n3 = this.readLength();
        if (n3 < 0) {
            if (!bl) {
                throw new IOException("indefinite length primitive encoding encountered");
            }
            IndefiniteLengthInputStream indefiniteLengthInputStream = new IndefiniteLengthInputStream(this);
            if ((n & 0x40) != 0) {
                ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(indefiniteLengthInputStream, this.limit);
                return new BERApplicationSpecificParser(n2, aSN1StreamParser).getDERObject();
            }
            if ((n & 0x80) != 0) {
                return new BERTaggedObjectParser(n, n2, indefiniteLengthInputStream).getDERObject();
            }
            ASN1StreamParser aSN1StreamParser = new ASN1StreamParser(indefiniteLengthInputStream, this.limit);
            switch (n2) {
                case 4: {
                    return new BEROctetStringParser(aSN1StreamParser).getDERObject();
                }
                case 16: {
                    return new BERSequenceParser(aSN1StreamParser).getDERObject();
                }
                case 17: {
                    return new BERSetParser(aSN1StreamParser).getDERObject();
                }
                case 8: {
                    return new DERExternalParser(aSN1StreamParser).getDERObject();
                }
            }
            throw new IOException("unknown BER object encountered");
        }
        return this.buildObject(n, n2, n3);
    }

    static int readTagNumber(InputStream inputStream, int n) throws IOException {
        int n2 = n & 0x1F;
        if (n2 == 31) {
            n2 = 0;
            int n3 = inputStream.read();
            if ((n3 & 0x7F) == 0) {
                throw new IOException("corrupted stream - invalid high tag number found");
            }
            while (n3 >= 0 && (n3 & 0x80) != 0) {
                n2 |= n3 & 0x7F;
                n2 <<= 7;
                n3 = inputStream.read();
            }
            if (n3 < 0) {
                throw new EOFException("EOF found inside tag value.");
            }
            n2 |= n3 & 0x7F;
        }
        return n2;
    }

    static int readLength(InputStream inputStream, int n) throws IOException {
        int n2 = inputStream.read();
        if (n2 < 0) {
            throw new EOFException("EOF found when length expected");
        }
        if (n2 == 128) {
            return -1;
        }
        if (n2 > 127) {
            int n3 = n2 & 0x7F;
            if (n3 > 4) {
                throw new IOException("DER length more than 4 bytes: " + n3);
            }
            n2 = 0;
            for (int i = 0; i < n3; ++i) {
                int n4 = inputStream.read();
                if (n4 < 0) {
                    throw new EOFException("EOF found reading length");
                }
                n2 = (n2 << 8) + n4;
            }
            if (n2 < 0) {
                throw new IOException("corrupted stream - negative length found");
            }
            if (n2 >= n) {
                throw new IOException("corrupted stream - out of bounds length found");
            }
        }
        return n2;
    }

    static DERObject createPrimitiveDERObject(int n, byte[] byArray) {
        switch (n) {
            case 3: {
                byte by = byArray[0];
                byte[] byArray2 = new byte[byArray.length - 1];
                System.arraycopy(byArray, 1, byArray2, 0, byArray.length - 1);
                return new DERBitString(byArray2, (int)by);
            }
            case 30: {
                return new DERBMPString(byArray);
            }
            case 1: {
                return new DERBoolean(byArray);
            }
            case 10: {
                return new DEREnumerated(byArray);
            }
            case 24: {
                return new DERGeneralizedTime(byArray);
            }
            case 27: {
                return new DERGeneralString(byArray);
            }
            case 22: {
                return new DERIA5String(byArray);
            }
            case 2: {
                return new DERInteger(byArray);
            }
            case 5: {
                return DERNull.INSTANCE;
            }
            case 18: {
                return new DERNumericString(byArray);
            }
            case 6: {
                return new DERObjectIdentifier(byArray);
            }
            case 4: {
                return new DEROctetString(byArray);
            }
            case 19: {
                return new DERPrintableString(byArray);
            }
            case 20: {
                return new DERT61String(byArray);
            }
            case 28: {
                return new DERUniversalString(byArray);
            }
            case 23: {
                return new DERUTCTime(byArray);
            }
            case 12: {
                return new DERUTF8String(byArray);
            }
            case 26: {
                return new DERVisibleString(byArray);
            }
        }
        return new DERUnknownTag(false, n, byArray);
    }
}

