/*
 * Decompiled with CFR 0.152.
 */
package org.cybergarage.upnp.ssdp;

import java.net.InetAddress;
import java.util.Vector;
import org.cybergarage.net.HostInterface;
import org.cybergarage.upnp.ControlPoint;
import org.cybergarage.upnp.ssdp.SSDP;
import org.cybergarage.upnp.ssdp.SSDPSearchRequest;
import org.cybergarage.upnp.ssdp.SSDPSearchResponseSocket;

public class SSDPSearchResponseSocketList
extends Vector<SSDPSearchResponseSocket> {
    private InetAddress[] binds = null;

    public SSDPSearchResponseSocketList() {
    }

    public SSDPSearchResponseSocketList(InetAddress[] binds) {
        this.binds = binds;
    }

    public void setControlPoint(ControlPoint ctrlPoint) {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.setControlPoint(ctrlPoint);
        }
    }

    public SSDPSearchResponseSocket getSSDPSearchResponseSocket(int n) {
        return (SSDPSearchResponseSocket)this.get(n);
    }

    public boolean open(int port) {
        String[] bindAddresses;
        InetAddress[] binds = this.binds;
        if (binds != null) {
            bindAddresses = new String[binds.length];
            for (int i = 0; i < binds.length; ++i) {
                bindAddresses[i] = binds[i].getHostAddress();
            }
        } else {
            int nHostAddrs = HostInterface.getNHostAddresses();
            bindAddresses = new String[nHostAddrs];
            for (int n = 0; n < nHostAddrs; ++n) {
                bindAddresses[n] = HostInterface.getHostAddress(n);
            }
        }
        try {
            for (int j = 0; j < bindAddresses.length; ++j) {
                SSDPSearchResponseSocket socket = new SSDPSearchResponseSocket(bindAddresses[j], port);
                this.add(socket);
            }
        }
        catch (Exception e) {
            this.stop();
            this.close();
            this.clear();
            return false;
        }
        return true;
    }

    public boolean open() {
        return this.open(1900);
    }

    public void close() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.close();
        }
        this.clear();
    }

    public void start() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.start();
        }
    }

    public void stop() {
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            sock.stop();
        }
    }

    public boolean post(SSDPSearchRequest req) {
        boolean ret = true;
        int nSockets = this.size();
        for (int n = 0; n < nSockets; ++n) {
            SSDPSearchResponseSocket sock = this.getSSDPSearchResponseSocket(n);
            String bindAddr = sock.getLocalAddress();
            req.setLocalAddress(bindAddr);
            String ssdpAddr = "239.255.255.250";
            if (HostInterface.isIPv6Address(bindAddr)) {
                ssdpAddr = SSDP.getIPv6Address();
            }
            if (sock.post(ssdpAddr, 1900, req)) continue;
            ret = false;
        }
        return ret;
    }
}

