/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.tagging;

import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.openstreetmap.josm.tools.CheckParameterUtil;

public class TagTableColumnModelBuilder {
    private final DefaultTableColumnModel model = new DefaultTableColumnModel();

    public TagTableColumnModelBuilder(TableCellRenderer renderer, String ... headerValues) {
        CheckParameterUtil.ensureParameterNotNull(headerValues, "headerValues");
        for (int i = 0; i < headerValues.length; ++i) {
            TableColumn col = new TableColumn(i);
            col.setHeaderValue(headerValues[i]);
            col.setResizable(true);
            col.setCellRenderer(renderer);
            this.model.addColumn(col);
        }
    }

    public TagTableColumnModelBuilder setWidth(int width, int ... indexes) {
        for (int i : indexes) {
            this.model.getColumn(i).setWidth(width);
        }
        return this;
    }

    public TagTableColumnModelBuilder setPreferredWidth(int width, int ... indexes) {
        for (int i : indexes) {
            this.model.getColumn(i).setPreferredWidth(width);
        }
        return this;
    }

    public TagTableColumnModelBuilder setMaxWidth(int width, int ... indexes) {
        for (int i : indexes) {
            this.model.getColumn(i).setMaxWidth(width);
        }
        return this;
    }

    public TagTableColumnModelBuilder setCellEditor(TableCellEditor editor, int ... indexes) {
        for (int i : indexes) {
            this.model.getColumn(i).setCellEditor(editor);
        }
        return this;
    }

    public TagTableColumnModelBuilder setSelectionModel(ListSelectionModel selectionModel) {
        this.model.setSelectionModel(selectionModel);
        return this;
    }

    public DefaultTableColumnModel build() {
        return this.model;
    }
}

