/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.help.search;

import com.sun.java.help.search.Compressor;
import com.sun.java.help.search.ConceptLocation;
import com.sun.java.help.search.IntegerArray;
import com.sun.java.help.search.StreamDecompressor;
import java.io.BufferedInputStream;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.URL;
import java.net.URLConnection;

class DocumentCompressor {
    public static final int NConceptsInGroup = 16;
    public static final int BitsInLabel = 4;
    public static final int DefaultSize = 32;
    private int _nGroups;
    private int _nExtents;
    private int _freeComp;
    private int _sizeComp = 32;
    private int _kk;
    private Compressor _currentCompressor = null;
    private Compressor[] _compressors = new Compressor[32];
    private Compressor _kCompr = new Compressor();
    private Compressor _lCompr = new Compressor();
    private Compressor _mCompr = new Compressor();
    private Compressor _posCompressor = new Compressor();
    private IntegerArray _kTable = new IntegerArray();
    private IntegerArray _lTable = new IntegerArray();
    private IntegerArray _maxConcepts = new IntegerArray();
    private IntegerArray _concepts = new IntegerArray();
    private IntegerArray _documents = new IntegerArray();
    private IntegerArray _offsets = new IntegerArray();
    private IntegerArray _titles = new IntegerArray();
    private IntegerArray _positions = new IntegerArray();
    private IntegerArray _labels = new IntegerArray();
    private RandomAccessFile _posFile;
    private static boolean debug = false;

    public DocumentCompressor(URL uRL) throws Exception {
        URL uRL2 = new URL(uRL, "POSITIONS");
        if (this.isFileURL(uRL2)) {
            try {
                URL uRL3 = new URL(uRL, "OFFSETS");
                URLConnection uRLConnection = uRL3.openConnection();
                BufferedInputStream bufferedInputStream = new BufferedInputStream(uRLConnection.getInputStream());
                int n = bufferedInputStream.read();
                StreamDecompressor streamDecompressor = new StreamDecompressor(bufferedInputStream);
                streamDecompressor.ascDecode(n, this._documents);
                int n2 = bufferedInputStream.read();
                StreamDecompressor streamDecompressor2 = new StreamDecompressor(bufferedInputStream);
                streamDecompressor2.ascDecode(n2, this._offsets);
                int n3 = bufferedInputStream.read();
                StreamDecompressor streamDecompressor3 = new StreamDecompressor(bufferedInputStream);
                streamDecompressor3.decode(n3, this._titles);
                bufferedInputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {}
        } else {
            throw new IOException();
        }
        this._posFile = new RandomAccessFile(uRL2.getFile(), "rw");
    }

    private int byteCount() {
        if (this._nGroups == 1 && this._nExtents == 0) {
            return 2 + this._compressors[0].byteCount();
        }
        int n = 1;
        n += this._kCompr.byteCount();
        int n2 = 0;
        while (n2 < this._freeComp) {
            n += this._compressors[n2].byteCount();
            ++n2;
        }
        return n;
    }

    private void clear() {
        this._nGroups = 0;
        this._nExtents = 0;
        this._kTable.clear();
        this._lTable.clear();
        this._concepts.clear();
        this._maxConcepts.clear();
        this._kCompr.clear();
        this._lCompr.clear();
        this._mCompr.clear();
        int n = 0;
        while (n < this._sizeComp) {
            if (this._compressors[n] != null) {
                this._compressors[n].clear();
            }
            ++n;
        }
        this._freeComp = 0;
        this._currentCompressor = null;
    }

    public void close(String string) throws IOException {
        this._posFile.close();
        this.writeOutOffsets(string);
    }

    public void compress(int n, int n2, ConceptLocation[] conceptLocationArray, int n3, ConceptLocation[] conceptLocationArray2, int n4) throws IOException {
        long l = System.currentTimeMillis();
        this.encode(conceptLocationArray, n3, 16);
        if (n4 > 0) {
            this.encodeExtents(conceptLocationArray2, n4);
        }
        this.finalizeEncoding();
        DocumentCompressor.debug(String.valueOf(System.currentTimeMillis() - l) + " msec proc");
        int n5 = this.byteCount();
        l = System.currentTimeMillis();
        long l2 = this._posFile.length();
        this._documents.add(n);
        this._offsets.add((int)l2);
        this._titles.add(n2);
        this._posFile.seek(l2);
        this.writeOut(this._posFile);
        DocumentCompressor.debug(String.valueOf(System.currentTimeMillis() - l) + " msec file");
        DocumentCompressor.debug("nGroups = " + this._nGroups);
    }

    private static void debug(String string) {
        if (debug) {
            System.err.println("DocumentCompressor: " + string);
        }
    }

    private void encode(ConceptLocation[] conceptLocationArray, int n, int n2) {
        int n3 = 4;
        ConceptLocation.sortByConcept(conceptLocationArray, 0, n);
        this.clear();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = conceptLocationArray[0].getConcept();
        this.nextCompressor();
        this._concepts.add(n7);
        int n8 = 0;
        while (true) {
            if (n8 < n && conceptLocationArray[n8].getConcept() == n7) {
                conceptLocationArray[n8].setConcept(n4);
                ++n8;
                continue;
            }
            if (n8 == n) {
                if (this._concepts.cardinality() > 0) {
                    ++this._nGroups;
                    this._kTable.add(this._currentCompressor.minimize(this._concepts, 4));
                }
                break;
            }
            if (++n4 == n2) {
                ++this._nGroups;
                this._concepts.popLast();
                this._maxConcepts.add(n7 - n6);
                n6 = n7;
                this._kTable.add(this._currentCompressor.minimize(this._concepts, 4));
                this.encodePositions(conceptLocationArray, n5, n8, 4);
                n5 = n8;
                this.nextCompressor();
                this._concepts.clear();
                n4 = 0;
            }
            this._concepts.add(conceptLocationArray[n8].getConcept() - n7);
            n7 = conceptLocationArray[n8].getConcept();
        }
        this.encodePositions(conceptLocationArray, n5, n8, 4);
    }

    private void encodeExtents(ConceptLocation[] conceptLocationArray, int n) {
        int n2 = 4;
        int n3 = 0;
        IntegerArray integerArray = new IntegerArray(n);
        IntegerArray integerArray2 = new IntegerArray();
        IntegerArray integerArray3 = new IntegerArray();
        IntegerArray integerArray4 = new IntegerArray();
        this.nextCompressor();
        Compressor compressor = this._currentCompressor;
        int n4 = 0;
        while (n4 < n) {
            if (conceptLocationArray[n4].getConcept() != n3) {
                if (n3 != 0) {
                    ++this._nExtents;
                    this.nextCompressor();
                    integerArray3.add(this._currentCompressor.minimize(integerArray2, 4));
                    integerArray4.add(this._currentCompressor.byteCount());
                }
                integerArray.add(conceptLocationArray[n4].getConcept() - n3);
                n3 = conceptLocationArray[n4].getConcept();
                integerArray2.clear();
                integerArray2.add(conceptLocationArray[n4].getLength());
            } else {
                integerArray2.add(conceptLocationArray[n4].getLength());
            }
            ++n4;
        }
        this.nextCompressor();
        integerArray3.add(this._currentCompressor.minimize(integerArray2, 4));
        integerArray4.add(this._currentCompressor.byteCount());
        Compressor compressor2 = new Compressor();
        integerArray3.add(compressor2.minimize(integerArray4, 4));
        Compressor compressor3 = new Compressor();
        integerArray3.add(compressor3.minimize(integerArray, 4));
        this._kTable.add(compressor.minimize(integerArray3, 4));
        compressor.concatenate(compressor2);
        compressor.concatenate(compressor3);
    }

    private void encodePositions(ConceptLocation[] conceptLocationArray, int n, int n2, int n3) {
        int n4 = 3;
        ConceptLocation.sortByPosition(conceptLocationArray, n, n2);
        this._positions.clear();
        this._labels.clear();
        int n5 = conceptLocationArray[n].getBegin();
        this._positions.add(n5);
        this._labels.add(conceptLocationArray[n].getConcept());
        int n6 = n;
        int n7 = n + 1;
        while (n7 < n2) {
            if (!conceptLocationArray[n6].equals(conceptLocationArray[n7])) {
                n6 = n7;
                this._positions.add(conceptLocationArray[n6].getBegin() - n5);
                n5 = conceptLocationArray[n6].getBegin();
                this._labels.add(conceptLocationArray[n6].getConcept());
            }
            ++n7;
        }
        int n8 = this._posCompressor.minimize(this._positions, 3);
        this._kTable.add(n8);
        this._posCompressor.clear();
        this._posCompressor.encode(this._positions, this._labels, n8, n3);
        this._currentCompressor.concatenate(this._posCompressor);
    }

    private void finalizeEncoding() {
        if (this._nGroups > 1) {
            int n = this._nExtents > 0 ? this._freeComp : this._freeComp - 1;
            int n2 = 0;
            while (n2 < n) {
                this._lTable.add(this._compressors[n2].byteCount());
                ++n2;
            }
            this._kTable.add(this._mCompr.minimize(this._maxConcepts, 3));
            this._kTable.add(this._lCompr.minimize(this._lTable, 3));
            this._kk = this._kCompr.minimize(this._kTable, 3);
            this._kCompr.concatenate(this._lCompr);
            this._kCompr.concatenate(this._mCompr);
        } else if (this._nGroups == 1 && this._nExtents > 0) {
            this._kTable.add(this._compressors[0].byteCount());
            this._kk = this._kCompr.minimize(this._kTable, 3);
        }
        DocumentCompressor.debug("compr: " + this.byteCount() + " bytes");
    }

    private boolean isFileURL(URL uRL) {
        return uRL.getProtocol().equalsIgnoreCase("file");
    }

    private Compressor nextCompressor() {
        if (this._freeComp == this._sizeComp) {
            Compressor[] compressorArray = new Compressor[this._sizeComp *= 2];
            System.arraycopy(this._compressors, 0, compressorArray, 0, this._freeComp);
            this._compressors = compressorArray;
        }
        if (this._compressors[this._freeComp] == null) {
            this._compressors[this._freeComp] = new Compressor();
        }
        this._currentCompressor = this._compressors[this._freeComp++];
        return this._currentCompressor;
    }

    private void writeOut(DataOutput dataOutput) throws IOException {
        if (this._nExtents == 0) {
            if (this._nGroups > 1) {
                dataOutput.write(0x80 | this._kk);
                this._kCompr.write(dataOutput);
                int n = 0;
                while (n < this._freeComp) {
                    this._compressors[n].write(dataOutput);
                    ++n;
                }
            } else {
                dataOutput.write(this._kTable.at(0));
                dataOutput.write(this._kTable.at(1));
                this._compressors[0].write(dataOutput);
            }
        } else {
            dataOutput.write((this._nGroups > 1 ? 192 : 64) | this._kk);
            this._kCompr.write(dataOutput);
            int n = 0;
            while (n < this._freeComp) {
                this._compressors[n].write(dataOutput);
                ++n;
            }
        }
    }

    private void writeOutOffsets(String string) throws IOException {
        Compressor compressor = new Compressor();
        int n = compressor.compressAscending(this._documents);
        Compressor compressor2 = new Compressor();
        int n2 = compressor2.compressAscending(this._offsets);
        Compressor compressor3 = new Compressor();
        int n3 = compressor3.minimize(this._titles, 8);
        int n4 = compressor.byteCount();
        RandomAccessFile randomAccessFile = new RandomAccessFile(string, "rw");
        randomAccessFile.seek(0L);
        randomAccessFile.write(n);
        compressor.write(randomAccessFile);
        randomAccessFile.write(n2);
        compressor2.write(randomAccessFile);
        randomAccessFile.write(n3);
        compressor3.write(randomAccessFile);
        randomAccessFile.close();
    }
}

