/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.certs.pem.der;

import io.vertx.core.buffer.Buffer;
import java.util.concurrent.atomic.AtomicInteger;

public class DerParser {
    private final Type type;
    private final long tag;
    private final int length;
    private final Buffer content;
    private final int size;
    private int cursor;

    public DerParser(byte[] bytes) {
        AtomicInteger position = new AtomicInteger(0);
        Buffer buffer = Buffer.buffer((byte[])bytes);
        byte b = buffer.getByte(position.getAndIncrement());
        this.type = Type.from(b);
        this.tag = this.decodeTag(b, buffer, position);
        this.length = this.decodeLength(buffer, position);
        this.content = buffer.slice(position.get(), position.get() + this.length);
        this.size = position.get() + this.length;
        this.cursor = 0;
    }

    private long decodeTag(byte b, Buffer bytes, AtomicInteger position) {
        long t = b & 0x1F;
        if (t != 31L) {
            return t;
        }
        t = 0L;
        b = bytes.getByte(position.getAndIncrement());
        while ((b & 0x80) != 0) {
            t <<= 7;
            t |= (long)(b & 0x7F);
            b = bytes.getByte(position.getAndIncrement());
        }
        return t;
    }

    private int decodeLength(Buffer bytes, AtomicInteger position) {
        byte b = bytes.getByte(position.getAndIncrement());
        if ((b & 0x80) == 0) {
            return b & 0x7F;
        }
        int numberOfLengthBytes = b & 0x7F;
        if (numberOfLengthBytes == 0) {
            throw new IllegalArgumentException("Indefinite form is not supported");
        }
        int length = 0;
        for (int i = 0; i < numberOfLengthBytes; ++i) {
            length <<= 8;
            length |= bytes.getByte(position.getAndIncrement()) & 0xFF;
        }
        return length;
    }

    public Buffer content() {
        return this.content;
    }

    public byte[] toByteArray() {
        return this.content.getBytes();
    }

    public Type type() {
        return this.type;
    }

    public long tag() {
        return this.tag;
    }

    public int length() {
        return this.length;
    }

    public DerParser next() {
        if ((this.tag == (long)Tag.ASN1_SEQUENCE.number() || this.tag == (long)Tag.SEQUENCE.number()) && this.cursor < this.length) {
            DerParser nested = new DerParser(this.content.getBytes(this.cursor, this.length));
            this.cursor += nested.size;
            return nested;
        }
        return null;
    }

    public static enum Type {
        PRIMITIVE,
        CONSTRUCTED;


        static Type from(byte b) {
            return (b & 0x20) == 0 ? PRIMITIVE : CONSTRUCTED;
        }
    }

    public static enum Tag {
        INTEGER(2),
        OCTET_STRING(4),
        OBJECT_IDENTIFIER(6),
        SEQUENCE(16),
        ASN1_SEQUENCE(48);

        private final int number;

        private Tag(int n2) {
            this.number = n2;
        }

        public int number() {
            return this.number;
        }
    }
}

