/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.internal.items;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.internal.items.ItemBuilderImpl;
import org.openhab.core.items.Item;
import org.openhab.core.items.ItemBuilder;
import org.openhab.core.items.ItemBuilderFactory;
import org.openhab.core.items.ItemFactory;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@NonNullByDefault
@Component
public class ItemBuilderFactoryImpl
implements ItemBuilderFactory {
    private final Set<ItemFactory> itemFactories = new CopyOnWriteArraySet<ItemFactory>();

    @Activate
    public ItemBuilderFactoryImpl(@Reference(target="(component.name=org.openhab.core.library.CoreItemFactory)") ItemFactory coreItemFactory) {
        this.itemFactories.add(coreItemFactory);
    }

    @Override
    public ItemBuilder newItemBuilder(Item item) {
        return new ItemBuilderImpl(this.itemFactories, item);
    }

    @Override
    public ItemBuilder newItemBuilder(String itemType, String itemName) {
        return new ItemBuilderImpl(this.itemFactories, itemType, itemName);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addItemFactory(ItemFactory itemFactory) {
        this.itemFactories.add(itemFactory);
    }

    protected void removeItemFactory(ItemFactory itemFactory) {
        this.itemFactories.remove(itemFactory);
    }
}

