/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.model;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.NameCache;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.DiplomaticTrade;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Event;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.HistoryEvent;
import net.sf.freecol.common.model.Limit;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.ModelMessage;
import net.sf.freecol.common.model.NationOptions;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Stance;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TradeItem;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.NewTurnMessage;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.Utils;
import net.sf.freecol.server.model.ServerColony;
import net.sf.freecol.server.model.ServerPlayer;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.server.model.Session;
import net.sf.freecol.server.model.TurnTaker;

public class ServerGame
extends Game
implements TurnTaker {
    private static final Logger logger = Logger.getLogger(ServerGame.class.getName());
    private long lastTime = -1L;

    public ServerGame(Specification specification) {
        super(specification);
    }

    public ServerGame(Specification specification, Random random) {
        this(specification);
        this.setNationOptions(new NationOptions(specification));
        this.randomize(random);
        this.establishUnknownEnemy();
    }

    public ServerGame(Specification specification, FreeColXMLReader xr) throws XMLStreamException {
        this(specification);
        this.readFromXML(xr);
    }

    @Override
    public int getNextId() {
        int ret = this.nextId++;
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Player> getConnectedPlayers(Player ... players) {
        Predicate<Player> connPred = p -> p.isConnected() && CollectionUtils.none(players, CollectionUtils.matchKey(p));
        List list = this.players;
        synchronized (list) {
            return CollectionUtils.transform(this.players, connPred);
        }
    }

    public void sendToAll(ChangeSet cs) {
        this.sendToList(this.getConnectedPlayers(new Player[0]), cs);
    }

    public void sendToOthers(Player player, ChangeSet cs) {
        this.sendToList(this.getConnectedPlayers(player), cs);
    }

    public void sendToList(List<Player> players, ChangeSet cs) {
        for (Player p : players) {
            this.sendTo(p, cs);
        }
    }

    public boolean sendTo(Player player, ChangeSet cs) {
        try {
            return player.send(cs);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "sendTo(" + player.getId() + "," + cs + ") failed", e);
            return false;
        }
    }

    public final Player establishUnknownEnemy() {
        Player ret = this.getUnknownEnemy();
        if (ret != null) {
            return ret;
        }
        ServerPlayer enemy = new ServerPlayer(this, false, this.getSpecification().getUnknownEnemyNation());
        this.setUnknownEnemy(enemy);
        return enemy;
    }

    public void updatePlayers(List<? extends Player> players) {
        if (!players.isEmpty()) {
            this.sendToAll(new ChangeSet().addPlayers(players));
        }
    }

    public void changeAI(Player player, boolean ai) {
        player.setAI(ai);
        this.sendToAll(ChangeSet.aiChange(player, ai));
    }

    private final void randomize(Random random) {
        if (random != null) {
            NameCache.requireCitiesOfCibola(random);
        }
    }

    public ServerPlayer checkForWinner() {
        List<Player> winners;
        Player winner;
        Specification spec = this.getSpecification();
        if (spec.getBoolean("model.option.victoryDefeatREF") && (winner = CollectionUtils.find(this.getLiveEuropeanPlayers(new Player[0]), p -> p.getPlayerType() == Player.PlayerType.INDEPENDENT)) != null) {
            return (ServerPlayer)winner;
        }
        if (spec.getBoolean("model.option.victoryDefeatEuropeans") && (winners = CollectionUtils.transform(this.getLiveEuropeanPlayers(new Player[0]), p -> !p.isREF())).size() == 1) {
            return (ServerPlayer)winners.get(0);
        }
        if (spec.getBoolean("model.option.victoryDefeatHumans") && (winners = CollectionUtils.transform(this.getLiveEuropeanPlayers(new Player[0]), p -> !p.isAI())).size() == 1) {
            return (ServerPlayer)winners.get(0);
        }
        return null;
    }

    public boolean isNextPlayerInNewTurn() {
        Player nextPlayer = this.getNextPlayer();
        return this.players.indexOf(this.currentPlayer) > this.players.indexOf(nextPlayer) || this.currentPlayer == nextPlayer;
    }

    public void csNextTurn(ChangeSet cs) {
        String duration = null;
        long now = new Date().getTime();
        if (this.lastTime >= 0L) {
            duration = ", previous turn duration = " + (now - this.lastTime) + "ms";
        }
        this.lastTime = now;
        Session.completeAll(cs);
        this.setTurn(this.getTurn().next());
        logger.finest("Turn is now " + this.getTurn() + "/" + duration);
        cs.add(ChangeSet.See.all(), new NewTurnMessage(this.getTurn()));
    }

    private boolean spanishSuccessionReady(Event event, List<Player> players, LogBuilder lb) {
        Limit yearLimit = event.getLimit("model.limit.spanishSuccession.year");
        if (!yearLimit.evaluate(this)) {
            return false;
        }
        Limit weakLimit = event.getLimit("model.limit.spanishSuccession.weakestPlayer");
        Limit strongLimit = event.getLimit("model.limit.spanishSuccession.strongestPlayer");
        Player weakAI = null;
        Player strongAI = null;
        int weakScore = Integer.MAX_VALUE;
        int strongScore = Integer.MIN_VALUE;
        boolean ready = false;
        lb.add("Spanish succession scores[");
        String sep = ", ";
        for (Player player : CollectionUtils.transform(this.getLiveEuropeanPlayers(new Player[0]), p -> !p.isREF())) {
            boolean ok = strongLimit.evaluate(player);
            ready |= ok;
            lb.add(player.getName(), "(", ok, ")");
            if (!player.isAI()) continue;
            int score = player.getSpanishSuccessionScore();
            lb.add("=", score, ", ");
            if (strongAI == null || strongScore < score) {
                strongScore = score;
                strongAI = player;
            }
            if (!weakLimit.evaluate(player) || weakAI != null && weakScore <= score) continue;
            weakScore = score;
            weakAI = player;
        }
        lb.truncate(lb.size() - ", ".length());
        lb.add("]");
        players.add(weakAI);
        players.add(0, strongAI);
        return ready;
    }

    private ServerPlayer csSpanishSuccession(ChangeSet cs, LogBuilder lb, Event event) {
        ArrayList<Player> ail = new ArrayList<Player>();
        if (!this.spanishSuccessionReady(event, ail, lb)) {
            return null;
        }
        Player strongAI = (Player)ail.get(0);
        Player weakAI = (Player)ail.get(1);
        if (weakAI == null || strongAI == null || weakAI == strongAI) {
            return null;
        }
        lb.add(" => ", weakAI.getName(), " cedes ", strongAI.getName(), ":");
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        HashSet<Tile> updated = new HashSet<Tile>();
        ServerPlayer strongest = (ServerPlayer)strongAI;
        ServerPlayer weakest = (ServerPlayer)weakAI;
        CollectionUtils.forEach(CollectionUtils.flatten(this.getLiveNativePlayers(new Player[0]), p -> p.getIndianSettlementsWithMissionary(weakest)), is -> {
            lb.add(" ", is.getName(), "(mission)");
            is.getTile().cacheUnseen(strongest);
            tiles.add(is.getTile());
            is.setContacted(strongAI);
            ServerUnit missionary = (ServerUnit)is.getMissionary();
            if (weakest.csChangeOwner(missionary, strongAI, null, null, cs)) {
                is.getTile().updateIndianSettlement(strongAI);
                cs.add(ChangeSet.See.perhaps().always(strongAI), (FreeColGameObject)is);
            }
        });
        List<Colony> cl = weakAI.getColonyList();
        HashSet<Unit> contacts = new HashSet<Unit>(cl.size());
        for (Colony c : cl) {
            updated.addAll(c.getOwnedTiles());
            ((ServerColony)c).csChangeOwner(strongAI, false, null, cs);
            lb.add(" ", c.getName());
            contacts.add(c.getFirstUnit());
        }
        for (Unit unit : weakAI.getUnitSet()) {
            Tile tile;
            lb.add(" ", unit.getId());
            if (unit.isOnCarrier()) continue;
            if (!weakest.csChangeOwner(unit, strongAI, null, null, cs)) {
                logger.warning("Owner change failed for " + unit);
                continue;
            }
            unit.setMovesLeft(0);
            unit.setState(Unit.UnitState.ACTIVE);
            if (unit.getLocation() instanceof Europe) {
                unit.setLocation(strongAI.getEurope());
                cs.add(ChangeSet.See.only(strongAI), unit);
            } else if (unit.getLocation() instanceof HighSeas) {
                unit.setLocation(strongAI.getHighSeas());
                cs.add(ChangeSet.See.only(strongAI), unit);
            } else if (unit.isOnTile() && !tiles.contains(tile = unit.getTile())) {
                tiles.add(tile);
            }
            contacts.add(unit);
        }
        for (Unit u : contacts) {
            if (!u.hasTile()) continue;
            ((ServerUnit)u).csNewContactCheck(u.getTile(), false, cs);
        }
        StringTemplate loser = weakAI.getNationLabel();
        StringTemplate winner = strongAI.getNationLabel();
        this.setSpanishSuccession(true);
        cs.addPartial(ChangeSet.See.all(), this, "spanishSuccession", Boolean.TRUE.toString());
        tiles.removeAll(updated);
        cs.add(ChangeSet.See.perhaps(), tiles);
        weakest.csWithdraw(cs, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, "model.game.spanishSuccession", strongAI).addStringTemplate("%loserNation%", loser)).addStringTemplate("%nation%", winner), (HistoryEvent)((StringTemplate)new HistoryEvent(this.getTurn(), HistoryEvent.HistoryEventType.SPANISH_SUCCESSION, null).addStringTemplate("%loserNation%", loser)).addStringTemplate("%nation%", winner));
        strongAI.invalidateCanSeeTiles();
        for (FreeColGameObject fcgo : this.getFreeColGameObjectList()) {
            if (!(fcgo instanceof Ownable) || ((Ownable)((Object)fcgo)).getOwner() != weakAI) continue;
            throw new RuntimeException("Lurking " + weakAI.getId() + " fcgo: " + fcgo);
        }
        return weakest;
    }

    public boolean csAcceptTrade(DiplomaticTrade agreement, Unit unit, Settlement settlement, ChangeSet cs) {
        Player dest;
        Player source;
        Player srcPlayer = agreement.getSender();
        Player dstPlayer = agreement.getRecipient();
        boolean visibilityChange = false;
        boolean fail = false;
        for (TradeItem tradeItem : agreement.getItems()) {
            Unit u;
            source = tradeItem.getSource();
            dest = tradeItem.getDestination();
            if (!tradeItem.isValid()) {
                logger.warning("Trade with invalid tradeItem: " + tradeItem);
                fail = true;
                continue;
            }
            if (source != srcPlayer && source != dstPlayer) {
                logger.warning("Trade with invalid source: " + (source == null ? "null" : source.getId()));
                fail = true;
                continue;
            }
            if (dest != srcPlayer && dest != dstPlayer) {
                logger.warning("Trade with invalid destination: " + (dest == null ? "null" : dest.getId()));
                fail = true;
                continue;
            }
            Colony colony = tradeItem.getColony(this.getGame());
            if (colony != null && !source.owns(colony)) {
                logger.warning("Trade with invalid source owner: " + colony);
                fail = true;
                continue;
            }
            int gold = tradeItem.getGold();
            if (gold > 0 && !source.checkGold(gold)) {
                logger.warning("Trade with invalid gold: " + gold);
                fail = true;
                continue;
            }
            Goods goods = tradeItem.getGoods();
            if (goods != null) {
                Location loc = goods.getLocation();
                if (loc instanceof Ownable && !source.owns((Ownable)((Object)loc))) {
                    logger.warning("Trade with invalid source owner: " + loc);
                    fail = true;
                } else if (!(loc instanceof GoodsLocation) || !loc.contains(goods)) {
                    logger.warning("Trade of unavailable goods " + goods + " at " + loc);
                    fail = true;
                } else if (dest.owns(unit) && !unit.couldCarry(goods)) {
                    logger.warning("Trade unit can not carry traded goods: " + goods);
                    fail = true;
                }
            }
            if ((u = tradeItem.getUnit()) == null) continue;
            if (!source.owns(u)) {
                logger.warning("Trade with invalid source owner: " + u);
                fail = true;
                continue;
            }
            if (!dest.owns(unit) || unit.couldCarry(u)) continue;
            logger.warning("Trade unit can not carry traded unit: " + u);
            fail = true;
        }
        if (fail) {
            return false;
        }
        for (TradeItem tradeItem : agreement.getItems()) {
            UnitLocation newLoc;
            ServerUnit newUnit;
            Player victim;
            Goods goods;
            int gold;
            Colony colony;
            source = tradeItem.getSource();
            dest = tradeItem.getDestination();
            Stance stance = tradeItem.getStance();
            if (stance != null && source.getStance(dest) != stance && !((ServerPlayer)source).csChangeStance(stance, dest, true, cs)) {
                logger.warning("Stance trade failure: " + stance);
            }
            if ((colony = tradeItem.getColony(this.getGame())) != null) {
                ((ServerColony)colony).csChangeOwner(dest, false, null, cs);
                visibilityChange = true;
            }
            if ((gold = tradeItem.getGold()) > 0) {
                source.modifyGold(-gold);
                dest.modifyGold(gold);
                cs.addPartial(ChangeSet.See.only(source), source, "gold", String.valueOf(source.getGold()), "score", String.valueOf(source.getScore()));
                cs.addPartial(ChangeSet.See.only(dest), dest, "gold", String.valueOf(dest.getGold()), "score", String.valueOf(dest.getScore()));
            }
            if ((goods = tradeItem.getGoods()) != null && settlement != null) {
                if (dest.owns(settlement)) {
                    goods.setLocation(unit);
                    GoodsLocation.moveGoods(unit, goods.getType(), goods.getAmount(), settlement);
                    cs.add(ChangeSet.See.only(source), unit);
                    cs.add(ChangeSet.See.only(dest), settlement.getGoodsContainer());
                } else {
                    goods.setLocation(settlement);
                    GoodsLocation.moveGoods(settlement, goods.getType(), goods.getAmount(), unit);
                    cs.add(ChangeSet.See.only(dest), unit);
                    cs.add(ChangeSet.See.only(source), settlement.getGoodsContainer());
                }
            }
            if ((victim = tradeItem.getVictim()) != null) {
                if (((ServerPlayer)source).csChangeStance(Stance.WAR, victim, true, cs)) {
                    cs.addStance(ChangeSet.See.only(dest), source, Stance.WAR, victim);
                    cs.addMessage(dest, (ModelMessage)((StringTemplate)new ModelMessage(ModelMessage.MessageType.FOREIGN_DIPLOMACY, Stance.WAR.getOtherStanceChangeKey(), source).addStringTemplate("%attacker%", source.getNationLabel())).addStringTemplate("%defender%", victim.getNationLabel()));
                } else {
                    logger.warning("Incite trade failure: " + victim);
                }
            }
            if ((newUnit = (ServerUnit)tradeItem.getUnit()) == null || settlement == null) continue;
            Player former = newUnit.getOwner();
            Tile oldTile = newUnit.getTile();
            if (unit.isOnCarrier()) {
                Unit carrier = unit.getCarrier();
                if (!carrier.couldCarry(newUnit)) {
                    logger.warning("Can not add " + newUnit + " to " + carrier);
                    continue;
                }
                newLoc = carrier;
            } else {
                newLoc = dest == unit.getOwner() ? unit.getTile() : settlement.getTile();
            }
            if (((ServerPlayer)source).csChangeOwner(newUnit, dest, null, newLoc, cs)) {
                newUnit.setMovesLeft(0);
                cs.add(ChangeSet.See.perhaps().always(former), oldTile);
            }
            visibilityChange = true;
        }
        if (visibilityChange) {
            srcPlayer.invalidateCanSeeTiles();
            dstPlayer.invalidateCanSeeTiles();
        }
        return true;
    }

    @Override
    public void csNewTurn(Random random, LogBuilder lb, ChangeSet cs) {
        lb.add("GAME ", this.getId(), ", ");
        for (Player player : this.getLivePlayerList(new Player[0])) {
            ((ServerPlayer)player).csNewTurn(random, lb, cs);
        }
        Specification spec = this.getSpecification();
        Event succession = spec.getEvent("model.event.spanishSuccession");
        if (succession != null && !this.getSpanishSuccession()) {
            ServerPlayer serverPlayer = this.csSpanishSuccession(cs, lb, succession);
        }
    }

    @Override
    public boolean equals(Object o) {
        return this == o;
    }

    @Override
    public int hashCode() {
        return Utils.hashCode(this.getId());
    }
}

