#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Charterstone
# send your bug reports to bugs@dotslashplay.it
###

script_version=20251020.2

PLAYIT_COMPATIBILITY_LEVEL='2.33'

GAME_ID='charterstone'
GAME_NAME='Charterstone'

ARCHIVE_BASE_0_NAME='charterstone_digital_edition_1_2_9_60090.sh'
ARCHIVE_BASE_0_MD5='2ae5e0a2a81433b3ae54e8ff80af9274'
ARCHIVE_BASE_0_SIZE='616080'
ARCHIVE_BASE_0_VERSION='1.2.9-gog60090'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/charterstone_digital_edition'

UNITY3D_NAME='Charterstone'

CONTENT_PATH_DEFAULT='data/noarch/game'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='64'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libm.so.6
libpthread.so.0
librt.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions.

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run default initialisation actions.

initialization_default "$@"

# Extract game data.

archive_extraction_default
## Prevent inclusion of unwanted Unity3D plugins.
rm --recursive "${PLAYIT_WORKDIR}/gamedata/$(content_path_default)/$(unity3d_name)_Data/Plugins"

# Include game data.

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers.

launchers_generation

# Build packages.

packages_generation
print_instructions

# Clean up.

working_directory_cleanup

exit 0
