/*
 * SPDX-FileCopyrightText: Copyright (c) 2003-2022 NVIDIA CORPORATION & AFFILIATES. All rights reserved.
 * SPDX-License-Identifier: MIT
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the Software),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED AS IS, WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 */

#ifndef __lr10_dev_pmgr_h__
#define __lr10_dev_pmgr_h__
/* This file is autogenerated.  Do not edit */
#define NV_PMGR_GPIO_OUTPUT_CNTL(i)              0x0000D610 +(i) * (0x0000D614 - 0x0000D610) /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL__SIZE_1                                                                                                  31 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL                                  7:0 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_INIT                      0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_NORMAL                    0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_RASTER_SYNC_0             0x00000040 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_RASTER_SYNC_1             0x00000041 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_RASTER_SYNC_2             0x00000042 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_RASTER_SYNC_3             0x00000043 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_RASTER_SYNC(i)         ((i) + 0x40)  /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_RASTER_SYNC__SIZE_1                4 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_STEREO_0                  0x00000048 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_STEREO_1                  0x00000049 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_STEREO_2                  0x0000004A /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_STEREO_3                  0x0000004B /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_STEREO(i)              ((i) + 0x48)  /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_STEREO__SIZE_1                     4 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SWAP_READY_OUT_0          0x00000050 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SWAP_READY_OUT_1          0x00000051 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SWAP_READY_OUT_2          0x00000052 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SWAP_READY_OUT_3          0x00000053 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SWAP_READY_OUT(i)       ((i) + 0x50) /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SWAP_READY_OUT__SIZE_1             4 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_VID_PWM_3                 0x00000055 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_VID_PWM_2                 0x00000056 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_VID_PWM_1                 0x00000057 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_FAN_ALERT                 0x00000059 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_ADC_MUX_SEL              0x0000005A /*        */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_BA_METER                  0x0000005B /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_PWM_OUTPUT                0x0000005C /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_VID_PWM                   0x0000005D /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_THERMAL_PWM               0x0000005E /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_THERMAL_SLOWDOWN          0x0000005F /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_0              0x00000060 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_1              0x00000061 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_2              0x00000062 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_3              0x00000063 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_4              0x00000064 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_5              0x00000065 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_6              0x00000066 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_7              0x00000067 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_8              0x00000068 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_9              0x00000069 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_A              0x0000006A /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_B              0x0000006B /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_C              0x0000006C /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_D              0x0000006D /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_E              0x0000006E /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_DEBUG_PORT_F              0x0000006F /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SPI_CS_1                  0x00000071 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SPI_CS_2                  0x00000072 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SPI_CS_3                  0x00000073 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SPI_CS(i)                 ((i)+0x70) /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SPI_CS__SIZE_1                     4 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR0_TMDS_OUT_PWM         0x00000080 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR0_TMDS_OUT_PINA        0x00000081 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR0_TMDS_OUT_PINB        0x00000082 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR1_TMDS_OUT_PWM         0x00000084 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR1_TMDS_OUT_PINA        0x00000085 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR1_TMDS_OUT_PINB        0x00000086 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR2_TMDS_OUT_PWM         0x00000088 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR2_TMDS_OUT_PINA        0x00000089 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR2_TMDS_OUT_PINB        0x0000008A /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR3_TMDS_OUT_PWM         0x0000008C /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR3_TMDS_OUT_PINA        0x0000008D /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR3_TMDS_OUT_PINB        0x0000008E /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR_TMDS_OUT_PWM(i)  (((i)*4) + 0x80)/*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR_TMDS_OUT_PWM__SIZE_1           8 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR_TMDS_OUT_PINA(i) (((i)*4) + 0x81)/*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR_TMDS_OUT_PINA__SIZE_1          8 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR_TMDS_OUT_PINB(i) (((i)*4) + 0x82)/*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_SEL_SOR_TMDS_OUT_PINB__SIZE_1          8 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUTPUT                          12:12 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUTPUT_INIT                0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUTPUT_0                   0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUTPUT_1                   0x00000001 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUT_EN                          13:13 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUT_EN_INIT                0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUT_EN_NO                  0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUT_EN_YES                 0x00000001 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_INPUT                           14:14 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_INPUT_0                    0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_INPUT_1                    0x00000001 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUT_INV                         15:15 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUT_INV_INIT               0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUT_INV_DISABLE            0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_IO_OUT_INV_ENABLE             0x00000001 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_PULLUD                             17:16 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_PULLUD_INIT                   0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_PULLUD_NONE                   0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_PULLUD_UP                     0x00000001 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_PULLUD_DOWN                   0x00000002 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_PULLUD_RESERVED               0x00000003 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_OPEN_DRAIN                         18:18 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_OPEN_DRAIN_INIT               0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_OPEN_DRAIN_DISABLE            0x00000000 /*       */
#define NV_PMGR_GPIO_OUTPUT_CNTL_OPEN_DRAIN_ENABLE             0x00000001 /*       */

#define NV_PMGR_GPIO_OUTPUT_CNTL_TRIGGER                        0x0000D604 /* RWI4R */
#define NV_PMGR_GPIO_OUTPUT_CNTL_TRIGGER_UPDATE                        0:0 /* RWIVF */
#define NV_PMGR_GPIO_OUTPUT_CNTL_TRIGGER_UPDATE_INIT            0x00000000 /* R-I-V */
#define NV_PMGR_GPIO_OUTPUT_CNTL_TRIGGER_UPDATE_DONE            0x00000000 /* R---V */
#define NV_PMGR_GPIO_OUTPUT_CNTL_TRIGGER_UPDATE_TRIGGER         0x00000001 /* -W--T */
#define NV_PMGR_GPIO_OUTPUT_CNTL_TRIGGER_UPDATE_PENDING         0x00000001 /* R---V */

#define NV_PMGR_ROM_WINDOW_XVE                                  0x0000E218 /* RW-4R */
#define NV_PMGR_ROM_WINDOW_XVE_OFFSET                           11:0       /* RWHVF */
#define NV_PMGR_ROM_WINDOW_XVE_OFFSET_MIN                       0x00000000 /* RWH-V */
#define NV_PMGR_ROM_WINDOW_XVE_OFFSET_MAX                       0x00000FFF /* RW--V */
#define NV_PMGR_ROM_WINDOW_XVE_LIMIT                            27:16      /* RWHVF */
#define NV_PMGR_ROM_WINDOW_XVE_LIMIT_MIN                        0x00000000 /* RW--V */
#define NV_PMGR_ROM_WINDOW_XVE_LIMIT_MAX                        0x00000FFF /* RWH-V */

#define NV_PMGR_GPIO_INPUT_CNTL_1                               0x0000D740 /* RW-4R */
#define NV_PMGR_GPIO_INPUT_CNTL_1_PINNUM                               7:0 /* RWIVF */
#define NV_PMGR_GPIO_INPUT_CNTL_1_PINNUM_INIT                   0x00000001 /* RWI-V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_INV                                  8:8 /* RWIVF */
#define NV_PMGR_GPIO_INPUT_CNTL_1_INV_NO                        0x00000000 /* RWI-V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_INV_YES                       0x00000001 /* RW--V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_READ                                 9:9 /* R--VF */
#define NV_PMGR_GPIO_INPUT_CNTL_1_READ_0                        0x00000000 /* R---V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_READ_1                        0x00000001 /* R---V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_BYPASS_FILTER                      10:10 /* RWIVF */
#define NV_PMGR_GPIO_INPUT_CNTL_1_BYPASS_FILTER_INIT            0x00000000 /* RWI-V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_BYPASS_FILTER_NO              0x00000000 /* RW--V */
#define NV_PMGR_GPIO_INPUT_CNTL_1_BYPASS_FILTER_YES             0x00000001 /* RW--V */

#define NV_PMGR_I2C_TIMING(i)            (0x0000D008 + (i) * 0x20) /* RW-4A */
#define NV_PMGR_I2C_TIMING__SIZE_1                              10 /*       */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD                         11:0 /* RWIVF */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD_INIT              0x0000010E /* RWI-V */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD_100KHZ            0x000003E8 /* RW--V */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD_200KHZ            0x000001F4 /* RW--V */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD_300KHZ            0x0000014E /* RW--V */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD_400KHZ            0x00000103 /* RW--V */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD_500KHZ            0x000000C8 /* RW--V */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD_600KHZ            0x000000A7 /* RW--V */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD_800KHZ            0x0000007D /* RW--V */
#define NV_PMGR_I2C_TIMING_SCL_PERIOD_1000KHZ           0x00000064 /* RW--V */
#define NV_PMGR_I2C_TIMING_IGNORE_ACK                        15:15 /* RWIVF */
#define NV_PMGR_I2C_TIMING_IGNORE_ACK_INIT              0x00000000 /* RWI-V */
#define NV_PMGR_I2C_TIMING_IGNORE_ACK_DISABLE           0x00000000 /* RW--V */
#define NV_PMGR_I2C_TIMING_IGNORE_ACK_ENABLE            0x00000001 /* RW--V */
#define NV_PMGR_I2C_TIMING_TIMEOUT_CLK_CNT                   23:16 /* RWIVF */
#define NV_PMGR_I2C_TIMING_TIMEOUT_CLK_CNT_INIT         0x00000001 /* R-I-V */
#define NV_PMGR_I2C_TIMING_TIMEOUT_CHECK                     24:24 /* RWIVF */
#define NV_PMGR_I2C_TIMING_TIMEOUT_CHECK_INIT           0x00000000 /* RWI-V */
#define NV_PMGR_I2C_TIMING_TIMEOUT_CHECK_DISABLE        0x00000000 /* RW--V */
#define NV_PMGR_I2C_TIMING_TIMEOUT_CHECK_ENABLE         0x00000001 /* RW--V */
#endif // __lr10_dev_pmgr_h__
