# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/en/1.1.0/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [2.5] - 2025-12-22

### Changed

- Versioning is from now on always in synch with AspectC++ Versioning

### Added

- Unified manual layout with other AspectC++ documentation and changed Makefile to also create an HTML variant

- Added sections in the manual on compilation process overview, parser configuration file, generation of acc files, e.g. for debugging, as well as cross compilation

- If a repository lock file is created by ac++, it will be deleted after linking or if we called a special ac++ function such as match expression evaluation against a repository file

- Made all translation units depend on all aspect dependency file that are passed with --deps

## [1.0.3] - 2025-07-05

### Added

- Added ag++ option --deps for passing aspect dependency files that can be used to avoid to make all translation units depend on all aspect headers; added also a section in the manual

### Fixed

- fixed build problem on Window where std::filesystem::path::c_str() return a wide string, not a standard char pointer

- Replaced option -I by -iquote for adding the cwd to the include search path; the cwd is only searched for double quoted includes, but -I also affects search for system headers

- Suppress deduplication of *.a files on the command, because sometimes archives must bei linked more than once

## [1.0.2] - 2025-02-02

### Fixed

- Correct handling of command line argument '-a0'

## [1.0.1] - 2025-02-01

### Fixed

- Remove duplicate command line arguments for g++

## [1.0.0] - 2024-12-31

### Added

- Support generation of dependency information during translation


### Changed

- Dependency information does not include woven source code anymore. Even if `--keep_woven` argument is passed to `ag++`.



