/*
 * Decompiled with CFR 0.152.
 */
package com.fluendo.jtiger;

import com.fluendo.jkate.Event;
import com.fluendo.jkate.Tracker;
import com.fluendo.jtiger.TigerBitmap;
import com.fluendo.utils.Debug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;

public class Item {
    private Tracker kin = null;
    private boolean alive = false;
    private Font font = null;
    private int font_size = 0;
    private String text = null;
    private TigerBitmap background_image = null;
    private int width = -1;
    private int height = -1;
    private float region_x;
    private float region_y;
    private float region_w;
    private float region_h;

    public Item(Event event) {
        this.kin = new Tracker(event);
        this.text = null;
        if (event.text != null && event.text.length > 0) {
            try {
                this.text = new String(event.text, "UTF8");
            }
            catch (Exception exception) {
                Debug.warning("Failed to convert text from UTF-8 - text will not display");
                this.text = null;
            }
        }
    }

    protected void createFont(Component component, Image image) {
        this.font_size = image.getWidth(null) / 32;
        if (this.font_size < 12) {
            this.font_size = 12;
        }
        this.font = new Font("sansserif", 1, this.font_size);
    }

    protected void updateCachedData(Component component, Image image) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n == this.width && n2 == this.height) {
            return;
        }
        this.createFont(component, image);
        this.width = n;
        this.height = n2;
    }

    public boolean update(Component component, Image image, double d) {
        Event event = this.kin.ev;
        if (event == null) {
            return false;
        }
        if (d >= event.end_time) {
            return false;
        }
        this.alive = !(d < event.start_time);
        Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
        return this.kin.update(d - event.start_time, dimension, dimension);
    }

    public void setupRegion(Component component, Image image) {
        if (this.kin.has[0]) {
            this.region_x = this.kin.region_x;
            this.region_y = this.kin.region_y;
            this.region_w = this.kin.region_w;
            this.region_h = this.kin.region_h;
        } else {
            Dimension dimension = new Dimension(image.getWidth(null), image.getHeight(null));
            this.region_x = (float)dimension.width * 0.1f;
            this.region_y = (float)dimension.height * 0.8f;
            this.region_w = (float)dimension.width * 0.8f;
            this.region_h = (float)dimension.height * 0.1f;
        }
    }

    public void render(Component component, Image image) {
        if (!this.alive) {
            return;
        }
        this.updateCachedData(component, image);
        this.setupRegion(component, image);
        this.renderBackground(component, image);
        this.renderText(image);
    }

    public void renderBackground(Component component, Image image) {
        if (this.kin.ev.bitmap != null) {
            if (this.background_image == null) {
                this.background_image = new TigerBitmap(component, this.kin.ev.bitmap, this.kin.ev.palette);
            }
            Graphics graphics = image.getGraphics();
            int n = (int)((double)this.region_x + 0.5);
            int n2 = (int)((double)this.region_y + 0.5);
            int n3 = (int)((double)this.region_w + 0.5);
            int n4 = (int)((double)this.region_h + 0.5);
            graphics.drawImage(this.background_image.getScaled(n3, n4), n, n2, null);
            graphics.dispose();
        }
    }

    public void renderText(Image image) {
        if (this.text == null) {
            return;
        }
        Graphics graphics = image.getGraphics();
        graphics.setFont(this.font);
        FontMetrics fontMetrics = graphics.getFontMetrics();
        float f = fontMetrics.stringWidth(this.text);
        float f2 = 0.0f;
        float f3 = (float)this.font_size * 0.05f;
        float f4 = (float)this.font_size * 0.05f;
        graphics.setColor(Color.black);
        graphics.drawString(this.text, (int)(this.region_x + (this.region_w - f) / 2.0f + f3 + 0.5f), (int)(this.region_y + f2 + f4 + 0.5f));
        graphics.drawString(this.text, (int)(this.region_x + (this.region_w - f) / 2.0f - f3 + 0.5f), (int)(this.region_y + f2 - f4 + 0.5f));
        graphics.drawString(this.text, (int)(this.region_x + (this.region_w - f) / 2.0f + f3 + 0.5f), (int)(this.region_y + f2 - f4 + 0.5f));
        graphics.drawString(this.text, (int)(this.region_x + (this.region_w - f) / 2.0f - f3 + 0.5f), (int)(this.region_y + f2 + f4 + 0.5f));
        graphics.setColor(Color.white);
        graphics.drawString(this.text, (int)(this.region_x + (this.region_w - f) / 2.0f + 0.5f), (int)(this.region_y + f2 + 0.5f));
        graphics.dispose();
    }
}

