from typing import Any, Callable, Union

class Node: ...

class Identifier(Node, str):
    def __new__(cls, value: Union[Any, str, None]) -> "Identifier": ...
    def eq(self, other: Any) -> bool: ...
    def neq(self, other: Any) -> bool: ...

class IdentifiedNode(Identifier): ...

class URIRef(IdentifiedNode):
    def toPython(self) -> str: ...
    def n3(self, namespace_manager: Any | None = ...) -> str: ...
    def defrag(self) -> "URIRef": ...
    def de_skolemize(self) -> "BNode": ...

class Genid(URIRef): ...
class RDFLibGenid(Genid): ...

class BNode(IdentifiedNode):
    def toPython(self) -> str: ...
    def n3(self, namespace_manager: Any | None = ...) -> str: ...
    def skolemize(
        self, authority: Any | None = ..., basepath: Any | None = ...
    ) -> "RDFLibGenid": ...

class Literal(Identifier):
    def normalize(self) -> "Literal": ...
    @property
    def value(self) -> Any: ...
    @property
    def language(self) -> str | None: ...
    @property
    def datatype(self) -> Any: ...
    def eq(self, other: Any) -> bool: ...
    def neq(self, other: Any) -> bool: ...
    def n3(self, namespace_manager: Any | None = ...) -> str: ...
    def toPython(self) -> str: ...

class Variable(Identifier):
    def toPython(self) -> str: ...
    def n3(self, namespace_manager: Any | None = ...) -> str: ...
