## Using `uv` to test `ezdxf` against the latest Python RC
- clone local repositiory
	- `git clone ezdxf.git ezdxf.lab`
- create environment for the current CPython3.14-rc including the dev tools
	- `uv sync -p 3.14 --extra dev`
- install `ezdxf` editable
	- `uv pip install -e .`
- run `pytest`
	- `uv run pytest`
- Full run on Windows:
	- ```cmd
	  Microsoft Windows [Version 10.0.26100.6584]
	  (c) Microsoft Corporation. Alle Rechte vorbehalten.
	  
	  C:\Source
	  >git clone ezdxf.git ezdxf.lab
	  Cloning into 'ezdxf.lab'...
	  done.
	  
	  C:\Source
	  >cd ezdxf.lab
	  
	  C:\Source\ezdxf.lab
	  >uv sync -p 3.14 --extra dev
	  Using CPython 3.14.0rc2
	  Creating virtual environment at: .venv
	  Resolved 39 packages in 1.30s
	        Built ezdxf @ file:///C:/Source/ezdxf.lab
	  Prepared 1 package in 7.26s
	  Installed 26 packages in 767ms
	   + colorama==0.4.6
	   + contourpy==1.3.3
	   + cycler==0.12.1
	   ...
	   
	  C:\Source\ezdxf.lab
	  >uv pip install -e .
	  Resolved 5 packages in 1.04s
	        Built ezdxf @ file:///C:/Source/ezdxf.lab
	  Prepared 1 package in 823ms
	  Uninstalled 1 package in 1ms
	  Installed 1 package in 11ms
	   ~ ezdxf==1.4.3b3 (from file:///C:/Source/ezdxf.lab)
	  
	  C:\Source\ezdxf.lab
	  >uv run pytest
	  ================================================= test session starts =================================================
	  platform win32 -- Python 3.14.0rc2, pytest-8.4.2, pluggy-1.6.0
	  rootdir: C:\Source\ezdxf.lab
	  configfile: pytest.ini
	  testpaths: tests
	  collected 7900 items
	  
	  tests\test_00_dxf_low_level_structs\test_001_dxf_types.py ..........                                             [  0%]
	  tests\test_00_dxf_low_level_structs\test_002_dxf_vertex.py .....                                                 [  0%]
	  tests\test_00_dxf_low_level_structs\test_003_dxf_binary_tag.py ..........                                        [  0%]
	  tests\test_00_dxf_low_level_structs\test_004_dxf_value.py ........                                               [  0%]
	    ...
	  
	  ==================================== 7872 passed, 27 skipped, 1 xfailed in 13.04s =====================================
	  ```