// Code generated by gqlclientgen - DO NOT EDIT.

package hgsrht

import (
	"context"
	"encoding/json"
	"fmt"
	gqlclient "git.sr.ht/~emersion/gqlclient"
)

type ACL struct {
	Id         int32          `json:"id"`
	Created    gqlclient.Time `json:"created"`
	Repository *Repository    `json:"repository"`
	Entity     *Entity        `json:"entity"`
	Mode       *AccessMode    `json:"mode,omitempty"`
}

// A cursor for enumerating access control list entries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type ACLCursor struct {
	Results []*ACL  `json:"results"`
	Cursor  *Cursor `json:"cursor,omitempty"`
}

type AccessKind string

const (
	AccessKindRo AccessKind = "RO"
	AccessKindRw AccessKind = "RW"
)

type AccessMode string

const (
	// Read-only
	AccessModeRo AccessMode = "RO"
	// Read/write
	AccessModeRw AccessMode = "RW"
)

type AccessScope string

const (
	AccessScopeProfile      AccessScope = "PROFILE"
	AccessScopeRepositories AccessScope = "REPOSITORIES"
	AccessScopeRevisions    AccessScope = "REVISIONS"
	AccessScopeAcls         AccessScope = "ACLS"
)

type Cursor string

type Entity struct {
	Id      int32          `json:"id"`
	Created gqlclient.Time `json:"created"`
	Updated gqlclient.Time `json:"updated"`
	// The canonical name of this entity. For users, this is their username
	// prefixed with '~'. Additional entity types will be supported in the future.
	CanonicalName string `json:"canonicalName"`
	// Returns a specific repository owned by the entity.
	Repository *Repository `json:"repository,omitempty"`
	// Returns a list of repositories owned by the entity.
	Repositories *RepositoryCursor `json:"repositories"`

	// Underlying value of the GraphQL interface
	Value EntityValue `json:"-"`
}

func (base *Entity) UnmarshalJSON(b []byte) error {
	type Raw Entity
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "User":
		base.Value = new(User)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface Entity: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// EntityValue is one of: User
type EntityValue interface {
	isEntity()
}

// Describes the status of optional features
type Features struct {
	Artifacts bool `json:"artifacts"`
}

type File struct {
	Name string `json:"name"`
}

// A cursor for enumerating files in a repository
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type FileCursor struct {
	Results []File  `json:"results"`
	Cursor  *Cursor `json:"cursor,omitempty"`
}

type NamedRevision struct {
	Name string `json:"name"`
	Id   string `json:"id"`
}

// A cursor for enumerating bookmarks, tags, and branches
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type NamedRevisionCursor struct {
	Results []*NamedRevision `json:"results"`
	Cursor  *Cursor          `json:"cursor,omitempty"`
}

type OAuthClient struct {
	Uuid string `json:"uuid"`
}

type RepoInput struct {
	// Omit these fields to leave them unchanged, or set them to null to clear
	// their value.
	Name        *string     `json:"name,omitempty"`
	Description *string     `json:"description,omitempty"`
	Visibility  *Visibility `json:"visibility,omitempty"`
	// Updates the custom README associated with this repository. Note that the
	// provided HTML will be sanitized when displayed on the web; see
	// https://man.sr.ht/markdown/#post-processing
	Readme *string `json:"readme,omitempty"`
	// Controls whether this repository is a non-publishing repository.
	NonPublishing *bool `json:"nonPublishing,omitempty"`
}

type Repository struct {
	Id          int32          `json:"id"`
	Created     gqlclient.Time `json:"created"`
	Updated     gqlclient.Time `json:"updated"`
	Owner       *Entity        `json:"owner"`
	Name        string         `json:"name"`
	Description *string        `json:"description,omitempty"`
	Visibility  Visibility     `json:"visibility"`
	// The repository's custom README, if set.
	//
	// NOTICE: This returns unsanitized HTML. It is the client's responsibility to
	// sanitize this for display on the web, if so desired.
	Readme *string `json:"readme,omitempty"`
	// Whether or not this repository is a non-publishing repository.
	NonPublishing     bool       `json:"nonPublishing"`
	AccessControlList *ACLCursor `json:"accessControlList"`
	// The tip reference for this repository (latest commit)
	Tip *Revision `json:"tip,omitempty"`
	// Returns the list of open heads in the repository (like `hg heads`)
	// If `rev` is specified, return only open heads on the branch associated with
	// the given revision (like `hg heads REV`)
	Heads *RevisionCursor `json:"heads"`
	// Returns a list of commits (like `hg log`)
	// If `rev` is specified, only show the given commit (like `hg log --rev REV`)
	Log *RevisionCursor `json:"log"`
	// Returns a list of bookmarks
	Bookmarks *NamedRevisionCursor `json:"bookmarks"`
	// Returns a list of branches
	Branches *NamedRevisionCursor `json:"branches"`
	// Returns a list of tags
	Tags *NamedRevisionCursor `json:"tags"`
	// Returns a list of files matching the given path
	Files *FileCursor `json:"files"`
	// Returns the contents of a file given a relative path and an optional revset
	Cat *string `json:"cat,omitempty"`
}

// A cursor for enumerating a list of repositories
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type RepositoryCursor struct {
	Results []*Repository `json:"results"`
	Cursor  *Cursor       `json:"cursor,omitempty"`
}

type RepositoryEvent struct {
	Uuid       string         `json:"uuid"`
	Event      WebhookEvent   `json:"event"`
	Date       gqlclient.Time `json:"date"`
	Repository *Repository    `json:"repository"`
}

func (*RepositoryEvent) isWebhookPayload() {}

type Revision struct {
	Id          string    `json:"id"`
	Branch      string    `json:"branch"`
	Tags        []*string `json:"tags"`
	Author      string    `json:"author"`
	Description string    `json:"description"`
}

// A cursor for enumerating revisions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type RevisionCursor struct {
	Results []*Revision `json:"results"`
	Cursor  *Cursor     `json:"cursor,omitempty"`
}

// Instance specific settings
type Settings struct {
	SshUser string `json:"sshUser"`
}

type Tag struct {
	Name string `json:"name"`
	Id   string `json:"id"`
}

type User struct {
	Id            int32             `json:"id"`
	Created       gqlclient.Time    `json:"created"`
	Updated       gqlclient.Time    `json:"updated"`
	CanonicalName string            `json:"canonicalName"`
	Username      string            `json:"username"`
	Email         string            `json:"email"`
	Url           *string           `json:"url,omitempty"`
	Location      *string           `json:"location,omitempty"`
	Bio           *string           `json:"bio,omitempty"`
	Repository    *Repository       `json:"repository,omitempty"`
	Repositories  *RepositoryCursor `json:"repositories"`
}

func (*User) isEntity() {}

type UserWebhookInput struct {
	Url    string         `json:"url"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
}

type UserWebhookSubscription struct {
	Id         int32                  `json:"id"`
	Events     []WebhookEvent         `json:"events"`
	Query      string                 `json:"query"`
	Url        string                 `json:"url"`
	Client     *OAuthClient           `json:"client,omitempty"`
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	Sample     string                 `json:"sample"`
}

func (*UserWebhookSubscription) isWebhookSubscription() {}

type Version struct {
	Major int32 `json:"major"`
	Minor int32 `json:"minor"`
	Patch int32 `json:"patch"`
	// If this API version is scheduled for deprecation, this is the date on which
	// it will stop working; or null if this API version is not scheduled for
	// deprecation.
	DeprecationDate gqlclient.Time `json:"deprecationDate,omitempty"`
	// Optional features
	Features *Features `json:"features"`
	// Config settings
	Settings *Settings `json:"settings"`
}

type Visibility string

const (
	// Visible to everyone, listed on your profile
	VisibilityPublic Visibility = "PUBLIC"
	// Visible to everyone (if they know the URL), not listed on your profile
	VisibilityUnlisted Visibility = "UNLISTED"
	// Not visible to anyone except those explicitly added to the access list
	VisibilityPrivate Visibility = "PRIVATE"
)

type WebhookDelivery struct {
	Uuid         string               `json:"uuid"`
	Date         gqlclient.Time       `json:"date"`
	Event        WebhookEvent         `json:"event"`
	Subscription *WebhookSubscription `json:"subscription"`
	RequestBody  string               `json:"requestBody"`
	// These details are provided only after a response is received from the
	// remote server. If a response is sent whose Content-Type is not text/*, or
	// cannot be decoded as UTF-8, the response body will be null. It will be
	// truncated after 64 KiB.
	ResponseBody    *string `json:"responseBody,omitempty"`
	ResponseHeaders *string `json:"responseHeaders,omitempty"`
	ResponseStatus  *int32  `json:"responseStatus,omitempty"`
}

// A cursor for enumerating a list of webhook deliveries
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookDeliveryCursor struct {
	Results []WebhookDelivery `json:"results"`
	Cursor  *Cursor           `json:"cursor,omitempty"`
}

type WebhookEvent string

const (
	WebhookEventRepoCreated WebhookEvent = "REPO_CREATED"
	WebhookEventRepoUpdate  WebhookEvent = "REPO_UPDATE"
	WebhookEventRepoDeleted WebhookEvent = "REPO_DELETED"
)

type WebhookPayload struct {
	Uuid  string         `json:"uuid"`
	Event WebhookEvent   `json:"event"`
	Date  gqlclient.Time `json:"date"`

	// Underlying value of the GraphQL interface
	Value WebhookPayloadValue `json:"-"`
}

func (base *WebhookPayload) UnmarshalJSON(b []byte) error {
	type Raw WebhookPayload
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "RepositoryEvent":
		base.Value = new(RepositoryEvent)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookPayload: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookPayloadValue is one of: RepositoryEvent
type WebhookPayloadValue interface {
	isWebhookPayload()
}

type WebhookSubscription struct {
	Id     int32          `json:"id"`
	Events []WebhookEvent `json:"events"`
	Query  string         `json:"query"`
	Url    string         `json:"url"`
	// If this webhook was registered by an authorized OAuth 2.0 client, this
	// field is non-null.
	Client *OAuthClient `json:"client,omitempty"`
	// All deliveries which have been sent to this webhook.
	Deliveries *WebhookDeliveryCursor `json:"deliveries"`
	// Returns a sample payload for this subscription, for testing purposes
	Sample string `json:"sample"`

	// Underlying value of the GraphQL interface
	Value WebhookSubscriptionValue `json:"-"`
}

func (base *WebhookSubscription) UnmarshalJSON(b []byte) error {
	type Raw WebhookSubscription
	var data struct {
		*Raw
		TypeName string `json:"__typename"`
	}
	data.Raw = (*Raw)(base)
	err := json.Unmarshal(b, &data)
	if err != nil {
		return err
	}
	switch data.TypeName {
	case "UserWebhookSubscription":
		base.Value = new(UserWebhookSubscription)
	case "":
		return nil
	default:
		return fmt.Errorf("gqlclient: interface WebhookSubscription: unknown __typename %q", data.TypeName)
	}
	return json.Unmarshal(b, base.Value)
}

// WebhookSubscriptionValue is one of: UserWebhookSubscription
type WebhookSubscriptionValue interface {
	isWebhookSubscription()
}

// A cursor for enumerating a list of webhook subscriptions
//
// If there are additional results available, the cursor object may be passed
// back into the same endpoint to retrieve another page. If the cursor is null,
// there are no remaining results to return.
type WebhookSubscriptionCursor struct {
	Results []WebhookSubscription `json:"results"`
	Cursor  *Cursor               `json:"cursor,omitempty"`
}

func RepositoryIDByName(client *gqlclient.Client, ctx context.Context, name string) (me *User, err error) {
	op := gqlclient.NewOperation("query repositoryIDByName ($name: String!) {\n\tme {\n\t\trepository(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func RepositoryIDByUser(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query repositoryIDByUser ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\trepository(name: $name) {\n\t\t\tid\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func Repositories(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (repositories *RepositoryCursor, err error) {
	op := gqlclient.NewOperation("query repositories ($cursor: Cursor) {\n\trepositories(cursor: $cursor) {\n\t\t... repos\n\t}\n}\nfragment repos on RepositoryCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Repositories *RepositoryCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Repositories, err
}

func RepositoriesByUser(client *gqlclient.Client, ctx context.Context, username string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query repositoriesByUser ($username: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\trepositories(cursor: $cursor) {\n\t\t\t... repos\n\t\t}\n\t}\n}\nfragment repos on RepositoryCursor {\n\tresults {\n\t\tname\n\t\tdescription\n\t\tvisibility\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t}\n\tcursor\n}\n")
	op.Var("username", username)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func ExportRepository(client *gqlclient.Client, ctx context.Context, username string, name string) (user *User, err error) {
	op := gqlclient.NewOperation("query exportRepository ($username: String!, $name: String!) {\n\tuser(username: $username) {\n\t\trepository(name: $name) {\n\t\t\t... repositoryExport\n\t\t}\n\t}\n}\nfragment repositoryExport on Repository {\n\tname\n\towner {\n\t\tcanonicalName\n\t}\n\tdescription\n\tvisibility\n\treadme\n\tnonPublishing\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func ExportRepositories(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (repositories *RepositoryCursor, err error) {
	op := gqlclient.NewOperation("query exportRepositories ($cursor: Cursor) {\n\trepositories(cursor: $cursor) {\n\t\tresults {\n\t\t\t... repositoryExport\n\t\t}\n\t\tcursor\n\t}\n}\nfragment repositoryExport on Repository {\n\tname\n\towner {\n\t\tcanonicalName\n\t}\n\tdescription\n\tvisibility\n\treadme\n\tnonPublishing\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		Repositories *RepositoryCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Repositories, err
}

func UserWebhooks(client *gqlclient.Client, ctx context.Context, cursor *Cursor) (userWebhooks *WebhookSubscriptionCursor, err error) {
	op := gqlclient.NewOperation("query userWebhooks ($cursor: Cursor) {\n\tuserWebhooks(cursor: $cursor) {\n\t\tresults {\n\t\t\tid\n\t\t\turl\n\t\t}\n\t\tcursor\n\t}\n}\n")
	op.Var("cursor", cursor)
	var respData struct {
		UserWebhooks *WebhookSubscriptionCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UserWebhooks, err
}

func SshSettings(client *gqlclient.Client, ctx context.Context) (version *Version, err error) {
	op := gqlclient.NewOperation("query sshSettings {\n\tversion {\n\t\tsettings {\n\t\t\tsshUser\n\t\t}\n\t}\n}\n")
	var respData struct {
		Version *Version
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Version, err
}

func CompleteRepositories(client *gqlclient.Client, ctx context.Context) (repositories *RepositoryCursor, err error) {
	op := gqlclient.NewOperation("query completeRepositories {\n\trepositories {\n\t\tresults {\n\t\t\tname\n\t\t}\n\t}\n}\n")
	var respData struct {
		Repositories *RepositoryCursor
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Repositories, err
}

func AclByRepoName(client *gqlclient.Client, ctx context.Context, name string, cursor *Cursor) (me *User, err error) {
	op := gqlclient.NewOperation("query aclByRepoName ($name: String!, $cursor: Cursor) {\n\tme {\n\t\t... acl\n\t}\n}\nfragment acl on User {\n\trepository(name: $name) {\n\t\taccessControlList(cursor: $cursor) {\n\t\t\tresults {\n\t\t\t\tid\n\t\t\t\tcreated\n\t\t\t\tentity {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t\tmode\n\t\t\t}\n\t\t\tcursor\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		Me *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.Me, err
}

func AclByUser(client *gqlclient.Client, ctx context.Context, username string, name string, cursor *Cursor) (user *User, err error) {
	op := gqlclient.NewOperation("query aclByUser ($username: String!, $name: String!, $cursor: Cursor) {\n\tuser(username: $username) {\n\t\t... acl\n\t}\n}\nfragment acl on User {\n\trepository(name: $name) {\n\t\taccessControlList(cursor: $cursor) {\n\t\t\tresults {\n\t\t\t\tid\n\t\t\t\tcreated\n\t\t\t\tentity {\n\t\t\t\t\tcanonicalName\n\t\t\t\t}\n\t\t\t\tmode\n\t\t\t}\n\t\t\tcursor\n\t\t}\n\t}\n}\n")
	op.Var("username", username)
	op.Var("name", name)
	op.Var("cursor", cursor)
	var respData struct {
		User *User
	}
	err = client.Execute(ctx, op, &respData)
	return respData.User, err
}

func CreateRepository(client *gqlclient.Client, ctx context.Context, name string, visibility Visibility, description string) (createRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation createRepository ($name: String!, $visibility: Visibility!, $description: String!) {\n\tcreateRepository(name: $name, visibility: $visibility, description: $description) {\n\t\tid\n\t\tname\n\t\towner {\n\t\t\tcanonicalName\n\t\t}\n\t}\n}\n")
	op.Var("name", name)
	op.Var("visibility", visibility)
	op.Var("description", description)
	var respData struct {
		CreateRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateRepository, err
}

func UpdateRepository(client *gqlclient.Client, ctx context.Context, id int32, input RepoInput) (updateRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation updateRepository ($id: Int!, $input: RepoInput!) {\n\tupdateRepository(id: $id, input: $input) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	op.Var("input", input)
	var respData struct {
		UpdateRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateRepository, err
}

func ClearCustomReadme(client *gqlclient.Client, ctx context.Context, id int32) (updateRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation clearCustomReadme ($id: Int!) {\n\tupdateRepository(id: $id, input: {readme:null}) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		UpdateRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateRepository, err
}

func ClearDescription(client *gqlclient.Client, ctx context.Context, id int32) (updateRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation clearDescription ($id: Int!) {\n\tupdateRepository(id: $id, input: {description:null}) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		UpdateRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateRepository, err
}

func DeleteRepository(client *gqlclient.Client, ctx context.Context, id int32) (deleteRepository *Repository, err error) {
	op := gqlclient.NewOperation("mutation deleteRepository ($id: Int!) {\n\tdeleteRepository(id: $id) {\n\t\tname\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteRepository *Repository
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteRepository, err
}

func CreateUserWebhook(client *gqlclient.Client, ctx context.Context, config UserWebhookInput) (createUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation createUserWebhook ($config: UserWebhookInput!) {\n\tcreateUserWebhook(config: $config) {\n\t\tid\n\t}\n}\n")
	op.Var("config", config)
	var respData struct {
		CreateUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.CreateUserWebhook, err
}

func DeleteUserWebhook(client *gqlclient.Client, ctx context.Context, id int32) (deleteUserWebhook *WebhookSubscription, err error) {
	op := gqlclient.NewOperation("mutation deleteUserWebhook ($id: Int!) {\n\tdeleteUserWebhook(id: $id) {\n\t\tid\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteUserWebhook *WebhookSubscription
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteUserWebhook, err
}

func UpdateACL(client *gqlclient.Client, ctx context.Context, repoId int32, mode AccessMode, entity string) (updateACL *ACL, err error) {
	op := gqlclient.NewOperation("mutation updateACL ($repoId: Int!, $mode: AccessMode!, $entity: ID!) {\n\tupdateACL(repoId: $repoId, mode: $mode, entity: $entity) {\n\t\tentity {\n\t\t\tcanonicalName\n\t\t}\n\t}\n}\n")
	op.Var("repoId", repoId)
	op.Var("mode", mode)
	op.Var("entity", entity)
	var respData struct {
		UpdateACL *ACL
	}
	err = client.Execute(ctx, op, &respData)
	return respData.UpdateACL, err
}

func DeleteACL(client *gqlclient.Client, ctx context.Context, id int32) (deleteACL *ACL, err error) {
	op := gqlclient.NewOperation("mutation deleteACL ($id: Int!) {\n\tdeleteACL(id: $id) {\n\t\tentity {\n\t\t\tcanonicalName\n\t\t}\n\t\trepository {\n\t\t\tname\n\t\t}\n\t}\n}\n")
	op.Var("id", id)
	var respData struct {
		DeleteACL *ACL
	}
	err = client.Execute(ctx, op, &respData)
	return respData.DeleteACL, err
}
