
/*** DO NOT EDIT THIS FILE DIRECTLY (use ../config/gen_code.sh to generate) ***/

#include "_hypre_parcsr_ls.h"

#ifdef HYPRE_MIXED_PRECISION

/******************************************************************************
 * Copyright (c) 1998 Lawrence Livermore National Security, LLC and other
 * HYPRE Project Developers. See the top-level COPYRIGHT file for details.
 *
 * SPDX-License-Identifier: (Apache-2.0 OR MIT)
 ******************************************************************************/


/*--------------------------------------------------------------------------*/

HYPRE_ParCSRMatrix
GenerateDifConv( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Real *value )
{
   return HYPRE_CURRENTPRECISION_FUNC(GenerateDifConv)( comm, nx, ny, nz, P, Q, R, p, q, r, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_ParCSRMatrix
GenerateLaplacian( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Real *value )
{
   return HYPRE_CURRENTPRECISION_FUNC(GenerateLaplacian)( comm, nx, ny, nz, P, Q, R, p, q, r, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_ParCSRMatrix
GenerateLaplacian27pt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Real *value )
{
   return HYPRE_CURRENTPRECISION_FUNC(GenerateLaplacian27pt)( comm, nx, ny, nz, P, Q, R, p, q, r, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_ParCSRMatrix
GenerateLaplacian9pt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int p, HYPRE_Int q, HYPRE_Real *value )
{
   return HYPRE_CURRENTPRECISION_FUNC(GenerateLaplacian9pt)( comm, nx, ny, P, Q, p, q, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_ParCSRMatrix
GenerateRSVarDifConv( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Real eps, HYPRE_ParVector *rhs_ptr, HYPRE_Int type )
{
   return HYPRE_CURRENTPRECISION_FUNC(GenerateRSVarDifConv)( comm, nx, ny, nz, P, Q, R, p, q, r, eps, rhs_ptr, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_ParCSRMatrix
GenerateRotate7pt( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int p, HYPRE_Int q, HYPRE_Real alpha, HYPRE_Real eps )
{
   return HYPRE_CURRENTPRECISION_FUNC(GenerateRotate7pt)( comm, nx, ny, P, Q, p, q, alpha, eps );
}

/*--------------------------------------------------------------------------*/

HYPRE_ParCSRMatrix
GenerateVarDifConv( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Real eps, HYPRE_ParVector *rhs_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(GenerateVarDifConv)( comm, nx, ny, nz, P, Q, R, p, q, r, eps, rhs_ptr );
}

/*--------------------------------------------------------------------------*/

float*
hypre_GenerateCoordinates( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Int coorddim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GenerateCoordinates)( comm, nx, ny, nz, P, Q, R, p, q, r, coorddim );
}


/*--------------------------------------------------------------------------*/

HYPRE_ParCSRMatrix
GenerateSysLaplacian( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Int num_fun, HYPRE_Real *mtrx, HYPRE_Real *value )
{
   return HYPRE_CURRENTPRECISION_FUNC(GenerateSysLaplacian)( comm, nx, ny, nz, P, Q, R, p, q, r, num_fun, mtrx, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_ParCSRMatrix
GenerateSysLaplacianVCoef( MPI_Comm comm, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt nz, HYPRE_Int P, HYPRE_Int Q, HYPRE_Int R, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_Int num_fun, HYPRE_Real *mtrx, HYPRE_Real *value )
{
   return HYPRE_CURRENTPRECISION_FUNC(GenerateSysLaplacianVCoef)( comm, nx, ny, nz, P, Q, R, p, q, r, num_fun, mtrx, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
afun( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(afun)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
afun_rs( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(afun_rs)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

void
aux_indexFromMask( HYPRE_Int n, HYPRE_Int *mask, HYPRE_Int *index )
{
   return HYPRE_CURRENTPRECISION_FUNC(aux_indexFromMask)( n, mask, index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
aux_maskCount( HYPRE_Int n, HYPRE_Int *mask )
{
   return HYPRE_CURRENTPRECISION_FUNC(aux_maskCount)( n, mask );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
bfun( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(bfun)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
bfun_rs( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(bfun_rs)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
bndfun( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(bndfun)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
bndfun_rs( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(bndfun_rs)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
cfun( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(cfun)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
cfun_rs( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(cfun_rs)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
dfun( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(dfun)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
dfun_rs( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(dfun_rs)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
efun( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(efun)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
efun_rs( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(efun_rs)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
ffun( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(ffun)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
ffun_rs( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(ffun_rs)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
gfun( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(gfun)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
gfun_rs( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(gfun_rs)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSComputePi( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *C, hypre_ParCSRMatrix *G, hypre_ParVector *x, hypre_ParVector *y, hypre_ParVector *z, hypre_ParCSRMatrix *PiNDx, hypre_ParCSRMatrix *PiNDy, hypre_ParCSRMatrix *PiNDz, hypre_ParCSRMatrix **Pi_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSComputePi)( A, C, G, x, y, z, PiNDx, PiNDy, PiNDz, Pi_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSComputePixyz( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *C, hypre_ParCSRMatrix *G, hypre_ParVector *x, hypre_ParVector *y, hypre_ParVector *z, hypre_ParCSRMatrix *PiNDx, hypre_ParCSRMatrix *PiNDy, hypre_ParCSRMatrix *PiNDz, hypre_ParCSRMatrix **Pix_ptr, hypre_ParCSRMatrix **Piy_ptr, hypre_ParCSRMatrix **Piz_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSComputePixyz)( A, C, G, x, y, z, PiNDx, PiNDy, PiNDz, Pix_ptr, Piy_ptr, Piz_ptr );
}

/*--------------------------------------------------------------------------*/

void *
hypre_ADSCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSDestroy( void *solver )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSDestroy)( solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSGetFinalRelativeResidualNorm( void *solver, HYPRE_Real *rel_resid_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSGetFinalRelativeResidualNorm)( solver, rel_resid_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSGetNumIterations( void *solver, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSGetNumIterations)( solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetAMGOptions( void *solver, HYPRE_Int B_Pi_coarsen_type, HYPRE_Int B_Pi_agg_levels, HYPRE_Int B_Pi_relax_type, HYPRE_Real B_Pi_theta, HYPRE_Int B_Pi_interp_type, HYPRE_Int B_Pi_Pmax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetAMGOptions)( solver, B_Pi_coarsen_type, B_Pi_agg_levels, B_Pi_relax_type, B_Pi_theta, B_Pi_interp_type, B_Pi_Pmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetAMSOptions( void *solver, HYPRE_Int B_C_cycle_type, HYPRE_Int B_C_coarsen_type, HYPRE_Int B_C_agg_levels, HYPRE_Int B_C_relax_type, HYPRE_Real B_C_theta, HYPRE_Int B_C_interp_type, HYPRE_Int B_C_Pmax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetAMSOptions)( solver, B_C_cycle_type, B_C_coarsen_type, B_C_agg_levels, B_C_relax_type, B_C_theta, B_C_interp_type, B_C_Pmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetChebySmoothingOptions( void *solver, HYPRE_Int A_cheby_order, HYPRE_Real A_cheby_fraction )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetChebySmoothingOptions)( solver, A_cheby_order, A_cheby_fraction );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetCoordinateVectors( void *solver, hypre_ParVector *x, hypre_ParVector *y, hypre_ParVector *z )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetCoordinateVectors)( solver, x, y, z );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetCycleType( void *solver, HYPRE_Int cycle_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetCycleType)( solver, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetDiscreteCurl( void *solver, hypre_ParCSRMatrix *C )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetDiscreteCurl)( solver, C );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetDiscreteGradient( void *solver, hypre_ParCSRMatrix *G )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetDiscreteGradient)( solver, G );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetInterpolations( void *solver, hypre_ParCSRMatrix *RT_Pi, hypre_ParCSRMatrix *RT_Pix, hypre_ParCSRMatrix *RT_Piy, hypre_ParCSRMatrix *RT_Piz, hypre_ParCSRMatrix *ND_Pi, hypre_ParCSRMatrix *ND_Pix, hypre_ParCSRMatrix *ND_Piy, hypre_ParCSRMatrix *ND_Piz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetInterpolations)( solver, RT_Pi, RT_Pix, RT_Piy, RT_Piz, ND_Pi, ND_Pix, ND_Piy, ND_Piz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetMaxIter( void *solver, HYPRE_Int maxit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetMaxIter)( solver, maxit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetPrintLevel( void *solver, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetPrintLevel)( solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetSmoothingOptions( void *solver, HYPRE_Int A_relax_type, HYPRE_Int A_relax_times, HYPRE_Real A_relax_weight, HYPRE_Real A_omega )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetSmoothingOptions)( solver, A_relax_type, A_relax_times, A_relax_weight, A_omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetTol( void *solver, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetTol)( solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSetup( void *solver, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSetup)( solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ADSSolve( void *solver, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ADSSolve)( solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

void *
hypre_AMECreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMECreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMEDestroy( void *esolver )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEDestroy)( esolver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMEDiscrDivFreeComponent( void *esolver, hypre_ParVector *b )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEDiscrDivFreeComponent)( esolver, b );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMEGetEigenvalues( void *esolver, HYPRE_Real **eigenvalues_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEGetEigenvalues)( esolver, eigenvalues_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMEGetEigenvectors( void *esolver, HYPRE_ParVector **eigenvectors_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEGetEigenvectors)( esolver, eigenvectors_ptr );
}

/*--------------------------------------------------------------------------*/

void
hypre_AMEMultiOperatorA( void *data, void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEMultiOperatorA)( data, x, y );
}

/*--------------------------------------------------------------------------*/

void
hypre_AMEMultiOperatorB( void *data, void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEMultiOperatorB)( data, x, y );
}

/*--------------------------------------------------------------------------*/

void
hypre_AMEMultiOperatorM( void *data, void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEMultiOperatorM)( data, x, y );
}

/*--------------------------------------------------------------------------*/

void
hypre_AMEOperatorA( void *data, void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEOperatorA)( data, x, y );
}

/*--------------------------------------------------------------------------*/

void
hypre_AMEOperatorB( void *data, void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEOperatorB)( data, x, y );
}

/*--------------------------------------------------------------------------*/

void
hypre_AMEOperatorM( void *data, void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMEOperatorM)( data, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESetAMSSolver( void *esolver, void *ams_solver )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESetAMSSolver)( esolver, ams_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESetBlockSize( void *esolver, HYPRE_Int block_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESetBlockSize)( esolver, block_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESetMassMatrix( void *esolver, hypre_ParCSRMatrix *M )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESetMassMatrix)( esolver, M );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESetMaxIter( void *esolver, HYPRE_Int maxit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESetMaxIter)( esolver, maxit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESetMaxPCGIter( void *esolver, HYPRE_Int maxit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESetMaxPCGIter)( esolver, maxit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESetPrintLevel( void *esolver, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESetPrintLevel)( esolver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESetRTol( void *esolver, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESetRTol)( esolver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESetTol( void *esolver, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESetTol)( esolver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESetup( void *esolver )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESetup)( esolver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMESolve( void *esolver )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMESolve)( esolver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGCreateDomainDof( hypre_CSRMatrix *A, HYPRE_Int domain_type, HYPRE_Int overlap, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_CSRMatrix **domain_structure_pointer, HYPRE_Int **piv_pointer, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGCreateDomainDof)( A, domain_type, overlap, num_functions, dof_func, domain_structure_pointer, piv_pointer, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

hypre_AMGDDCommPkg *
hypre_AMGDDCommPkgCreate( HYPRE_Int num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCommPkgCreate)( num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCommPkgDestroy( hypre_AMGDDCommPkg *compGridCommPkg )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCommPkgDestroy)( compGridCommPkg );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCommPkgRecvLevelDestroy( hypre_AMGDDCommPkg *amgddCommPkg, HYPRE_Int level, HYPRE_Int proc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCommPkgRecvLevelDestroy)( amgddCommPkg, level, proc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCommPkgSendLevelDestroy( hypre_AMGDDCommPkg *amgddCommPkg, HYPRE_Int level, HYPRE_Int proc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCommPkgSendLevelDestroy)( amgddCommPkg, level, proc );
}

/*--------------------------------------------------------------------------*/

hypre_AMGDDCompGrid *
hypre_AMGDDCompGridCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridDestroy( hypre_AMGDDCompGrid *compGrid )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridDestroy)( compGrid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridFinalize( hypre_ParAMGDDData *amgdd_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridFinalize)( amgdd_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridInitialize( hypre_ParAMGDDData *amgdd_data, HYPRE_Int padding, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridInitialize)( amgdd_data, padding, level );
}

/*--------------------------------------------------------------------------*/

hypre_AMGDDCompGridMatrix*
hypre_AMGDDCompGridMatrixCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridMatrixCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridMatrixDestroy( hypre_AMGDDCompGridMatrix *matrix )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridMatrixDestroy)( matrix );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridMatvec( HYPRE_Complex alpha, hypre_AMGDDCompGridMatrix *A, hypre_AMGDDCompGridVector *x, HYPRE_Complex beta, hypre_AMGDDCompGridVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridMatvec)( alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridRealMatvec( HYPRE_Complex alpha, hypre_AMGDDCompGridMatrix *A, hypre_AMGDDCompGridVector *x, HYPRE_Complex beta, hypre_AMGDDCompGridVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridRealMatvec)( alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridResize( hypre_AMGDDCompGrid *compGrid, HYPRE_Int new_size, HYPRE_Int need_coarse_info )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridResize)( compGrid, new_size, need_coarse_info );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridSetupLocalIndices( hypre_AMGDDCompGrid **compGrid, HYPRE_Int *num_added_nodes, HYPRE_Int ****recv_map, HYPRE_Int num_recv_procs, HYPRE_Int **A_tmp_info, HYPRE_Int start_level, HYPRE_Int num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridSetupLocalIndices)( compGrid, num_added_nodes, recv_map, num_recv_procs, A_tmp_info, start_level, num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridSetupLocalIndicesP( hypre_ParAMGDDData *amgdd_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridSetupLocalIndicesP)( amgdd_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridSetupRelax( hypre_ParAMGDDData *amgdd_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridSetupRelax)( amgdd_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorAxpy( HYPRE_Complex alpha, hypre_AMGDDCompGridVector *x, hypre_AMGDDCompGridVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorAxpy)( alpha, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorCopy( hypre_AMGDDCompGridVector *x, hypre_AMGDDCompGridVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorCopy)( x, y );
}

/*--------------------------------------------------------------------------*/

hypre_AMGDDCompGridVector*
hypre_AMGDDCompGridVectorCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorDestroy( hypre_AMGDDCompGridVector *vector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorDestroy)( vector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorInitialize( hypre_AMGDDCompGridVector *vector, HYPRE_Int num_owned, HYPRE_Int num_nonowned, HYPRE_Int num_real )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorInitialize)( vector, num_owned, num_nonowned, num_real );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_AMGDDCompGridVectorInnerProd( hypre_AMGDDCompGridVector *x, hypre_AMGDDCompGridVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorInnerProd)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorRealAxpy( HYPRE_Complex alpha, hypre_AMGDDCompGridVector *x, hypre_AMGDDCompGridVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorRealAxpy)( alpha, x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorRealCopy( hypre_AMGDDCompGridVector *x, hypre_AMGDDCompGridVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorRealCopy)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_AMGDDCompGridVectorRealInnerProd( hypre_AMGDDCompGridVector *x, hypre_AMGDDCompGridVector *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorRealInnerProd)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorRealScale( HYPRE_Complex alpha, hypre_AMGDDCompGridVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorRealScale)( alpha, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorRealSetConstantValues( hypre_AMGDDCompGridVector *vector, HYPRE_Complex value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorRealSetConstantValues)( vector, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorScale( HYPRE_Complex alpha, hypre_AMGDDCompGridVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorScale)( alpha, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGDDCompGridVectorSetConstantValues( hypre_AMGDDCompGridVector *vector, HYPRE_Complex value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGDDCompGridVectorSetConstantValues)( vector, value );
}

/*--------------------------------------------------------------------------*/

void *
hypre_AMGHybridCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridDestroy( void *AMGhybrid_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridDestroy)( AMGhybrid_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridGetDSCGNumIterations( void *AMGhybrid_vdata, HYPRE_Int *dscg_num_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridGetDSCGNumIterations)( AMGhybrid_vdata, dscg_num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridGetFinalRelativeResidualNorm( void *AMGhybrid_vdata, HYPRE_Real *final_rel_res_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridGetFinalRelativeResidualNorm)( AMGhybrid_vdata, final_rel_res_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridGetNumIterations( void *AMGhybrid_vdata, HYPRE_Int *num_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridGetNumIterations)( AMGhybrid_vdata, num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridGetPCGNumIterations( void *AMGhybrid_vdata, HYPRE_Int *pcg_num_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridGetPCGNumIterations)( AMGhybrid_vdata, pcg_num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridGetRecomputeResidual( void *AMGhybrid_vdata, HYPRE_Int *recompute_residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridGetRecomputeResidual)( AMGhybrid_vdata, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridGetRecomputeResidualP( void *AMGhybrid_vdata, HYPRE_Int *recompute_residual_p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridGetRecomputeResidualP)( AMGhybrid_vdata, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridGetSetupSolveTime( void *AMGhybrid_vdata, HYPRE_Real *time )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridGetSetupSolveTime)( AMGhybrid_vdata, time );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetAbsoluteTol( void *AMGhybrid_vdata, HYPRE_Real a_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetAbsoluteTol)( AMGhybrid_vdata, a_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetAggInterpType( void *AMGhybrid_vdata, HYPRE_Int agg_interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetAggInterpType)( AMGhybrid_vdata, agg_interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetAggNumLevels( void *AMGhybrid_vdata, HYPRE_Int agg_num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetAggNumLevels)( AMGhybrid_vdata, agg_num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetCoarsenType( void *AMGhybrid_vdata, HYPRE_Int coarsen_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetCoarsenType)( AMGhybrid_vdata, coarsen_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetConvergenceTol( void *AMGhybrid_vdata, HYPRE_Real cf_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetConvergenceTol)( AMGhybrid_vdata, cf_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetCycleNumSweeps( void *AMGhybrid_vdata, HYPRE_Int num_sweeps, HYPRE_Int k )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetCycleNumSweeps)( AMGhybrid_vdata, num_sweeps, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetCycleRelaxType( void *AMGhybrid_vdata, HYPRE_Int relax_type, HYPRE_Int k )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetCycleRelaxType)( AMGhybrid_vdata, relax_type, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetCycleType( void *AMGhybrid_vdata, HYPRE_Int cycle_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetCycleType)( AMGhybrid_vdata, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetDSCGMaxIter( void *AMGhybrid_vdata, HYPRE_Int dscg_max_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetDSCGMaxIter)( AMGhybrid_vdata, dscg_max_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetDofFunc( void *AMGhybrid_vdata, HYPRE_Int *dof_func )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetDofFunc)( AMGhybrid_vdata, dof_func );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetGridRelaxPoints( void *AMGhybrid_vdata, HYPRE_Int **grid_relax_points )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetGridRelaxPoints)( AMGhybrid_vdata, grid_relax_points );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetGridRelaxType( void *AMGhybrid_vdata, HYPRE_Int *grid_relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetGridRelaxType)( AMGhybrid_vdata, grid_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetInterpType( void *AMGhybrid_vdata, HYPRE_Int interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetInterpType)( AMGhybrid_vdata, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetKDim( void *AMGhybrid_vdata, HYPRE_Int k_dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetKDim)( AMGhybrid_vdata, k_dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetKeepTranspose( void *AMGhybrid_vdata, HYPRE_Int keepT )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetKeepTranspose)( AMGhybrid_vdata, keepT );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetLevelOuterWt( void *AMGhybrid_vdata, HYPRE_Real outer_wt, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetLevelOuterWt)( AMGhybrid_vdata, outer_wt, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetLevelRelaxWt( void *AMGhybrid_vdata, HYPRE_Real relax_wt, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetLevelRelaxWt)( AMGhybrid_vdata, relax_wt, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetLogging( void *AMGhybrid_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetLogging)( AMGhybrid_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetMaxCoarseSize( void *AMGhybrid_vdata, HYPRE_Int max_coarse_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetMaxCoarseSize)( AMGhybrid_vdata, max_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetMaxLevels( void *AMGhybrid_vdata, HYPRE_Int max_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetMaxLevels)( AMGhybrid_vdata, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetMaxRowSum( void *AMGhybrid_vdata, HYPRE_Real max_row_sum )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetMaxRowSum)( AMGhybrid_vdata, max_row_sum );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetMeasureType( void *AMGhybrid_vdata, HYPRE_Int measure_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetMeasureType)( AMGhybrid_vdata, measure_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetMinCoarseSize( void *AMGhybrid_vdata, HYPRE_Int min_coarse_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetMinCoarseSize)( AMGhybrid_vdata, min_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetNodal( void *AMGhybrid_vdata, HYPRE_Int nodal )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetNodal)( AMGhybrid_vdata, nodal );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetNonGalerkinTol( void *AMGhybrid_vdata, HYPRE_Int nongalerk_num_tol, HYPRE_Real *nongalerkin_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetNonGalerkinTol)( AMGhybrid_vdata, nongalerk_num_tol, nongalerkin_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetNumFunctions( void *AMGhybrid_vdata, HYPRE_Int num_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetNumFunctions)( AMGhybrid_vdata, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetNumGridSweeps( void *AMGhybrid_vdata, HYPRE_Int *num_grid_sweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetNumGridSweeps)( AMGhybrid_vdata, num_grid_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetNumPaths( void *AMGhybrid_vdata, HYPRE_Int num_paths )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetNumPaths)( AMGhybrid_vdata, num_paths );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetNumSweeps( void *AMGhybrid_vdata, HYPRE_Int num_sweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetNumSweeps)( AMGhybrid_vdata, num_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetOmega( void *AMGhybrid_vdata, HYPRE_Real *omega )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetOmega)( AMGhybrid_vdata, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetOuterWt( void *AMGhybrid_vdata, HYPRE_Real outer_wt )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetOuterWt)( AMGhybrid_vdata, outer_wt );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetPCGMaxIter( void *AMGhybrid_vdata, HYPRE_Int pcg_max_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetPCGMaxIter)( AMGhybrid_vdata, pcg_max_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetPMaxElmts( void *AMGhybrid_vdata, HYPRE_Int P_max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetPMaxElmts)( AMGhybrid_vdata, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetPrintLevel( void *AMGhybrid_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetPrintLevel)( AMGhybrid_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetRecomputeResidual( void *AMGhybrid_vdata, HYPRE_Int recompute_residual )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetRecomputeResidual)( AMGhybrid_vdata, recompute_residual );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetRecomputeResidualP( void *AMGhybrid_vdata, HYPRE_Int recompute_residual_p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetRecomputeResidualP)( AMGhybrid_vdata, recompute_residual_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetRelChange( void *AMGhybrid_vdata, HYPRE_Int rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetRelChange)( AMGhybrid_vdata, rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetRelaxOrder( void *AMGhybrid_vdata, HYPRE_Int relax_order )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetRelaxOrder)( AMGhybrid_vdata, relax_order );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetRelaxType( void *AMGhybrid_vdata, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetRelaxType)( AMGhybrid_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetRelaxWeight( void *AMGhybrid_vdata, HYPRE_Real *relax_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetRelaxWeight)( AMGhybrid_vdata, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetRelaxWt( void *AMGhybrid_vdata, HYPRE_Real relax_wt )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetRelaxWt)( AMGhybrid_vdata, relax_wt );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetSeqThreshold( void *AMGhybrid_vdata, HYPRE_Int seq_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetSeqThreshold)( AMGhybrid_vdata, seq_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetSetupType( void *AMGhybrid_vdata, HYPRE_Int setup_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetSetupType)( AMGhybrid_vdata, setup_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetSolverType( void *AMGhybrid_vdata, HYPRE_Int solver_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetSolverType)( AMGhybrid_vdata, solver_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetStopCrit( void *AMGhybrid_vdata, HYPRE_Int stop_crit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetStopCrit)( AMGhybrid_vdata, stop_crit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetStrongThreshold( void *AMGhybrid_vdata, HYPRE_Real strong_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetStrongThreshold)( AMGhybrid_vdata, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetTol( void *AMGhybrid_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetTol)( AMGhybrid_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetTruncFactor( void *AMGhybrid_vdata, HYPRE_Real trunc_factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetTruncFactor)( AMGhybrid_vdata, trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetTwoNorm( void *AMGhybrid_vdata, HYPRE_Int two_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetTwoNorm)( AMGhybrid_vdata, two_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSetup( void *AMGhybrid_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSetup)( AMGhybrid_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGHybridSolve( void *AMGhybrid_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGHybridSolve)( AMGhybrid_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGNodalSchwarzSmoother( hypre_CSRMatrix *A, HYPRE_Int num_functions, HYPRE_Int option, hypre_CSRMatrix **domain_structure_pointer )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGNodalSchwarzSmoother)( A, num_functions, option, domain_structure_pointer );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMGeAgglomerate( HYPRE_Int *i_AE_element, HYPRE_Int *j_AE_element, HYPRE_Int *i_face_face, HYPRE_Int *j_face_face, HYPRE_Int *w_face_face, HYPRE_Int *i_face_element, HYPRE_Int *j_face_element, HYPRE_Int *i_element_face, HYPRE_Int *j_element_face, HYPRE_Int *i_face_to_prefer_weight, HYPRE_Int *i_face_weight, HYPRE_Int num_faces, HYPRE_Int num_elements, HYPRE_Int *num_AEs_pointer )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMGeAgglomerate)( i_AE_element, j_AE_element, i_face_face, j_face_face, w_face_face, i_face_element, j_face_element, i_element_face, j_element_face, i_face_to_prefer_weight, i_face_weight, num_faces, num_elements, num_AEs_pointer );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSComputeGPi( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *G, hypre_ParVector *Gx, hypre_ParVector *Gy, hypre_ParVector *Gz, HYPRE_Int dim, hypre_ParCSRMatrix **GPi_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSComputeGPi)( A, G, Gx, Gy, Gz, dim, GPi_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSComputePi( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *G, hypre_ParVector *Gx, hypre_ParVector *Gy, hypre_ParVector *Gz, HYPRE_Int dim, hypre_ParCSRMatrix **Pi_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSComputePi)( A, G, Gx, Gy, Gz, dim, Pi_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSComputePixyz( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *G, hypre_ParVector *Gx, hypre_ParVector *Gy, hypre_ParVector *Gz, HYPRE_Int dim, hypre_ParCSRMatrix **Pix_ptr, hypre_ParCSRMatrix **Piy_ptr, hypre_ParCSRMatrix **Piz_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSComputePixyz)( A, G, Gx, Gy, Gz, dim, Pix_ptr, Piy_ptr, Piz_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSConstructDiscreteGradient( hypre_ParCSRMatrix *A, hypre_ParVector *x_coord, HYPRE_BigInt *edge_vertex, HYPRE_Int edge_orientation, hypre_ParCSRMatrix **G_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSConstructDiscreteGradient)( A, x_coord, edge_vertex, edge_orientation, G_ptr );
}

/*--------------------------------------------------------------------------*/

void *
hypre_AMSCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSDestroy( void *solver )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSDestroy)( solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSFEIDestroy( void *solver )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSFEIDestroy)( solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSFEISetup( void *solver, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x, HYPRE_Int num_vert, HYPRE_Int num_local_vert, HYPRE_BigInt *vert_number, HYPRE_Real *vert_coord, HYPRE_Int num_edges, HYPRE_BigInt *edge_vertex )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSFEISetup)( solver, A, b, x, num_vert, num_local_vert, vert_number, vert_coord, num_edges, edge_vertex );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSGetFinalRelativeResidualNorm( void *solver, HYPRE_Real *rel_resid_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSGetFinalRelativeResidualNorm)( solver, rel_resid_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSGetNumIterations( void *solver, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSGetNumIterations)( solver, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSProjectOutGradients( void *solver, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSProjectOutGradients)( solver, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetAlphaAMGCoarseRelaxType( void *solver, HYPRE_Int B_Pi_coarse_relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetAlphaAMGCoarseRelaxType)( solver, B_Pi_coarse_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetAlphaAMGOptions( void *solver, HYPRE_Int B_Pi_coarsen_type, HYPRE_Int B_Pi_agg_levels, HYPRE_Int B_Pi_relax_type, HYPRE_Real B_Pi_theta, HYPRE_Int B_Pi_interp_type, HYPRE_Int B_Pi_Pmax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetAlphaAMGOptions)( solver, B_Pi_coarsen_type, B_Pi_agg_levels, B_Pi_relax_type, B_Pi_theta, B_Pi_interp_type, B_Pi_Pmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetAlphaPoissonMatrix( void *solver, hypre_ParCSRMatrix *A_Pi )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetAlphaPoissonMatrix)( solver, A_Pi );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetBetaAMGCoarseRelaxType( void *solver, HYPRE_Int B_G_coarse_relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetBetaAMGCoarseRelaxType)( solver, B_G_coarse_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetBetaAMGOptions( void *solver, HYPRE_Int B_G_coarsen_type, HYPRE_Int B_G_agg_levels, HYPRE_Int B_G_relax_type, HYPRE_Real B_G_theta, HYPRE_Int B_G_interp_type, HYPRE_Int B_G_Pmax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetBetaAMGOptions)( solver, B_G_coarsen_type, B_G_agg_levels, B_G_relax_type, B_G_theta, B_G_interp_type, B_G_Pmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetBetaPoissonMatrix( void *solver, hypre_ParCSRMatrix *A_G )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetBetaPoissonMatrix)( solver, A_G );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetChebySmoothingOptions( void *solver, HYPRE_Int A_cheby_order, HYPRE_Real A_cheby_fraction )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetChebySmoothingOptions)( solver, A_cheby_order, A_cheby_fraction );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetCoordinateVectors( void *solver, hypre_ParVector *x, hypre_ParVector *y, hypre_ParVector *z )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetCoordinateVectors)( solver, x, y, z );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetCycleType( void *solver, HYPRE_Int cycle_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetCycleType)( solver, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetDimension( void *solver, HYPRE_Int dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetDimension)( solver, dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetDiscreteGradient( void *solver, hypre_ParCSRMatrix *G )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetDiscreteGradient)( solver, G );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetEdgeConstantVectors( void *solver, hypre_ParVector *Gx, hypre_ParVector *Gy, hypre_ParVector *Gz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetEdgeConstantVectors)( solver, Gx, Gy, Gz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetInteriorNodes( void *solver, hypre_ParVector *interior_nodes )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetInteriorNodes)( solver, interior_nodes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetInterpolations( void *solver, hypre_ParCSRMatrix *Pi, hypre_ParCSRMatrix *Pix, hypre_ParCSRMatrix *Piy, hypre_ParCSRMatrix *Piz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetInterpolations)( solver, Pi, Pix, Piy, Piz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetMaxIter( void *solver, HYPRE_Int maxit )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetMaxIter)( solver, maxit );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetPrintLevel( void *solver, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetPrintLevel)( solver, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetProjectionFrequency( void *solver, HYPRE_Int projection_frequency )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetProjectionFrequency)( solver, projection_frequency );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetSmoothingOptions( void *solver, HYPRE_Int A_relax_type, HYPRE_Int A_relax_times, HYPRE_Real A_relax_weight, HYPRE_Real A_omega )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetSmoothingOptions)( solver, A_relax_type, A_relax_times, A_relax_weight, A_omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetTol( void *solver, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetTol)( solver, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSetup( void *solver, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSetup)( solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AMSSolve( void *solver, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AMSSolve)( solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AdSchwarzCFSolve( hypre_ParCSRMatrix *par_A, hypre_ParVector *par_rhs, hypre_CSRMatrix *domain_structure, HYPRE_Real *scale, hypre_ParVector *par_x, hypre_ParVector *par_aux, HYPRE_Int *CF_marker, HYPRE_Int rlx_pt, HYPRE_Int *pivots, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AdSchwarzCFSolve)( par_A, par_rhs, domain_structure, scale, par_x, par_aux, CF_marker, rlx_pt, pivots, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AdSchwarzSolve( hypre_ParCSRMatrix *par_A, hypre_ParVector *par_rhs, hypre_CSRMatrix *domain_structure, HYPRE_Real *scale, hypre_ParVector *par_x, hypre_ParVector *par_aux, HYPRE_Int *pivots, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AdSchwarzSolve)( par_A, par_rhs, domain_structure, scale, par_x, par_aux, pivots, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AddToPattern( hypre_Vector *kaporin_gradient, HYPRE_Int *kap_grad_nonzeros, HYPRE_Int *S_Pattern, HYPRE_Int *S_nnz, HYPRE_Int *kg_marker, HYPRE_Int max_step_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AddToPattern)( kaporin_gradient, kap_grad_nonzeros, S_Pattern, S_nnz, kg_marker, max_step_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AmgCGCBoundaryFix( hypre_ParCSRMatrix *S, HYPRE_Int *CF_marker, HYPRE_Int *CF_marker_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AmgCGCBoundaryFix)( S, CF_marker, CF_marker_offd );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AmgCGCChoose( hypre_CSRMatrix *G, HYPRE_Int *vertexrange, HYPRE_Int mpisize, HYPRE_Int **coarse )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AmgCGCChoose)( G, vertexrange, mpisize, coarse );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AmgCGCGraphAssemble( hypre_ParCSRMatrix *S, HYPRE_Int *vertexrange, HYPRE_Int *CF_marker, HYPRE_Int *CF_marker_offd, HYPRE_Int coarsen_type, HYPRE_IJMatrix *ijG )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AmgCGCGraphAssemble)( S, vertexrange, CF_marker, CF_marker_offd, coarsen_type, ijG );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_AmgCGCPrepare( hypre_ParCSRMatrix *S, HYPRE_Int nlocal, HYPRE_Int *CF_marker, HYPRE_Int **CF_marker_offd, HYPRE_Int coarsen_type, HYPRE_Int **vrange )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_AmgCGCPrepare)( S, nlocal, CF_marker, CF_marker_offd, coarsen_type, vrange );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_Bisection( HYPRE_Int n, HYPRE_Real *diag, HYPRE_Real *offd, HYPRE_Real y, HYPRE_Real z, HYPRE_Real tol, HYPRE_Int k, HYPRE_Real *ev_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_Bisection)( n, diag, offd, y, z, tol, k, ev_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BlockDiagInvLapack( HYPRE_Real *diag, HYPRE_Int N, HYPRE_Int blk_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockDiagInvLapack)( diag, N, blk_size );
}

/*--------------------------------------------------------------------------*/

void *
hypre_BlockTridiagCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockTridiagCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BlockTridiagDestroy( void *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockTridiagDestroy)( data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BlockTridiagSetAMGNumSweeps( void *data, HYPRE_Int nsweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockTridiagSetAMGNumSweeps)( data, nsweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BlockTridiagSetAMGRelaxType( void *data, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockTridiagSetAMGRelaxType)( data, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BlockTridiagSetAMGStrengthThreshold( void *data, HYPRE_Real thresh )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockTridiagSetAMGStrengthThreshold)( data, thresh );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BlockTridiagSetIndexSet( void *data, HYPRE_Int n, HYPRE_Int *inds )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockTridiagSetIndexSet)( data, n, inds );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BlockTridiagSetPrintLevel( void *data, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockTridiagSetPrintLevel)( data, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BlockTridiagSetup( void *data, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockTridiagSetup)( data, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BlockTridiagSolve( void *data, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BlockTridiagSolve)( data, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGAdditiveCycle( void *amg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGAdditiveCycle)( amg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBlockSolve( void *B, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBlockSolve)( B, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildCoarseOperator( hypre_ParCSRMatrix *RT, hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *P, hypre_ParCSRMatrix **RAP_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildCoarseOperator)( RT, A, P, RAP_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildCoarseOperatorKT( hypre_ParCSRMatrix *RT, hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *P, HYPRE_Int keepTranspose, hypre_ParCSRMatrix **RAP_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildCoarseOperatorKT)( RT, A, P, keepTranspose, RAP_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildDirInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, HYPRE_Int interp_type, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildDirInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, interp_type, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildExtInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildExtInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildExtPICCInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildExtPICCInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildExtPIInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildExtPIInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildExtPIInterpHost( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildExtPIInterpHost)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildFF1Interp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildFF1Interp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildFFInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildFFInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildInterpGSMG( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildInterpGSMG)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildInterpHE( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildInterpHE)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildInterpLS( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int num_smooth, HYPRE_Real *SmoothVecs, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildInterpLS)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, num_smooth, SmoothVecs, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildInterpModUnk( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildInterpModUnk)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildInterpOnePnt( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildInterpOnePnt)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildInterpOnePntHost( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildInterpOnePntHost)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildModExtInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildModExtInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildModExtPEInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildModExtPEInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildModExtPIInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildModExtPIInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildModMultipass( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Real trunc_factor, HYPRE_Int P_max_elmts, HYPRE_Int interp_type, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildModMultipass)( A, CF_marker, S, num_cpts_global, trunc_factor, P_max_elmts, interp_type, num_functions, dof_func, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildModMultipassHost( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Real trunc_factor, HYPRE_Int P_max_elmts, HYPRE_Int interp_type, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildModMultipassHost)( A, CF_marker, S, num_cpts_global, trunc_factor, P_max_elmts, interp_type, num_functions, dof_func, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildModPartialExtInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_BigInt *num_old_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildModPartialExtInterp)( A, CF_marker, S, num_cpts_global, num_old_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildModPartialExtInterpHost( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_BigInt *num_old_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildModPartialExtInterpHost)( A, CF_marker, S, num_cpts_global, num_old_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildModPartialExtPEInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_BigInt *num_old_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildModPartialExtPEInterp)( A, CF_marker, S, num_cpts_global, num_old_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildModPartialExtPEInterpHost( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_BigInt *num_old_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildModPartialExtPEInterpHost)( A, CF_marker, S, num_cpts_global, num_old_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildMultipass( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int P_max_elmts, HYPRE_Int weight_option, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildMultipass)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, P_max_elmts, weight_option, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildMultipassHost( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int P_max_elmts, HYPRE_Int weight_option, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildMultipassHost)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, P_max_elmts, weight_option, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildNonGalerkinCoarseOperator( hypre_ParCSRMatrix **RAP_ptr, hypre_ParCSRMatrix *AP, HYPRE_Real strong_threshold, HYPRE_Real max_row_sum, HYPRE_Int num_functions, HYPRE_Int * dof_func_value, HYPRE_Int * CF_marker, HYPRE_Real droptol, HYPRE_Int sym_collapse, HYPRE_Real lump_percent, HYPRE_Int collapse_beta )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildNonGalerkinCoarseOperator)( RAP_ptr, AP, strong_threshold, max_row_sum, num_functions, dof_func_value, CF_marker, droptol, sym_collapse, lump_percent, collapse_beta );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildPartialExtInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_BigInt *num_old_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildPartialExtInterp)( A, CF_marker, S, num_cpts_global, num_old_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildPartialExtPIInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_BigInt *num_old_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildPartialExtPIInterp)( A, CF_marker, S, num_cpts_global, num_old_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildPartialStdInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_BigInt *num_old_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, HYPRE_Int sep_weight, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildPartialStdInterp)( A, CF_marker, S, num_cpts_global, num_old_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, sep_weight, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildRestrAIR( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Real filter_thresholdR, HYPRE_Int debug_flag, hypre_ParCSRMatrix **R_ptr, HYPRE_Int is_triangular, HYPRE_Int gmres_switch )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildRestrAIR)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, filter_thresholdR, debug_flag, R_ptr, is_triangular, gmres_switch );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildRestrDist2AIR( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Real filter_thresholdR, HYPRE_Int debug_flag, hypre_ParCSRMatrix **R_ptr, HYPRE_Int AIR1_5, HYPRE_Int is_triangular, HYPRE_Int gmres_switch )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildRestrDist2AIR)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, filter_thresholdR, debug_flag, R_ptr, AIR1_5, is_triangular, gmres_switch );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildRestrNeumannAIR( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int NeumannDeg, HYPRE_Real strong_thresholdR, HYPRE_Real filter_thresholdR, HYPRE_Int debug_flag, hypre_ParCSRMatrix **R_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildRestrNeumannAIR)( A, CF_marker, num_cpts_global, num_functions, dof_func, NeumannDeg, strong_thresholdR, filter_thresholdR, debug_flag, R_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGBuildStdInterp( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_BigInt *num_cpts_global, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int debug_flag, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, HYPRE_Int sep_weight, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGBuildStdInterp)( A, CF_marker, S, num_cpts_global, num_functions, dof_func, debug_flag, trunc_factor, max_elmts, sep_weight, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCGRelaxWt( void *amg_vdata, HYPRE_Int level, HYPRE_Int num_cg_sweeps, HYPRE_Real *rlx_wt_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCGRelaxWt)( amg_vdata, level, num_cg_sweeps, rlx_wt_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarseParms( MPI_Comm comm, HYPRE_Int local_num_variables, HYPRE_Int num_functions, hypre_IntArray *dof_func, hypre_IntArray *CF_marker, hypre_IntArray **coarse_dof_func_ptr, HYPRE_BigInt *coarse_pnts_global )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarseParms)( comm, local_num_variables, num_functions, dof_func, CF_marker, coarse_dof_func_ptr, coarse_pnts_global );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarseParmsHost( MPI_Comm comm, HYPRE_Int local_num_variables, HYPRE_Int num_functions, hypre_IntArray *dof_func, hypre_IntArray *CF_marker, hypre_IntArray **coarse_dof_func_ptr, HYPRE_BigInt *coarse_pnts_global )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarseParmsHost)( comm, local_num_variables, num_functions, dof_func, CF_marker, coarse_dof_func_ptr, coarse_pnts_global );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsen( hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *A, HYPRE_Int CF_init, HYPRE_Int debug_flag, hypre_IntArray **CF_marker_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsen)( S, A, CF_init, debug_flag, CF_marker_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenCGC( hypre_ParCSRMatrix *S, HYPRE_Int numberofgrids, HYPRE_Int coarsen_type, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenCGC)( S, numberofgrids, coarsen_type, CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenCGCb( hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *A, HYPRE_Int measure_type, HYPRE_Int coarsen_type, HYPRE_Int cgc_its, HYPRE_Int debug_flag, hypre_IntArray **CF_marker_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenCGCb)( S, A, measure_type, coarsen_type, cgc_its, debug_flag, CF_marker_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenCR( hypre_ParCSRMatrix *A, hypre_IntArray **CF_marker_ptr, HYPRE_BigInt *coarse_size_ptr, HYPRE_Int num_CR_relax_steps, HYPRE_Int IS_type, HYPRE_Int num_functions, HYPRE_Int rlx_type, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real theta, HYPRE_Solver smoother, hypre_ParCSRMatrix *AN, HYPRE_Int useCG, hypre_ParCSRMatrix *S )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenCR)( A, CF_marker_ptr, coarse_size_ptr, num_CR_relax_steps, IS_type, num_functions, rlx_type, relax_weight, omega, theta, smoother, AN, useCG, S );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenCR1( hypre_ParCSRMatrix *A, hypre_IntArray **CF_marker_ptr, HYPRE_BigInt *coarse_size_ptr, HYPRE_Int num_CR_relax_steps, HYPRE_Int IS_type, HYPRE_Int CRaddCpoints )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenCR1)( A, CF_marker_ptr, coarse_size_ptr, num_CR_relax_steps, IS_type, CRaddCpoints );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenFalgout( hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *A, HYPRE_Int measure_type, HYPRE_Int cut_factor, HYPRE_Int debug_flag, hypre_IntArray **CF_marker_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenFalgout)( S, A, measure_type, cut_factor, debug_flag, CF_marker_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenHMIS( hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *A, HYPRE_Int measure_type, HYPRE_Int cut_factor, HYPRE_Int debug_flag, hypre_IntArray **CF_marker_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenHMIS)( S, A, measure_type, cut_factor, debug_flag, CF_marker_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenInterpVectors( hypre_ParCSRMatrix *P, HYPRE_Int num_smooth_vecs, hypre_ParVector **smooth_vecs, HYPRE_Int *CF_marker, hypre_ParVector ***new_smooth_vecs, HYPRE_Int expand_level, HYPRE_Int num_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenInterpVectors)( P, num_smooth_vecs, smooth_vecs, CF_marker, new_smooth_vecs, expand_level, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenPMIS( hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *A, HYPRE_Int CF_init, HYPRE_Int debug_flag, hypre_IntArray **CF_marker_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenPMIS)( S, A, CF_init, debug_flag, CF_marker_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenPMISHost( hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *A, HYPRE_Int CF_init, HYPRE_Int debug_flag, hypre_IntArray **CF_marker_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenPMISHost)( S, A, CF_init, debug_flag, CF_marker_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCoarsenRuge( hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *A, HYPRE_Int measure_type, HYPRE_Int coarsen_type, HYPRE_Int cut_factor, HYPRE_Int debug_flag, hypre_IntArray **CF_marker_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCoarsenRuge)( S, A, measure_type, coarsen_type, cut_factor, debug_flag, CF_marker_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCorrectCFMarker( hypre_IntArray *CF_marker, hypre_IntArray *new_CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCorrectCFMarker)( CF_marker, new_CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCorrectCFMarker2( hypre_IntArray *CF_marker, hypre_IntArray *new_CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCorrectCFMarker2)( CF_marker, new_CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCorrectCFMarker2Host( hypre_IntArray *CF_marker, hypre_IntArray *new_CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCorrectCFMarker2Host)( CF_marker, new_CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCorrectCFMarkerHost( hypre_IntArray *CF_marker, hypre_IntArray *new_CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCorrectCFMarkerHost)( CF_marker, new_CF_marker );
}

/*--------------------------------------------------------------------------*/

void *
hypre_BoomerAMGCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreate2ndS( hypre_ParCSRMatrix *S, HYPRE_Int *CF_marker, HYPRE_Int num_paths, HYPRE_BigInt *coarse_row_starts, hypre_ParCSRMatrix **C_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreate2ndS)( S, CF_marker, num_paths, coarse_row_starts, C_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateNodalA( hypre_ParCSRMatrix *A, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int option, HYPRE_Int diag_option, hypre_ParCSRMatrix **AN_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateNodalA)( A, num_functions, dof_func, option, diag_option, AN_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateS( hypre_ParCSRMatrix *A, HYPRE_Real strength_threshold, HYPRE_Real max_row_sum, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_ParCSRMatrix **S_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateS)( A, strength_threshold, max_row_sum, num_functions, dof_func, S_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateSCommPkg( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *S, HYPRE_Int **col_offd_S_to_A_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateSCommPkg)( A, S, col_offd_S_to_A_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateSFromCFMarker( hypre_ParCSRMatrix *A, HYPRE_Real strength_threshold, HYPRE_Real max_row_sum, HYPRE_Int *CF_marker, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int SMRK, hypre_ParCSRMatrix **S_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateSFromCFMarker)( A, strength_threshold, max_row_sum, CF_marker, num_functions, dof_func, SMRK, S_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateSHost( hypre_ParCSRMatrix *A, HYPRE_Real strength_threshold, HYPRE_Real max_row_sum, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_ParCSRMatrix **S_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateSHost)( A, strength_threshold, max_row_sum, num_functions, dof_func, S_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateSabs( hypre_ParCSRMatrix *A, HYPRE_Real strength_threshold, HYPRE_Real max_row_sum, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_ParCSRMatrix **S_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateSabs)( A, strength_threshold, max_row_sum, num_functions, dof_func, S_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateSabsHost( hypre_ParCSRMatrix *A, HYPRE_Real strength_threshold, HYPRE_Real max_row_sum, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_ParCSRMatrix **S_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateSabsHost)( A, strength_threshold, max_row_sum, num_functions, dof_func, S_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateScalarCF( HYPRE_Int *CFN_marker, HYPRE_Int num_functions, HYPRE_Int num_nodes, hypre_IntArray **dof_func_ptr, hypre_IntArray **CF_marker_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateScalarCF)( CFN_marker, num_functions, num_nodes, dof_func_ptr, CF_marker_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateScalarCFS( hypre_ParCSRMatrix *SN, hypre_ParCSRMatrix *A, HYPRE_Int *CFN_marker, HYPRE_Int num_functions, HYPRE_Int nodal, HYPRE_Int keep_same_sign, hypre_IntArray **dof_func_ptr, hypre_IntArray **CF_marker_ptr, hypre_ParCSRMatrix **S_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateScalarCFS)( SN, A, CFN_marker, num_functions, nodal, keep_same_sign, dof_func_ptr, CF_marker_ptr, S_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateSmoothDirs( void *data, hypre_ParCSRMatrix *A, HYPRE_Real *SmoothVecs, HYPRE_Real thresh, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_ParCSRMatrix **S_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateSmoothDirs)( data, A, SmoothVecs, thresh, num_functions, dof_func, S_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCreateSmoothVecs( void *data, hypre_ParCSRMatrix *A, HYPRE_Int num_sweeps, HYPRE_Int level, HYPRE_Real **SmoothVecs_p )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCreateSmoothVecs)( data, A, num_sweeps, level, SmoothVecs_p );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCycle( void *amg_vdata, hypre_ParVector **F_array, hypre_ParVector **U_array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCycle)( amg_vdata, F_array, U_array );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGCycleT( void *amg_vdata, hypre_ParVector **F_array, hypre_ParVector **U_array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGCycleT)( amg_vdata, F_array, U_array );
}

/*--------------------------------------------------------------------------*/

void *
hypre_BoomerAMGDDCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDDestroy( void *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDDestroy)( data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDGetAMG( void *data, void **amg_solver )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDGetAMG)( data, amg_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDGetFACCycleType( void *data, HYPRE_Int *fac_cycle_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDGetFACCycleType)( data, fac_cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDGetFACNumCycles( void *data, HYPRE_Int *fac_num_cycles )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDGetFACNumCycles)( data, fac_num_cycles );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDGetFACNumRelax( void *data, HYPRE_Int *fac_num_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDGetFACNumRelax)( data, fac_num_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDGetFACRelaxType( void *data, HYPRE_Int *fac_relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDGetFACRelaxType)( data, fac_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDGetFACRelaxWeight( void *data, HYPRE_Real *fac_relax_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDGetFACRelaxWeight)( data, fac_relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDGetNumGhostLayers( void *data, HYPRE_Int *num_ghost_layers )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDGetNumGhostLayers)( data, num_ghost_layers );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDGetPadding( void *data, HYPRE_Int *padding )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDGetPadding)( data, padding );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDGetStartLevel( void *data, HYPRE_Int *start_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDGetStartLevel)( data, start_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSetFACCycleType( void *data, HYPRE_Int fac_cycle_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSetFACCycleType)( data, fac_cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSetFACNumCycles( void *data, HYPRE_Int fac_num_cycles )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSetFACNumCycles)( data, fac_num_cycles );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSetFACNumRelax( void *data, HYPRE_Int fac_num_relax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSetFACNumRelax)( data, fac_num_relax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSetFACRelaxType( void *data, HYPRE_Int fac_relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSetFACRelaxType)( data, fac_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSetFACRelaxWeight( void *data, HYPRE_Real fac_relax_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSetFACRelaxWeight)( data, fac_relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSetNumGhostLayers( void *data, HYPRE_Int num_ghost_layers )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSetNumGhostLayers)( data, num_ghost_layers );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSetPadding( void *data, HYPRE_Int padding )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSetPadding)( data, padding );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSetStartLevel( void *data, HYPRE_Int start_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSetStartLevel)( data, start_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSetup( void *amgdd_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSetup)( amgdd_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDDSolve( void *solver, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDDSolve)( solver, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_CommunicateRemainingMatrixInfo( hypre_ParAMGDDData* amgdd_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_CommunicateRemainingMatrixInfo)( amgdd_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC( void *amgdd_vdata, HYPRE_Int first_iteration )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC)( amgdd_vdata, first_iteration );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_CFL1Jacobi( void *amgdd_vdata, HYPRE_Int level, HYPRE_Int cycle_param )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_CFL1Jacobi)( amgdd_vdata, level, cycle_param );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_CFL1JacobiHost( void *amgdd_vdata, HYPRE_Int level, HYPRE_Int relax_set )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_CFL1JacobiHost)( amgdd_vdata, level, relax_set );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_Cycle( void *amgdd_vdata, HYPRE_Int level, HYPRE_Int cycle_type, HYPRE_Int first_iteration )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_Cycle)( amgdd_vdata, level, cycle_type, first_iteration );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_FCycle( void *amgdd_vdata, HYPRE_Int first_iteration )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_FCycle)( amgdd_vdata, first_iteration );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_GaussSeidel( void *amgdd_vdata, HYPRE_Int level, HYPRE_Int cycle_param )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_GaussSeidel)( amgdd_vdata, level, cycle_param );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_Interpolate( hypre_AMGDDCompGrid *compGrid_f, hypre_AMGDDCompGrid *compGrid_c )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_Interpolate)( compGrid_f, compGrid_c );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_Jacobi( void *amgdd_vdata, HYPRE_Int level, HYPRE_Int cycle_param )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_Jacobi)( amgdd_vdata, level, cycle_param );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_JacobiHost( void *amgdd_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_JacobiHost)( amgdd_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_OrderedGaussSeidel( void *amgdd_vdata, HYPRE_Int level, HYPRE_Int cycle_param )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_OrderedGaussSeidel)( amgdd_vdata, level, cycle_param );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_Relax( void *amgdd_vdata, HYPRE_Int level, HYPRE_Int cycle_param )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_Relax)( amgdd_vdata, level, cycle_param );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FAC_Restrict( hypre_AMGDDCompGrid *compGrid_f, hypre_AMGDDCompGrid *compGrid_c, HYPRE_Int first_iteration )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FAC_Restrict)( compGrid_f, compGrid_c, first_iteration );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_FixUpRecvMaps( hypre_AMGDDCompGrid **compGrid, hypre_AMGDDCommPkg *compGridCommPkg, HYPRE_Int start_level, HYPRE_Int num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_FixUpRecvMaps)( compGrid, compGridCommPkg, start_level, num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_MarkCoarse( HYPRE_Int *list, HYPRE_Int *marker, HYPRE_Int *owned_coarse_indices, HYPRE_Int *nonowned_coarse_indices, HYPRE_Int *sort_map, HYPRE_Int num_owned, HYPRE_Int total_num_nodes, HYPRE_Int num_owned_coarse, HYPRE_Int list_size, HYPRE_Int dist, HYPRE_Int use_sort, HYPRE_Int *nodes_to_add )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_MarkCoarse)( list, marker, owned_coarse_indices, nonowned_coarse_indices, sort_map, num_owned, total_num_nodes, num_owned_coarse, list_size, dist, use_sort, nodes_to_add );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_PackRecvMapSendBuffer( HYPRE_Int *recv_map_send_buffer, HYPRE_Int **recv_red_marker, HYPRE_Int *num_recv_nodes, HYPRE_Int *recv_buffer_size, HYPRE_Int current_level, HYPRE_Int num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_PackRecvMapSendBuffer)( recv_map_send_buffer, recv_red_marker, num_recv_nodes, recv_buffer_size, current_level, num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Complex*
hypre_BoomerAMGDD_PackResidualBuffer( hypre_AMGDDCompGrid **compGrid, hypre_AMGDDCommPkg *compGridCommPkg, HYPRE_Int current_level, HYPRE_Int proc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_PackResidualBuffer)( compGrid, compGridCommPkg, current_level, proc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int*
hypre_BoomerAMGDD_PackSendBuffer( hypre_ParAMGDDData *amgdd_data, HYPRE_Int proc, HYPRE_Int current_level, HYPRE_Int *padding, HYPRE_Int *send_flag_buffer_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_PackSendBuffer)( amgdd_data, proc, current_level, padding, send_flag_buffer_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_RecursivelyBuildPsiComposite( HYPRE_Int node, HYPRE_Int m, hypre_AMGDDCompGrid *compGrid, HYPRE_Int *add_flag, HYPRE_Int use_sort )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_RecursivelyBuildPsiComposite)( node, m, compGrid, add_flag, use_sort );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_ResidualCommunication( hypre_ParAMGDDData *amgdd_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_ResidualCommunication)( amgdd_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_SetupNearestProcessorNeighbors( hypre_ParCSRMatrix *A, hypre_AMGDDCommPkg *compGridCommPkg, HYPRE_Int level, HYPRE_Int *padding, HYPRE_Int num_ghost_layers )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_SetupNearestProcessorNeighbors)( A, compGridCommPkg, level, padding, num_ghost_layers );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_UnpackRecvBuffer( hypre_ParAMGDDData *amgdd_data, HYPRE_Int *recv_buffer, HYPRE_Int **A_tmp_info, HYPRE_Int *recv_map_send_buffer_size, HYPRE_Int *nodes_added_on_level, HYPRE_Int current_level, HYPRE_Int buffer_number )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_UnpackRecvBuffer)( amgdd_data, recv_buffer, A_tmp_info, recv_map_send_buffer_size, nodes_added_on_level, current_level, buffer_number );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_UnpackResidualBuffer( HYPRE_Complex *buffer, hypre_AMGDDCompGrid **compGrid, hypre_AMGDDCommPkg *compGridCommPkg, HYPRE_Int current_level, HYPRE_Int proc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_UnpackResidualBuffer)( buffer, compGrid, compGridCommPkg, current_level, proc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDD_UnpackSendFlagBuffer( hypre_AMGDDCompGrid **compGrid, HYPRE_Int *send_flag_buffer, HYPRE_Int **send_flag, HYPRE_Int *num_send_nodes, HYPRE_Int *send_buffer_size, HYPRE_Int current_level, HYPRE_Int num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDD_UnpackSendFlagBuffer)( compGrid, send_flag_buffer, send_flag, num_send_nodes, send_buffer_size, current_level, num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGDestroy( void *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGDestroy)( data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGFitVectors( HYPRE_Int ip, HYPRE_Int n, HYPRE_Int num, const HYPRE_Real *V, HYPRE_Int nc, const HYPRE_Int *ind, HYPRE_Real *val )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGFitVectors)( ip, n, num, V, nc, ind, val );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetAdditive( void *data, HYPRE_Int *additive )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetAdditive)( data, additive );
}

/*--------------------------------------------------------------------------*/

const char*
hypre_BoomerAMGGetAggProlongationName( hypre_ParAMGData *amg_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetAggProlongationName)( amg_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetCoarsenCutFactor( void *data, HYPRE_Int *coarsen_cut_factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetCoarsenCutFactor)( data, coarsen_cut_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetCoarsenType( void *data, HYPRE_Int *coarsen_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetCoarsenType)( data, coarsen_type );
}

/*--------------------------------------------------------------------------*/

const char*
hypre_BoomerAMGGetCoarseningName( hypre_ParAMGData *amg_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetCoarseningName)( amg_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetConvergeType( void *data, HYPRE_Int *type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetConvergeType)( data, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetCumNnzAP( void *data, HYPRE_Real *cum_nnz_AP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetCumNnzAP)( data, cum_nnz_AP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetCumNumIterations( void *data, HYPRE_Int *cum_num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetCumNumIterations)( data, cum_num_iterations );
}

/*--------------------------------------------------------------------------*/

const char*
hypre_BoomerAMGGetCycleName( hypre_ParAMGData *amg_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetCycleName)( amg_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetCycleNumSweeps( void *data, HYPRE_Int *num_sweeps, HYPRE_Int k )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetCycleNumSweeps)( data, num_sweeps, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetCycleRelaxType( void *data, HYPRE_Int *relax_type, HYPRE_Int k )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetCycleRelaxType)( data, relax_type, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetCycleType( void *data, HYPRE_Int *cycle_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetCycleType)( data, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetDebugFlag( void *data, HYPRE_Int *debug_flag )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetDebugFlag)( data, debug_flag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetDomainType( void *data, HYPRE_Int *domain_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetDomainType)( data, domain_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetFCycle( void *data, HYPRE_Int *fcycle )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetFCycle)( data, fcycle );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetFilterFunctions( void *data, HYPRE_Int *filter_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetFilterFunctions)( data, filter_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetFilterThresholdR( void *data, HYPRE_Real *filter_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetFilterThresholdR)( data, filter_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetGridHierarchy( void *data, HYPRE_Int *cgrid )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetGridHierarchy)( data, cgrid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetGridRelaxPoints( void *data, HYPRE_Int ***grid_relax_points )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetGridRelaxPoints)( data, grid_relax_points );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetGridRelaxType( void *data, HYPRE_Int **grid_relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetGridRelaxType)( data, grid_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetInterpType( void *data, HYPRE_Int *interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetInterpType)( data, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetJacobiTruncThreshold( void *data, HYPRE_Real *jacobi_trunc_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetJacobiTruncThreshold)( data, jacobi_trunc_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetLevelOuterWt( void *data, HYPRE_Real *omega, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetLevelOuterWt)( data, omega, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetLevelRelaxWt( void *data, HYPRE_Real *relax_weight, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetLevelRelaxWt)( data, relax_weight, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetLogging( void *data, HYPRE_Int *logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetLogging)( data, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetMaxCoarseSize( void *data, HYPRE_Int *max_coarse_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetMaxCoarseSize)( data, max_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetMaxIter( void *data, HYPRE_Int *max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetMaxIter)( data, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetMaxLevels( void *data, HYPRE_Int *max_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetMaxLevels)( data, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetMaxRowSum( void *data, HYPRE_Real *max_row_sum )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetMaxRowSum)( data, max_row_sum );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetMeasureType( void *data, HYPRE_Int *measure_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetMeasureType)( data, measure_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetMinCoarseSize( void *data, HYPRE_Int *min_coarse_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetMinCoarseSize)( data, min_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetMinIter( void *data, HYPRE_Int *min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetMinIter)( data, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetMultAdditive( void *data, HYPRE_Int *mult_additive )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetMultAdditive)( data, mult_additive );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetNumFunctions( void *data, HYPRE_Int *num_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetNumFunctions)( data, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetNumGridSweeps( void *data, HYPRE_Int **num_grid_sweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetNumGridSweeps)( data, num_grid_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetNumIterations( void *data, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetNumIterations)( data, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetOmega( void *data, HYPRE_Real **omega )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetOmega)( data, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetOverlap( void *data, HYPRE_Int *overlap )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetOverlap)( data, overlap );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetPMaxElmts( void *data, HYPRE_Int *P_max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetPMaxElmts)( data, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetPostInterpType( void *data, HYPRE_Int *post_interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetPostInterpType)( data, post_interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetPrintFileName( void *data, char **print_file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetPrintFileName)( data, print_file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetPrintLevel( void *data, HYPRE_Int *print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetPrintLevel)( data, print_level );
}

/*--------------------------------------------------------------------------*/

const char*
hypre_BoomerAMGGetProlongationName( hypre_ParAMGData *amg_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetProlongationName)( amg_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetRedundant( void *data, HYPRE_Int *redundant )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetRedundant)( data, redundant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetRelResidualNorm( void *data, HYPRE_Real *rel_resid_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetRelResidualNorm)( data, rel_resid_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetRelaxOrder( void *data, HYPRE_Int *relax_order )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetRelaxOrder)( data, relax_order );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetRelaxWeight( void *data, HYPRE_Real **relax_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetRelaxWeight)( data, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetResidual( void *data, hypre_ParVector **resid )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetResidual)( data, resid );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetSchwarzRlxWeight( void *data, HYPRE_Real *schwarz_rlx_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetSchwarzRlxWeight)( data, schwarz_rlx_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetSeqThreshold( void *data, HYPRE_Int *seq_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetSeqThreshold)( data, seq_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetSetupType( void *data, HYPRE_Int *setup_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetSetupType)( data, setup_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetSimple( void *data, HYPRE_Int *simple )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetSimple)( data, simple );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetSmoothNumLevels( void *data, HYPRE_Int *smooth_num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetSmoothNumLevels)( data, smooth_num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetSmoothNumSweeps( void *data, HYPRE_Int *smooth_num_sweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetSmoothNumSweeps)( data, smooth_num_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetSmoothType( void *data, HYPRE_Int *smooth_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetSmoothType)( data, smooth_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetStrongThreshold( void *data, HYPRE_Real *strong_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetStrongThreshold)( data, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetStrongThresholdR( void *data, HYPRE_Real *strong_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetStrongThresholdR)( data, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetTol( void *data, HYPRE_Real *tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetTol)( data, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetTruncFactor( void *data, HYPRE_Real *trunc_factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetTruncFactor)( data, trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGGetVariant( void *data, HYPRE_Int *variant )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGGetVariant)( data, variant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGIndepHMIS( hypre_ParCSRMatrix *S, HYPRE_Int measure_type, HYPRE_Int debug_flag, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGIndepHMIS)( S, measure_type, debug_flag, CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGIndepHMISa( hypre_ParCSRMatrix *S, HYPRE_Int measure_type, HYPRE_Int debug_flag, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGIndepHMISa)( S, measure_type, debug_flag, CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGIndepPMIS( hypre_ParCSRMatrix *S, HYPRE_Int CF_init, HYPRE_Int debug_flag, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGIndepPMIS)( S, CF_init, debug_flag, CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGIndepPMISa( hypre_ParCSRMatrix *S, HYPRE_Int CF_init, HYPRE_Int debug_flag, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGIndepPMISa)( S, CF_init, debug_flag, CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGIndepRS( hypre_ParCSRMatrix *S, HYPRE_Int measure_type, HYPRE_Int debug_flag, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGIndepRS)( S, measure_type, debug_flag, CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGIndepRSa( hypre_ParCSRMatrix *S, HYPRE_Int measure_type, HYPRE_Int debug_flag, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGIndepRSa)( S, measure_type, debug_flag, CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGIndepSet( hypre_ParCSRMatrix *S, HYPRE_Real *measure_array, HYPRE_Int *graph_array, HYPRE_Int graph_array_size, HYPRE_Int *graph_array_offd, HYPRE_Int graph_array_offd_size, HYPRE_Int *IS_marker, HYPRE_Int *IS_marker_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGIndepSet)( S, measure_array, graph_array, graph_array_size, graph_array_offd, graph_array_offd_size, IS_marker, IS_marker_offd );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGIndepSetInit( hypre_ParCSRMatrix *S, HYPRE_Real *measure_array, HYPRE_Int seq_rand )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGIndepSetInit)( S, measure_array, seq_rand );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGInterpTruncation( hypre_ParCSRMatrix *P, HYPRE_Real trunc_factor, HYPRE_Int max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGInterpTruncation)( P, trunc_factor, max_elmts );
}

/*--------------------------------------------------------------------------*/

void
hypre_BoomerAMGJacobiInterp( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix **P, hypre_ParCSRMatrix *S, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int *CF_marker, HYPRE_Int level, HYPRE_Real truncation_threshold, HYPRE_Real truncation_threshold_minus )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGJacobiInterp)( A, P, S, num_functions, dof_func, CF_marker, level, truncation_threshold, truncation_threshold_minus );
}

/*--------------------------------------------------------------------------*/

void
hypre_BoomerAMGJacobiInterp_1( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix **P, hypre_ParCSRMatrix *S, HYPRE_Int *CF_marker, HYPRE_Int level, HYPRE_Real truncation_threshold, HYPRE_Real truncation_threshold_minus, HYPRE_Int *dof_func, HYPRE_Int *dof_func_offd, HYPRE_Real weight_AF )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGJacobiInterp_1)( A, P, S, CF_marker, level, truncation_threshold, truncation_threshold_minus, dof_func, dof_func_offd, weight_AF );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGNormalizeVecs( HYPRE_Int n, HYPRE_Int num, HYPRE_Real *V )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGNormalizeVecs)( n, num, V );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGPrintGeneralInfo( hypre_ParAMGData *amg_data, HYPRE_Int shift )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGPrintGeneralInfo)( amg_data, shift );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRefineInterp( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *P, HYPRE_BigInt *num_cpts_global, HYPRE_Int *nf, HYPRE_Int *dof_func, HYPRE_Int *CF_marker, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRefineInterp)( A, P, num_cpts_global, nf, dof_func, CF_marker, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_type, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax)( A, f, cf_marker, relax_type, relax_points, relax_weight, omega, l1_norms, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax0WeightedJacobi( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, hypre_ParVector *u, hypre_ParVector *Vtemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax0WeightedJacobi)( A, f, cf_marker, relax_points, relax_weight, u, Vtemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax10TopoOrderedGaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax10TopoOrderedGaussSeidel)( A, f, cf_marker, relax_points, relax_weight, omega, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax11TwoStageGaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *A_diag_diag, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax11TwoStageGaussSeidel)( A, f, cf_marker, relax_points, relax_weight, omega, A_diag_diag, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax12TwoStageGaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *A_diag_diag, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax12TwoStageGaussSeidel)( A, f, cf_marker, relax_points, relax_weight, omega, A_diag_diag, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax13HybridL1GaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax13HybridL1GaussSeidel)( A, f, cf_marker, relax_points, relax_weight, omega, l1_norms, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax14HybridL1GaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax14HybridL1GaussSeidel)( A, f, cf_marker, relax_points, relax_weight, omega, l1_norms, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax18WeightedL1Jacobi( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax18WeightedL1Jacobi)( A, f, cf_marker, relax_points, relax_weight, l1_norms, u, Vtemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax1GaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax1GaussSeidel)( A, f, cf_marker, relax_points, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax2GaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax2GaussSeidel)( A, f, cf_marker, relax_points, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax3HybridGaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax3HybridGaussSeidel)( A, f, cf_marker, relax_points, relax_weight, omega, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax4HybridGaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax4HybridGaussSeidel)( A, f, cf_marker, relax_points, relax_weight, omega, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax5ChaoticHybridGaussSeidel( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax5ChaoticHybridGaussSeidel)( A, f, cf_marker, relax_points, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax6HybridSSOR( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax6HybridSSOR)( A, f, cf_marker, relax_points, relax_weight, omega, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax7Jacobi( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax7Jacobi)( A, f, cf_marker, relax_points, relax_weight, l1_norms, u, Vtemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax89HybridL1SSOR( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax89HybridL1SSOR)( A, f, cf_marker, relax_points, relax_weight, omega, l1_norms, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax8HybridL1SSOR( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax8HybridL1SSOR)( A, f, cf_marker, relax_points, relax_weight, omega, l1_norms, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelaxComputeL1Norms( hypre_ParCSRMatrix *A, HYPRE_Int relax_type, HYPRE_Int relax_order, HYPRE_Int coarsest_lvl, hypre_IntArray *CF_marker, HYPRE_Real **l1_norms_data_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelaxComputeL1Norms)( A, relax_type, relax_order, coarsest_lvl, CF_marker, l1_norms_data_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelaxHybridGaussSeidel_core( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp, HYPRE_Int GS_order, HYPRE_Int Symm, HYPRE_Int Skip_diag, HYPRE_Int forced_seq, HYPRE_Int Topo_order )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelaxHybridGaussSeidel_core)( A, f, cf_marker, relax_points, relax_weight, omega, l1_norms, u, Vtemp, Ztemp, GS_order, Symm, Skip_diag, forced_seq, Topo_order );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelaxHybridSOR( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp, HYPRE_Int direction, HYPRE_Int symm, HYPRE_Int skip_diag, HYPRE_Int force_seq )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelaxHybridSOR)( A, f, cf_marker, relax_points, relax_weight, omega, l1_norms, u, Vtemp, Ztemp, direction, symm, skip_diag, force_seq );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelaxIF( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_type, HYPRE_Int relax_order, HYPRE_Int cycle_type, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp, hypre_ParVector *Ztemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelaxIF)( A, f, cf_marker, relax_type, relax_order, cycle_type, relax_weight, omega, l1_norms, u, Vtemp, Ztemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelaxKaczmarz( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Real omega, HYPRE_Real *l1_norms, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelaxKaczmarz)( A, f, omega, l1_norms, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelaxT( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_type, HYPRE_Int relax_points, HYPRE_Real relax_weight, hypre_ParVector *u, hypre_ParVector *Vtemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelaxT)( A, f, cf_marker, relax_type, relax_points, relax_weight, u, Vtemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGRelax_FCFJacobi( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Real relax_weight, hypre_ParVector *u, hypre_ParVector *Vtemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGRelax_FCFJacobi)( A, f, cf_marker, relax_weight, u, Vtemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetADropTol( void *data, HYPRE_Real A_drop_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetADropTol)( data, A_drop_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetADropType( void *data, HYPRE_Int A_drop_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetADropType)( data, A_drop_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAddLastLvl( void *data, HYPRE_Int add_last_lvl )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAddLastLvl)( data, add_last_lvl );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAddRelaxType( void *data, HYPRE_Int add_rlx_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAddRelaxType)( data, add_rlx_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAddRelaxWt( void *data, HYPRE_Real add_rlx_wt )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAddRelaxWt)( data, add_rlx_wt );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAdditive( void *data, HYPRE_Int additive )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAdditive)( data, additive );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAggInterpType( void *data, HYPRE_Int agg_interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAggInterpType)( data, agg_interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAggNumLevels( void *data, HYPRE_Int agg_num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAggNumLevels)( data, agg_num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAggP12MaxElmts( void *data, HYPRE_Int agg_P12_max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAggP12MaxElmts)( data, agg_P12_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAggP12TruncFactor( void *data, HYPRE_Real agg_P12_trunc_factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAggP12TruncFactor)( data, agg_P12_trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAggPMaxElmts( void *data, HYPRE_Int agg_P_max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAggPMaxElmts)( data, agg_P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetAggTruncFactor( void *data, HYPRE_Real agg_trunc_factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetAggTruncFactor)( data, agg_trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCGCIts( void *data, HYPRE_Int its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCGCIts)( data, its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCPoints( void *data, HYPRE_Int cpt_coarse_level, HYPRE_Int num_cpt_coarse, HYPRE_BigInt *cpt_coarse_index )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCPoints)( data, cpt_coarse_level, num_cpt_coarse, cpt_coarse_index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCRRate( void *data, HYPRE_Real CR_rate )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCRRate)( data, CR_rate );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCRStrongTh( void *data, HYPRE_Real CR_strong_th )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCRStrongTh)( data, CR_strong_th );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCRUseCG( void *data, HYPRE_Int CR_use_CG )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCRUseCG)( data, CR_use_CG );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetChebyEigEst( void *data, HYPRE_Int eig_est )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetChebyEigEst)( data, eig_est );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetChebyFraction( void *data, HYPRE_Real ratio )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetChebyFraction)( data, ratio );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetChebyOrder( void *data, HYPRE_Int order )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetChebyOrder)( data, order );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetChebyScale( void *data, HYPRE_Int scale )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetChebyScale)( data, scale );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetChebyVariant( void *data, HYPRE_Int variant )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetChebyVariant)( data, variant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCoarsenCutFactor( void *data, HYPRE_Int coarsen_cut_factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCoarsenCutFactor)( data, coarsen_cut_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCoarsenType( void *data, HYPRE_Int coarsen_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCoarsenType)( data, coarsen_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetConvergeType( void *data, HYPRE_Int type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetConvergeType)( data, type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCoordDim( void *data, HYPRE_Int coorddim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCoordDim)( data, coorddim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCoordinates( void *data, float *coordinates )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCoordinates)( data, coordinates );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCumNnzAP( void *data, HYPRE_Real cum_nnz_AP )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCumNnzAP)( data, cum_nnz_AP );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCycleNumSweeps( void *data, HYPRE_Int num_sweeps, HYPRE_Int k )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCycleNumSweeps)( data, num_sweeps, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCycleRelaxType( void *data, HYPRE_Int relax_type, HYPRE_Int k )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCycleRelaxType)( data, relax_type, k );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetCycleType( void *data, HYPRE_Int cycle_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetCycleType)( data, cycle_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetDebugFlag( void *data, HYPRE_Int debug_flag )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetDebugFlag)( data, debug_flag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetDofFunc( void *data, HYPRE_Int *dof_func )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetDofFunc)( data, dof_func );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetDofPoint( void *data, HYPRE_Int *dof_point )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetDofPoint)( data, dof_point );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetDomainType( void *data, HYPRE_Int domain_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetDomainType)( data, domain_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetDropTol( void *data, HYPRE_Real drop_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetDropTol)( data, drop_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetEuBJ( void *data, HYPRE_Int eu_bj )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetEuBJ)( data, eu_bj );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetEuLevel( void *data, HYPRE_Int eu_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetEuLevel)( data, eu_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetEuSparseA( void *data, HYPRE_Real eu_sparse_A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetEuSparseA)( data, eu_sparse_A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetEuclidFile( void *data, char *euclidfile )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetEuclidFile)( data, euclidfile );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFCycle( void *data, HYPRE_Int fcycle )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFCycle)( data, fcycle );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFPoints( void *data, HYPRE_Int isolated, HYPRE_Int num_points, HYPRE_BigInt *indices )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFPoints)( data, isolated, num_points, indices );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFSAIAlgoType( void *data, HYPRE_Int fsai_algo_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFSAIAlgoType)( data, fsai_algo_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFSAIEigMaxIters( void *data, HYPRE_Int fsai_eig_max_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFSAIEigMaxIters)( data, fsai_eig_max_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFSAIKapTolerance( void *data, HYPRE_Real fsai_kap_tolerance )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFSAIKapTolerance)( data, fsai_kap_tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFSAILocalSolveType( void *data, HYPRE_Int local_solve_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFSAILocalSolveType)( data, local_solve_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFSAIMaxNnzRow( void *data, HYPRE_Int fsai_max_nnz_row )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFSAIMaxNnzRow)( data, fsai_max_nnz_row );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFSAIMaxStepSize( void *data, HYPRE_Int fsai_max_step_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFSAIMaxStepSize)( data, fsai_max_step_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFSAIMaxSteps( void *data, HYPRE_Int fsai_max_steps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFSAIMaxSteps)( data, fsai_max_steps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFSAINumLevels( void *data, HYPRE_Int fsai_num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFSAINumLevels)( data, fsai_num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFSAIThreshold( void *data, HYPRE_Real fsai_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFSAIThreshold)( data, fsai_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFilter( void *data, HYPRE_Real filter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFilter)( data, filter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFilterFunctions( void *data, HYPRE_Int filter_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFilterFunctions)( data, filter_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetFilterThresholdR( void *data, HYPRE_Real filter_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetFilterThresholdR)( data, filter_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetGMRESSwitchR( void *data, HYPRE_Int gmres_switch )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetGMRESSwitchR)( data, gmres_switch );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetGSMG( void *data, HYPRE_Int par )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetGSMG)( data, par );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetGridRelaxPoints( void *data, HYPRE_Int **grid_relax_points )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetGridRelaxPoints)( data, grid_relax_points );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetGridRelaxType( void *data, HYPRE_Int *grid_relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetGridRelaxType)( data, grid_relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUDroptol( void *data, HYPRE_Real ilu_droptol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUDroptol)( data, ilu_droptol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUIterSetupMaxIter( void *data, HYPRE_Int ilu_iter_setup_max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUIterSetupMaxIter)( data, ilu_iter_setup_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUIterSetupOption( void *data, HYPRE_Int ilu_iter_setup_option )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUIterSetupOption)( data, ilu_iter_setup_option );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUIterSetupTolerance( void *data, HYPRE_Real ilu_iter_setup_tolerance )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUIterSetupTolerance)( data, ilu_iter_setup_tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUIterSetupType( void *data, HYPRE_Int ilu_iter_setup_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUIterSetupType)( data, ilu_iter_setup_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILULevel( void *data, HYPRE_Int ilu_lfil )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILULevel)( data, ilu_lfil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILULocalReordering( void *data, HYPRE_Int ilu_reordering_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILULocalReordering)( data, ilu_reordering_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILULowerJacobiIters( void *data, HYPRE_Int ilu_lower_jacobi_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILULowerJacobiIters)( data, ilu_lower_jacobi_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUMaxIter( void *data, HYPRE_Int ilu_max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUMaxIter)( data, ilu_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUMaxRowNnz( void *data, HYPRE_Int ilu_max_row_nnz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUMaxRowNnz)( data, ilu_max_row_nnz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUTriSolve( void *data, HYPRE_Int ilu_tri_solve )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUTriSolve)( data, ilu_tri_solve );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUType( void *data, HYPRE_Int ilu_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUType)( data, ilu_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetILUUpperJacobiIters( void *data, HYPRE_Int ilu_upper_jacobi_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetILUUpperJacobiIters)( data, ilu_upper_jacobi_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetISType( void *data, HYPRE_Int IS_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetISType)( data, IS_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetInterpRefine( void *data, HYPRE_Int num_refine )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetInterpRefine)( data, num_refine );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetInterpType( void *data, HYPRE_Int interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetInterpType)( data, interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetInterpVecAbsQTrunc( void *data, HYPRE_Real q_trunc )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetInterpVecAbsQTrunc)( data, q_trunc );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetInterpVecFirstLevel( void *data, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetInterpVecFirstLevel)( data, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetInterpVecQMax( void *data, HYPRE_Int q_max )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetInterpVecQMax)( data, q_max );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetInterpVecVariant( void *solver, HYPRE_Int var )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetInterpVecVariant)( solver, var );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetInterpVectors( void *solver, HYPRE_Int num_vectors, hypre_ParVector **interp_vectors )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetInterpVectors)( solver, num_vectors, interp_vectors );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetIsTriangular( void *data, HYPRE_Int is_triangular )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetIsTriangular)( data, is_triangular );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetJacobiTruncThreshold( void *data, HYPRE_Real jacobi_trunc_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetJacobiTruncThreshold)( data, jacobi_trunc_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetKeepSameSign( void *data, HYPRE_Int keep_same_sign )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetKeepSameSign)( data, keep_same_sign );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetKeepTranspose( void *data, HYPRE_Int keepTranspose )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetKeepTranspose)( data, keepTranspose );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetLevel( void *data, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetLevel)( data, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetLevelNonGalerkinTol( void *data, HYPRE_Real nongalerkin_tol, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetLevelNonGalerkinTol)( data, nongalerkin_tol, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetLevelOuterWt( void *data, HYPRE_Real omega, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetLevelOuterWt)( data, omega, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetLevelRelaxWt( void *data, HYPRE_Real relax_weight, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetLevelRelaxWt)( data, relax_weight, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetLogging( void *data, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetLogging)( data, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMaxCoarseSize( void *data, HYPRE_Int max_coarse_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMaxCoarseSize)( data, max_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMaxIter( void *data, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMaxIter)( data, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMaxLevels( void *data, HYPRE_Int max_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMaxLevels)( data, max_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMaxNzPerRow( void *data, HYPRE_Int max_nz_per_row )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMaxNzPerRow)( data, max_nz_per_row );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMaxRowSum( void *data, HYPRE_Real max_row_sum )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMaxRowSum)( data, max_row_sum );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMeasureType( void *data, HYPRE_Int measure_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMeasureType)( data, measure_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMinCoarseSize( void *data, HYPRE_Int min_coarse_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMinCoarseSize)( data, min_coarse_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMinIter( void *data, HYPRE_Int min_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMinIter)( data, min_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetModuleRAP2( void *data, HYPRE_Int mod_rap2 )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetModuleRAP2)( data, mod_rap2 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMultAddPMaxElmts( void *data, HYPRE_Int add_P_max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMultAddPMaxElmts)( data, add_P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMultAddTruncFactor( void *data, HYPRE_Real add_trunc_factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMultAddTruncFactor)( data, add_trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetMultAdditive( void *data, HYPRE_Int mult_additive )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetMultAdditive)( data, mult_additive );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNodal( void *data, HYPRE_Int nodal )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNodal)( data, nodal );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNodalDiag( void *data, HYPRE_Int nodal )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNodalDiag)( data, nodal );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNodalLevels( void *data, HYPRE_Int nodal_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNodalLevels)( data, nodal_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNonGalerkTol( void *data, HYPRE_Int nongalerk_num_tol, HYPRE_Real *nongalerk_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNonGalerkTol)( data, nongalerk_num_tol, nongalerk_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNonGalerkinTol( void *data, HYPRE_Real nongalerkin_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNonGalerkinTol)( data, nongalerkin_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNumCRRelaxSteps( void *data, HYPRE_Int num_CR_relax_steps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNumCRRelaxSteps)( data, num_CR_relax_steps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNumFunctions( void *data, HYPRE_Int num_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNumFunctions)( data, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNumGridSweeps( void *data, HYPRE_Int *num_grid_sweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNumGridSweeps)( data, num_grid_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNumIterations( void *data, HYPRE_Int num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNumIterations)( data, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNumPaths( void *data, HYPRE_Int num_paths )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNumPaths)( data, num_paths );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNumPoints( void *data, HYPRE_Int num_points )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNumPoints)( data, num_points );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNumSamples( void *data, HYPRE_Int par )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNumSamples)( data, par );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetNumSweeps( void *data, HYPRE_Int num_sweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetNumSweeps)( data, num_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetOmega( void *data, HYPRE_Real *omega )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetOmega)( data, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetOuterWt( void *data, HYPRE_Real omega )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetOuterWt)( data, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetOverlap( void *data, HYPRE_Int overlap )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetOverlap)( data, overlap );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetPMaxElmts( void *data, HYPRE_Int P_max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetPMaxElmts)( data, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetPlotFileName( void *data, const char *plot_file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetPlotFileName)( data, plot_file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetPlotGrids( void *data, HYPRE_Int plotgrids )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetPlotGrids)( data, plotgrids );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetPointDofMap( void *data, HYPRE_Int *point_dof_map )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetPointDofMap)( data, point_dof_map );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetPostInterpType( void *data, HYPRE_Int post_interp_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetPostInterpType)( data, post_interp_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetPrintFileName( void *data, const char *print_file_name )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetPrintFileName)( data, print_file_name );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetPrintLevel( void *data, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetPrintLevel)( data, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetRAP2( void *data, HYPRE_Int rap2 )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetRAP2)( data, rap2 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetRedundant( void *data, HYPRE_Int redundant )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetRedundant)( data, redundant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetRelaxOrder( void *data, HYPRE_Int relax_order )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetRelaxOrder)( data, relax_order );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetRelaxType( void *data, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetRelaxType)( data, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetRelaxWeight( void *data, HYPRE_Real *relax_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetRelaxWeight)( data, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetRelaxWt( void *data, HYPRE_Real relax_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetRelaxWt)( data, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetRestriction( void *data, HYPRE_Int restr_par )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetRestriction)( data, restr_par );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSabs( void *data, HYPRE_Int Sabs )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSabs)( data, Sabs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSchwarzRlxWeight( void *data, HYPRE_Real schwarz_rlx_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSchwarzRlxWeight)( data, schwarz_rlx_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSchwarzUseNonSymm( void *data, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSchwarzUseNonSymm)( data, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSepWeight( void *data, HYPRE_Int sep_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSepWeight)( data, sep_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSeqThreshold( void *data, HYPRE_Int seq_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSeqThreshold)( data, seq_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSetupType( void *data, HYPRE_Int setup_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSetupType)( data, setup_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSimple( void *data, HYPRE_Int simple )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSimple)( data, simple );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSmoothInterpVectors( void *solver, HYPRE_Int smooth_interp_vectors )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSmoothInterpVectors)( solver, smooth_interp_vectors );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSmoothNumLevels( void *data, HYPRE_Int smooth_num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSmoothNumLevels)( data, smooth_num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSmoothNumSweeps( void *data, HYPRE_Int smooth_num_sweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSmoothNumSweeps)( data, smooth_num_sweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSmoothType( void *data, HYPRE_Int smooth_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSmoothType)( data, smooth_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetStrongThreshold( void *data, HYPRE_Real strong_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetStrongThreshold)( data, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetStrongThresholdR( void *data, HYPRE_Real strong_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetStrongThresholdR)( data, strong_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetSym( void *data, HYPRE_Int sym )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetSym)( data, sym );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetThreshold( void *data, HYPRE_Real thresh )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetThreshold)( data, thresh );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetTol( void *data, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetTol)( data, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetTruncFactor( void *data, HYPRE_Real trunc_factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetTruncFactor)( data, trunc_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetVariant( void *data, HYPRE_Int variant )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetVariant)( data, variant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetup( void *amg_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetup)( amg_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSetupStats( void *amg_vdata, hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSetupStats)( amg_vdata, A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSmoothInterpVectors( hypre_ParCSRMatrix *A, HYPRE_Int num_smooth_vecs, hypre_ParVector **smooth_vecs, HYPRE_Int smooth_steps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSmoothInterpVectors)( A, num_smooth_vecs, smooth_vecs, smooth_steps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSolve( void *amg_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSolve)( amg_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGSolveT( void *amg_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGSolveT)( amg_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGTruncandBuild( hypre_ParCSRMatrix *P, HYPRE_Real trunc_factor, HYPRE_Int max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGTruncandBuild)( P, trunc_factor, max_elmts );
}

/*--------------------------------------------------------------------------*/

void
hypre_BoomerAMGTruncateInterp( hypre_ParCSRMatrix *P, HYPRE_Real eps, HYPRE_Real dlt, HYPRE_Int *CF_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGTruncateInterp)( P, eps, dlt, CF_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMGWriteSolverParams( void *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMGWriteSolverParams)( data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMG_GMExpandInterp( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix **P, HYPRE_Int num_smooth_vecs, hypre_ParVector **smooth_vecs, HYPRE_Int *nf, HYPRE_Int *dof_func, hypre_IntArray **coarse_dof_func, HYPRE_Int variant, HYPRE_Int level, HYPRE_Real abs_trunc, HYPRE_Real *weights, HYPRE_Int q_max, HYPRE_Int *CF_marker, HYPRE_Int interp_vec_first_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMG_GMExpandInterp)( A, P, num_smooth_vecs, smooth_vecs, nf, dof_func, coarse_dof_func, variant, level, abs_trunc, weights, q_max, CF_marker, interp_vec_first_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMG_LNExpandInterp( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix **P, HYPRE_BigInt *num_cpts_global, HYPRE_Int *nf, HYPRE_Int *dof_func, hypre_IntArray **coarse_dof_func, HYPRE_Int *CF_marker, HYPRE_Int level, HYPRE_Real *weights, HYPRE_Int num_smooth_vecs, hypre_ParVector **smooth_vecs, HYPRE_Real abs_trunc, HYPRE_Int q_max, HYPRE_Int interp_vec_first_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMG_LNExpandInterp)( A, P, num_cpts_global, nf, dof_func, coarse_dof_func, CF_marker, level, weights, num_smooth_vecs, smooth_vecs, abs_trunc, q_max, interp_vec_first_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_BoomerAMG_MyCreateS( hypre_ParCSRMatrix *A, HYPRE_Real strength_threshold, HYPRE_Real max_row_sum, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_ParCSRMatrix **S_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_BoomerAMG_MyCreateS)( A, strength_threshold, max_row_sum, num_functions, dof_func, S_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixDropInplace( hypre_CSRMatrix *A, HYPRE_Real droptol, HYPRE_Int max_row_nnz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixDropInplace)( A, droptol, max_row_nnz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixExtractDenseMat( hypre_CSRMatrix *A, hypre_Vector *A_sub, HYPRE_Int *S_Pattern, HYPRE_Int S_nnz, HYPRE_Int *marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixExtractDenseMat)( A, A_sub, S_Pattern, S_nnz, marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixExtractDenseRow( hypre_CSRMatrix *A, hypre_Vector *A_subrow, HYPRE_Int *marker, HYPRE_Int row_num )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixExtractDenseRow)( A, A_subrow, marker, row_num );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixNormFro( hypre_CSRMatrix *A, HYPRE_Real *norm_io )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixNormFro)( A, norm_io );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixResNormFro( hypre_CSRMatrix *A, HYPRE_Real *norm_io )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixResNormFro)( A, norm_io );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CSRMatrixTrace( hypre_CSRMatrix *A, HYPRE_Real *trace_io )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CSRMatrixTrace)( A, trace_io );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_CreateC( hypre_ParCSRMatrix *A, HYPRE_Real w )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CreateC)( A, w );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CreateDinv( void *amg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CreateDinv)( amg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_CreateLambda( void *amg_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_CreateLambda)( amg_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIApply( void *fsai_vdata, HYPRE_Complex alpha, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIApply)( fsai_vdata, alpha, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIComputeOmega( void *fsai_vdata, hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIComputeOmega)( fsai_vdata, A );
}

/*--------------------------------------------------------------------------*/

void*
hypre_FSAICreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAICreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIDestroy( void *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIDestroy)( data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIDumpLocalLSDense( void *fsai_vdata, const char *filename, hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIDumpLocalLSDense)( fsai_vdata, filename, A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetAlgoType( void *data, HYPRE_Int *algo_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetAlgoType)( data, algo_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetEigMaxIters( void *data, HYPRE_Int *eig_max_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetEigMaxIters)( data, eig_max_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetKapTolerance( void *data, HYPRE_Real *kap_tolerance )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetKapTolerance)( data, kap_tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetLocalSolveType( void *data, HYPRE_Int *local_solve_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetLocalSolveType)( data, local_solve_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetLogging( void *data, HYPRE_Int *logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetLogging)( data, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetMaxIterations( void *data, HYPRE_Int *max_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetMaxIterations)( data, max_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetMaxNnzRow( void *data, HYPRE_Int *max_nnz_row )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetMaxNnzRow)( data, max_nnz_row );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetMaxStepSize( void *data, HYPRE_Int *max_step_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetMaxStepSize)( data, max_step_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetMaxSteps( void *data, HYPRE_Int *max_steps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetMaxSteps)( data, max_steps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetNumIterations( void *data, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetNumIterations)( data, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetNumLevels( void *data, HYPRE_Int *num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetNumLevels)( data, num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetOmega( void *data, HYPRE_Real *omega )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetOmega)( data, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetPrintLevel( void *data, HYPRE_Int *print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetPrintLevel)( data, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetThreshold( void *data, HYPRE_Real *threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetThreshold)( data, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetTolerance( void *data, HYPRE_Real *tolerance )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetTolerance)( data, tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIGetZeroGuess( void *data, HYPRE_Int *zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIGetZeroGuess)( data, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAIPrintStats( void *fsai_vdata, hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAIPrintStats)( fsai_vdata, A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetAlgoType( void *data, HYPRE_Int algo_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetAlgoType)( data, algo_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetEigMaxIters( void *data, HYPRE_Int eig_max_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetEigMaxIters)( data, eig_max_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetKapTolerance( void *data, HYPRE_Real kap_tolerance )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetKapTolerance)( data, kap_tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetLocalSolveType( void *data, HYPRE_Int local_solve_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetLocalSolveType)( data, local_solve_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetLogging( void *data, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetLogging)( data, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetMaxIterations( void *data, HYPRE_Int max_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetMaxIterations)( data, max_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetMaxNnzRow( void *data, HYPRE_Int max_nnz_row )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetMaxNnzRow)( data, max_nnz_row );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetMaxStepSize( void *data, HYPRE_Int max_step_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetMaxStepSize)( data, max_step_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetMaxSteps( void *data, HYPRE_Int max_steps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetMaxSteps)( data, max_steps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetNumIterations( void *data, HYPRE_Int num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetNumIterations)( data, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetNumLevels( void *data, HYPRE_Int num_levels )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetNumLevels)( data, num_levels );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetOmega( void *data, HYPRE_Real omega )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetOmega)( data, omega );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetPrintLevel( void *data, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetPrintLevel)( data, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetThreshold( void *data, HYPRE_Real threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetThreshold)( data, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetTolerance( void *data, HYPRE_Real tolerance )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetTolerance)( data, tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetZeroGuess( void *data, HYPRE_Int zero_guess )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetZeroGuess)( data, zero_guess );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetup( void *fsai_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetup)( fsai_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetupNative( void *fsai_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetupNative)( fsai_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISetupOMPDyn( void *fsai_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISetupOMPDyn)( fsai_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FSAISolve( void *fsai_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *b, hypre_ParVector *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FSAISolve)( fsai_vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_FindKapGrad( hypre_CSRMatrix *A_diag, hypre_Vector *kaporin_gradient, HYPRE_Int *kap_grad_nonzeros, hypre_Vector *G_temp, HYPRE_Int *S_Pattern, HYPRE_Int S_nnz, HYPRE_Int max_row_size, HYPRE_Int row_num, HYPRE_Int *kg_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_FindKapGrad)( A_diag, kaporin_gradient, kap_grad_nonzeros, G_temp, S_Pattern, S_nnz, max_row_size, row_num, kg_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GaussElimSetup( hypre_ParAMGData *amg_data, HYPRE_Int level, HYPRE_Int solver_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GaussElimSetup)( amg_data, level, solver_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GaussElimSolve( hypre_ParAMGData *amg_data, HYPRE_Int level, HYPRE_Int solver_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GaussElimSolve)( amg_data, level, solver_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GenerateMultiPi( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *P, HYPRE_BigInt *c_pts_starts, HYPRE_Int *pass_order, HYPRE_Int *pass_marker, HYPRE_Int *pass_marker_offd, HYPRE_Int num_points, HYPRE_Int color, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int *dof_func_offd, hypre_ParCSRMatrix **Pi_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GenerateMultiPi)( A, S, P, c_pts_starts, pass_order, pass_marker, pass_marker_offd, num_points, color, num_functions, dof_func, dof_func_offd, Pi_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GenerateMultipassPi( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *S, HYPRE_BigInt *c_pts_starts, HYPRE_Int *pass_order, HYPRE_Int *pass_marker, HYPRE_Int *pass_marker_offd, HYPRE_Int num_points, HYPRE_Int color, HYPRE_Real *row_sums, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GenerateMultipassPi)( A, S, c_pts_starts, pass_order, pass_marker, pass_marker_offd, num_points, color, row_sums, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GenerateScale( hypre_CSRMatrix *domain_structure, HYPRE_Int num_variables, HYPRE_Real relaxation_weight, HYPRE_Real **scale_pointer )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GenerateScale)( domain_structure, num_variables, relaxation_weight, scale_pointer );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GenerateSendMapAndCommPkg( MPI_Comm comm, HYPRE_Int num_sends, HYPRE_Int num_recvs, HYPRE_Int *recv_procs, HYPRE_Int *send_procs, HYPRE_Int *recv_vec_starts, hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GenerateSendMapAndCommPkg)( comm, num_sends, num_recvs, recv_procs, send_procs, recv_vec_starts, A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GenerateSubComm( MPI_Comm comm, HYPRE_Int participate, MPI_Comm *new_comm_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GenerateSubComm)( comm, participate, new_comm_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GetCommPkgRTFromCommPkgA( hypre_ParCSRMatrix *RT, hypre_ParCSRMatrix *A, HYPRE_Int *fine_to_coarse, HYPRE_Int *tmp_map_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GetCommPkgRTFromCommPkgA)( RT, A, fine_to_coarse, tmp_map_offd );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GrabSubArray( HYPRE_Int *indices, HYPRE_Int start, HYPRE_Int end, HYPRE_BigInt *array, HYPRE_BigInt *output )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GrabSubArray)( indices, start, end, array, output );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GraphAdd( Link *list, HYPRE_Int *head, HYPRE_Int *tail, HYPRE_Int index, HYPRE_Int istack )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GraphAdd)( list, head, tail, index, istack );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_GraphRemove( Link *list, HYPRE_Int *head, HYPRE_Int *tail, HYPRE_Int index )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_GraphRemove)( list, head, tail, index );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUBuildRASExternalMatrix( hypre_ParCSRMatrix *A, HYPRE_Int *rperm, HYPRE_Int **E_i, HYPRE_Int **E_j, HYPRE_Real **E_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUBuildRASExternalMatrix)( A, rperm, E_i, E_j, E_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUCSRMatrixInverseSelfPrecondMRGlobal( hypre_CSRMatrix *matA, hypre_CSRMatrix **M, HYPRE_Real droptol, HYPRE_Real tol, HYPRE_Real eps_tol, HYPRE_Int max_row_nnz, HYPRE_Int max_iter, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUCSRMatrixInverseSelfPrecondMRGlobal)( matA, M, droptol, tol, eps_tol, max_row_nnz, max_iter, print_level );
}

/*--------------------------------------------------------------------------*/

void *
hypre_ILUCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUDestroy( void *ilu_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUDestroy)( ilu_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUGetFinalRelativeResidualNorm( void *ilu_vdata, HYPRE_Real *res_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUGetFinalRelativeResidualNorm)( ilu_vdata, res_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUGetInteriorExteriorPerm( hypre_ParCSRMatrix *A, HYPRE_MemoryLocation memory_location, HYPRE_Int **perm, HYPRE_Int *nLU, HYPRE_Int reordering_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUGetInteriorExteriorPerm)( A, memory_location, perm, nLU, reordering_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUGetIterativeSetupHistory( void *ilu_vdata, HYPRE_Complex **iter_setup_history )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUGetIterativeSetupHistory)( ilu_vdata, iter_setup_history );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUGetLocalPerm( hypre_ParCSRMatrix *A, HYPRE_Int **perm_ptr, HYPRE_Int *nLU, HYPRE_Int reordering_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUGetLocalPerm)( A, perm_ptr, nLU, reordering_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUGetNumIterations( void *ilu_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUGetNumIterations)( ilu_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUGetPermddPQ( hypre_ParCSRMatrix *A, HYPRE_Int **io_pperm, HYPRE_Int **io_qperm, HYPRE_Real tol, HYPRE_Int *nB, HYPRE_Int *nI, HYPRE_Int reordering_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUGetPermddPQ)( A, io_pperm, io_qperm, tol, nB, nI, reordering_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUGetPermddPQPre( HYPRE_Int n, HYPRE_Int nLU, HYPRE_Int *A_diag_i, HYPRE_Int *A_diag_j, HYPRE_Real *A_diag_data, HYPRE_Real tol, HYPRE_Int *perm, HYPRE_Int *rperm, HYPRE_Int *pperm_pre, HYPRE_Int *qperm_pre, HYPRE_Int *nB )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUGetPermddPQPre)( n, nLU, A_diag_i, A_diag_j, A_diag_data, tol, perm, rperm, pperm_pre, qperm_pre, nB );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILULocalRCM( hypre_CSRMatrix *A, HYPRE_Int start, HYPRE_Int end, HYPRE_Int **permp, HYPRE_Int **qpermp, HYPRE_Int sym )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILULocalRCM)( A, start, end, permp, qpermp, sym );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILULocalRCMBuildFinalPerm( HYPRE_Int start, HYPRE_Int end, HYPRE_Int * G_perm, HYPRE_Int *perm, HYPRE_Int *qperm, HYPRE_Int **permp, HYPRE_Int **qpermp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILULocalRCMBuildFinalPerm)( start, end, G_perm, perm, qperm, permp, qpermp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILULocalRCMBuildLevel( hypre_CSRMatrix *A, HYPRE_Int root, HYPRE_Int *marker, HYPRE_Int *level_i, HYPRE_Int *level_j, HYPRE_Int *nlevp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILULocalRCMBuildLevel)( A, root, marker, level_i, level_j, nlevp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILULocalRCMFindPPNode( hypre_CSRMatrix *A, HYPRE_Int *rootp, HYPRE_Int *marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILULocalRCMFindPPNode)( A, rootp, marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILULocalRCMMindegree( HYPRE_Int n, HYPRE_Int *degree, HYPRE_Int *marker, HYPRE_Int *rootp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILULocalRCMMindegree)( n, degree, marker, rootp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILULocalRCMNumbering( hypre_CSRMatrix *A, HYPRE_Int root, HYPRE_Int *marker, HYPRE_Int *perm, HYPRE_Int *current_nump )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILULocalRCMNumbering)( A, root, marker, perm, current_nump );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILULocalRCMOrder( hypre_CSRMatrix *A, HYPRE_Int *perm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILULocalRCMOrder)( A, perm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILULocalRCMQsort( HYPRE_Int *perm, HYPRE_Int start, HYPRE_Int end, HYPRE_Int *degree )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILULocalRCMQsort)( perm, start, end, degree );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILULocalRCMReverse( HYPRE_Int *perm, HYPRE_Int start, HYPRE_Int end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILULocalRCMReverse)( perm, start, end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMaxQSplitRabsI( HYPRE_Real *arrayR, HYPRE_Int *arrayI, HYPRE_Int left, HYPRE_Int bound, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMaxQSplitRabsI)( arrayR, arrayI, left, bound, right );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMaxRabs( HYPRE_Real *array_data, HYPRE_Int *array_j, HYPRE_Int start, HYPRE_Int end, HYPRE_Int nLU, HYPRE_Int *rperm, HYPRE_Real *value, HYPRE_Int *index, HYPRE_Real *l1_norm, HYPRE_Int *nnz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMaxRabs)( array_data, array_j, start, end, nLU, rperm, value, index, l1_norm, nnz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMaxrHeapAddRabsI( HYPRE_Real *heap, HYPRE_Int *I1, HYPRE_Int len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMaxrHeapAddRabsI)( heap, I1, len );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMaxrHeapRemoveRabsI( HYPRE_Real *heap, HYPRE_Int *I1, HYPRE_Int len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMaxrHeapRemoveRabsI)( heap, I1, len );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMinHeapAddI( HYPRE_Int *heap, HYPRE_Int len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMinHeapAddI)( heap, len );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMinHeapAddIIIi( HYPRE_Int *heap, HYPRE_Int *I1, HYPRE_Int *Ii1, HYPRE_Int len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMinHeapAddIIIi)( heap, I1, Ii1, len );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMinHeapAddIRIi( HYPRE_Int *heap, HYPRE_Real *I1, HYPRE_Int *Ii1, HYPRE_Int len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMinHeapAddIRIi)( heap, I1, Ii1, len );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMinHeapRemoveI( HYPRE_Int *heap, HYPRE_Int len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMinHeapRemoveI)( heap, len );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMinHeapRemoveIIIi( HYPRE_Int *heap, HYPRE_Int *I1, HYPRE_Int *Ii1, HYPRE_Int len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMinHeapRemoveIIIi)( heap, I1, Ii1, len );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUMinHeapRemoveIRIi( HYPRE_Int *heap, HYPRE_Real *I1, HYPRE_Int *Ii1, HYPRE_Int len )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUMinHeapRemoveIRIi)( heap, I1, Ii1, len );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUParCSRInverseNSH( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix **M, HYPRE_Real *droptol, HYPRE_Real mr_tol, HYPRE_Real nsh_tol, HYPRE_Real eps_tol, HYPRE_Int mr_max_row_nnz, HYPRE_Int nsh_max_row_nnz, HYPRE_Int mr_max_iter, HYPRE_Int nsh_max_iter, HYPRE_Int mr_col_version, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUParCSRInverseNSH)( A, M, droptol, mr_tol, nsh_tol, eps_tol, mr_max_row_nnz, nsh_max_row_nnz, mr_max_iter, nsh_max_iter, mr_col_version, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetDropThreshold( void *ilu_vdata, HYPRE_Real threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetDropThreshold)( ilu_vdata, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetDropThresholdArray( void *ilu_vdata, HYPRE_Real *threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetDropThresholdArray)( ilu_vdata, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetIterativeSetupMaxIter( void *ilu_vdata, HYPRE_Int iter_setup_max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetIterativeSetupMaxIter)( ilu_vdata, iter_setup_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetIterativeSetupOption( void *ilu_vdata, HYPRE_Int iter_setup_option )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetIterativeSetupOption)( ilu_vdata, iter_setup_option );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetIterativeSetupTolerance( void *ilu_vdata, HYPRE_Real iter_setup_tolerance )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetIterativeSetupTolerance)( ilu_vdata, iter_setup_tolerance );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetIterativeSetupType( void *ilu_vdata, HYPRE_Int iter_setup_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetIterativeSetupType)( ilu_vdata, iter_setup_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetLevelOfFill( void *ilu_vdata, HYPRE_Int lfil )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetLevelOfFill)( ilu_vdata, lfil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetLocalReordering( void *ilu_vdata, HYPRE_Int ordering_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetLocalReordering)( ilu_vdata, ordering_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetLogging( void *ilu_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetLogging)( ilu_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetLowerJacobiIters( void *ilu_vdata, HYPRE_Int lower_jacobi_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetLowerJacobiIters)( ilu_vdata, lower_jacobi_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetMaxIter( void *ilu_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetMaxIter)( ilu_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetMaxNnzPerRow( void *ilu_vdata, HYPRE_Int nzmax )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetMaxNnzPerRow)( ilu_vdata, nzmax );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetPrintLevel( void *ilu_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetPrintLevel)( ilu_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurNSHDropThreshold( void *ilu_vdata, HYPRE_Real threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurNSHDropThreshold)( ilu_vdata, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurNSHDropThresholdArray( void *ilu_vdata, HYPRE_Real *threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurNSHDropThresholdArray)( ilu_vdata, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondILUDropThreshold( void *ilu_vdata, HYPRE_Real sp_ilu_droptol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondILUDropThreshold)( ilu_vdata, sp_ilu_droptol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondILUDropThresholdArray( void *ilu_vdata, HYPRE_Real *sp_ilu_droptol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondILUDropThresholdArray)( ilu_vdata, sp_ilu_droptol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondILULevelOfFill( void *ilu_vdata, HYPRE_Int sp_ilu_lfil )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondILULevelOfFill)( ilu_vdata, sp_ilu_lfil );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondILUMaxNnzPerRow( void *ilu_vdata, HYPRE_Int sp_ilu_max_row_nnz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondILUMaxNnzPerRow)( ilu_vdata, sp_ilu_max_row_nnz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondILUType( void *ilu_vdata, HYPRE_Int sp_ilu_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondILUType)( ilu_vdata, sp_ilu_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondLowerJacobiIters( void *ilu_vdata, HYPRE_Int sp_lower_jacobi_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondLowerJacobiIters)( ilu_vdata, sp_lower_jacobi_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondMaxIter( void *ilu_vdata, HYPRE_Int sp_max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondMaxIter)( ilu_vdata, sp_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondPrintLevel( void *ilu_vdata, HYPRE_Int sp_print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondPrintLevel)( ilu_vdata, sp_print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondTol( void *ilu_vdata, HYPRE_Int sp_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondTol)( ilu_vdata, sp_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondTriSolve( void *ilu_vdata, HYPRE_Int sp_tri_solve )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondTriSolve)( ilu_vdata, sp_tri_solve );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurPrecondUpperJacobiIters( void *ilu_vdata, HYPRE_Int sp_upper_jacobi_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurPrecondUpperJacobiIters)( ilu_vdata, sp_upper_jacobi_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurSolverAbsoluteTol( void *ilu_vdata, HYPRE_Real ss_absolute_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurSolverAbsoluteTol)( ilu_vdata, ss_absolute_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurSolverLogging( void *ilu_vdata, HYPRE_Int ss_logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurSolverLogging)( ilu_vdata, ss_logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurSolverMaxIter( void *ilu_vdata, HYPRE_Int ss_max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurSolverMaxIter)( ilu_vdata, ss_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurSolverPrintLevel( void *ilu_vdata, HYPRE_Int ss_print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurSolverPrintLevel)( ilu_vdata, ss_print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurSolverRelChange( void *ilu_vdata, HYPRE_Int ss_rel_change )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurSolverRelChange)( ilu_vdata, ss_rel_change );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetSchurSolverTol( void *ilu_vdata, HYPRE_Real ss_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetSchurSolverTol)( ilu_vdata, ss_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetTol( void *ilu_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetTol)( ilu_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetTriSolve( void *ilu_vdata, HYPRE_Int tri_solve )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetTriSolve)( ilu_vdata, tri_solve );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetType( void *ilu_vdata, HYPRE_Int ilu_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetType)( ilu_vdata, ilu_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetUpperJacobiIters( void *ilu_vdata, HYPRE_Int upper_jacobi_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetUpperJacobiIters)( ilu_vdata, upper_jacobi_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetup( void *ilu_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetup)( ilu_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupILU0( hypre_ParCSRMatrix *A, HYPRE_Int *perm, HYPRE_Int *qperm, HYPRE_Int nLU, HYPRE_Int nI, hypre_ParCSRMatrix **Lptr, HYPRE_Real **Dptr, hypre_ParCSRMatrix **Uptr, hypre_ParCSRMatrix **Sptr, HYPRE_Int **u_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupILU0)( A, perm, qperm, nLU, nI, Lptr, Dptr, Uptr, Sptr, u_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupILU0RAS( hypre_ParCSRMatrix *A, HYPRE_Int *perm, HYPRE_Int nLU, hypre_ParCSRMatrix **Lptr, HYPRE_Real **Dptr, hypre_ParCSRMatrix **Uptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupILU0RAS)( A, perm, nLU, Lptr, Dptr, Uptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupILUK( hypre_ParCSRMatrix *A, HYPRE_Int lfil, HYPRE_Int *permp, HYPRE_Int *qpermp, HYPRE_Int nLU, HYPRE_Int nI, hypre_ParCSRMatrix **Lptr, HYPRE_Real **Dptr, hypre_ParCSRMatrix **Uptr, hypre_ParCSRMatrix **Sptr, HYPRE_Int **u_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupILUK)( A, lfil, permp, qpermp, nLU, nI, Lptr, Dptr, Uptr, Sptr, u_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupILUKRAS( hypre_ParCSRMatrix *A, HYPRE_Int lfil, HYPRE_Int *perm, HYPRE_Int nLU, hypre_ParCSRMatrix **Lptr, HYPRE_Real **Dptr, hypre_ParCSRMatrix **Uptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupILUKRAS)( A, lfil, perm, nLU, Lptr, Dptr, Uptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupILUKRASSymbolic( HYPRE_Int n, HYPRE_Int *A_diag_i, HYPRE_Int *A_diag_j, HYPRE_Int *A_offd_i, HYPRE_Int *A_offd_j, HYPRE_Int *E_i, HYPRE_Int *E_j, HYPRE_Int ext, HYPRE_Int lfil, HYPRE_Int *perm, HYPRE_Int *rperm, HYPRE_Int *iw, HYPRE_Int nLU, HYPRE_Int *L_diag_i, HYPRE_Int *U_diag_i, HYPRE_Int **L_diag_j, HYPRE_Int **U_diag_j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupILUKRASSymbolic)( n, A_diag_i, A_diag_j, A_offd_i, A_offd_j, E_i, E_j, ext, lfil, perm, rperm, iw, nLU, L_diag_i, U_diag_i, L_diag_j, U_diag_j );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupILUKSymbolic( HYPRE_Int n, HYPRE_Int *A_diag_i, HYPRE_Int *A_diag_j, HYPRE_Int lfil, HYPRE_Int *perm, HYPRE_Int *rperm, HYPRE_Int *iw, HYPRE_Int nLU, HYPRE_Int *L_diag_i, HYPRE_Int *U_diag_i, HYPRE_Int *S_diag_i, HYPRE_Int **L_diag_j, HYPRE_Int **U_diag_j, HYPRE_Int **S_diag_j, HYPRE_Int **u_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupILUKSymbolic)( n, A_diag_i, A_diag_j, lfil, perm, rperm, iw, nLU, L_diag_i, U_diag_i, S_diag_i, L_diag_j, U_diag_j, S_diag_j, u_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupILUT( hypre_ParCSRMatrix *A, HYPRE_Int lfil, HYPRE_Real *tol, HYPRE_Int *permp, HYPRE_Int *qpermp, HYPRE_Int nLU, HYPRE_Int nI, hypre_ParCSRMatrix **Lptr, HYPRE_Real **Dptr, hypre_ParCSRMatrix **Uptr, hypre_ParCSRMatrix **Sptr, HYPRE_Int **u_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupILUT)( A, lfil, tol, permp, qpermp, nLU, nI, Lptr, Dptr, Uptr, Sptr, u_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupILUTRAS( hypre_ParCSRMatrix *A, HYPRE_Int lfil, HYPRE_Real *tol, HYPRE_Int *perm, HYPRE_Int nLU, hypre_ParCSRMatrix **Lptr, HYPRE_Real **Dptr, hypre_ParCSRMatrix **Uptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupILUTRAS)( A, lfil, tol, perm, nLU, Lptr, Dptr, Uptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupLDUtoCusparse( hypre_ParCSRMatrix *L, HYPRE_Real *D, hypre_ParCSRMatrix *U, hypre_ParCSRMatrix **LDUp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupLDUtoCusparse)( L, D, U, LDUp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupMILU0( hypre_ParCSRMatrix *A, HYPRE_Int *permp, HYPRE_Int *qpermp, HYPRE_Int nLU, HYPRE_Int nI, hypre_ParCSRMatrix **Lptr, HYPRE_Real **Dptr, hypre_ParCSRMatrix **Uptr, hypre_ParCSRMatrix **Sptr, HYPRE_Int **u_end, HYPRE_Int modified )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupMILU0)( A, permp, qpermp, nLU, nI, Lptr, Dptr, Uptr, Sptr, u_end, modified );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupRAPILU0( hypre_ParCSRMatrix *A, HYPRE_Int *perm, HYPRE_Int n, HYPRE_Int nLU, hypre_ParCSRMatrix **Lptr, HYPRE_Real **Dptr, hypre_ParCSRMatrix **Uptr, hypre_ParCSRMatrix **mLptr, HYPRE_Real **mDptr, hypre_ParCSRMatrix **mUptr, HYPRE_Int **u_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupRAPILU0)( A, perm, n, nLU, Lptr, Dptr, Uptr, mLptr, mDptr, mUptr, u_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupRAPILU0Device( hypre_ParCSRMatrix *A, HYPRE_Int *perm, HYPRE_Int n, HYPRE_Int nLU, hypre_ParCSRMatrix **Apermptr, hypre_ParCSRMatrix **matSptr, hypre_CSRMatrix **ALUptr, hypre_CSRMatrix **BLUptr, hypre_CSRMatrix **CLUptr, hypre_CSRMatrix **Eptr, hypre_CSRMatrix **Fptr, HYPRE_Int test_opt )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupRAPILU0Device)( A, perm, n, nLU, Apermptr, matSptr, ALUptr, BLUptr, CLUptr, Eptr, Fptr, test_opt );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSetupRAPMILU0( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix **ALUp, HYPRE_Int modified )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSetupRAPMILU0)( A, ALUp, modified );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSolve( void *ilu_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSolve)( ilu_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSolveLU( hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int *perm, HYPRE_Int nLU, hypre_ParCSRMatrix *L, HYPRE_Real *D, hypre_ParCSRMatrix *U, hypre_ParVector *ftemp, hypre_ParVector *utemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSolveLU)( A, f, u, perm, nLU, L, D, U, ftemp, utemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSolveLUIter( hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int *perm, HYPRE_Int nLU, hypre_ParCSRMatrix *L, HYPRE_Real *D, hypre_ParCSRMatrix *U, hypre_ParVector *ftemp, hypre_ParVector *utemp, HYPRE_Int lower_jacobi_iters, HYPRE_Int upper_jacobi_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSolveLUIter)( A, f, u, perm, nLU, L, D, U, ftemp, utemp, lower_jacobi_iters, upper_jacobi_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSolveLURAS( hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int *perm, hypre_ParCSRMatrix *L, HYPRE_Real *D, hypre_ParCSRMatrix *U, hypre_ParVector *ftemp, hypre_ParVector *utemp, HYPRE_Real *fext, HYPRE_Real *uext )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSolveLURAS)( A, f, u, perm, L, D, U, ftemp, utemp, fext, uext );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSolveRAPGMRESHost( hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int *perm, HYPRE_Int nLU, hypre_ParCSRMatrix *L, HYPRE_Real *D, hypre_ParCSRMatrix *U, hypre_ParCSRMatrix *mL, HYPRE_Real *mD, hypre_ParCSRMatrix *mU, hypre_ParVector *ftemp, hypre_ParVector *utemp, hypre_ParVector *xtemp, hypre_ParVector *ytemp, HYPRE_Solver schur_solver, HYPRE_Solver schur_precond, hypre_ParVector *rhs, hypre_ParVector *x, HYPRE_Int *u_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSolveRAPGMRESHost)( A, f, u, perm, nLU, L, D, U, mL, mD, mU, ftemp, utemp, xtemp, ytemp, schur_solver, schur_precond, rhs, x, u_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSolveSchurGMRES( hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int *perm, HYPRE_Int *qperm, HYPRE_Int nLU, hypre_ParCSRMatrix *L, HYPRE_Real *D, hypre_ParCSRMatrix *U, hypre_ParCSRMatrix *S, hypre_ParVector *ftemp, hypre_ParVector *utemp, HYPRE_Solver schur_solver, HYPRE_Solver schur_precond, hypre_ParVector *rhs, hypre_ParVector *x, HYPRE_Int *u_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSolveSchurGMRES)( A, f, u, perm, qperm, nLU, L, D, U, S, ftemp, utemp, schur_solver, schur_precond, rhs, x, u_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSolveSchurNSH( hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int *perm, HYPRE_Int nLU, hypre_ParCSRMatrix *L, HYPRE_Real *D, hypre_ParCSRMatrix *U, hypre_ParCSRMatrix *S, hypre_ParVector *ftemp, hypre_ParVector *utemp, HYPRE_Solver schur_solver, hypre_ParVector *rhs, hypre_ParVector *x, HYPRE_Int *u_end )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSolveSchurNSH)( A, f, u, perm, nLU, L, D, U, S, ftemp, utemp, schur_solver, rhs, x, u_end );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUSortOffdColmap( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUSortOffdColmap)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ILUWriteSolverParams( void *ilu_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ILUWriteSolverParams)( ilu_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IndepSetGreedy( HYPRE_Int *A_i, HYPRE_Int *A_j, HYPRE_Int n, HYPRE_Int *cf )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IndepSetGreedy)( A_i, A_j, n, cf );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IndepSetGreedyS( HYPRE_Int *A_i, HYPRE_Int *A_j, HYPRE_Int n, HYPRE_Int *cf )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IndepSetGreedyS)( A_i, A_j, n, cf );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntersectTwoArrays( HYPRE_Int *x, HYPRE_Real *x_data, HYPRE_Int x_length, HYPRE_Int *y, HYPRE_Int y_length, HYPRE_Int *z, HYPRE_Real *output_x_data, HYPRE_Int *intersect_length )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntersectTwoArrays)( x, x_data, x_length, y, y_length, z, output_x_data, intersect_length );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_IntersectTwoBigArrays( HYPRE_BigInt *x, HYPRE_Real *x_data, HYPRE_Int x_length, HYPRE_BigInt *y, HYPRE_Int y_length, HYPRE_BigInt *z, HYPRE_Real *output_x_data, HYPRE_Int *intersect_length )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_IntersectTwoBigArrays)( x, x_data, x_length, y, y_length, z, output_x_data, intersect_length );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_LINPACKcgpthy( HYPRE_Real *a, HYPRE_Real *b )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LINPACKcgpthy)( a, b );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_LINPACKcgtql1( HYPRE_Int *n, HYPRE_Real *d, HYPRE_Real *e, HYPRE_Int *ierr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_LINPACKcgtql1)( n, d, e, ierr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRAddVectorP( hypre_IntArray *CF_marker, HYPRE_Int point_type, HYPRE_Real a, hypre_ParVector *fromVector, HYPRE_Real b, hypre_ParVector **toVector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRAddVectorP)( CF_marker, point_type, a, fromVector, b, toVector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRAddVectorR( hypre_IntArray *CF_marker, HYPRE_Int point_type, HYPRE_Real a, hypre_ParVector *fromVector, HYPRE_Real b, hypre_ParVector **toVector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRAddVectorR)( CF_marker, point_type, a, fromVector, b, toVector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRApproximateInverse( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix **A_inv )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRApproximateInverse)( A, A_inv );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBlockColLumpedRestrict( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *A_FF, hypre_ParCSRMatrix *A_CF, hypre_IntArray *CF_marker, HYPRE_Int blk_dim, hypre_ParCSRMatrix **Wr_ptr, hypre_ParCSRMatrix **R_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBlockColLumpedRestrict)( A, A_FF, A_CF, CF_marker, blk_dim, Wr_ptr, R_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBlockRelaxSetup( hypre_ParCSRMatrix *A, HYPRE_Int blk_size, HYPRE_Real **diaginvptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBlockRelaxSetup)( A, blk_size, diaginvptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBlockRelaxSolve( hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int blk_size, HYPRE_Int n_block, HYPRE_Int left_size, HYPRE_Int method, HYPRE_Real *diaginv, hypre_ParVector *Vtemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBlockRelaxSolve)( A, f, u, blk_size, n_block, left_size, method, diaginv, Vtemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBlockRelaxSolveDevice( hypre_ParCSRMatrix *B, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, hypre_ParVector *Vtemp, HYPRE_Real relax_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBlockRelaxSolveDevice)( B, A, f, u, Vtemp, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildAff( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, HYPRE_Int debug_flag, hypre_ParCSRMatrix **A_ff_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildAff)( A, CF_marker, debug_flag, A_ff_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildBlockJacobiP( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *A_FF, hypre_ParCSRMatrix *A_FC, hypre_ParCSRMatrix *Wp, HYPRE_Int blk_size, HYPRE_Int *CF_marker, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildBlockJacobiP)( A, A_FF, A_FC, Wp, blk_size, CF_marker, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildBlockJacobiWp( hypre_ParCSRMatrix *A_FF, hypre_ParCSRMatrix *A_FC, HYPRE_Int blk_size, hypre_ParCSRMatrix **Wp_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildBlockJacobiWp)( A_FF, A_FC, blk_size, Wp_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildCoarseOperator( void *mgr_data, hypre_ParCSRMatrix *A_FF, hypre_ParCSRMatrix *A_FC, hypre_ParCSRMatrix *A_CF, hypre_ParCSRMatrix **A_CC_ptr, hypre_ParCSRMatrix *Wp, hypre_ParCSRMatrix *Wr, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildCoarseOperator)( mgr_data, A_FF, A_FC, A_CF, A_CC_ptr, Wp, Wr, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildInterp( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *A_FF, hypre_ParCSRMatrix *A_FC, hypre_ParCSRMatrix *S, hypre_IntArray *CF_marker, HYPRE_BigInt *num_cpts_global, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, HYPRE_Int block_jacobi_bsize, HYPRE_Int method, HYPRE_Int num_sweeps_post, hypre_ParCSRMatrix **Wp_ptr, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildInterp)( A, A_FF, A_FC, S, CF_marker, num_cpts_global, trunc_factor, max_elmts, block_jacobi_bsize, method, num_sweeps_post, Wp_ptr, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildInterpApproximateInverse( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, HYPRE_BigInt *num_cpts_global, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildInterpApproximateInverse)( A, CF_marker, num_cpts_global, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildP( hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, HYPRE_BigInt *num_cpts_global, HYPRE_Int method, HYPRE_Int debug_flag, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildP)( A, CF_marker, num_cpts_global, method, debug_flag, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildPFromWp( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *Wp, HYPRE_Int *CF_marker, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildPFromWp)( A, Wp, CF_marker, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildPFromWpHost( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *Wp, HYPRE_Int *CF_marker, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildPFromWpHost)( A, Wp, CF_marker, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildPHost( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *A_FF, hypre_ParCSRMatrix *A_FC, HYPRE_Int *CF_marker, HYPRE_BigInt *num_cpts_global, HYPRE_Int method, hypre_ParCSRMatrix **Wp_ptr, hypre_ParCSRMatrix **P_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildPHost)( A, A_FF, A_FC, CF_marker, num_cpts_global, method, Wp_ptr, P_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildRFromWr( hypre_IntArray *C_map, hypre_IntArray *F_map, HYPRE_BigInt global_num_rows_R, HYPRE_BigInt global_num_cols_R, HYPRE_BigInt *row_starts_R, HYPRE_BigInt *col_starts_R, hypre_ParCSRMatrix *Wr, hypre_ParCSRMatrix **R_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildRFromWr)( C_map, F_map, global_num_rows_R, global_num_cols_R, row_starts_R, col_starts_R, Wr, R_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRBuildRestrict( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *A_FF, hypre_ParCSRMatrix *A_FC, hypre_ParCSRMatrix *A_CF, hypre_IntArray *CF_marker, HYPRE_BigInt *num_cpts_global, HYPRE_Real trunc_factor, HYPRE_Int max_elmts, HYPRE_Real strong_threshold, HYPRE_Real max_row_sum, HYPRE_Int blk_size, HYPRE_Int method, hypre_ParCSRMatrix **W_ptr, hypre_ParCSRMatrix **R_ptr, hypre_ParCSRMatrix **RT_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRBuildRestrict)( A, A_FF, A_FC, A_CF, CF_marker, num_cpts_global, trunc_factor, max_elmts, strong_threshold, max_row_sum, blk_size, method, W_ptr, R_ptr, RT_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRCoarseParms( MPI_Comm comm, HYPRE_Int num_rows, hypre_IntArray *CF_marker, HYPRE_BigInt *row_starts_cpts, HYPRE_BigInt *row_starts_fpts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRCoarseParms)( comm, num_rows, CF_marker, row_starts_cpts, row_starts_fpts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRCoarsen( hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *A, HYPRE_Int final_coarse_size, HYPRE_Int *final_coarse_indexes, HYPRE_Int debug_flag, hypre_IntArray **CF_marker, HYPRE_Int last_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRCoarsen)( S, A, final_coarse_size, final_coarse_indexes, debug_flag, CF_marker, last_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRColLumpedRestrict( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *A_FF, hypre_ParCSRMatrix *A_CF, hypre_IntArray *CF_marker, hypre_ParCSRMatrix **Wr_ptr, hypre_ParCSRMatrix **R_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRColLumpedRestrict)( A, A_FF, A_CF, CF_marker, Wr_ptr, R_ptr );
}

/*--------------------------------------------------------------------------*/

void *
hypre_MGRCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRCreate)( );
}

/*--------------------------------------------------------------------------*/

void *
hypre_MGRCreateFrelaxVcycleData( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRCreateFrelaxVcycleData)( );
}

/*--------------------------------------------------------------------------*/

void *
hypre_MGRCreateGSElimData( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRCreateGSElimData)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRCycle( void *mgr_vdata, hypre_ParVector **F_array, hypre_ParVector **U_array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRCycle)( mgr_vdata, F_array, U_array );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRDataPrint( void *mgr_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRDataPrint)( mgr_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRDestroy( void *mgr_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRDestroy)( mgr_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRDestroyFrelaxVcycleData( void *mgr_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRDestroyFrelaxVcycleData)( mgr_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRDestroyGSElimData( void *mgr_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRDestroyGSElimData)( mgr_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRFrelaxVcycle( void *mgr_vdata, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRFrelaxVcycle)( mgr_vdata, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRGetCoarseGridConvergenceFactor( void *mgr_data, HYPRE_Real *conv_factor )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRGetCoarseGridConvergenceFactor)( mgr_data, conv_factor );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRGetFinalRelativeResidualNorm( void *mgr_vdata, HYPRE_Real *res_norm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRGetFinalRelativeResidualNorm)( mgr_vdata, res_norm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRGetNumIterations( void *mgr_vdata, HYPRE_Int *num_iterations )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRGetNumIterations)( mgr_vdata, num_iterations );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRGetSubBlock( hypre_ParCSRMatrix *A, HYPRE_Int *row_cf_marker, HYPRE_Int *col_cf_marker, HYPRE_Int debug_flag, hypre_ParCSRMatrix **A_ff_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRGetSubBlock)( A, row_cf_marker, col_cf_marker, debug_flag, A_ff_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetBlockJacobiBlockSize( void *mgr_vdata, HYPRE_Int blk_size )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetBlockJacobiBlockSize)( mgr_vdata, blk_size );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetBlockSize( void *mgr_vdata, HYPRE_Int bsize )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetBlockSize)( mgr_vdata, bsize );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetCoarseGridMethod( void *mgr_vdata, HYPRE_Int *cg_method )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetCoarseGridMethod)( mgr_vdata, cg_method );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetCoarseGridPrintLevel( void *mgr_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetCoarseGridPrintLevel)( mgr_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetCpointsByBlock( void *mgr_vdata, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *block_num_coarse_points, HYPRE_Int **block_coarse_indexes )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetCpointsByBlock)( mgr_vdata, block_size, max_num_levels, block_num_coarse_points, block_coarse_indexes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetCpointsByContiguousBlock( void *mgr_vdata, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_BigInt *begin_idx_array, HYPRE_Int *block_num_coarse_points, HYPRE_Int **block_coarse_indexes )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetCpointsByContiguousBlock)( mgr_vdata, block_size, max_num_levels, begin_idx_array, block_num_coarse_points, block_coarse_indexes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetCpointsByPointMarkerArray( void *mgr_vdata, HYPRE_Int block_size, HYPRE_Int max_num_levels, HYPRE_Int *block_num_coarse_points, HYPRE_Int **block_coarse_indexes, HYPRE_Int *point_marker_array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetCpointsByPointMarkerArray)( mgr_vdata, block_size, max_num_levels, block_num_coarse_points, block_coarse_indexes, point_marker_array );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetFRelaxMethod( void *mgr_vdata, HYPRE_Int relax_method )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetFRelaxMethod)( mgr_vdata, relax_method );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetFSolverAtLevel( void *mgr_vdata, void *fsolver, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetFSolverAtLevel)( mgr_vdata, fsolver, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetFrelaxPrintLevel( void *mgr_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetFrelaxPrintLevel)( mgr_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetGlobalSmoothCycle( void *mgr_vdata, HYPRE_Int global_smooth_cycle )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetGlobalSmoothCycle)( mgr_vdata, global_smooth_cycle );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetGlobalSmoothType( void *mgr_vdata, HYPRE_Int iter_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetGlobalSmoothType)( mgr_vdata, iter_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetGlobalSmootherAtLevel( void *mgr_vdata, HYPRE_Solver smoother, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetGlobalSmootherAtLevel)( mgr_vdata, smoother, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetInterpType( void *mgr_vdata, HYPRE_Int interpType )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetInterpType)( mgr_vdata, interpType );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelFRelaxMethod( void *mgr_vdata, HYPRE_Int *relax_method )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelFRelaxMethod)( mgr_vdata, relax_method );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelFRelaxNumFunctions( void *mgr_vdata, HYPRE_Int *num_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelFRelaxNumFunctions)( mgr_vdata, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelFRelaxType( void *mgr_vdata, HYPRE_Int *relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelFRelaxType)( mgr_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelInterpType( void *mgr_vdata, HYPRE_Int *interpType )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelInterpType)( mgr_vdata, interpType );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelNonGalerkinMaxElmts( void *mgr_vdata, HYPRE_Int *max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelNonGalerkinMaxElmts)( mgr_vdata, max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelNumRelaxSweeps( void *mgr_vdata, HYPRE_Int *nsweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelNumRelaxSweeps)( mgr_vdata, nsweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelPMaxElmts( void *mgr_vdata, HYPRE_Int *P_max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelPMaxElmts)( mgr_vdata, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelRestrictType( void *mgr_vdata, HYPRE_Int *restrictType )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelRestrictType)( mgr_vdata, restrictType );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelSmoothIters( void *mgr_vdata, HYPRE_Int *level_smooth_iters )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelSmoothIters)( mgr_vdata, level_smooth_iters );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLevelSmoothType( void *mgr_vdata, HYPRE_Int *level_smooth_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLevelSmoothType)( mgr_vdata, level_smooth_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetLogging( void *mgr_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetLogging)( mgr_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetMaxCoarseLevels( void *mgr_vdata, HYPRE_Int maxlev )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetMaxCoarseLevels)( mgr_vdata, maxlev );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetMaxGlobalSmoothIters( void *mgr_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetMaxGlobalSmoothIters)( mgr_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetMaxIter( void *mgr_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetMaxIter)( mgr_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetNonCpointsToFpoints( void *mgr_vdata, HYPRE_Int nonCptToFptFlag )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetNonCpointsToFpoints)( mgr_vdata, nonCptToFptFlag );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetNonGalerkinMaxElmts( void *mgr_vdata, HYPRE_Int max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetNonGalerkinMaxElmts)( mgr_vdata, max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetNumInterpSweeps( void *mgr_vdata, HYPRE_Int nsweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetNumInterpSweeps)( mgr_vdata, nsweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetNumRelaxSweeps( void *mgr_vdata, HYPRE_Int nsweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetNumRelaxSweeps)( mgr_vdata, nsweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetNumRestrictSweeps( void *mgr_vdata, HYPRE_Int nsweeps )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetNumRestrictSweeps)( mgr_vdata, nsweeps );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetPMaxElmts( void *mgr_vdata, HYPRE_Int P_max_elmts )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetPMaxElmts)( mgr_vdata, P_max_elmts );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetPrintLevel( void *mgr_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetPrintLevel)( mgr_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetRelaxType( void *mgr_vdata, HYPRE_Int relax_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetRelaxType)( mgr_vdata, relax_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetReservedCoarseNodes( void *mgr_vdata, HYPRE_Int reserved_coarse_size, HYPRE_BigInt *reserved_coarse_nodes )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetReservedCoarseNodes)( mgr_vdata, reserved_coarse_size, reserved_coarse_nodes );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetReservedCpointsLevelToKeep( void *mgr_vdata, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetReservedCpointsLevelToKeep)( mgr_vdata, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetRestrictType( void *mgr_vdata, HYPRE_Int restrictType )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetRestrictType)( mgr_vdata, restrictType );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetTol( void *mgr_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetTol)( mgr_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetTruncateCoarseGridThreshold( void *mgr_vdata, HYPRE_Real threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetTruncateCoarseGridThreshold)( mgr_vdata, threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetup( void *mgr_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetup)( mgr_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetupFrelaxVcycleData( void *mgr_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetupFrelaxVcycleData)( mgr_vdata, A, f, u, level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSetupStats( void *mgr_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSetupStats)( mgr_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRSolve( void *mgr_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRSolve)( mgr_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRTruncateAcfCPR( hypre_ParCSRMatrix *A_CF, hypre_ParCSRMatrix **A_CF_new_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRTruncateAcfCPR)( A_CF, A_CF_new_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MGRTruncateAcfCPRDevice( hypre_ParCSRMatrix *A_CF, hypre_ParCSRMatrix **A_CF_new_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MGRTruncateAcfCPRDevice)( A_CF, A_CF_new_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPSchwarzCFFWSolve( hypre_ParCSRMatrix *par_A, hypre_Vector *rhs_vector, hypre_CSRMatrix *domain_structure, hypre_ParVector *par_x, HYPRE_Real relax_wt, hypre_Vector *aux_vector, HYPRE_Int *CF_marker, HYPRE_Int rlx_pt, HYPRE_Int *pivots, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPSchwarzCFFWSolve)( par_A, rhs_vector, domain_structure, par_x, relax_wt, aux_vector, CF_marker, rlx_pt, pivots, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPSchwarzCFSolve( hypre_ParCSRMatrix *par_A, hypre_Vector *rhs_vector, hypre_CSRMatrix *domain_structure, hypre_ParVector *par_x, HYPRE_Real relax_wt, hypre_Vector *aux_vector, HYPRE_Int *CF_marker, HYPRE_Int rlx_pt, HYPRE_Int *pivots, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPSchwarzCFSolve)( par_A, rhs_vector, domain_structure, par_x, relax_wt, aux_vector, CF_marker, rlx_pt, pivots, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPSchwarzFWSolve( hypre_ParCSRMatrix *par_A, hypre_Vector *rhs_vector, hypre_CSRMatrix *domain_structure, hypre_ParVector *par_x, HYPRE_Real relax_wt, hypre_Vector *aux_vector, HYPRE_Int *pivots, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPSchwarzFWSolve)( par_A, rhs_vector, domain_structure, par_x, relax_wt, aux_vector, pivots, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_MPSchwarzSolve( hypre_ParCSRMatrix *par_A, hypre_Vector *rhs_vector, hypre_CSRMatrix *domain_structure, hypre_ParVector *par_x, HYPRE_Real relax_wt, hypre_Vector *aux_vector, HYPRE_Int *pivots, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_MPSchwarzSolve)( par_A, rhs_vector, domain_structure, par_x, relax_wt, aux_vector, pivots, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

void *
hypre_NSHCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHDestroy( void *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHDestroy)( data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetColVersion( void *nsh_vdata, HYPRE_Int mr_col_version )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetColVersion)( nsh_vdata, mr_col_version );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetDropThreshold( void *nsh_vdata, HYPRE_Real droptol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetDropThreshold)( nsh_vdata, droptol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetDropThresholdArray( void *nsh_vdata, HYPRE_Real *droptol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetDropThresholdArray)( nsh_vdata, droptol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetGlobalSolver( void *nsh_vdata, HYPRE_Int global_solver )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetGlobalSolver)( nsh_vdata, global_solver );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetLogging( void *nsh_vdata, HYPRE_Int logging )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetLogging)( nsh_vdata, logging );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetMRMaxIter( void *nsh_vdata, HYPRE_Int mr_max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetMRMaxIter)( nsh_vdata, mr_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetMRMaxRowNnz( void *nsh_vdata, HYPRE_Int mr_max_row_nnz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetMRMaxRowNnz)( nsh_vdata, mr_max_row_nnz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetMRTol( void *nsh_vdata, HYPRE_Real mr_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetMRTol)( nsh_vdata, mr_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetMaxIter( void *nsh_vdata, HYPRE_Int max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetMaxIter)( nsh_vdata, max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetNSHMaxIter( void *nsh_vdata, HYPRE_Int nsh_max_iter )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetNSHMaxIter)( nsh_vdata, nsh_max_iter );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetNSHMaxRowNnz( void *nsh_vdata, HYPRE_Int nsh_max_row_nnz )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetNSHMaxRowNnz)( nsh_vdata, nsh_max_row_nnz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetNSHTol( void *nsh_vdata, HYPRE_Real nsh_tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetNSHTol)( nsh_vdata, nsh_tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetPrintLevel( void *nsh_vdata, HYPRE_Int print_level )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetPrintLevel)( nsh_vdata, print_level );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetTol( void *nsh_vdata, HYPRE_Real tol )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetTol)( nsh_vdata, tol );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSetup( void *nsh_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSetup)( nsh_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSolve( void *nsh_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSolve)( nsh_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHSolveInverse( hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, hypre_ParCSRMatrix *M, hypre_ParVector *ftemp, hypre_ParVector *utemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHSolveInverse)( A, f, u, M, ftemp, utemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NSHWriteSolverParams( void *nsh_vdata )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NSHWriteSolverParams)( nsh_vdata );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NonGalerkinIJBigBufferInit( HYPRE_Int *ijbuf_cnt, HYPRE_Int *ijbuf_rowcounter, HYPRE_BigInt *ijbuf_numcols )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NonGalerkinIJBigBufferInit)( ijbuf_cnt, ijbuf_rowcounter, ijbuf_numcols );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NonGalerkinIJBufferCompress( HYPRE_MemoryLocation memory_location, HYPRE_Int ijbuf_size, HYPRE_Int *ijbuf_cnt, HYPRE_Int *ijbuf_rowcounter, HYPRE_Real **ijbuf_data, HYPRE_BigInt **ijbuf_cols, HYPRE_BigInt **ijbuf_rownums, HYPRE_Int **ijbuf_numcols )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NonGalerkinIJBufferCompress)( memory_location, ijbuf_size, ijbuf_cnt, ijbuf_rowcounter, ijbuf_data, ijbuf_cols, ijbuf_rownums, ijbuf_numcols );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NonGalerkinIJBufferCompressRow( HYPRE_Int *ijbuf_cnt, HYPRE_Int ijbuf_rowcounter, HYPRE_Real *ijbuf_data, HYPRE_BigInt *ijbuf_cols, HYPRE_BigInt *ijbuf_rownums, HYPRE_Int *ijbuf_numcols )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NonGalerkinIJBufferCompressRow)( ijbuf_cnt, ijbuf_rowcounter, ijbuf_data, ijbuf_cols, ijbuf_rownums, ijbuf_numcols );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NonGalerkinIJBufferEmpty( HYPRE_IJMatrix B, HYPRE_Int ijbuf_size, HYPRE_Int *ijbuf_cnt, HYPRE_Int ijbuf_rowcounter, HYPRE_Real **ijbuf_data, HYPRE_BigInt **ijbuf_cols, HYPRE_BigInt **ijbuf_rownums, HYPRE_Int **ijbuf_numcols )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NonGalerkinIJBufferEmpty)( B, ijbuf_size, ijbuf_cnt, ijbuf_rowcounter, ijbuf_data, ijbuf_cols, ijbuf_rownums, ijbuf_numcols );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NonGalerkinIJBufferInit( HYPRE_Int *ijbuf_cnt, HYPRE_Int *ijbuf_rowcounter, HYPRE_Int *ijbuf_numcols )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NonGalerkinIJBufferInit)( ijbuf_cnt, ijbuf_rowcounter, ijbuf_numcols );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NonGalerkinIJBufferNewRow( HYPRE_BigInt *ijbuf_rownums, HYPRE_Int *ijbuf_numcols, HYPRE_Int *ijbuf_rowcounter, HYPRE_BigInt new_row )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NonGalerkinIJBufferNewRow)( ijbuf_rownums, ijbuf_numcols, ijbuf_rowcounter, new_row );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_NonGalerkinIJBufferWrite( HYPRE_IJMatrix B, HYPRE_Int *ijbuf_cnt, HYPRE_Int ijbuf_size, HYPRE_Int *ijbuf_rowcounter, HYPRE_Real **ijbuf_data, HYPRE_BigInt **ijbuf_cols, HYPRE_BigInt **ijbuf_rownums, HYPRE_Int **ijbuf_numcols, HYPRE_BigInt row_to_write, HYPRE_BigInt col_to_write, HYPRE_Real val_to_write )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NonGalerkinIJBufferWrite)( B, ijbuf_cnt, ijbuf_size, ijbuf_rowcounter, ijbuf_data, ijbuf_cols, ijbuf_rownums, ijbuf_numcols, row_to_write, col_to_write, val_to_write );
}

/*--------------------------------------------------------------------------*/

hypre_ParCSRMatrix *
hypre_NonGalerkinSparsityPattern( hypre_ParCSRMatrix *R_IAP, hypre_ParCSRMatrix *RAP, HYPRE_Int * CF_marker, HYPRE_Real droptol, HYPRE_Int sym_collapse, HYPRE_Int collapse_beta )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_NonGalerkinSparsityPattern)( R_IAP, RAP, CF_marker, droptol, sym_collapse, collapse_beta );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParAMGCreateDomainDof( hypre_ParCSRMatrix *A, HYPRE_Int domain_type, HYPRE_Int overlap, HYPRE_Int num_functions, HYPRE_Int *dof_func, hypre_CSRMatrix **domain_structure_pointer, HYPRE_Int **piv_pointer, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParAMGCreateDomainDof)( A, domain_type, overlap, num_functions, dof_func, domain_structure_pointer, piv_pointer, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParAdSchwarzSolve( hypre_ParCSRMatrix *A, hypre_ParVector *F, hypre_CSRMatrix *domain_structure, HYPRE_Real *scale, hypre_ParVector *X, hypre_ParVector *Vtemp, HYPRE_Int *pivots, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParAdSchwarzSolve)( A, F, domain_structure, scale, X, Vtemp, pivots, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRComputeL1Norms( hypre_ParCSRMatrix *A, HYPRE_Int option, HYPRE_Int *cf_marker, HYPRE_Real **l1_norm_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRComputeL1Norms)( A, option, cf_marker, l1_norm_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRComputeL1NormsThreads( hypre_ParCSRMatrix *A, HYPRE_Int option, HYPRE_Int num_threads, HYPRE_Int *cf_marker, HYPRE_Real **l1_norm_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRComputeL1NormsThreads)( A, option, num_threads, cf_marker, l1_norm_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixBlockDiagMatrix( hypre_ParCSRMatrix *A, HYPRE_Int blk_size, HYPRE_Int point_type, HYPRE_Int *CF_marker, HYPRE_Int diag_type, hypre_ParCSRMatrix **B_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixBlockDiagMatrix)( A, blk_size, point_type, CF_marker, diag_type, B_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixBlockDiagMatrixHost( hypre_ParCSRMatrix *A, HYPRE_Int blk_size, HYPRE_Int point_type, HYPRE_Int *CF_marker, HYPRE_Int diag_type, hypre_ParCSRMatrix **B_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixBlockDiagMatrixHost)( A, blk_size, point_type, CF_marker, diag_type, B_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_ParCSRMatrixChooseThresh( hypre_ParCSRMatrix *S )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixChooseThresh)( S );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixExtractBlockDiagHost( hypre_ParCSRMatrix *par_A, HYPRE_Int blk_size, HYPRE_Int num_points, HYPRE_Int point_type, HYPRE_Int *CF_marker, HYPRE_Int diag_size, HYPRE_Int diag_type, HYPRE_Real *diag_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixExtractBlockDiagHost)( par_A, blk_size, num_points, point_type, CF_marker, diag_size, diag_type, diag_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixFillSmooth( HYPRE_Int nsamples, HYPRE_Real *samples, hypre_ParCSRMatrix *S, hypre_ParCSRMatrix *A, HYPRE_Int num_functions, HYPRE_Int *dof_func )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixFillSmooth)( nsamples, samples, S, A, num_functions, dof_func );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixFixZeroRows( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixFixZeroRows)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixNormFro( hypre_ParCSRMatrix *A, HYPRE_Real *norm_io )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixNormFro)( A, norm_io );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixResNormFro( hypre_ParCSRMatrix *A, HYPRE_Real *norm_io )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixResNormFro)( A, norm_io );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixScaledNorm( hypre_ParCSRMatrix *A, HYPRE_Real *scnorm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixScaledNorm)( A, scnorm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixSetDiagRows( hypre_ParCSRMatrix *A, HYPRE_Real d )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixSetDiagRows)( A, d );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrixThreshold( hypre_ParCSRMatrix *A, HYPRE_Real thresh )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrixThreshold)( A, thresh );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMatrix_dof_func_offd( hypre_ParCSRMatrix *A, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int **dof_func_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMatrix_dof_func_offd)( A, num_functions, dof_func, dof_func_offd );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMaxEigEstimate( hypre_ParCSRMatrix *A, HYPRE_Int scale, HYPRE_Real *max_eig, HYPRE_Real *min_eig )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMaxEigEstimate)( A, scale, max_eig, min_eig );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMaxEigEstimateCG( hypre_ParCSRMatrix *A, HYPRE_Int scale, HYPRE_Int max_iter, HYPRE_Real *max_eig, HYPRE_Real *min_eig )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMaxEigEstimateCG)( A, scale, max_iter, max_eig, min_eig );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMaxEigEstimateCGHost( hypre_ParCSRMatrix *A, HYPRE_Int scale, HYPRE_Int max_iter, HYPRE_Real *max_eig, HYPRE_Real *min_eig )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMaxEigEstimateCGHost)( A, scale, max_iter, max_eig, min_eig );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRMaxEigEstimateHost( hypre_ParCSRMatrix *A, HYPRE_Int scale, HYPRE_Real *max_eig, HYPRE_Real *min_eig )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRMaxEigEstimateHost)( A, scale, max_eig, min_eig );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRRelax( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int relax_type, HYPRE_Int relax_times, HYPRE_Real *l1_norms, HYPRE_Real relax_weight, HYPRE_Real omega, HYPRE_Real max_eig_est, HYPRE_Real min_eig_est, HYPRE_Int cheby_order, HYPRE_Real cheby_fraction, hypre_ParVector *u, hypre_ParVector *v, hypre_ParVector *z )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRRelax)( A, f, relax_type, relax_times, l1_norms, relax_weight, omega, max_eig_est, min_eig_est, cheby_order, cheby_fraction, u, v, z );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRRelax_CG( HYPRE_Solver solver, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int num_its )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRRelax_CG)( solver, A, f, u, num_its );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRRelax_Cheby( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Real max_eig, HYPRE_Real min_eig, HYPRE_Real fraction, HYPRE_Int order, HYPRE_Int scale, HYPRE_Int variant, hypre_ParVector *u, hypre_ParVector *v, hypre_ParVector *r )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRRelax_Cheby)( A, f, max_eig, min_eig, fraction, order, scale, variant, u, v, r );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRRelax_Cheby_Setup( hypre_ParCSRMatrix *A, HYPRE_Real max_eig, HYPRE_Real min_eig, HYPRE_Real fraction, HYPRE_Int order, HYPRE_Int scale, HYPRE_Int variant, HYPRE_Real **coefs_ptr, HYPRE_Real **ds_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRRelax_Cheby_Setup)( A, max_eig, min_eig, fraction, order, scale, variant, coefs_ptr, ds_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRRelax_Cheby_Solve( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Real *ds_data, HYPRE_Real *coefs, HYPRE_Int order, HYPRE_Int scale, HYPRE_Int variant, hypre_ParVector *u, hypre_ParVector *v, hypre_ParVector *r, hypre_ParVector *orig_u_vec, hypre_ParVector *tmp_vec )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRRelax_Cheby_Solve)( A, f, ds_data, coefs, order, scale, variant, u, v, r, orig_u_vec, tmp_vec );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRRelax_Cheby_SolveHost( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Real *ds_data, HYPRE_Real *coefs, HYPRE_Int order, HYPRE_Int scale, HYPRE_Int variant, hypre_ParVector *u, hypre_ParVector *v, hypre_ParVector *r, hypre_ParVector *orig_u_vec, hypre_ParVector *tmp_vec )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRRelax_Cheby_SolveHost)( A, f, ds_data, coefs, order, scale, variant, u, v, r, orig_u_vec, tmp_vec );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRRelax_L1_Jacobi( hypre_ParCSRMatrix *A, hypre_ParVector *f, HYPRE_Int *cf_marker, HYPRE_Int relax_points, HYPRE_Real relax_weight, HYPRE_Real *l1_norms, hypre_ParVector *u, hypre_ParVector *Vtemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRRelax_L1_Jacobi)( A, f, cf_marker, relax_points, relax_weight, l1_norms, u, Vtemp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParCSRSubspacePrec( hypre_ParCSRMatrix *A0, HYPRE_Int A0_relax_type, HYPRE_Int A0_relax_times, HYPRE_Real *A0_l1_norms, HYPRE_Real A0_relax_weight, HYPRE_Real A0_omega, HYPRE_Real A0_max_eig_est, HYPRE_Real A0_min_eig_est, HYPRE_Int A0_cheby_order, HYPRE_Real A0_cheby_fraction, hypre_ParCSRMatrix **A, HYPRE_Solver *B, HYPRE_PtrToSolverFcn *HB, hypre_ParCSRMatrix **P, hypre_ParVector **r, hypre_ParVector **g, hypre_ParVector *x, hypre_ParVector *y, hypre_ParVector *r0, hypre_ParVector *g0, char *cycle, hypre_ParVector *z )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParCSRSubspacePrec)( A0, A0_relax_type, A0_relax_times, A0_l1_norms, A0_relax_weight, A0_omega, A0_max_eig_est, A0_min_eig_est, A0_cheby_order, A0_cheby_fraction, A, B, HB, P, r, g, x, y, r0, g0, cycle, z );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParGenerateHybridScale( hypre_ParCSRMatrix *A, hypre_CSRMatrix *domain_structure, hypre_CSRMatrix **A_boundary_pointer, HYPRE_Real **scale_pointer )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParGenerateHybridScale)( A, domain_structure, A_boundary_pointer, scale_pointer );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParGenerateScale( hypre_ParCSRMatrix *A, hypre_CSRMatrix *domain_structure, HYPRE_Real relaxation_weight, HYPRE_Real **scale_pointer )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParGenerateScale)( A, domain_structure, relaxation_weight, scale_pointer );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParILUExtractEBFC( hypre_CSRMatrix *A_diag, HYPRE_Int nLU, hypre_CSRMatrix **Bp, hypre_CSRMatrix **Cp, hypre_CSRMatrix **Ep, hypre_CSRMatrix **Fp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParILUExtractEBFC)( A_diag, nLU, Bp, Cp, Ep, Fp );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParILURAPReorder( hypre_ParCSRMatrix *A, HYPRE_Int *perm, HYPRE_Int *rqperm, hypre_ParCSRMatrix **A_pq )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParILURAPReorder)( A, perm, rqperm, A_pq );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParILURAPSchurGMRESCommInfoHost( void *ilu_vdata, HYPRE_Int *my_id, HYPRE_Int *num_procs )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParILURAPSchurGMRESCommInfoHost)( ilu_vdata, my_id, num_procs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParILURAPSchurGMRESMatvecHost( void *matvec_data, HYPRE_Complex alpha, void *ilu_vdata, void *x, HYPRE_Complex beta, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParILURAPSchurGMRESMatvecHost)( matvec_data, alpha, ilu_vdata, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParILURAPSchurGMRESSolveHost( void *ilu_vdata, void *ilu_vdata2, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParILURAPSchurGMRESSolveHost)( ilu_vdata, ilu_vdata2, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovAxpy( HYPRE_Complex alpha, void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovAxpy)( alpha, x, y );
}

/*--------------------------------------------------------------------------*/

void *
hypre_ParKrylovCAlloc( size_t count, size_t elt_size, HYPRE_MemoryLocation location )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovCAlloc)( count, elt_size, location );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovClearVector( void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovClearVector)( x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovCommInfo( void *A, HYPRE_Int *my_id, HYPRE_Int *num_procs )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovCommInfo)( A, my_id, num_procs );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovCopyVector( void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovCopyVector)( x, y );
}

/*--------------------------------------------------------------------------*/

void *
hypre_ParKrylovCreateVector( void *vvector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovCreateVector)( vvector );
}

/*--------------------------------------------------------------------------*/

void *
hypre_ParKrylovCreateVectorArray( HYPRE_Int n, void *vvector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovCreateVectorArray)( n, vvector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovDestroyVector( void *vvector )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovDestroyVector)( vvector );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovFree( void *ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovFree)( ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovIdentity( void *vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovIdentity)( vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovIdentitySetup( void *vdata, void *A, void *b, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovIdentitySetup)( vdata, A, b, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
hypre_ParKrylovInnerProd( void *x, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovInnerProd)( x, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovInnerProdTagged( void *x, void *y, HYPRE_Int *num_tags_ptr, HYPRE_Complex **iprod_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovInnerProdTagged)( x, y, num_tags_ptr, iprod_ptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovMassAxpy( HYPRE_Complex *alpha, void **x, void *y, HYPRE_Int k, HYPRE_Int unroll )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovMassAxpy)( alpha, x, y, k, unroll );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovMassDotpTwo( void *x, void *y, void **z, HYPRE_Int k, HYPRE_Int unroll, void *result_x, void *result_y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovMassDotpTwo)( x, y, z, k, unroll, result_x, result_y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovMassInnerProd( void *x, void **y, HYPRE_Int k, HYPRE_Int unroll, void *result )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovMassInnerProd)( x, y, k, unroll, result );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovMatvec( void *matvec_data, HYPRE_Complex alpha, void *A, void *x, HYPRE_Complex beta, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovMatvec)( matvec_data, alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

void *
hypre_ParKrylovMatvecCreate( void *A, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovMatvecCreate)( A, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovMatvecDestroy( void *matvec_data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovMatvecDestroy)( matvec_data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovMatvecT( void *matvec_data, HYPRE_Complex alpha, void *A, void *x, HYPRE_Complex beta, void *y )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovMatvecT)( matvec_data, alpha, A, x, beta, y );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParKrylovScaleVector( HYPRE_Complex alpha, void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParKrylovScaleVector)( alpha, x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParMPSchwarzSolve( hypre_ParCSRMatrix *par_A, hypre_CSRMatrix *A_boundary, hypre_ParVector *rhs_vector, hypre_CSRMatrix *domain_structure, hypre_ParVector *par_x, HYPRE_Real relax_wt, HYPRE_Real *scale, hypre_ParVector *Vtemp, HYPRE_Int *pivots, HYPRE_Int use_nonsymm )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParMPSchwarzSolve)( par_A, A_boundary, rhs_vector, domain_structure, par_x, relax_wt, scale, Vtemp, pivots, use_nonsymm );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParPrintVector( void *v, const char *file )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParPrintVector)( v, file );
}

/*--------------------------------------------------------------------------*/

void *
hypre_ParReadVector( MPI_Comm comm, const char *file )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParReadVector)( comm, file );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParSetRandomValues( void *v, HYPRE_Int seed )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParSetRandomValues)( v, seed );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorBlockGather( hypre_ParVector *x, hypre_ParVector *x_ [3 ], HYPRE_Int dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorBlockGather)( x, x_, dim );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorBlockSplit( hypre_ParVector *x, hypre_ParVector *x_ [3 ], HYPRE_Int dim )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorBlockSplit)( x, x_, dim );
}

/*--------------------------------------------------------------------------*/

hypre_ParVector *
hypre_ParVectorInDomainOf( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorInDomainOf)( A );
}

/*--------------------------------------------------------------------------*/

hypre_ParVector *
hypre_ParVectorInRangeOf( hypre_ParCSRMatrix *A )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorInRangeOf)( A );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ParVectorSize( void *x )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ParVectorSize)( x );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzCFSolve( void *schwarz_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int *CF_marker, HYPRE_Int rlx_pt )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzCFSolve)( schwarz_vdata, A, f, u, CF_marker, rlx_pt );
}

/*--------------------------------------------------------------------------*/

void *
hypre_SchwarzCreate( void )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzCreate)( );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzDestroy( void *data )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzDestroy)( data );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzReScale( void *data, HYPRE_Int size, HYPRE_Real value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzReScale)( data, size, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetDofFunc( void *data, HYPRE_Int *dof_func )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetDofFunc)( data, dof_func );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetDomainStructure( void *data, hypre_CSRMatrix *domain_structure )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetDomainStructure)( data, domain_structure );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetDomainType( void *data, HYPRE_Int domain_type )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetDomainType)( data, domain_type );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetNonSymm( void *data, HYPRE_Int value )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetNonSymm)( data, value );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetNumFunctions( void *data, HYPRE_Int num_functions )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetNumFunctions)( data, num_functions );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetOverlap( void *data, HYPRE_Int overlap )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetOverlap)( data, overlap );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetRelaxWeight( void *data, HYPRE_Real relax_weight )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetRelaxWeight)( data, relax_weight );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetScale( void *data, HYPRE_Real *scale )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetScale)( data, scale );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetVariant( void *data, HYPRE_Int variant )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetVariant)( data, variant );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSetup( void *schwarz_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSetup)( schwarz_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SchwarzSolve( void *schwarz_vdata, hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SchwarzSolve)( schwarz_vdata, A, f, u );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_SortedCopyParCSRData( hypre_ParCSRMatrix *A, hypre_ParCSRMatrix *B )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_SortedCopyParCSRData)( A, B );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_alt_insert_new_nodes( hypre_ParCSRCommPkg *comm_pkg, hypre_ParCSRCommPkg *extend_comm_pkg, HYPRE_Int *IN_marker, HYPRE_Int full_off_procNodes, HYPRE_Int *OUT_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_alt_insert_new_nodes)( comm_pkg, extend_comm_pkg, IN_marker, full_off_procNodes, OUT_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_big_insert_new_nodes( hypre_ParCSRCommPkg *comm_pkg, hypre_ParCSRCommPkg *extend_comm_pkg, HYPRE_Int *IN_marker, HYPRE_Int full_off_procNodes, HYPRE_BigInt offset, HYPRE_BigInt *OUT_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_big_insert_new_nodes)( comm_pkg, extend_comm_pkg, IN_marker, full_off_procNodes, offset, OUT_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_block_jacobi_solve( hypre_ParCSRMatrix *A, hypre_ParVector *f, hypre_ParVector *u, HYPRE_Int blk_size, HYPRE_Int method, HYPRE_Real *diaginv, hypre_ParVector *Vtemp )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_block_jacobi_solve)( A, f, u, blk_size, method, diaginv, Vtemp );
}

/*--------------------------------------------------------------------------*/

void
hypre_build_interp_colmap( hypre_ParCSRMatrix *P, HYPRE_Int full_off_procNodes, HYPRE_Int *tmp_CF_marker_offd, HYPRE_BigInt *fine_to_coarse_offd )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_build_interp_colmap)( P, full_off_procNodes, tmp_CF_marker_offd, fine_to_coarse_offd );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_cr( HYPRE_Int *A_i, HYPRE_Int *A_j, HYPRE_Real *A_data, HYPRE_Int n, HYPRE_Int *cf, HYPRE_Int rlx, HYPRE_Real omega, HYPRE_Real tg, HYPRE_Int mu )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_cr)( A_i, A_j, A_data, n, cf, rlx, omega, tg, mu );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_exchange_interp_data( HYPRE_Int **CF_marker_offd, HYPRE_Int **dof_func_offd, hypre_CSRMatrix **A_ext, HYPRE_Int *full_off_procNodes, hypre_CSRMatrix **Sop, hypre_ParCSRCommPkg **extend_comm_pkg, hypre_ParCSRMatrix *A, HYPRE_Int *CF_marker, hypre_ParCSRMatrix *S, HYPRE_Int num_functions, HYPRE_Int *dof_func, HYPRE_Int skip_fine_or_same_sign )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_exchange_interp_data)( CF_marker_offd, dof_func_offd, A_ext, full_off_procNodes, Sop, extend_comm_pkg, A, CF_marker, S, num_functions, dof_func, skip_fine_or_same_sign );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_exchange_marker( hypre_ParCSRCommPkg *comm_pkg, HYPRE_Int *IN_marker, HYPRE_Int *OUT_marker )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_exchange_marker)( comm_pkg, IN_marker, OUT_marker );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_formu( HYPRE_Int *cf, HYPRE_Int n, HYPRE_Real *e1, HYPRE_Int *A_i, HYPRE_Real rho )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_formu)( cf, n, e1, A_i, rho );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_fptgscr( HYPRE_Int *cf, HYPRE_Int *A_i, HYPRE_Int *A_j, HYPRE_Real *A_data, HYPRE_Int n, HYPRE_Real *e0, HYPRE_Real *e1 )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_fptgscr)( cf, A_i, A_j, A_data, n, e0, e1 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_fptjaccr( HYPRE_Int *cf, HYPRE_Int *A_i, HYPRE_Int *A_j, HYPRE_Real *A_data, HYPRE_Int n, HYPRE_Real *e0, HYPRE_Real omega, HYPRE_Real *e1 )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_fptjaccr)( cf, A_i, A_j, A_data, n, e0, omega, e1 );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_index_of_minimum( HYPRE_BigInt *data, HYPRE_Int n )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_index_of_minimum)( data, n );
}

/*--------------------------------------------------------------------------*/

void
hypre_initialize_vecs( HYPRE_Int diag_n, HYPRE_Int offd_n, HYPRE_Int *diag_ftc, HYPRE_BigInt *offd_ftc, HYPRE_Int *diag_pm, HYPRE_Int *offd_pm, HYPRE_Int *tmp_CF )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_initialize_vecs)( diag_n, offd_n, diag_ftc, offd_ftc, diag_pm, offd_pm, tmp_CF );
}

/*--------------------------------------------------------------------------*/

HYPRE_BigInt
hypre_map( HYPRE_BigInt ix, HYPRE_BigInt iy, HYPRE_BigInt iz, HYPRE_Int p, HYPRE_Int q, HYPRE_Int r, HYPRE_BigInt nx, HYPRE_BigInt ny, HYPRE_BigInt *nx_part, HYPRE_BigInt *ny_part, HYPRE_BigInt *nz_part )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_map)( ix, iy, iz, p, q, r, nx, ny, nx_part, ny_part, nz_part );
}

/*--------------------------------------------------------------------------*/

HYPRE_BigInt
hypre_map2( HYPRE_BigInt ix, HYPRE_BigInt iy, HYPRE_Int p, HYPRE_Int q, HYPRE_BigInt nx, HYPRE_BigInt *nx_part, HYPRE_BigInt *ny_part )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_map2)( ix, iy, p, q, nx, nx_part, ny_part );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_matinv( HYPRE_Real *x, HYPRE_Real *a, HYPRE_Int k )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_matinv)( x, a, k );
}

/*--------------------------------------------------------------------------*/

void
hypre_merge_lists( HYPRE_Int *list1, HYPRE_Int *list2, hypre_int *np1, hypre_MPI_Datatype *dptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_merge_lists)( list1, list2, np1, dptr );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_move_entry( HYPRE_Int weight, HYPRE_Int *weight_max, HYPRE_Int *previous, HYPRE_Int *next, HYPRE_Int *first, HYPRE_Int *last, HYPRE_Int head, HYPRE_Int tail, HYPRE_Int i )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_move_entry)( weight, weight_max, previous, next, first, last, head, tail, i );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_parCorrRes( hypre_ParCSRMatrix *A, hypre_ParVector *x, hypre_Vector *rhs, hypre_Vector **tmp_ptr )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_parCorrRes)( A, x, rhs, tmp_ptr );
}

/*--------------------------------------------------------------------------*/

void
hypre_qsort2_ci( HYPRE_Complex *v, HYPRE_Int *w, HYPRE_Int left, HYPRE_Int right )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_qsort2_ci)( v, w, left, right );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_remove_entry( HYPRE_Int weight, HYPRE_Int *weight_max, HYPRE_Int *previous, HYPRE_Int *next, HYPRE_Int *first, HYPRE_Int *last, HYPRE_Int head, HYPRE_Int tail, HYPRE_Int i )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_remove_entry)( weight, weight_max, previous, next, first, last, head, tail, i );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_seqAMGCycle( hypre_ParAMGData *amg_data, HYPRE_Int p_level, hypre_ParVector **Par_F_array, hypre_ParVector **Par_U_array )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_seqAMGCycle)( amg_data, p_level, Par_F_array, Par_U_array );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_seqAMGSetup( hypre_ParAMGData *amg_data, HYPRE_Int p_level, HYPRE_Int coarse_threshold )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_seqAMGSetup)( amg_data, p_level, coarse_threshold );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_ssort( HYPRE_BigInt *data, HYPRE_Int n )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_ssort)( data, n );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap2_ci( HYPRE_Complex *v, HYPRE_Int *w, HYPRE_Int i, HYPRE_Int j )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap2_ci)( v, w, i, j );
}

/*--------------------------------------------------------------------------*/

void
hypre_swap_int( HYPRE_BigInt *data, HYPRE_Int a, HYPRE_Int b )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_swap_int)( data, a, b );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
hypre_update_entry( HYPRE_Int weight, HYPRE_Int *weight_max, HYPRE_Int *previous, HYPRE_Int *next, HYPRE_Int *first, HYPRE_Int *last, HYPRE_Int head, HYPRE_Int tail, HYPRE_Int i )
{
   return HYPRE_CURRENTPRECISION_FUNC(hypre_update_entry)( weight, weight_max, previous, next, first, last, head, tail, i );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
matrix_matrix_product( HYPRE_Int **i_element_edge_pointer, HYPRE_Int **j_element_edge_pointer, HYPRE_Int *i_element_face, HYPRE_Int *j_element_face, HYPRE_Int *i_face_edge, HYPRE_Int *j_face_edge, HYPRE_Int num_elements, HYPRE_Int num_faces, HYPRE_Int num_edges )
{
   return HYPRE_CURRENTPRECISION_FUNC(matrix_matrix_product)( i_element_edge_pointer, j_element_edge_pointer, i_element_face, j_element_face, i_face_edge, j_face_edge, num_elements, num_faces, num_edges );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
rfun( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(rfun)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Real
rfun_rs( HYPRE_Real xx, HYPRE_Real yy, HYPRE_Real zz )
{
   return HYPRE_CURRENTPRECISION_FUNC(rfun_rs)( xx, yy, zz );
}

/*--------------------------------------------------------------------------*/

HYPRE_Int
transpose_matrix_create( HYPRE_Int **i_face_element_pointer, HYPRE_Int **j_face_element_pointer, HYPRE_Int *i_element_face, HYPRE_Int *j_element_face, HYPRE_Int num_elements, HYPRE_Int num_faces )
{
   return HYPRE_CURRENTPRECISION_FUNC(transpose_matrix_create)( i_face_element_pointer, j_face_element_pointer, i_element_face, j_element_face, num_elements, num_faces );
}


#endif

