% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ambientProfileEmpty.R
\name{ambientProfileEmpty}
\alias{ambientProfileEmpty}
\alias{estimateAmbience}
\alias{ambientProfileEmpty,ANY-method}
\alias{ambientProfileEmpty,SummarizedExperiment-method}
\title{Estimate the ambient profile from empty droplets}
\usage{
estimateAmbience(...)

ambientProfileEmpty(m, ...)

\S4method{ambientProfileEmpty}{ANY}(
  m,
  lower = 100,
  by.rank = NULL,
  known.empty = NULL,
  round = TRUE,
  good.turing = TRUE,
  BPPARAM = SerialParam()
)

\S4method{ambientProfileEmpty}{SummarizedExperiment}(m, ..., assay.type = "counts")
}
\arguments{
\item{...}{For the generic, further arguments to pass to individual methods.

For the SummarizedExperiment method, further arguments to pass to the ANY method.

For \code{estimateAmbience}, arguments to pass to \code{ambientProfileEmpty}.}

\item{m}{A numeric matrix-like object - usually a \linkS4class{dgTMatrix} or \linkS4class{dgCMatrix} - 
containing droplet data \emph{prior to any filtering or cell calling}.
Columns represent barcoded droplets, rows represent genes.

For \code{emptyDrops}, this may also be a \linkS4class{SummarizedExperiment} object containing such a matrix.}

\item{lower}{A numeric scalar specifying the lower bound on the total UMI count, 
at or below which all barcodes are assumed to correspond to empty droplets.}

\item{by.rank}{An optional integer scalar, used as an alternative to \code{lower} to identifying assumed empty droplets - see Details.}

\item{known.empty}{an optional integer vector indexing barcodes that will be assumed to be empty, over-riding \code{lower} and \code{by.rank}.}

\item{round}{Logical scalar indicating whether to check for non-integer values in \code{m} and, if present, round them for ambient profile estimation (see \code{?\link{ambientProfileEmpty}}) and the multinomial simulations.}

\item{good.turing}{Logical scalar indicating whether to perform Good-Turing estimation of the proportions.}

\item{BPPARAM}{A \linkS4class{BiocParallelParam} object indicating whether parallelization should be used.}

\item{assay.type}{Integer or string specifying the assay containing the count matrix.}
}
\value{
A numeric vector of length equal to \code{nrow(m)},
containing the estimated proportion of each transcript in the ambient solution.

If \code{good.turing=FALSE}, the vector instead contains the sum of counts for each gene across all low-count barcodes.
}
\description{
Estimate the transcript proportions in the ambient solution from an unfiltered count matrix,
assuming that low-count barcodes correspond to \dQuote{known empty} droplets.
Zeroes are filled in using the Good-Turing method.
}
\details{
This function obtains an estimate of the composition of the ambient pool of RNA based on the barcodes with total UMI counts less than or equal to \code{lower}.
For each gene, counts are summed across all low-count barcodes and the resulting count vector is used for Good-Turing estimation of the proportions for each transcript.
The aim here is to obtain reasonable proportions for genes with counts of zero in low-count barcodes but non-zero counts for other barcodes (thus avoiding likelihoods of zero when modelling the latter with the proportions).

This function will also attempt to detect whether \code{m} contains non-integer values by seeing if the column and row sums are discrete.
If such values are present, \code{m} is first \code{\link{round}}ed to the nearest integer value before proceeding.
This may be relevant when the count matrix is generated from pseudo-alignment methods like Alevin (see the \pkg{tximeta} package for details).
Rounding is performed by default as discrete count values are necessary for the Good-Turing algorithm, but if \code{m} is known to be discrete, setting \code{round=FALSE} can provide a small efficiency improvement.

Setting \code{good.turing=FALSE} may be convenient to obtain raw counts for use in further modelling.

\code{estimateAmbience} is soft-deprecated; use \code{ambientProfileEmpty} instead.
}
\section{Behavior at zero counts}{

Good-Turing returns zero probabilities for zero counts if none of the summed counts are equal to 1.
This is technically correct but not helpful, so we protect against this by adding a single \dQuote{pseudo-feature} with a count of 1 to the profile.
The modified profile is used to calculate a Good-Turing estimate of observing any feature that has zero counts, which is then divided to get the per-feature probability. 
We scale down all the other probabilities to make space for this new pseudo-probability, which has some properties of unclear utility (see \url{https://github.com/MarioniLab/DropletUtils/issues/39}). 

Note that genes with counts of zero across all barcodes in \code{m} automatically have proportions of zero.
This ensures that the estimation is not affected by the presence/absence of non-expressed genes in different annotations.
In any case, such genes are likely to be completely irrelevant to downstream steps and can be safely ignored.
}

\section{Finding the assumed empty droplets}{

The default approach is to assume that all barcodes with total counts less than or equal to \code{lower} are empty.
This is generally effective but may not be adequate for datasets with unusually low or high sequencing depth, such that all or none of the barcodes are detected as empty respectively.
For example, there is no obvious choice for \code{lower} in CITE-seq data given that the coverage can be highly variable. 

In such cases, an alternative approach can be used by passing an integer to the \code{by.rank} argument.
This specifies the number of barcodes with the highest total counts to ignore; the remaining barcodes are assumed to be ambient.
The idea is that, even if the exact threshold is unknown, we can be certain that a given experiment does not contain more than a particular number of genuine cell-containing barcodes based on the number of cells that were loaded into the machine.
By setting \code{by.rank} to something greater than this \emph{a priori} known number, we exclude the most likely candidates and use the remaining barcodes to compute the ambient profile.

Another alternative when working with some multimodal data, such as CITE-seq, could be to use statistics from one modality (e.g. mRNA counts) to define empty droplets in the other modality (e.g. CITE-seq) or combining CITE-seq with mRNA-counts.
In this case, one may set \code{known.empty} to an integer vector indexing barcodes in columns of `m` to mark cells for the ambient pool.
For the purpose of retaining cells, if \code{lower} is set, it will be used to define the pool of ambient RNA in \code{barcodeRanks}.
Otherwise the median of total counts of barcodes that have \code{known.empty} set will be used in its place.
}

\examples{
# Mocking up some data:
set.seed(0)
my.counts <- DropletUtils:::simCounts()

ambience <- ambientProfileEmpty(my.counts)
head(ambience)

}
\seealso{
\code{\link{emptyDrops}} and \code{\link{hashedDrops}}, where the ambient profile estimates are used for testing.

\code{\link{ambientContribMaximum}} and related functions, to estimate the contribution of ambient contamination in each library.
}
\author{
Aaron Lun
}
