% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/treeManipulation.R
\name{add.tips}
\alias{add.tips}
\title{Add tips to a tree}
\usage{
add.tips(tree, tips, where, edge.length = NULL)
}
\arguments{
\item{tree}{an object of class "phylo".}

\item{tips}{a character vector containing the names of the tips.}

\item{where}{an integer or character vector of the same length as tips giving
the number of the node or tip of the tree where to add the new tips.}

\item{edge.length}{optional numeric vector with edge length}
}
\value{
an object of class phylo
}
\description{
This function binds tips to nodes of a phylogenetic trees.
}
\examples{
tree <- rcoal(10)
plot(tree)
nodelabels()
tiplabels()
tree1 <- add.tips(tree, c("A", "B", "C"), c(1,2,15))
plot(tree1)
}
\seealso{
\code{\link[ape]{bind.tree}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
