﻿' Licensed to the .NET Foundation under one or more agreements.
' The .NET Foundation licenses this file to you under the MIT license.
' See the LICENSE file in the project root for more information.

Imports Microsoft.CodeAnalysis.VisualBasic.Symbols
Imports Microsoft.CodeAnalysis.EditAndContinue.UnitTests
Imports Microsoft.CodeAnalysis.Test.Utilities
Imports Roslyn.Test.Utilities
Imports Microsoft.CodeAnalysis.VisualBasic.UnitTests

Namespace Microsoft.CodeAnalysis.VisualBasic.EditAndContinue.UnitTests

    Friend NotInheritable Class EditAndContinueTest
        Inherits EditAndContinueTest(Of EditAndContinueTest)

        Private ReadOnly _options As VisualBasicCompilationOptions
        Private ReadOnly _parseOptions As VisualBasicParseOptions
        Private ReadOnly _targetFramework As TargetFramework

        Sub New(Optional options As VisualBasicCompilationOptions = Nothing,
                Optional parseOptions As VisualBasicParseOptions = Nothing,
                Optional targetFramework As TargetFramework = TargetFramework.StandardAndVBRuntime,
                Optional verification As Verification? = Nothing)

            MyBase.New(verification)

            _options = If(options, EditAndContinueTestBase.ComSafeDebugDll)
            _parseOptions = If(parseOptions, TestOptions.Regular)
            _targetFramework = targetFramework
        End Sub

        Protected Overrides Function CreateCompilation(tree As SyntaxTree) As Compilation
            Return CompilationUtils.CreateCompilation(tree, options:=_options, targetFramework:=_targetFramework)
        End Function

        Protected Overrides Function CreateSourceWithMarkedNodes(source As String) As SourceWithMarkedNodes
            Return EditAndContinueTestBase.MarkedSource(source, options:=_parseOptions)
        End Function

        Protected Overrides Function GetEquivalentNodesMap(left As ISymbol, right As ISymbol) As Func(Of SyntaxNode, SyntaxNode)
            Return EditAndContinueTestBase.GetEquivalentNodesMap(DirectCast(left, MethodSymbol), DirectCast(right, MethodSymbol))
        End Function
    End Class
End Namespace
