%{!?_pkgdocdir: %global _pkgdocdir %{_docdir}/%{name}-%{version}}
%global __cmake cmake3

Name:				davix
Version:			0.8.0
Release:			1%{?dist}
Summary:			Toolkit for Http-based file management
License:			LGPLv2+
URL:				http://dmc.web.cern.ch/projects/davix/home
# git clone http://git.cern.ch/pub/davix
Source0:			http://grid-deployment.web.cern.ch/grid-deployment/dms/lcgutil/tar/%{name}/%{name}-%{version}.tar.gz

#main lib dependencies
BuildRequires:                  python2
BuildRequires:                  libuuid-devel
BuildRequires:                  cmake
BuildRequires:                  cmake3
BuildRequires:                  doxygen
BuildRequires:                  libxml2-devel
BuildRequires:                  openssl-devel
%{?el6:BuildRequires: python-argparse}

Requires: libuuid

# davix-copy dependencies
BuildRequires:                  gsoap-devel

# unit tests and abi check
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildRequires:                  abi-compliance-checker
%endif

Requires:                       %{name}-libs%{?_isa} = %{version}-%{release}



%description
Davix is a toolkit designed for file operations
with Http based protocols (WebDav, Amazon S3, ...).
Davix provides an API and a set of command line tools.

%package libs
Summary:			Development files for %{name}
Requires:                       gsoap

%description libs
Libraries for %{name}. Davix is a toolkit designed for file operations
with Http based protocols (WebDav, Amazon S3, ...).


%package devel
Summary:			Development files for %{name}
Requires:			%{name}-libs%{?_isa} = %{version}-%{release}
Requires:			pkgconfig

%description devel
Development files for %{name}. Davix is a toolkit designed for file operations
with Http based protocols (WebDav, Amazon S3, ...).

%package tests
Summary:            Test suite for %{name}
Requires:			%{name}-libs%{?_isa} = %{version}-%{release}

%description tests
Test suite for %{name}. Davix is a toolkit designed for file operations
with Http based protocols (WebDav, Amazon S3, ...).

%package doc
Summary:			Documentation for %{name}
%if %{?fedora}%{!?fedora:0} >= 10 || %{?rhel}%{!?rhel:0} >= 6
BuildArch:	noarch
%endif

%description doc
Documentation and examples for %{name}. Davix is a toolkit designed
for file operations with Http based protocols (WebDav, Amazon S3, ...).

%clean
%cmake3_build --target clean

%prep
%setup -q
# remove useless embedded components
rm -rf test/pywebdav/

%build

%cmake3 \
  -DDOC_INSTALL_DIR=%{_pkgdocdir} \
  -DENABLE_THIRD_PARTY_COPY=TRUE \
  -DENABLE_HTML_DOCS=TRUE \
  .
%cmake3_build
%cmake3_build --target doc

%install
%cmake3_install

%if 0%{?rhel} == 7
%post libs -p /sbin/ldconfig
%postun libs -p /sbin/ldconfig
%else
%ldconfig_scriptlets libs
%endif

%files
%{_bindir}/davix-cp
%{_bindir}/davix-get
%{_bindir}/davix-http
%{_bindir}/davix-ls
%{_bindir}/davix-mkdir
%{_bindir}/davix-mv
%{_bindir}/davix-put
%{_bindir}/davix-rm
%{_mandir}/man1/*

%files libs
%{_libdir}/libdavix.so.*
%{_libdir}/libdavix_copy.so.*
%{_mandir}/man3/*


%files devel
%{_libdir}/libdavix.so
%{_libdir}/libdavix_copy.so
%dir %{_includedir}/davix
%{_includedir}/davix/*
%{_libdir}/pkgconfig/*

%files doc
%{_pkgdocdir}/LICENSE
%{_pkgdocdir}/RELEASE-NOTES.md
%{_pkgdocdir}/html/

%files tests
%{_bindir}/davix-unit-tests
%{_bindir}/davix-tester

%changelog
* Fri Sep 17 2021 Mihai Patrascoiu <mihai.patrascoiu at cern.ch> - 0.8.0-1
 - davix 0.8.0 release, see RELEASE-NOTES.md for changes

* Wed Apr 29 2020 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.6-1
 - davix 0.7.6 release, see RELEASE-NOTES.md for changes

* Wed Aug 28 2019 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.5-1
 - davix 0.7.5 release, see RELEASE-NOTES.md for changes

* Thu Jul 04 2019 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.4-1
 - davix 0.7.4 release, see RELEASE-NOTES.md for changes

* Wed May 08 2019 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.3-1
 - davix 0.7.3 release, see RELEASE-NOTES.md for changes

* Fri Feb 15 2019 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.2-1
 - davix 0.7.2 release, see RELEASE-NOTES.md for changes

* Wed Oct 24 2018 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.1-1
 - davix 0.7.1 release, see RELEASE-NOTES.md for changes

* Mon Oct 22 2018 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.7.0-1
 - davix 0.7.0 release, see RELEASE-NOTES.md for changes

* Tue Sep 25 2018 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.9-1
 - davix 0.6.9 release, see RELEASE-NOTES.md for changes

* Fri Dec 01 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.8-1
 - davix 0.6.8 release, see RELEASE-NOTES for changes

* Tue Nov 07 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.7-1
 - davix 0.6.7 release, see RELEASE-NOTES for changes

* Wed May 17 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.7-1
 - davix 0.6.7 release, see RELEASE-NOTES for changes

* Thu May 11 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.6-1
 - davix 0.6.6 release, see RELEASE-NOTES for changes

* Tue Feb 07 2017 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.5-1
 - davix 0.6.5 release, see RELEASE-NOTES for changes

* Thu Aug 18 2016 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.4-1
 - davix 0.6.4 release, see RELEASE-NOTES for changes

* Thu Apr 07 2016 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.3-1
 - davix 0.6.3 release, see RELEASE-NOTES for changes

* Tue Apr 05 2016 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.2-1
 - davix 0.6.2 release, see RELEASE-NOTES for changes

* Mon Apr 04 2016 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.1-1
 - davix 0.6.1 release, see RELEASE-NOTES for changes

* Thu Nov 05 2015 Georgios Bitzes <georgios.bitzes at cern.ch> - 0.6.0-1
 - davix 0.6.0 release, see RELEASE-NOTES for changes

* Fri Dec 05 2014 Adrien Devresse <adevress at cern.ch> - 0.4.0-1
 - davix 0.4.0 release, see RELEASE-NOTES for changes

* Tue Aug 12 2014 Adrien Devresse <adevress at cern.ch> - 0.3.6-1
 - davix 0.3.6 release, see RELEASE-NOTES for changes

* Tue Jul 22 2014 Adrien Devresse <adevress at cern.ch> - 0.3.4-1
 - Update to release 0.3.4

* Wed Jun 04 2014 Adrien Devresse <adevress at cern.ch> - 0.3.1-1
 - davix 0.3.1 release, see RELEASE-NOTES for changes

* Tue Jun 03 2014 Adrien Devresse <adevress at cern.ch> - 0.3.0-1
 - davix 0.3.0 release, see RELEASE-NOTES for changes

* Tue Jan 28 2014 Adrien Devresse <adevress at cern.ch> - 0.2.10-1
 - davix 0.2.10 release, see RELEASE-NOTES for details

* Mon Oct 28 2013 Adrien Devresse <adevress at cern.ch> - 0.2.7-3
 - New update of davix, see RELEASE-NOTES for details

* Tue Sep 03 2013 Adrien Devresse <adevress at cern.ch> - 0.2.6-1
 - Release 0.2.6 of davix, see RELEASE-NOTES for details

* Wed Jun 05 2013 Adrien Devresse <adevress at cern.ch> - 0.2.2-2
 - Initial EPEL release
