# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Maciek Borzecki
AMAZONLINUX_RELEASES += 2023

.PHONY: all
all:: amazonlinux-cloud-2023.$(GARDEN_ARCH).qcow2 amazonlinux-cloud-2023.$(GARDEN_ARCH).run

# The image URL isn't stable and changes with every release version, e.g.
# https://cdn.amazonlinux.com/al2023/os-images/latest/kvm/al2023-kvm-<unstable-part>-x86_64.xfs.gpt.qcow2
# but the actual image name is stored in SHA256SUMS, so we can extract that

# x86_64 support

AMAZONLINUX_2023_X86_64_FILENAME ?=

$(GARDEN_DL_DIR)/amazonlinux/SHA256SUMS.2023.x86_64: | $(GARDEN_DL_DIR)/amazonlinux
	$(strip $(WGET) \
		--no-clobber \
		--output-document=$@ \
		https://cdn.amazonlinux.com/al2023/os-images/latest/kvm/SHA256SUMS)

$(GARDEN_DL_DIR)/amazonlinux/info.2023.x86_64.mk: $(GARDEN_DL_DIR)/amazonlinux/SHA256SUMS.2023.x86_64
	echo 'AMAZONLINUX_2023_X86_64_FILENAME := $(or $(lastword $(file < $<)),UNKNOWN)' >$@
	touch --reference=$< $@

include $(GARDEN_DL_DIR)/amazonlinux/info.2023.x86_64.mk

ifneq ($(AMAZONLINUX_2023_X86_64_FILENAME),)
AMAZONLINUX_2023_X86_64_URL = https://cdn.amazonlinux.com/al2023/os-images/latest/kvm/$(AMAZONLINUX_2023_X86_64_FILENAME)

$(GARDEN_DL_DIR)/amazonlinux/$(AMAZONLINUX_2023_X86_64_FILENAME): $(GARDEN_DL_DIR)/amazonlinux/SHA256SUMS.2023.x86_64 | $(GARDEN_DL_DIR)/amazonlinux
	$(strip $(WGET) \
			--no-clobber \
			--directory-prefix=$(firstword $|)/ \
			$(AMAZONLINUX_2023_X86_64_URL))

$(GARDEN_DL_DIR)/amazonlinux/amazonlinux-cloud-2023.x86_64.qcow2: | $(GARDEN_DL_DIR)/amazonlinux $(GARDEN_DL_DIR)/amazonlinux/$(AMAZONLINUX_2023_X86_64_FILENAME)
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/amazonlinux/$(AMAZONLINUX_2023_X86_64_FILENAME)

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/amazonlinux/$(AMAZONLINUX_2023_X86_64_FILENAME)

endif

# aarch64 support

AMAZONLINUX_2023_AARCH64_FILENAME ?=

$(GARDEN_DL_DIR)/amazonlinux/SHA256SUMS.2023.aarch64: | $(GARDEN_DL_DIR)/amazonlinux
	$(strip $(WGET) \
		--no-clobber \
		--output-document=$@ \
		https://cdn.amazonlinux.com/al2023/os-images/latest/kvm-arm64/SHA256SUMS)

$(GARDEN_DL_DIR)/amazonlinux/info.2023.aarch64.mk: $(GARDEN_DL_DIR)/amazonlinux/SHA256SUMS.2023.aarch64
	echo 'AMAZONLINUX_2023_AARCH64_FILENAME := $(or $(lastword $(file < $<)),UNKNOWN)' >$@
	touch --reference=$< $@

include $(GARDEN_DL_DIR)/amazonlinux/info.2023.aarch64.mk

ifneq ($(AMAZONLINUX_2023_AARCH64_FILENAME),)
AMAZONLINUX_2023_AARCH64_URL = https://cdn.amazonlinux.com/al2023/os-images/latest/kvm-arm64/$(AMAZONLINUX_2023_AARCH64_FILENAME)

$(GARDEN_DL_DIR)/amazonlinux/$(AMAZONLINUX_2023_AARCH64_FILENAME): $(GARDEN_DL_DIR)/amazonlinux/SHA256SUMS.2023.aarch64 | $(GARDEN_DL_DIR)/amazonlinux
	$(strip $(WGET) \
			--no-clobber \
			--directory-prefix=$(firstword $|)/ \
			$(AMAZONLINUX_2023_AARCH64_URL))

$(GARDEN_DL_DIR)/amazonlinux/amazonlinux-cloud-2023.aarch64.qcow2: | $(GARDEN_DL_DIR)/amazonlinux $(GARDEN_DL_DIR)/amazonlinux/$(AMAZONLINUX_2023_AARCH64_FILENAME)
	ln -sf $(notdir $(word 2,$|)) $@

.PHONY: distclean
distclean::
		rm -f $(GARDEN_DL_DIR)/amazonlinux/$(AMAZONLINUX_2023_AARCH64_FILENAME)

.PHONY: fetch
fetch: $(GARDEN_DL_DIR)/amazonlinux/$(AMAZONLINUX_2023_AARCH64_FILENAME)

endif

.PHONY: clean
clean::
	rm -f $(GARDEN_DL_DIR)/amazonlinux/amazonlinux-cloud-2023.*.qcow2
	rm -f $(GARDEN_DL_DIR)/amazonlinux/info.2023.*.mk

.PHONY: distclean
distclean::
	rm -f $(GARDEN_DL_DIR)/amazonlinux/SHA256SUMS.2023.*
